/* THIS FILE IS AUTOGENERATED FROM StreamFilter.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_StreamFilterBinding_h
#define mozilla_dom_StreamFilterBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

namespace dom {

struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom

namespace extensions {

class StreamFilter;

} // namespace extensions

} // namespace mozilla

namespace mozilla::dom {

enum class StreamFilterStatus : uint8_t {
  Uninitialized,
  Transferringdata,
  Finishedtransferringdata,
  Suspended,
  Closed,
  Disconnected,
  Failed,
  EndGuard_
};

namespace StreamFilterStatusValues {
extern const EnumEntry strings[8];

static constexpr size_t Count = 7;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(StreamFilterStatus::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(StreamFilterStatus stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace StreamFilterStatusValues

bool
ToJSValue(JSContext* aCx, StreamFilterStatus aArgument, JS::MutableHandle<JS::Value> aValue);


class ArrayBufferOrUint8Array
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBuffer,
    eUint8Array
  };
public:
  enum class Type
  {
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eUint8Array = TypeOrUninit::eUint8Array
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<RootedSpiderMonkeyInterface<Uint8Array> > mUint8Array;

  };

  TypeOrUninit mType;
  Value mValue;

  ArrayBufferOrUint8Array(const ArrayBufferOrUint8Array&) = delete;
  ArrayBufferOrUint8Array& operator=(const ArrayBufferOrUint8Array&) = delete;
public:
  explicit inline ArrayBufferOrUint8Array()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferOrUint8Array()
  {
    Uninit();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline RootedSpiderMonkeyInterface<Uint8Array>&
  RawSetAsUint8Array(JSContext* cx)
  {
    if (mType == eUint8Array) {
      return mValue.mUint8Array.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUint8Array;
    return mValue.mUint8Array.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<Uint8Array>&
  SetAsUint8Array(JSContext* cx)
  {
    if (mType == eUint8Array) {
      return mValue.mUint8Array.Value();
    }
    Uninit();
    mType = eUint8Array;
    return mValue.mUint8Array.SetValue(cx);
  }

  inline bool
  IsUint8Array() const
  {
    return mType == eUint8Array;
  }

  inline RootedSpiderMonkeyInterface<Uint8Array>&
  GetAsUint8Array()
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  inline Uint8Array const &
  GetAsUint8Array() const
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eUint8Array: {
        DestroyUint8Array();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUint8Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUint8Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUint8Array()
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    mValue.mUint8Array.Destroy();
    mType = eUninitialized;
  }
};


class OwningArrayBufferOrUint8Array : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBuffer,
    eUint8Array
  };
public:
  enum class Type
  {
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eUint8Array = TypeOrUninit::eUint8Array
  };

private:
  union Value
  {
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<Uint8Array > mUint8Array;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningArrayBufferOrUint8Array(const OwningArrayBufferOrUint8Array&) = delete;
  OwningArrayBufferOrUint8Array& operator=(const OwningArrayBufferOrUint8Array&) = delete;
public:
  explicit inline OwningArrayBufferOrUint8Array()
    : mType(eUninitialized)
  {
  }

  OwningArrayBufferOrUint8Array(OwningArrayBufferOrUint8Array&& aOther);

  inline ~OwningArrayBufferOrUint8Array()
  {
    Uninit();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  Uint8Array&
  RawSetAsUint8Array();

  Uint8Array&
  SetAsUint8Array();

  inline bool
  IsUint8Array() const
  {
    return mType == eUint8Array;
  }

  inline Uint8Array&
  GetAsUint8Array()
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  inline Uint8Array const &
  GetAsUint8Array() const
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningArrayBufferOrUint8Array&
  operator=(OwningArrayBufferOrUint8Array&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToUint8Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUint8Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUint8Array();
};


namespace StreamFilter_Binding {

  typedef mozilla::extensions::StreamFilter NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::extensions::StreamFilter* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::StreamFilter,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::StreamFilter,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace StreamFilter_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_StreamFilterBinding_h
