/* THIS FILE IS AUTOGENERATED FROM MediaSession.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaSessionBinding_h
#define mozilla_dom_MediaSessionBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

struct MediaImage;
struct MediaImageAtoms;
class MediaMetadata;
struct MediaMetadataInitAtoms;
struct MediaPositionStateAtoms;
class MediaSession;
struct MediaSessionActionDetails;
struct MediaSessionActionDetailsAtoms;
class MediaSessionActionHandler;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class MediaSessionPlaybackState : uint8_t {
  None,
  Paused,
  Playing,
  EndGuard_
};

namespace MediaSessionPlaybackStateValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaSessionPlaybackState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(MediaSessionPlaybackState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace MediaSessionPlaybackStateValues

bool
ToJSValue(JSContext* aCx, MediaSessionPlaybackState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class MediaSessionAction : uint8_t {
  Play,
  Pause,
  Seekbackward,
  Seekforward,
  Previoustrack,
  Nexttrack,
  Skipad,
  Seekto,
  Stop,
  EndGuard_
};

namespace MediaSessionActionValues {
extern const EnumEntry strings[10];

static constexpr size_t Count = 9;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaSessionAction::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(MediaSessionAction stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace MediaSessionActionValues

bool
ToJSValue(JSContext* aCx, MediaSessionAction aArgument, JS::MutableHandle<JS::Value> aValue);


struct MediaImage : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mSizes;
  MOZ_INIT_OUTSIDE_CTOR nsString mSrc;
  MOZ_INIT_OUTSIDE_CTOR nsString mType;

  MediaImage();

  explicit inline MediaImage(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaImage(MediaImage&& aOther) = default;

  explicit inline MediaImage(const MediaImage& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaImage&
  operator=(const MediaImage& aOther);

  bool
  operator==(const MediaImage& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MediaImageAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaImage : public MediaImage
{
  inline FastMediaImage()
    : MediaImage(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaPositionState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mDuration;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mPlaybackRate;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mPosition;

  MediaPositionState();

  explicit inline MediaPositionState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaPositionState(MediaPositionState&& aOther) = default;

  explicit inline MediaPositionState(const MediaPositionState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MediaPositionState&
  operator=(const MediaPositionState& aOther);

  bool
  operator==(const MediaPositionState& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MediaPositionStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaPositionState : public MediaPositionState
{
  inline FastMediaPositionState()
    : MediaPositionState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaSessionActionDetails : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR MediaSessionAction mAction;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mFastSeek;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mSeekOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mSeekTime;

  MediaSessionActionDetails();

  explicit inline MediaSessionActionDetails(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaSessionActionDetails(MediaSessionActionDetails&& aOther) = default;

  explicit inline MediaSessionActionDetails(const MediaSessionActionDetails& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaSessionActionDetails&
  operator=(const MediaSessionActionDetails& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaSessionActionDetailsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaSessionActionDetails : public MediaSessionActionDetails
{
  inline FastMediaSessionActionDetails()
    : MediaSessionActionDetails(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class MediaSessionActionHandler : public CallbackFunction
{
public:
  explicit inline MediaSessionActionHandler(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MediaSessionActionHandler(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MediaSessionActionHandler(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MediaSessionActionHandler(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const MediaSessionActionDetails& details, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "MediaSessionActionHandler";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, details, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const MediaSessionActionDetails& details, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "MediaSessionActionHandler";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, details, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const MediaSessionActionDetails& details, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, details, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const MediaSessionActionDetails& details, const char* aExecutionReason = nullptr)
  {
    return Call(details, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const MediaSessionActionHandler& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const MediaSessionActionDetails& details, ErrorResult& aRv);
};


namespace binding_detail {
class FastMediaSessionActionHandler : public MediaSessionActionHandler
{
public:
  explicit inline FastMediaSessionActionHandler(JSObject* aCallback, JSObject* aCallbackGlobal)
    : MediaSessionActionHandler(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    MediaSessionActionHandler::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    MediaSessionActionHandler::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct MediaMetadataInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mAlbum;
  MOZ_INIT_OUTSIDE_CTOR nsString mArtist;
  MOZ_INIT_OUTSIDE_CTOR Sequence<MediaImage> mArtwork;
  MOZ_INIT_OUTSIDE_CTOR nsString mTitle;

  MediaMetadataInit();

  explicit inline MediaMetadataInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaMetadataInit(MediaMetadataInit&& aOther) = default;

  explicit inline MediaMetadataInit(const MediaMetadataInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaMetadataInit&
  operator=(const MediaMetadataInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaMetadataInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaMetadataInit : public MediaMetadataInit
{
  inline FastMediaMetadataInit()
    : MediaMetadataInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MediaMetadata_Binding {

  typedef mozilla::dom::MediaMetadata NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaMetadata* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedArtworkValue(mozilla::dom::MediaMetadata* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaMetadata,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaMetadata,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaMetadata_Binding



namespace MediaSession_Binding {

  typedef mozilla::dom::MediaSession NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaSession* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaSession,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaSession,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaSession_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_MediaSessionBinding_h
