/* THIS FILE IS AUTOGENERATED FROM ExtendableMessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ExtendableMessageEventBinding_h
#define mozilla_dom_ExtendableMessageEventBinding_h

#include "ExtendableEventBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/MessagePort.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Client;
class ClientOrServiceWorkerOrMessagePort;
class ExtendableMessageEvent;
struct ExtendableMessageEventInitAtoms;
class MessagePort;
struct NativePropertyHooks;
class OwningClientOrServiceWorkerOrMessagePort;
class ProtoAndIfaceCache;
class ServiceWorker;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningClientOrServiceWorkerOrMessagePort& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningClientOrServiceWorkerOrMessagePort& aUnion);


class ClientOrServiceWorkerOrMessagePort
{
  enum TypeOrUninit
  {
    eUninitialized,
    eClient,
    eServiceWorker,
    eMessagePort
  };
public:
  enum class Type
  {
    eClient = TypeOrUninit::eClient,
    eServiceWorker = TypeOrUninit::eServiceWorker,
    eMessagePort = TypeOrUninit::eMessagePort
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Client> > mClient;
    UnionMember<NonNull<mozilla::dom::ServiceWorker> > mServiceWorker;
    UnionMember<NonNull<mozilla::dom::MessagePort> > mMessagePort;

  };

  TypeOrUninit mType;
  Value mValue;

  ClientOrServiceWorkerOrMessagePort(const ClientOrServiceWorkerOrMessagePort&) = delete;
  ClientOrServiceWorkerOrMessagePort& operator=(const ClientOrServiceWorkerOrMessagePort&) = delete;
public:
  explicit inline ClientOrServiceWorkerOrMessagePort()
    : mType(eUninitialized)
  {
  }

  inline ~ClientOrServiceWorkerOrMessagePort()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Client>&
  RawSetAsClient()
  {
    if (mType == eClient) {
      return mValue.mClient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eClient;
    return mValue.mClient.SetValue();
  }

  inline NonNull<mozilla::dom::Client>&
  SetAsClient()
  {
    if (mType == eClient) {
      return mValue.mClient.Value();
    }
    Uninit();
    mType = eClient;
    return mValue.mClient.SetValue();
  }

  inline bool
  IsClient() const
  {
    return mType == eClient;
  }

  inline NonNull<mozilla::dom::Client>&
  GetAsClient()
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline mozilla::dom::Client&
  GetAsClient() const
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline NonNull<mozilla::dom::ServiceWorker>&
  RawSetAsServiceWorker()
  {
    if (mType == eServiceWorker) {
      return mValue.mServiceWorker.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eServiceWorker;
    return mValue.mServiceWorker.SetValue();
  }

  inline NonNull<mozilla::dom::ServiceWorker>&
  SetAsServiceWorker()
  {
    if (mType == eServiceWorker) {
      return mValue.mServiceWorker.Value();
    }
    Uninit();
    mType = eServiceWorker;
    return mValue.mServiceWorker.SetValue();
  }

  inline bool
  IsServiceWorker() const
  {
    return mType == eServiceWorker;
  }

  inline NonNull<mozilla::dom::ServiceWorker>&
  GetAsServiceWorker()
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline mozilla::dom::ServiceWorker&
  GetAsServiceWorker() const
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline NonNull<mozilla::dom::MessagePort>&
  RawSetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline NonNull<mozilla::dom::MessagePort>&
  SetAsMessagePort()
  {
    if (mType == eMessagePort) {
      return mValue.mMessagePort.Value();
    }
    Uninit();
    mType = eMessagePort;
    return mValue.mMessagePort.SetValue();
  }

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline NonNull<mozilla::dom::MessagePort>&
  GetAsMessagePort()
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline mozilla::dom::MessagePort&
  GetAsMessagePort() const
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eClient: {
        DestroyClient();
        break;
      }
      case eServiceWorker: {
        DestroyServiceWorker();
        break;
      }
      case eMessagePort: {
        DestroyMessagePort();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToClient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToClient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyClient()
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    mValue.mClient.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyServiceWorker()
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    mValue.mServiceWorker.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyMessagePort()
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    mValue.mMessagePort.Destroy();
    mType = eUninitialized;
  }
};


class OwningClientOrServiceWorkerOrMessagePort : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningClientOrServiceWorkerOrMessagePort& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eClient,
    eServiceWorker,
    eMessagePort
  };
public:
  enum class Type
  {
    eClient = TypeOrUninit::eClient,
    eServiceWorker = TypeOrUninit::eServiceWorker,
    eMessagePort = TypeOrUninit::eMessagePort
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Client> > mClient;
    UnionMember<OwningNonNull<mozilla::dom::ServiceWorker> > mServiceWorker;
    UnionMember<OwningNonNull<mozilla::dom::MessagePort> > mMessagePort;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningClientOrServiceWorkerOrMessagePort()
    : mType(eUninitialized)
  {
  }

  OwningClientOrServiceWorkerOrMessagePort(OwningClientOrServiceWorkerOrMessagePort&& aOther);

  explicit inline OwningClientOrServiceWorkerOrMessagePort(const OwningClientOrServiceWorkerOrMessagePort& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningClientOrServiceWorkerOrMessagePort()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Client>&
  RawSetAsClient();

  OwningNonNull<mozilla::dom::Client>&
  SetAsClient();

  inline bool
  IsClient() const
  {
    return mType == eClient;
  }

  inline OwningNonNull<mozilla::dom::Client>&
  GetAsClient()
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline OwningNonNull<mozilla::dom::Client> const &
  GetAsClient() const
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  OwningNonNull<mozilla::dom::ServiceWorker>&
  RawSetAsServiceWorker();

  OwningNonNull<mozilla::dom::ServiceWorker>&
  SetAsServiceWorker();

  inline bool
  IsServiceWorker() const
  {
    return mType == eServiceWorker;
  }

  inline OwningNonNull<mozilla::dom::ServiceWorker>&
  GetAsServiceWorker()
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  inline OwningNonNull<mozilla::dom::ServiceWorker> const &
  GetAsServiceWorker() const
  {
    MOZ_RELEASE_ASSERT(IsServiceWorker(), "Wrong type!");
    return mValue.mServiceWorker.Value();
  }

  OwningNonNull<mozilla::dom::MessagePort>&
  RawSetAsMessagePort();

  OwningNonNull<mozilla::dom::MessagePort>&
  SetAsMessagePort();

  inline bool
  IsMessagePort() const
  {
    return mType == eMessagePort;
  }

  inline OwningNonNull<mozilla::dom::MessagePort>&
  GetAsMessagePort()
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  inline OwningNonNull<mozilla::dom::MessagePort> const &
  GetAsMessagePort() const
  {
    MOZ_RELEASE_ASSERT(IsMessagePort(), "Wrong type!");
    return mValue.mMessagePort.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningClientOrServiceWorkerOrMessagePort&
  operator=(OwningClientOrServiceWorkerOrMessagePort&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningClientOrServiceWorkerOrMessagePort&
  operator=(const OwningClientOrServiceWorkerOrMessagePort& aOther);

private:
  bool
  TrySetToClient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToClient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyClient();

  bool
  TrySetToServiceWorker(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToServiceWorker(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyServiceWorker();

  bool
  TrySetToMessagePort(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToMessagePort(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyMessagePort();
};


struct ExtendableMessageEventInit : public ExtendableEventInit
{
  MOZ_INIT_OUTSIDE_CTOR JS::Value mData;
  MOZ_INIT_OUTSIDE_CTOR nsString mLastEventId;
  MOZ_INIT_OUTSIDE_CTOR nsString mOrigin;
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::dom::MessagePort>> mPorts;
  MOZ_INIT_OUTSIDE_CTOR Nullable<OwningClientOrServiceWorkerOrMessagePort > mSource;

  ExtendableMessageEventInit();

  explicit inline ExtendableMessageEventInit(const FastDictionaryInitializer& )
    : ExtendableEventInit(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ExtendableMessageEventInit(ExtendableMessageEventInit&& aOther) = default;

private:
  ExtendableMessageEventInit(const ExtendableMessageEventInit&) = delete;
  ExtendableMessageEventInit& operator=(const ExtendableMessageEventInit&) = delete;

  static bool
  InitIds(JSContext* cx, ExtendableMessageEventInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mPorts, "mPorts", aFlags);
    ImplCycleCollectionTraverse(aCallback, mSource, "mSource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mPorts);
    ImplCycleCollectionUnlink(mSource);
  }
};

namespace binding_detail {
struct FastExtendableMessageEventInit : public ExtendableMessageEventInit
{
  inline FastExtendableMessageEventInit()
    : ExtendableMessageEventInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ExtendableMessageEvent_Binding {

  typedef mozilla::dom::ExtendableMessageEvent NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::ExtendableMessageEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::ExtendableMessageEvent,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ExtendableMessageEvent,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace ExtendableMessageEvent_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_ExtendableMessageEventBinding_h
