#ifndef mozilla_dom_BindingNames_h
#define mozilla_dom_BindingNames_h

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioDestinationNode = 335,
  AudioListener = 356,
  AudioNode = 370,
  AudioParam = 380,
  AudioParamMap = 391,
  AudioProcessingEvent = 405,
  AudioScheduledSourceNode = 426,
  AudioTrack = 451,
  AudioTrackList = 462,
  AudioWorklet = 477,
  AudioWorkletGlobalScope = 490,
  AudioWorkletNode = 514,
  AudioWorkletProcessor = 531,
  AuthenticatorAssertionResponse = 553,
  AuthenticatorAttestationResponse = 584,
  AuthenticatorResponse = 617,
  BarProp = 639,
  BaseAudioContext = 647,
  BatteryManager = 664,
  BeforeUnloadEvent = 679,
  BiquadFilterNode = 697,
  Blob = 714,
  BlobEvent = 719,
  BroadcastChannel = 729,
  BrowsingContext = 746,
  BrowsingContextGroup = 762,
  ByteLengthQueuingStrategy = 783,
  CDATASection = 809,
  CSS = 822,
  CSS2Properties = 826,
  CSSAnimation = 841,
  CSSConditionRule = 854,
  CSSContainerRule = 871,
  CSSCounterStyleRule = 888,
  CSSFontFaceRule = 908,
  CSSFontFeatureValuesRule = 924,
  CSSFontPaletteValuesRule = 949,
  CSSGroupingRule = 974,
  CSSImportRule = 990,
  CSSKeyframeRule = 1004,
  CSSKeyframesRule = 1020,
  CSSLayerBlockRule = 1037,
  CSSLayerStatementRule = 1055,
  CSSMediaRule = 1077,
  CSSMozDocumentRule = 1090,
  CSSNamespaceRule = 1109,
  CSSPageRule = 1126,
  CSSPropertyRule = 1138,
  CSSPseudoElement = 1154,
  CSSRule = 1171,
  CSSRuleList = 1179,
  CSSStyleDeclaration = 1191,
  CSSStyleRule = 1211,
  CSSStyleSheet = 1224,
  CSSSupportsRule = 1238,
  CSSTransition = 1254,
  Cache = 1268,
  CacheStorage = 1274,
  CallbackDebuggerNotification = 1287,
  CanonicalBrowsingContext = 1316,
  CanvasCaptureMediaStream = 1341,
  CanvasGradient = 1366,
  CanvasPattern = 1381,
  CanvasRenderingContext2D = 1395,
  CaretPosition = 1420,
  CaretStateChangedEvent = 1434,
  ChannelMergerNode = 1457,
  ChannelSplitterNode = 1475,
  ChannelWrapper = 1495,
  CharacterData = 1510,
  CheckerboardReportService = 1524,
  ChildProcessMessageManager = 1550,
  ChildSHistory = 1577,
  ChromeMessageBroadcaster = 1591,
  ChromeMessageSender = 1616,
  ChromeNodeList = 1636,
  ChromeUtils = 1651,
  ChromeWorker = 1663,
  Client = 1676,
  Clients = 1683,
  Clipboard = 1691,
  ClipboardEvent = 1701,
  ClipboardItem = 1716,
  ClonedErrorHolder = 1730,
  CloseEvent = 1748,
  CommandEvent = 1759,
  Comment = 1772,
  CompositionEvent = 1780,
  CompressionStream = 1797,
  ConsoleInstance = 1815,
  ConstantSourceNode = 1831,
  ContentFrameMessageManager = 1850,
  ContentProcessMessageManager = 1877,
  ContentVisibilityAutoStateChangeEvent = 1906,
  ConvolverNode = 1944,
  CountQueuingStrategy = 1958,
  CreateOfferRequest = 1979,
  Credential = 1998,
  CredentialsContainer = 2009,
  Crypto = 2030,
  CryptoKey = 2037,
  CustomElementRegistry = 2047,
  CustomEvent = 2069,
  DOMException = 2081,
  DOMImplementation = 2094,
  DOMLocalization = 2112,
  DOMMatrix = 2128,
  DOMMatrixReadOnly = 2138,
  DOMParser = 2156,
  DOMPoint = 2166,
  DOMPointReadOnly = 2175,
  DOMQuad = 2192,
  DOMRect = 2200,
  DOMRectList = 2208,
  DOMRectReadOnly = 2220,
  DOMRequest = 2236,
  DOMStringList = 2247,
  DOMStringMap = 2261,
  DOMTokenList = 2274,
  DataTransfer = 2287,
  DataTransferItem = 2300,
  DataTransferItemList = 2317,
  DebuggerNotification = 2338,
  DebuggerNotificationObserver = 2359,
  DecompressionStream = 2388,
  DedicatedWorkerGlobalScope = 2408,
  DelayNode = 2435,
  DeprecationReportBody = 2445,
  DeviceAcceleration = 2467,
  DeviceLightEvent = 2486,
  DeviceMotionEvent = 2503,
  DeviceOrientationEvent = 2521,
  DeviceRotationRate = 2544,
  Directory = 2563,
  Document = 2573,
  DocumentFragment = 2582,
  DocumentL10n = 2599,
  DocumentTimeline = 2612,
  DocumentType = 2629,
  DominatorTree = 2642,
  DragEvent = 2656,
  DynamicsCompressorNode = 2666,
  EXT_blend_minmax = 2689,
  EXT_color_buffer_float = 2706,
  EXT_color_buffer_half_float = 2729,
  EXT_disjoint_timer_query = 2757,
  EXT_float_blend = 2782,
  EXT_frag_depth = 2798,
  EXT_sRGB = 2813,
  EXT_shader_texture_lod = 2822,
  EXT_texture_compression_bptc = 2845,
  EXT_texture_compression_rgtc = 2874,
  EXT_texture_filter_anisotropic = 2903,
  EXT_texture_norm16 = 2934,
  Element = 2953,
  ElementInternals = 2961,
  ErrorEvent = 2978,
  Event = 2989,
  EventCallbackDebuggerNotification = 2995,
  EventCounts = 3029,
  EventSource = 3041,
  EventTarget = 3053,
  Exception = 3065,
  ExtendableEvent = 3075,
  ExtendableMessageEvent = 3091,
  ExtensionAlarms = 3114,
  ExtensionBrowser = 3130,
  ExtensionBrowserSettings = 3147,
  ExtensionBrowserSettingsColorManagement = 3172,
  ExtensionDns = 3212,
  ExtensionEventManager = 3225,
  ExtensionMockAPI = 3247,
  ExtensionPort = 3264,
  ExtensionProxy = 3278,
  ExtensionRuntime = 3293,
  ExtensionScripting = 3310,
  ExtensionSetting = 3329,
  ExtensionTest = 3346,
  External = 3360,
  FeaturePolicy = 3369,
  FeaturePolicyViolationReportBody = 3383,
  FetchEvent = 3416,
  FetchObserver = 3427,
  File = 3441,
  FileList = 3446,
  FileReader = 3455,
  FileReaderSync = 3466,
  FileSystem = 3481,
  FileSystemDirectoryEntry = 3492,
  FileSystemDirectoryHandle = 3517,
  FileSystemDirectoryHandle_AsyncIterator = 3543,
  FileSystemDirectoryIterator = 3583,
  FileSystemDirectoryReader = 3611,
  FileSystemEntry = 3637,
  FileSystemFileEntry = 3653,
  FileSystemFileHandle = 3673,
  FileSystemHandle = 3694,
  FileSystemSyncAccessHandle = 3711,
  FileSystemWritableFileStream = 3738,
  Flex = 3767,
  FlexItemValues = 3772,
  FlexLineValues = 3787,
  FluentBundle = 3802,
  FluentBundleAsyncIterator = 3815,
  FluentBundleIterator = 3841,
  FluentPattern = 3862,
  FluentResource = 3876,
  FocusEvent = 3891,
  FontFace = 3902,
  FontFaceSet = 3911,
  FontFaceSetIterator = 3923,
  FontFaceSetLoadEvent = 3943,
  FormData = 3964,
  FormData_Iterator = 3973,
  FormDataEvent = 3991,
  FrameCrashedEvent = 4005,
  FrameLoader = 4023,
  GPU = 4035,
  GPUAdapter = 4039,
  GPUAdapterInfo = 4050,
  GPUBindGroup = 4065,
  GPUBindGroupLayout = 4078,
  GPUBuffer = 4097,
  GPUBufferUsage = 4107,
  GPUCanvasContext = 4122,
  GPUColorWrite = 4139,
  GPUCommandBuffer = 4153,
  GPUCommandEncoder = 4170,
  GPUCompilationInfo = 4188,
  GPUCompilationMessage = 4207,
  GPUComputePassEncoder = 4229,
  GPUComputePipeline = 4251,
  GPUDevice = 4270,
  GPUDeviceLostInfo = 4280,
  GPUMapMode = 4298,
  GPUOutOfMemoryError = 4309,
  GPUPipelineLayout = 4329,
  GPUQuerySet = 4347,
  GPUQueue = 4359,
  GPURenderBundle = 4368,
  GPURenderBundleEncoder = 4384,
  GPURenderPassEncoder = 4407,
  GPURenderPipeline = 4428,
  GPUSampler = 4446,
  GPUShaderModule = 4457,
  GPUShaderStage = 4473,
  GPUSupportedFeatures = 4488,
  GPUSupportedLimits = 4509,
  GPUTexture = 4528,
  GPUTextureUsage = 4539,
  GPUTextureView = 4555,
  GPUUncapturedErrorEvent = 4570,
  GPUValidationError = 4594,
  GainNode = 4613,
  Gamepad = 4622,
  GamepadAxisMoveEvent = 4630,
  GamepadButton = 4651,
  GamepadButtonEvent = 4665,
  GamepadEvent = 4684,
  GamepadHapticActuator = 4697,
  GamepadLightIndicator = 4719,
  GamepadPose = 4741,
  GamepadServiceTest = 4753,
  GamepadTouch = 4772,
  Geolocation = 4785,
  GeolocationCoordinates = 4797,
  GeolocationPosition = 4820,
  GeolocationPositionError = 4840,
  GetUserMediaRequest = 4865,
  GleanCategory = 4885,
  GleanImpl = 4899,
  GleanLabeled = 4909,
  GleanPingsImpl = 4922,
  Grid = 4937,
  GridArea = 4942,
  GridDimension = 4951,
  GridLine = 4965,
  GridLines = 4974,
  GridTrack = 4984,
  GridTracks = 4994,
  HTMLAllCollection = 5005,
  HTMLAnchorElement = 5023,
  HTMLAreaElement = 5041,
  HTMLAudioElement = 5057,
  HTMLBRElement = 5074,
  HTMLBaseElement = 5088,
  HTMLBodyElement = 5104,
  HTMLButtonElement = 5120,
  HTMLCanvasElement = 5138,
  HTMLCollection = 5156,
  HTMLDListElement = 5171,
  HTMLDataElement = 5188,
  HTMLDataListElement = 5204,
  HTMLDetailsElement = 5224,
  HTMLDialogElement = 5243,
  HTMLDirectoryElement = 5261,
  HTMLDivElement = 5282,
  HTMLDocument = 5297,
  HTMLElement = 5310,
  HTMLEmbedElement = 5322,
  HTMLFieldSetElement = 5339,
  HTMLFontElement = 5359,
  HTMLFormControlsCollection = 5375,
  HTMLFormElement = 5402,
  HTMLFrameElement = 5418,
  HTMLFrameSetElement = 5435,
  HTMLHRElement = 5455,
  HTMLHeadElement = 5469,
  HTMLHeadingElement = 5485,
  HTMLHtmlElement = 5504,
  HTMLIFrameElement = 5520,
  HTMLImageElement = 5538,
  HTMLInputElement = 5555,
  HTMLLIElement = 5572,
  HTMLLabelElement = 5586,
  HTMLLegendElement = 5603,
  HTMLLinkElement = 5621,
  HTMLMapElement = 5637,
  HTMLMarqueeElement = 5652,
  HTMLMediaElement = 5671,
  HTMLMenuElement = 5688,
  HTMLMetaElement = 5704,
  HTMLMeterElement = 5720,
  HTMLModElement = 5737,
  HTMLOListElement = 5752,
  HTMLObjectElement = 5769,
  HTMLOptGroupElement = 5787,
  HTMLOptionElement = 5807,
  HTMLOptionsCollection = 5825,
  HTMLOutputElement = 5847,
  HTMLParagraphElement = 5865,
  HTMLParamElement = 5886,
  HTMLPictureElement = 5903,
  HTMLPreElement = 5922,
  HTMLProgressElement = 5937,
  HTMLQuoteElement = 5957,
  HTMLScriptElement = 5974,
  HTMLSelectElement = 5992,
  HTMLSlotElement = 6010,
  HTMLSourceElement = 6026,
  HTMLSpanElement = 6044,
  HTMLStyleElement = 6060,
  HTMLTableCaptionElement = 6077,
  HTMLTableCellElement = 6101,
  HTMLTableColElement = 6122,
  HTMLTableElement = 6142,
  HTMLTableRowElement = 6159,
  HTMLTableSectionElement = 6179,
  HTMLTemplateElement = 6203,
  HTMLTextAreaElement = 6223,
  HTMLTimeElement = 6243,
  HTMLTitleElement = 6259,
  HTMLTrackElement = 6276,
  HTMLUListElement = 6293,
  HTMLUnknownElement = 6310,
  HTMLVideoElement = 6329,
  HashChangeEvent = 6346,
  Headers = 6362,
  Headers_Iterator = 6370,
  HeapSnapshot = 6387,
  Highlight = 6400,
  HighlightRegistry = 6410,
  History = 6428,
  IDBCursor = 6436,
  IDBCursorWithValue = 6446,
  IDBDatabase = 6465,
  IDBFactory = 6477,
  IDBIndex = 6488,
  IDBKeyRange = 6497,
  IDBLocaleAwareKeyRange = 6509,
  IDBObjectStore = 6532,
  IDBOpenDBRequest = 6547,
  IDBRequest = 6564,
  IDBTransaction = 6575,
  IDBVersionChangeEvent = 6590,
  IIRFilterNode = 6612,
  IOUtils = 6626,
  IdentityCredential = 6634,
  IdleDeadline = 6653,
  Image = 6666,
  ImageBitmap = 6672,
  ImageBitmapRenderingContext = 6684,
  ImageCapture = 6712,
  ImageCaptureError = 6725,
  ImageCaptureErrorEvent = 6743,
  ImageData = 6766,
  ImageDocument = 6776,
  InputEvent = 6790,
  InspectorFontFace = 6801,
  InspectorUtils = 6819,
  InstallTriggerImpl = 6834,
  IntersectionObserver = 6853,
  IntersectionObserverEntry = 6874,
  IntlUtils = 6900,
  JSProcessActorChild = 6910,
  JSProcessActorParent = 6930,
  JSWindowActorChild = 6951,
  JSWindowActorParent = 6970,
  KeyEvent = 6990,
  KeyboardEvent = 6999,
  KeyframeEffect = 7013,
  L10nFileSource = 7028,
  L10nOverlays = 7043,
  L10nRegistry = 7056,
  LargestContentfulPaint = 7069,
  LegacyMozTCPSocket = 7092,
  Localization = 7111,
  Location = 7124,
  Lock = 7133,
  LockManager = 7138,
  MIDIAccess = 7150,
  MIDIConnectionEvent = 7161,
  MIDIInput = 7181,
  MIDIInputMap = 7191,
  MIDIMessageEvent = 7204,
  MIDIOutput = 7221,
  MIDIOutputMap = 7232,
  MIDIPort = 7246,
  MOZ_debug = 7255,
  MatchGlob = 7265,
  MatchPattern = 7275,
  MatchPatternSet = 7288,
  MathMLElement = 7304,
  MediaCapabilities = 7318,
  MediaCapabilitiesInfo = 7336,
  MediaControlService = 7358,
  MediaController = 7378,
  MediaDeviceInfo = 7394,
  MediaDevices = 7410,
  MediaElementAudioSourceNode = 7423,
  MediaEncryptedEvent = 7451,
  MediaError = 7471,
  MediaKeyError = 7482,
  MediaKeyMessageEvent = 7496,
  MediaKeySession = 7517,
  MediaKeyStatusMap = 7533,
  MediaKeyStatusMap_Iterator = 7551,
  MediaKeySystemAccess = 7578,
  MediaKeys = 7599,
  MediaList = 7609,
  MediaMetadata = 7619,
  MediaQueryList = 7633,
  MediaQueryListEvent = 7648,
  MediaRecorder = 7668,
  MediaRecorderErrorEvent = 7682,
  MediaSession = 7706,
  MediaSource = 7719,
  MediaStream = 7731,
  MediaStreamAudioDestinationNode = 7743,
  MediaStreamAudioSourceNode = 7775,
  MediaStreamError = 7802,
  MediaStreamEvent = 7819,
  MediaStreamTrack = 7836,
  MediaStreamTrackAudioSourceNode = 7853,
  MediaStreamTrackEvent = 7885,
  MerchantValidationEvent = 7907,
  MessageBroadcaster = 7931,
  MessageChannel = 7950,
  MessageEvent = 7965,
  MessageListenerManager = 7978,
  MessagePort = 8001,
  MessageSender = 8013,
  MimeType = 8027,
  MimeTypeArray = 8036,
  MouseEvent = 8050,
  MouseScrollEvent = 8061,
  MozCanvasPrintState = 8078,
  MozDocumentMatcher = 8098,
  MozDocumentObserver = 8117,
  MozQueryInterface = 8137,
  MozSharedMap = 8155,
  MozSharedMap_Iterator = 8168,
  MozSharedMapChangeEvent = 8190,
  MozStorageAsyncStatementParams = 8214,
  MozStorageStatementParams = 8245,
  MozStorageStatementRow = 8271,
  MozWritableSharedMap = 8294,
  MutationEvent = 8315,
  MutationObserver = 8329,
  MutationRecord = 8346,
  NamedNodeMap = 8361,
  NavigationPreloadManager = 8374,
  Navigator = 8399,
  NetworkInformation = 8409,
  Node = 8428,
  NodeFilter = 8433,
  NodeIterator = 8444,
  NodeList = 8457,
  Notification = 8466,
  NotificationEvent = 8479,
  NotifyPaintEvent = 8497,
  OES_draw_buffers_indexed = 8514,
  OES_element_index_uint = 8539,
  OES_fbo_render_mipmap = 8562,
  OES_standard_derivatives = 8584,
  OES_texture_float = 8609,
  OES_texture_float_linear = 8627,
  OES_texture_half_float = 8652,
  OES_texture_half_float_linear = 8675,
  OES_vertex_array_object = 8705,
  OVR_multiview2 = 8729,
  OfflineAudioCompletionEvent = 8744,
  OfflineAudioContext = 8772,
  OffscreenCanvas = 8792,
  OffscreenCanvasRenderingContext2D = 8808,
  Option = 8842,
  OscillatorNode = 8849,
  PageTransitionEvent = 8864,
  PaintRequest = 8884,
  PaintRequestList = 8897,
  PaintWorkletGlobalScope = 8914,
  PannerNode = 8938,
  ParentProcessMessageManager = 8949,
  Path2D = 8977,
  PathUtils = 8984,
  PaymentAddress = 8994,
  PaymentMethodChangeEvent = 9009,
  PaymentRequest = 9034,
  PaymentRequestUpdateEvent = 9049,
  PaymentResponse = 9075,
  PeerConnectionImpl = 9091,
  PeerConnectionObserver = 9110,
  Performance = 9133,
  PerformanceEntry = 9145,
  PerformanceEntryEvent = 9162,
  PerformanceEventTiming = 9184,
  PerformanceMark = 9207,
  PerformanceMeasure = 9223,
  PerformanceNavigation = 9242,
  PerformanceNavigationTiming = 9264,
  PerformanceObserver = 9292,
  PerformanceObserverEntryList = 9312,
  PerformancePaintTiming = 9341,
  PerformanceResourceTiming = 9364,
  PerformanceServerTiming = 9390,
  PerformanceTiming = 9414,
  PeriodicWave = 9432,
  PermissionStatus = 9445,
  Permissions = 9462,
  PlacesBookmark = 9474,
  PlacesBookmarkAddition = 9489,
  PlacesBookmarkChanged = 9512,
  PlacesBookmarkGuid = 9534,
  PlacesBookmarkKeyword = 9553,
  PlacesBookmarkMoved = 9575,
  PlacesBookmarkRemoved = 9595,
  PlacesBookmarkTags = 9617,
  PlacesBookmarkTime = 9636,
  PlacesBookmarkTitle = 9655,
  PlacesBookmarkUrl = 9675,
  PlacesEvent = 9693,
  PlacesFavicon = 9705,
  PlacesHistoryCleared = 9719,
  PlacesObservers = 9740,
  PlacesPurgeCaches = 9756,
  PlacesRanking = 9774,
  PlacesVisit = 9788,
  PlacesVisitRemoved = 9800,
  PlacesVisitTitle = 9819,
  PlacesWeakCallbackWrapper = 9836,
  Plugin = 9862,
  PluginArray = 9869,
  PluginCrashedEvent = 9881,
  PointerEvent = 9900,
  PopStateEvent = 9913,
  PopupBlockedEvent = 9927,
  PopupPositionedEvent = 9945,
  PositionStateEvent = 9966,
  PrecompiledScript = 9985,
  ProcessMessageManager = 10003,
  ProcessingInstruction = 10025,
  ProgressEvent = 10047,
  PromiseDebugging = 10061,
  PromiseNativeHandler = 10078,
  PromiseRejectionEvent = 10099,
  PublicKeyCredential = 10121,
  PushEvent = 10141,
  PushManager = 10151,
  PushManagerImpl = 10163,
  PushMessageData = 10179,
  PushSubscription = 10195,
  PushSubscriptionOptions = 10212,
  RTCCertificate = 10236,
  RTCDTMFSender = 10251,
  RTCDTMFToneChangeEvent = 10265,
  RTCDataChannel = 10288,
  RTCDataChannelEvent = 10303,
  RTCDtlsTransport = 10323,
  RTCIceCandidate = 10340,
  RTCIdentityProviderRegistrar = 10356,
  RTCPeerConnection = 10385,
  RTCPeerConnectionIceEvent = 10403,
  RTCPeerConnectionStatic = 10429,
  RTCRtpReceiver = 10453,
  RTCRtpSender = 10468,
  RTCRtpTransceiver = 10481,
  RTCSctpTransport = 10499,
  RTCSessionDescription = 10516,
  RTCStatsReport = 10538,
  RTCTrackEvent = 10553,
  RadioNodeList = 10567,
  Range = 10581,
  ReadableByteStreamController = 10587,
  ReadableStream = 10616,
  ReadableStream_AsyncIterator = 10631,
  ReadableStreamBYOBReader = 10660,
  ReadableStreamBYOBRequest = 10685,
  ReadableStreamDefaultController = 10711,
  ReadableStreamDefaultReader = 10743,
  Report = 10771,
  ReportBody = 10778,
  ReportingObserver = 10789,
  Request = 10807,
  ResizeObserver = 10815,
  ResizeObserverEntry = 10830,
  ResizeObserverSize = 10850,
  Response = 10869,
  SVGAElement = 10878,
  SVGAngle = 10890,
  SVGAnimateElement = 10899,
  SVGAnimateMotionElement = 10917,
  SVGAnimateTransformElement = 10941,
  SVGAnimatedAngle = 10968,
  SVGAnimatedBoolean = 10985,
  SVGAnimatedEnumeration = 11004,
  SVGAnimatedInteger = 11027,
  SVGAnimatedLength = 11046,
  SVGAnimatedLengthList = 11064,
  SVGAnimatedNumber = 11086,
  SVGAnimatedNumberList = 11104,
  SVGAnimatedPreserveAspectRatio = 11126,
  SVGAnimatedRect = 11157,
  SVGAnimatedString = 11173,
  SVGAnimatedTransformList = 11191,
  SVGAnimationElement = 11216,
  SVGCircleElement = 11236,
  SVGClipPathElement = 11253,
  SVGComponentTransferFunctionElement = 11272,
  SVGDefsElement = 11308,
  SVGDescElement = 11323,
  SVGElement = 11338,
  SVGEllipseElement = 11349,
  SVGFEBlendElement = 11367,
  SVGFEColorMatrixElement = 11385,
  SVGFEComponentTransferElement = 11409,
  SVGFECompositeElement = 11439,
  SVGFEConvolveMatrixElement = 11461,
  SVGFEDiffuseLightingElement = 11488,
  SVGFEDisplacementMapElement = 11516,
  SVGFEDistantLightElement = 11544,
  SVGFEDropShadowElement = 11569,
  SVGFEFloodElement = 11592,
  SVGFEFuncAElement = 11610,
  SVGFEFuncBElement = 11628,
  SVGFEFuncGElement = 11646,
  SVGFEFuncRElement = 11664,
  SVGFEGaussianBlurElement = 11682,
  SVGFEImageElement = 11707,
  SVGFEMergeElement = 11725,
  SVGFEMergeNodeElement = 11743,
  SVGFEMorphologyElement = 11765,
  SVGFEOffsetElement = 11788,
  SVGFEPointLightElement = 11807,
  SVGFESpecularLightingElement = 11830,
  SVGFESpotLightElement = 11859,
  SVGFETileElement = 11881,
  SVGFETurbulenceElement = 11898,
  SVGFilterElement = 11921,
  SVGForeignObjectElement = 11938,
  SVGGElement = 11962,
  SVGGeometryElement = 11974,
  SVGGradientElement = 11993,
  SVGGraphicsElement = 12012,
  SVGImageElement = 12031,
  SVGLength = 12047,
  SVGLengthList = 12057,
  SVGLineElement = 12071,
  SVGLinearGradientElement = 12086,
  SVGMPathElement = 12111,
  SVGMarkerElement = 12127,
  SVGMaskElement = 12144,
  SVGMatrix = 12159,
  SVGMetadataElement = 12169,
  SVGNumber = 12188,
  SVGNumberList = 12198,
  SVGPathElement = 12212,
  SVGPathSeg = 12227,
  SVGPathSegArcAbs = 12238,
  SVGPathSegArcRel = 12255,
  SVGPathSegClosePath = 12272,
  SVGPathSegCurvetoCubicAbs = 12292,
  SVGPathSegCurvetoCubicRel = 12318,
  SVGPathSegCurvetoCubicSmoothAbs = 12344,
  SVGPathSegCurvetoCubicSmoothRel = 12376,
  SVGPathSegCurvetoQuadraticAbs = 12408,
  SVGPathSegCurvetoQuadraticRel = 12438,
  SVGPathSegCurvetoQuadraticSmoothAbs = 12468,
  SVGPathSegCurvetoQuadraticSmoothRel = 12504,
  SVGPathSegLinetoAbs = 12540,
  SVGPathSegLinetoHorizontalAbs = 12560,
  SVGPathSegLinetoHorizontalRel = 12590,
  SVGPathSegLinetoRel = 12620,
  SVGPathSegLinetoVerticalAbs = 12640,
  SVGPathSegLinetoVerticalRel = 12668,
  SVGPathSegList = 12696,
  SVGPathSegMovetoAbs = 12711,
  SVGPathSegMovetoRel = 12731,
  SVGPatternElement = 12751,
  SVGPoint = 12769,
  SVGPointList = 12778,
  SVGPolygonElement = 12791,
  SVGPolylineElement = 12809,
  SVGPreserveAspectRatio = 12828,
  SVGRadialGradientElement = 12851,
  SVGRect = 12876,
  SVGRectElement = 12884,
  SVGSVGElement = 12899,
  SVGScriptElement = 12913,
  SVGSetElement = 12930,
  SVGStopElement = 12944,
  SVGStringList = 12959,
  SVGStyleElement = 12973,
  SVGSwitchElement = 12989,
  SVGSymbolElement = 13006,
  SVGTSpanElement = 13023,
  SVGTextContentElement = 13039,
  SVGTextElement = 13061,
  SVGTextPathElement = 13076,
  SVGTextPositioningElement = 13095,
  SVGTitleElement = 13121,
  SVGTransform = 13137,
  SVGTransformList = 13150,
  SVGUnitTypes = 13167,
  SVGUseElement = 13180,
  SVGViewElement = 13194,
  Sanitizer = 13209,
  Scheduler = 13219,
  Screen = 13229,
  ScreenLuminance = 13236,
  ScreenOrientation = 13252,
  ScriptProcessorNode = 13270,
  ScrollAreaEvent = 13290,
  ScrollViewChangeEvent = 13306,
  SecurityPolicyViolationEvent = 13328,
  Selection = 13357,
  ServiceWorker = 13367,
  ServiceWorkerContainer = 13381,
  ServiceWorkerGlobalScope = 13404,
  ServiceWorkerRegistration = 13429,
  SessionStoreFormData = 13455,
  SessionStoreScrollData = 13476,
  SessionStoreUtils = 13499,
  ShadowRealmGlobalScope = 13517,
  ShadowRoot = 13540,
  SharedWorker = 13551,
  SharedWorkerGlobalScope = 13564,
  SimpleGestureEvent = 13588,
  SourceBuffer = 13607,
  SourceBufferList = 13620,
  SpeechGrammar = 13637,
  SpeechGrammarList = 13651,
  SpeechRecognition = 13669,
  SpeechRecognitionAlternative = 13687,
  SpeechRecognitionError = 13716,
  SpeechRecognitionEvent = 13739,
  SpeechRecognitionResult = 13762,
  SpeechRecognitionResultList = 13786,
  SpeechSynthesis = 13814,
  SpeechSynthesisErrorEvent = 13830,
  SpeechSynthesisEvent = 13856,
  SpeechSynthesisUtterance = 13877,
  SpeechSynthesisVoice = 13902,
  StaticRange = 13923,
  StereoPannerNode = 13935,
  Storage = 13952,
  StorageEvent = 13960,
  StorageManager = 13973,
  StreamFilter = 13988,
  StreamFilterDataEvent = 14001,
  StructuredCloneHolder = 14023,
  StructuredCloneTester = 14045,
  StyleSheet = 14067,
  StyleSheetApplicableStateChangeEvent = 14078,
  StyleSheetList = 14115,
  SubmitEvent = 14130,
  SubtleCrypto = 14142,
  SyncMessageSender = 14155,
  SyncReadFile = 14173,
  TCPServerSocket = 14186,
  TCPServerSocketEvent = 14202,
  TCPSocket = 14223,
  TCPSocketErrorEvent = 14233,
  TCPSocketEvent = 14253,
  TaskController = 14268,
  TaskPriorityChangeEvent = 14283,
  TaskSignal = 14307,
  TelemetryStopwatch = 14318,
  TestUtils = 14337,
  TestingDeprecatedInterface = 14347,
  Text = 14374,
  TextClause = 14379,
  TextDecoder = 14390,
  TextDecoderStream = 14402,
  TextEncoder = 14420,
  TextEncoderStream = 14432,
  TextMetrics = 14450,
  TextTrack = 14462,
  TextTrackCue = 14472,
  TextTrackCueList = 14485,
  TextTrackList = 14502,
  TimeEvent = 14516,
  TimeRanges = 14526,
  ToggleEvent = 14537,
  Touch = 14549,
  TouchEvent = 14555,
  TouchList = 14566,
  TrackEvent = 14576,
  TransformStream = 14587,
  TransformStreamDefaultController = 14603,
  TransitionEvent = 14636,
  TreeColumn = 14652,
  TreeColumns = 14663,
  TreeContentView = 14675,
  TreeWalker = 14691,
  UDPMessageEvent = 14702,
  UDPSocket = 14718,
  UIEvent = 14728,
  URL = 14736,
  URLSearchParams = 14740,
  URLSearchParams_Iterator = 14756,
  UniFFIPointer = 14781,
  UniFFIScaffolding = 14795,
  UserInteraction = 14813,
  UserProximityEvent = 14829,
  VRDisplay = 14848,
  VRDisplayCapabilities = 14858,
  VRDisplayEvent = 14880,
  VREyeParameters = 14895,
  VRFieldOfView = 14911,
  VRFrameData = 14925,
  VRMockController = 14937,
  VRMockDisplay = 14954,
  VRPose = 14968,
  VRServiceTest = 14975,
  VRStageParameters = 14989,
  VTTCue = 15007,
  VTTRegion = 15014,
  ValidityState = 15024,
  VideoColorSpace = 15038,
  VideoFrame = 15054,
  VideoPlaybackQuality = 15065,
  VideoTrack = 15086,
  VideoTrackList = 15097,
  VisualViewport = 15112,
  WEBGL_color_buffer_float = 15127,
  WEBGL_compressed_texture_astc = 15152,
  WEBGL_compressed_texture_etc = 15182,
  WEBGL_compressed_texture_etc1 = 15211,
  WEBGL_compressed_texture_pvrtc = 15241,
  WEBGL_compressed_texture_s3tc = 15272,
  WEBGL_compressed_texture_s3tc_srgb = 15302,
  WEBGL_debug_renderer_info = 15337,
  WEBGL_debug_shaders = 15363,
  WEBGL_depth_texture = 15383,
  WEBGL_draw_buffers = 15403,
  WEBGL_explicit_present = 15422,
  WEBGL_lose_context = 15445,
  WEBGL_provoking_vertex = 15464,
  WaveShaperNode = 15487,
  WebExtensionContentScript = 15502,
  WebExtensionPolicy = 15528,
  WebGL2RenderingContext = 15547,
  WebGLActiveInfo = 15570,
  WebGLBuffer = 15586,
  WebGLContextEvent = 15598,
  WebGLFramebuffer = 15616,
  WebGLProgram = 15633,
  WebGLQuery = 15646,
  WebGLRenderbuffer = 15657,
  WebGLRenderingContext = 15675,
  WebGLSampler = 15697,
  WebGLShader = 15710,
  WebGLShaderPrecisionFormat = 15722,
  WebGLSync = 15749,
  WebGLTexture = 15759,
  WebGLTransformFeedback = 15772,
  WebGLUniformLocation = 15795,
  WebGLVertexArrayObject = 15816,
  WebKitCSSMatrix = 15839,
  WebSocket = 15855,
  WebTransport = 15865,
  WebTransportBidirectionalStream = 15878,
  WebTransportDatagramDuplexStream = 15910,
  WebTransportError = 15943,
  WebTransportReceiveStream = 15961,
  WebTransportSendStream = 15987,
  WebrtcGlobalInformation = 16010,
  WheelEvent = 16034,
  Window = 16045,
  WindowClient = 16052,
  WindowContext = 16065,
  WindowGlobalChild = 16079,
  WindowGlobalParent = 16097,
  WindowRoot = 16116,
  Worker = 16127,
  WorkerDebuggerGlobalScope = 16134,
  WorkerGlobalScope = 16160,
  WorkerLocation = 16178,
  WorkerNavigator = 16193,
  WorkerTestUtils = 16209,
  Worklet = 16225,
  WorkletGlobalScope = 16233,
  WritableStream = 16252,
  WritableStreamDefaultController = 16267,
  WritableStreamDefaultWriter = 16299,
  XMLDocument = 16327,
  XMLHttpRequest = 16339,
  XMLHttpRequestEventTarget = 16354,
  XMLHttpRequestUpload = 16380,
  XMLSerializer = 16401,
  XPathEvaluator = 16415,
  XPathExpression = 16430,
  XPathResult = 16446,
  XRBoundedReferenceSpace = 16458,
  XRFrame = 16482,
  XRInputSource = 16490,
  XRInputSourceArray = 16504,
  XRInputSourceEvent = 16523,
  XRInputSourcesChangeEvent = 16542,
  XRPose = 16568,
  XRReferenceSpace = 16575,
  XRReferenceSpaceEvent = 16592,
  XRRenderState = 16614,
  XRRigidTransform = 16628,
  XRSession = 16645,
  XRSessionEvent = 16655,
  XRSpace = 16670,
  XRSystem = 16678,
  XRView = 16687,
  XRViewerPose = 16694,
  XRViewport = 16707,
  XRWebGLLayer = 16718,
  XSLTProcessor = 16731,
  XULCommandEvent = 16745,
  XULElement = 16761,
  XULFrameElement = 16772,
  XULMenuElement = 16788,
  XULPopupElement = 16803,
  XULResizerElement = 16819,
  XULTextElement = 16837,
  XULTreeElement = 16852,
  console = 16867,
  webkitSpeechGrammar = 16875,
  webkitSpeechGrammarList = 16895,
  webkitSpeechRecognition = 16919,
  webkitURL = 16943,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // mozilla_dom_BindingNames_h
