/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  History,
  Anonymous082,
  Anonymous407,
  Anonymous253,
  Anonymous214,
  UrlClassifierUtils,
  Anonymous428,
  Anonymous064,
  ExternalProtocolHandler,
  Anonymous313,
  Anonymous200,
  Anonymous208,
  Anonymous132,
  Anonymous280,
  Anonymous207,
  Anonymous139,
  Anonymous104,
  Anonymous030,
  Anonymous449,
  Anonymous102,
  Anonymous469,
  Anonymous243,
  Anonymous423,
  Anonymous085,
  Anonymous395,
  Anonymous405,
  Anonymous205,
  Anonymous361,
  Anonymous279,
  Anonymous103,
  Anonymous391,
  Anonymous198,
  Anonymous330,
  Anonymous006,
  Anonymous249,
  Anonymous337,
  Anonymous344,
  Anonymous049,
  Anonymous359,
  Anonymous231,
  DownloadPlatform,
  Anonymous044,
  Anonymous320,
  Anonymous014,
  Anonymous256,
  Anonymous288,
  Anonymous301,
  Anonymous004,
  Anonymous341,
  Anonymous136,
  Anonymous156,
  Anonymous319,
  Anonymous274,
  Anonymous054,
  Anonymous343,
  Anonymous222,
  Anonymous074,
  Anonymous141,
  Anonymous413,
  Anonymous094,
  Anonymous466,
  Anonymous187,
  Anonymous419,
  Anonymous229,
  Preferences,
  Anonymous295,
  Anonymous092,
  Anonymous296,
  Anonymous457,
  Anonymous160,
  Anonymous081,
  Anonymous118,
  Anonymous285,
  Anonymous109,
  Anonymous184,
  Anonymous172,
  Anonymous384,
  Anonymous338,
  Anonymous070,
  Anonymous140,
  Anonymous434,
  Anonymous158,
  Anonymous444,
  Anonymous073,
  Anonymous114,
  AsyncShutdown,
  Anonymous340,
  AppStartup,
  Anonymous145,
  Anonymous443,
  Anonymous001,
  Anonymous075,
  Anonymous302,
  Anonymous135,
  Anonymous053,
  TypeAheadFind,
  Anonymous012,
  Anonymous033,
  Anonymous278,
  Anonymous355,
  Anonymous190,
  Anonymous381,
  Anonymous215,
  Anonymous045,
  Anonymous093,
  Directory,
  Anonymous349,
  Anonymous392,
  Anonymous186,
  Anonymous068,
  Anonymous334,
  Anonymous350,
  Anonymous196,
  Anonymous447,
  Anonymous032,
  Anonymous076,
  Anonymous086,
  Anonymous036,
  Anonymous408,
  Anonymous304,
  Anonymous325,
  Anonymous271,
  Anonymous058,
  Anonymous170,
  Anonymous177,
  Anonymous125,
  Anonymous401,
  Anonymous442,
  Anonymous299,
  Anonymous420,
  Anonymous406,
  Anonymous117,
  Anonymous363,
  Anonymous393,
  Anonymous360,
  Anonymous105,
  Anonymous382,
  Anonymous209,
  Anonymous212,
  Anonymous199,
  Anonymous237,
  Anonymous300,
  Anonymous011,
  Anonymous315,
  Anonymous261,
  Anonymous298,
  Anonymous168,
  Anonymous061,
  Anonymous437,
  Anonymous269,
  Anonymous260,
  LoginReputation,
  Anonymous026,
  Anonymous067,
  HttpActivityDistributor,
  Anonymous123,
  Anonymous144,
  Anonymous024,
  Anonymous283,
  Anonymous264,
  ThirdPartyUtil,
  Anonymous174,
  Anonymous107,
  Anonymous077,
  Anonymous148,
  Anonymous017,
  Anonymous364,
  CookieBannerService,
  Anonymous326,
  Anonymous265,
  Anonymous448,
  Anonymous005,
  Anonymous236,
  Anonymous111,
  Anonymous234,
  Anonymous098,
  Anonymous403,
  Anonymous015,
  Anonymous432,
  Anonymous189,
  Anonymous031,
  FindService,
  Anonymous327,
  Anonymous047,
  Anonymous146,
  Anonymous424,
  Anonymous436,
  Anonymous213,
  Anonymous332,
  Anonymous297,
  Anonymous400,
  Anonymous147,
  UUIDGenerator,
  Anonymous387,
  Anonymous055,
  Anonymous316,
  Anonymous240,
  Anonymous066,
  Anonymous345,
  Anonymous267,
  Anonymous096,
  Anonymous398,
  Anonymous021,
  Anonymous191,
  CacheStorage,
  Anonymous404,
  Anonymous418,
  Anonymous254,
  Anonymous383,
  Anonymous040,
  Anonymous050,
  Anonymous194,
  Anonymous367,
  Anonymous087,
  Anonymous369,
  Anonymous220,
  Anonymous188,
  Anonymous157,
  Anonymous358,
  Anonymous242,
  Anonymous138,
  Anonymous376,
  Anonymous152,
  Anonymous331,
  Anonymous180,
  ServiceWorkerManager,
  Anonymous007,
  Anonymous227,
  Anonymous377,
  Anonymous201,
  Anonymous159,
  Anonymous410,
  Anonymous452,
  Anonymous178,
  Anonymous016,
  UrlClassifierDB,
  Anonymous131,
  Anonymous099,
  Anonymous019,
  Anonymous071,
  GfxInfo,
  Anonymous122,
  Anonymous305,
  Anonymous440,
  Anonymous028,
  Anonymous027,
  Anonymous080,
  Anonymous142,
  Anonymous164,
  Anonymous248,
  Anonymous293,
  Anonymous259,
  Anonymous235,
  Anonymous368,
  Anonymous399,
  Anonymous239,
  AddonContentPolicy,
  Anonymous185,
  Anonymous008,
  Anonymous216,
  Anonymous354,
  Anonymous339,
  Anonymous112,
  Anonymous372,
  Anonymous257,
  Anonymous056,
  Anonymous101,
  Anonymous059,
  Anonymous126,
  Anonymous106,
  Anonymous179,
  Anonymous365,
  Anonymous035,
  Anonymous389,
  Anonymous063,
  Anonymous197,
  Anonymous097,
  Anonymous232,
  Anonymous429,
  Anonymous318,
  Anonymous211,
  Anonymous128,
  Anonymous062,
  Anonymous307,
  Anonymous127,
  Anonymous245,
  Anonymous090,
  Anonymous427,
  Anonymous150,
  Anonymous116,
  SocketTransport,
  Anonymous328,
  Anonymous397,
  Anonymous013,
  Anonymous221,
  Anonymous233,
  Anonymous388,
  Anonymous069,
  Anonymous272,
  Anonymous203,
  Anonymous335,
  Anonymous115,
  Anonymous351,
  Anonymous083,
  Anonymous409,
  Anonymous143,
  Anonymous247,
  Anonymous120,
  Anonymous181,
  Anonymous378,
  Anonymous385,
  Anonymous171,
  Anonymous366,
  Anonymous312,
  Anonymous165,
  Anonymous371,
  Anonymous022,
  Anonymous454,
  Anonymous414,
  Anonymous352,
  Anonymous342,
  Anonymous091,
  Anonymous416,
  Prefetch,
  Anonymous042,
  Anonymous251,
  Anonymous217,
  DocLoader,
  ChromeRegistry,
  Anonymous224,
  Anonymous333,
  Anonymous183,
  Anonymous470,
  Anonymous230,
  Anonymous003,
  Anonymous052,
  Anonymous456,
  Anonymous167,
  Anonymous057,
  Anonymous323,
  Anonymous290,
  UrlClassifierStreamUpdater,
  Anonymous000,
  IdentityCredentialPromptService,
  Anonymous468,
  Anonymous370,
  Anonymous133,
  StreamTransport,
  Anonymous166,
  Anonymous192,
  Anonymous129,
  Anonymous266,
  Anonymous463,
  Anonymous446,
  Anonymous356,
  Anonymous461,
  Anonymous210,
  Anonymous411,
  Anonymous324,
  Anonymous018,
  Anonymous153,
  Anonymous465,
  AlertNotification,
  Anonymous451,
  Anonymous078,
  Anonymous241,
  Anonymous450,
  Anonymous467,
  Anonymous321,
  Anonymous089,
  Anonymous276,
  Anonymous317,
  Anonymous394,
  Anonymous039,
  Anonymous149,
  Anonymous268,
  Anonymous163,
  Anonymous375,
  Anonymous244,
  Anonymous309,
  Anonymous314,
  Anonymous204,
  Anonymous426,
  Anonymous464,
  Anonymous255,
  Anonymous124,
  Anonymous439,
  Anonymous100,
  Anonymous252,
  Anonymous415,
  Anonymous072,
  Anonymous119,
  Anonymous228,
  Anonymous041,
  Anonymous182,
  Anonymous380,
  Anonymous155,
  Anonymous287,
  Anonymous438,
  Anonymous020,
  Observer,
  IdentityCredentialStorageService,
  Anonymous088,
  Anonymous346,
  Anonymous176,
  Anonymous460,
  Anonymous034,
  Anonymous292,
  Anonymous151,
  IO,
  StringBundle,
  Anonymous303,
  Anonymous277,
  Anonymous435,
  Anonymous051,
  Anonymous023,
  Anonymous379,
  Anonymous173,
  Anonymous458,
  Anonymous025,
  Anonymous226,
  Anonymous218,
  Anonymous137,
  Anonymous084,
  URILoader,
  Anonymous134,
  Anonymous322,
  Anonymous353,
  Anonymous453,
  Anonymous441,
  Anonymous462,
  Anonymous246,
  Anonymous348,
  Anonymous079,
  Anonymous425,
  Anonymous009,
  Anonymous002,
  XULRuntime,
  Anonymous282,
  Anonymous273,
  Anonymous373,
  URIFixup,
  Anonymous310,
  Anonymous412,
  Anonymous281,
  Anonymous284,
  DNS,
  Anonymous275,
  Anonymous329,
  Anonymous417,
  Anonymous169,
  Anonymous095,
  Anonymous065,
  Anonymous195,
  Anonymous311,
  Anonymous238,
  Anonymous108,
  Anonymous431,
  ExtensionPolicy,
  Anonymous258,
  Anonymous422,
  Anonymous291,
  Anonymous113,
  Anonymous202,
  Anonymous043,
  Anonymous175,
  Anonymous038,
  UrlClassifierPrefixSet,
  Anonymous010,
  Anonymous162,
  Anonymous286,
  Anonymous263,
  Anonymous029,
  Anonymous110,
  Anonymous060,
  Anonymous430,
  Anonymous193,
  Anonymous250,
  Anonymous472,
  ApplicationReputation,
  Anonymous037,
  Anonymous161,
  URLQueryStringStripper,
  Anonymous347,
  Anonymous154,
  Alerts,
  Anonymous219,
  Anonymous459,
  Anonymous130,
  Anonymous390,
  PermissionManager,
  Anonymous225,
  Anonymous206,
  Anonymous374,
  Anonymous306,
  Anonymous048,
  Anonymous046,
  Anonymous262,
  Anonymous121,
  Anonymous362,
  Anonymous386,
  Anonymous445,
  Anonymous471,
  Anonymous396,
  Anonymous402,
  Anonymous294,
  Anonymous289,
  Anonymous455,
  Anonymous357,
  Anonymous421,
  Anonymous336,
  Anonymous270,
  Anonymous223,
  Anonymous308,
  Anonymous433,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace LoginReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::LoginReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::LoginReputation, aRv};
}
}  // namespace LoginReputation

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

}  // namespace components

}  // namespace mozilla

#endif
