(function (factory) {
    typeof define === 'function' && define.amd ? define(factory) :
    factory();
})((function () { 'use strict';

    (function() {
        const env = {"NODE_ENV":"production"};
        try {
            if (process) {
                process.env = Object.assign({}, process.env);
                Object.assign(process.env, env);
                return;
            }
        } catch (e) {} // avoid ReferenceError: process is not defined
        globalThis.process = { env:env };
    })();

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    var lib$6 = {};

    var isReactComponent$4 = {};

    var buildMatchMemberExpression$3 = {};

    var matchesPattern$3 = {};

    var generated$8 = {};

    var shallowEqual$3 = {};

    Object.defineProperty(shallowEqual$3, "__esModule", {
      value: true
    });
    shallowEqual$3.default = shallowEqual$2;

    function shallowEqual$2(actual, expected) {
      const keys = Object.keys(expected);

      for (const key of keys) {
        if (actual[key] !== expected[key]) {
          return false;
        }
      }

      return true;
    }

    Object.defineProperty(generated$8, "__esModule", {
      value: true
    });
    generated$8.isArrayExpression = isArrayExpression$2;
    generated$8.isAssignmentExpression = isAssignmentExpression$3;
    generated$8.isBinaryExpression = isBinaryExpression$2;
    generated$8.isInterpreterDirective = isInterpreterDirective$1;
    generated$8.isDirective = isDirective$1;
    generated$8.isDirectiveLiteral = isDirectiveLiteral$1;
    generated$8.isBlockStatement = isBlockStatement$2;
    generated$8.isBreakStatement = isBreakStatement$1;
    generated$8.isCallExpression = isCallExpression$5;
    generated$8.isCatchClause = isCatchClause$1;
    generated$8.isConditionalExpression = isConditionalExpression$2;
    generated$8.isContinueStatement = isContinueStatement$1;
    generated$8.isDebuggerStatement = isDebuggerStatement$1;
    generated$8.isDoWhileStatement = isDoWhileStatement$1;
    generated$8.isEmptyStatement = isEmptyStatement$2;
    generated$8.isExpressionStatement = isExpressionStatement$3;
    generated$8.isFile = isFile$2;
    generated$8.isForInStatement = isForInStatement$2;
    generated$8.isForStatement = isForStatement$3;
    generated$8.isFunctionDeclaration = isFunctionDeclaration$1;
    generated$8.isFunctionExpression = isFunctionExpression$1;
    generated$8.isIdentifier = isIdentifier$4;
    generated$8.isIfStatement = isIfStatement$3;
    generated$8.isLabeledStatement = isLabeledStatement$1;
    generated$8.isStringLiteral = isStringLiteral$2;
    generated$8.isNumericLiteral = isNumericLiteral$1;
    generated$8.isNullLiteral = isNullLiteral$1;
    generated$8.isBooleanLiteral = isBooleanLiteral$1;
    generated$8.isRegExpLiteral = isRegExpLiteral$1;
    generated$8.isLogicalExpression = isLogicalExpression$2;
    generated$8.isMemberExpression = isMemberExpression$5;
    generated$8.isNewExpression = isNewExpression$4;
    generated$8.isProgram = isProgram$2;
    generated$8.isObjectExpression = isObjectExpression$2;
    generated$8.isObjectMethod = isObjectMethod$1;
    generated$8.isObjectProperty = isObjectProperty$1;
    generated$8.isRestElement = isRestElement$1;
    generated$8.isReturnStatement = isReturnStatement$2;
    generated$8.isSequenceExpression = isSequenceExpression$2;
    generated$8.isParenthesizedExpression = isParenthesizedExpression$1;
    generated$8.isSwitchCase = isSwitchCase$1;
    generated$8.isSwitchStatement = isSwitchStatement$2;
    generated$8.isThisExpression = isThisExpression$1;
    generated$8.isThrowStatement = isThrowStatement$2;
    generated$8.isTryStatement = isTryStatement$1;
    generated$8.isUnaryExpression = isUnaryExpression$1;
    generated$8.isUpdateExpression = isUpdateExpression$1;
    generated$8.isVariableDeclaration = isVariableDeclaration$1;
    generated$8.isVariableDeclarator = isVariableDeclarator$2;
    generated$8.isWhileStatement = isWhileStatement$2;
    generated$8.isWithStatement = isWithStatement$1;
    generated$8.isAssignmentPattern = isAssignmentPattern$2;
    generated$8.isArrayPattern = isArrayPattern$1;
    generated$8.isArrowFunctionExpression = isArrowFunctionExpression$2;
    generated$8.isClassBody = isClassBody$1;
    generated$8.isClassExpression = isClassExpression$2;
    generated$8.isClassDeclaration = isClassDeclaration$3;
    generated$8.isExportAllDeclaration = isExportAllDeclaration$1;
    generated$8.isExportDefaultDeclaration = isExportDefaultDeclaration$3;
    generated$8.isExportNamedDeclaration = isExportNamedDeclaration$2;
    generated$8.isExportSpecifier = isExportSpecifier$1;
    generated$8.isForOfStatement = isForOfStatement$2;
    generated$8.isImportDeclaration = isImportDeclaration$1;
    generated$8.isImportDefaultSpecifier = isImportDefaultSpecifier$2;
    generated$8.isImportNamespaceSpecifier = isImportNamespaceSpecifier$2;
    generated$8.isImportSpecifier = isImportSpecifier$1;
    generated$8.isMetaProperty = isMetaProperty$1;
    generated$8.isClassMethod = isClassMethod$1;
    generated$8.isObjectPattern = isObjectPattern$2;
    generated$8.isSpreadElement = isSpreadElement$1;
    generated$8.isSuper = isSuper$1;
    generated$8.isTaggedTemplateExpression = isTaggedTemplateExpression$2;
    generated$8.isTemplateElement = isTemplateElement$1;
    generated$8.isTemplateLiteral = isTemplateLiteral$1;
    generated$8.isYieldExpression = isYieldExpression$2;
    generated$8.isAwaitExpression = isAwaitExpression$2;
    generated$8.isImport = isImport$1;
    generated$8.isBigIntLiteral = isBigIntLiteral$1;
    generated$8.isExportNamespaceSpecifier = isExportNamespaceSpecifier$2;
    generated$8.isOptionalMemberExpression = isOptionalMemberExpression$3;
    generated$8.isOptionalCallExpression = isOptionalCallExpression$3;
    generated$8.isClassProperty = isClassProperty$1;
    generated$8.isClassPrivateProperty = isClassPrivateProperty$1;
    generated$8.isClassPrivateMethod = isClassPrivateMethod$1;
    generated$8.isPrivateName = isPrivateName$1;
    generated$8.isAnyTypeAnnotation = isAnyTypeAnnotation$1;
    generated$8.isArrayTypeAnnotation = isArrayTypeAnnotation$2;
    generated$8.isBooleanTypeAnnotation = isBooleanTypeAnnotation$1;
    generated$8.isBooleanLiteralTypeAnnotation = isBooleanLiteralTypeAnnotation$1;
    generated$8.isNullLiteralTypeAnnotation = isNullLiteralTypeAnnotation$1;
    generated$8.isClassImplements = isClassImplements$1;
    generated$8.isDeclareClass = isDeclareClass$1;
    generated$8.isDeclareFunction = isDeclareFunction$1;
    generated$8.isDeclareInterface = isDeclareInterface$1;
    generated$8.isDeclareModule = isDeclareModule$1;
    generated$8.isDeclareModuleExports = isDeclareModuleExports$1;
    generated$8.isDeclareTypeAlias = isDeclareTypeAlias$1;
    generated$8.isDeclareOpaqueType = isDeclareOpaqueType$1;
    generated$8.isDeclareVariable = isDeclareVariable$1;
    generated$8.isDeclareExportDeclaration = isDeclareExportDeclaration$1;
    generated$8.isDeclareExportAllDeclaration = isDeclareExportAllDeclaration$1;
    generated$8.isDeclaredPredicate = isDeclaredPredicate$1;
    generated$8.isExistsTypeAnnotation = isExistsTypeAnnotation$1;
    generated$8.isFunctionTypeAnnotation = isFunctionTypeAnnotation$1;
    generated$8.isFunctionTypeParam = isFunctionTypeParam$1;
    generated$8.isGenericTypeAnnotation = isGenericTypeAnnotation$1;
    generated$8.isInferredPredicate = isInferredPredicate$1;
    generated$8.isInterfaceExtends = isInterfaceExtends$1;
    generated$8.isInterfaceDeclaration = isInterfaceDeclaration$1;
    generated$8.isInterfaceTypeAnnotation = isInterfaceTypeAnnotation$1;
    generated$8.isIntersectionTypeAnnotation = isIntersectionTypeAnnotation$2;
    generated$8.isMixedTypeAnnotation = isMixedTypeAnnotation$1;
    generated$8.isEmptyTypeAnnotation = isEmptyTypeAnnotation$1;
    generated$8.isNullableTypeAnnotation = isNullableTypeAnnotation$2;
    generated$8.isNumberLiteralTypeAnnotation = isNumberLiteralTypeAnnotation$1;
    generated$8.isNumberTypeAnnotation = isNumberTypeAnnotation$1;
    generated$8.isObjectTypeAnnotation = isObjectTypeAnnotation$1;
    generated$8.isObjectTypeInternalSlot = isObjectTypeInternalSlot$1;
    generated$8.isObjectTypeCallProperty = isObjectTypeCallProperty$1;
    generated$8.isObjectTypeIndexer = isObjectTypeIndexer$1;
    generated$8.isObjectTypeProperty = isObjectTypeProperty$1;
    generated$8.isObjectTypeSpreadProperty = isObjectTypeSpreadProperty$1;
    generated$8.isOpaqueType = isOpaqueType$1;
    generated$8.isQualifiedTypeIdentifier = isQualifiedTypeIdentifier$1;
    generated$8.isStringLiteralTypeAnnotation = isStringLiteralTypeAnnotation$1;
    generated$8.isStringTypeAnnotation = isStringTypeAnnotation$1;
    generated$8.isSymbolTypeAnnotation = isSymbolTypeAnnotation$1;
    generated$8.isThisTypeAnnotation = isThisTypeAnnotation$1;
    generated$8.isTupleTypeAnnotation = isTupleTypeAnnotation$1;
    generated$8.isTypeofTypeAnnotation = isTypeofTypeAnnotation$1;
    generated$8.isTypeAlias = isTypeAlias$1;
    generated$8.isTypeAnnotation = isTypeAnnotation$2;
    generated$8.isTypeCastExpression = isTypeCastExpression$1;
    generated$8.isTypeParameter = isTypeParameter$1;
    generated$8.isTypeParameterDeclaration = isTypeParameterDeclaration$1;
    generated$8.isTypeParameterInstantiation = isTypeParameterInstantiation$1;
    generated$8.isUnionTypeAnnotation = isUnionTypeAnnotation$2;
    generated$8.isVariance = isVariance$1;
    generated$8.isVoidTypeAnnotation = isVoidTypeAnnotation$1;
    generated$8.isEnumDeclaration = isEnumDeclaration$1;
    generated$8.isEnumBooleanBody = isEnumBooleanBody$1;
    generated$8.isEnumNumberBody = isEnumNumberBody$1;
    generated$8.isEnumStringBody = isEnumStringBody$1;
    generated$8.isEnumSymbolBody = isEnumSymbolBody$1;
    generated$8.isEnumBooleanMember = isEnumBooleanMember$1;
    generated$8.isEnumNumberMember = isEnumNumberMember$1;
    generated$8.isEnumStringMember = isEnumStringMember$1;
    generated$8.isEnumDefaultedMember = isEnumDefaultedMember$1;
    generated$8.isIndexedAccessType = isIndexedAccessType$1;
    generated$8.isOptionalIndexedAccessType = isOptionalIndexedAccessType;
    generated$8.isJSXAttribute = isJSXAttribute$1;
    generated$8.isJSXClosingElement = isJSXClosingElement$1;
    generated$8.isJSXElement = isJSXElement$1;
    generated$8.isJSXEmptyExpression = isJSXEmptyExpression$1;
    generated$8.isJSXExpressionContainer = isJSXExpressionContainer$1;
    generated$8.isJSXSpreadChild = isJSXSpreadChild$1;
    generated$8.isJSXIdentifier = isJSXIdentifier$1;
    generated$8.isJSXMemberExpression = isJSXMemberExpression$1;
    generated$8.isJSXNamespacedName = isJSXNamespacedName$1;
    generated$8.isJSXOpeningElement = isJSXOpeningElement$1;
    generated$8.isJSXSpreadAttribute = isJSXSpreadAttribute$1;
    generated$8.isJSXText = isJSXText$1;
    generated$8.isJSXFragment = isJSXFragment$1;
    generated$8.isJSXOpeningFragment = isJSXOpeningFragment$1;
    generated$8.isJSXClosingFragment = isJSXClosingFragment$1;
    generated$8.isNoop = isNoop$1;
    generated$8.isPlaceholder = isPlaceholder$1;
    generated$8.isV8IntrinsicIdentifier = isV8IntrinsicIdentifier$1;
    generated$8.isArgumentPlaceholder = isArgumentPlaceholder$1;
    generated$8.isBindExpression = isBindExpression$1;
    generated$8.isImportAttribute = isImportAttribute$1;
    generated$8.isDecorator = isDecorator$1;
    generated$8.isDoExpression = isDoExpression$1;
    generated$8.isExportDefaultSpecifier = isExportDefaultSpecifier$2;
    generated$8.isRecordExpression = isRecordExpression$1;
    generated$8.isTupleExpression = isTupleExpression$1;
    generated$8.isDecimalLiteral = isDecimalLiteral;
    generated$8.isStaticBlock = isStaticBlock;
    generated$8.isModuleExpression = isModuleExpression;
    generated$8.isTopicReference = isTopicReference;
    generated$8.isPipelineTopicExpression = isPipelineTopicExpression$1;
    generated$8.isPipelineBareFunction = isPipelineBareFunction$1;
    generated$8.isPipelinePrimaryTopicReference = isPipelinePrimaryTopicReference$1;
    generated$8.isTSParameterProperty = isTSParameterProperty$1;
    generated$8.isTSDeclareFunction = isTSDeclareFunction$1;
    generated$8.isTSDeclareMethod = isTSDeclareMethod$1;
    generated$8.isTSQualifiedName = isTSQualifiedName$1;
    generated$8.isTSCallSignatureDeclaration = isTSCallSignatureDeclaration$1;
    generated$8.isTSConstructSignatureDeclaration = isTSConstructSignatureDeclaration$1;
    generated$8.isTSPropertySignature = isTSPropertySignature$1;
    generated$8.isTSMethodSignature = isTSMethodSignature$1;
    generated$8.isTSIndexSignature = isTSIndexSignature$1;
    generated$8.isTSAnyKeyword = isTSAnyKeyword$1;
    generated$8.isTSBooleanKeyword = isTSBooleanKeyword$1;
    generated$8.isTSBigIntKeyword = isTSBigIntKeyword$1;
    generated$8.isTSIntrinsicKeyword = isTSIntrinsicKeyword;
    generated$8.isTSNeverKeyword = isTSNeverKeyword$1;
    generated$8.isTSNullKeyword = isTSNullKeyword$1;
    generated$8.isTSNumberKeyword = isTSNumberKeyword$1;
    generated$8.isTSObjectKeyword = isTSObjectKeyword$1;
    generated$8.isTSStringKeyword = isTSStringKeyword$1;
    generated$8.isTSSymbolKeyword = isTSSymbolKeyword$1;
    generated$8.isTSUndefinedKeyword = isTSUndefinedKeyword$1;
    generated$8.isTSUnknownKeyword = isTSUnknownKeyword$1;
    generated$8.isTSVoidKeyword = isTSVoidKeyword$1;
    generated$8.isTSThisType = isTSThisType$1;
    generated$8.isTSFunctionType = isTSFunctionType$1;
    generated$8.isTSConstructorType = isTSConstructorType$1;
    generated$8.isTSTypeReference = isTSTypeReference$1;
    generated$8.isTSTypePredicate = isTSTypePredicate$1;
    generated$8.isTSTypeQuery = isTSTypeQuery$1;
    generated$8.isTSTypeLiteral = isTSTypeLiteral$1;
    generated$8.isTSArrayType = isTSArrayType$2;
    generated$8.isTSTupleType = isTSTupleType$1;
    generated$8.isTSOptionalType = isTSOptionalType$2;
    generated$8.isTSRestType = isTSRestType$2;
    generated$8.isTSNamedTupleMember = isTSNamedTupleMember;
    generated$8.isTSUnionType = isTSUnionType$2;
    generated$8.isTSIntersectionType = isTSIntersectionType$2;
    generated$8.isTSConditionalType = isTSConditionalType$1;
    generated$8.isTSInferType = isTSInferType$1;
    generated$8.isTSParenthesizedType = isTSParenthesizedType$1;
    generated$8.isTSTypeOperator = isTSTypeOperator$1;
    generated$8.isTSIndexedAccessType = isTSIndexedAccessType$1;
    generated$8.isTSMappedType = isTSMappedType$1;
    generated$8.isTSLiteralType = isTSLiteralType$1;
    generated$8.isTSExpressionWithTypeArguments = isTSExpressionWithTypeArguments$1;
    generated$8.isTSInterfaceDeclaration = isTSInterfaceDeclaration$1;
    generated$8.isTSInterfaceBody = isTSInterfaceBody$1;
    generated$8.isTSTypeAliasDeclaration = isTSTypeAliasDeclaration$1;
    generated$8.isTSAsExpression = isTSAsExpression$2;
    generated$8.isTSTypeAssertion = isTSTypeAssertion$2;
    generated$8.isTSEnumDeclaration = isTSEnumDeclaration$1;
    generated$8.isTSEnumMember = isTSEnumMember$1;
    generated$8.isTSModuleDeclaration = isTSModuleDeclaration$1;
    generated$8.isTSModuleBlock = isTSModuleBlock$1;
    generated$8.isTSImportType = isTSImportType$1;
    generated$8.isTSImportEqualsDeclaration = isTSImportEqualsDeclaration$1;
    generated$8.isTSExternalModuleReference = isTSExternalModuleReference$1;
    generated$8.isTSNonNullExpression = isTSNonNullExpression$2;
    generated$8.isTSExportAssignment = isTSExportAssignment$1;
    generated$8.isTSNamespaceExportDeclaration = isTSNamespaceExportDeclaration$1;
    generated$8.isTSTypeAnnotation = isTSTypeAnnotation$1;
    generated$8.isTSTypeParameterInstantiation = isTSTypeParameterInstantiation$1;
    generated$8.isTSTypeParameterDeclaration = isTSTypeParameterDeclaration$1;
    generated$8.isTSTypeParameter = isTSTypeParameter$1;
    generated$8.isExpression = isExpression$1;
    generated$8.isBinary = isBinary$3;
    generated$8.isScopable = isScopable$1;
    generated$8.isBlockParent = isBlockParent$1;
    generated$8.isBlock = isBlock$1;
    generated$8.isStatement = isStatement$3;
    generated$8.isTerminatorless = isTerminatorless$1;
    generated$8.isCompletionStatement = isCompletionStatement$1;
    generated$8.isConditional = isConditional$2;
    generated$8.isLoop = isLoop$3;
    generated$8.isWhile = isWhile$1;
    generated$8.isExpressionWrapper = isExpressionWrapper$1;
    generated$8.isFor = isFor$3;
    generated$8.isForXStatement = isForXStatement$1;
    generated$8.isFunction = isFunction$7;
    generated$8.isFunctionParent = isFunctionParent$1;
    generated$8.isPureish = isPureish$1;
    generated$8.isDeclaration = isDeclaration$1;
    generated$8.isPatternLike = isPatternLike$1;
    generated$8.isLVal = isLVal$1;
    generated$8.isTSEntityName = isTSEntityName$1;
    generated$8.isLiteral = isLiteral$3;
    generated$8.isImmutable = isImmutable$5;
    generated$8.isUserWhitespacable = isUserWhitespacable$1;
    generated$8.isMethod = isMethod$1;
    generated$8.isObjectMember = isObjectMember$1;
    generated$8.isProperty = isProperty$1;
    generated$8.isUnaryLike = isUnaryLike$2;
    generated$8.isPattern = isPattern$1;
    generated$8.isClass = isClass$1;
    generated$8.isModuleDeclaration = isModuleDeclaration$1;
    generated$8.isExportDeclaration = isExportDeclaration$2;
    generated$8.isModuleSpecifier = isModuleSpecifier$1;
    generated$8.isPrivate = isPrivate$1;
    generated$8.isFlow = isFlow$1;
    generated$8.isFlowType = isFlowType$1;
    generated$8.isFlowBaseAnnotation = isFlowBaseAnnotation$1;
    generated$8.isFlowDeclaration = isFlowDeclaration$1;
    generated$8.isFlowPredicate = isFlowPredicate$1;
    generated$8.isEnumBody = isEnumBody$1;
    generated$8.isEnumMember = isEnumMember$1;
    generated$8.isJSX = isJSX$1;
    generated$8.isTSTypeElement = isTSTypeElement$1;
    generated$8.isTSType = isTSType$1;
    generated$8.isTSBaseType = isTSBaseType$1;
    generated$8.isNumberLiteral = isNumberLiteral$1;
    generated$8.isRegexLiteral = isRegexLiteral$1;
    generated$8.isRestProperty = isRestProperty$1;
    generated$8.isSpreadProperty = isSpreadProperty$1;

    var _shallowEqual$1 = shallowEqual$3;

    function isArrayExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrayExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isAssignmentExpression$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AssignmentExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBinaryExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BinaryExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isInterpreterDirective$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterpreterDirective") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDirective$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Directive") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDirectiveLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DirectiveLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBlockStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BlockStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBreakStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BreakStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isCallExpression$5(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "CallExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isCatchClause$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "CatchClause") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isConditionalExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ConditionalExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isContinueStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ContinueStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDebuggerStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DebuggerStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDoWhileStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DoWhileStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEmptyStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EmptyStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExpressionStatement$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExpressionStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFile$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "File") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isForInStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForInStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isForStatement$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isIdentifier$4(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Identifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isIfStatement$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "IfStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isLabeledStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "LabeledStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isStringLiteral$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StringLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNumericLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumericLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNullLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NullLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBooleanLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BooleanLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isRegExpLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RegExpLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isLogicalExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "LogicalExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isMemberExpression$5(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "MemberExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNewExpression$4(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NewExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isProgram$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Program") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectMethod$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isRestElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RestElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isReturnStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ReturnStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSequenceExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SequenceExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isParenthesizedExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ParenthesizedExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSwitchCase$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SwitchCase") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSwitchStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SwitchStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isThisExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ThisExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isThrowStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ThrowStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTryStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TryStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isUnaryExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UnaryExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isUpdateExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UpdateExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isVariableDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "VariableDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isVariableDeclarator$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "VariableDeclarator") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isWhileStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "WhileStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isWithStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "WithStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isAssignmentPattern$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AssignmentPattern") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isArrayPattern$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrayPattern") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isArrowFunctionExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrowFunctionExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassDeclaration$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportAllDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportAllDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportDefaultDeclaration$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportDefaultDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportNamedDeclaration$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportNamedDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isForOfStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForOfStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImportDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImportDefaultSpecifier$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportDefaultSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImportNamespaceSpecifier$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportNamespaceSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImportSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isMetaProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "MetaProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassMethod$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectPattern$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectPattern") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSpreadElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SpreadElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSuper$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Super") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTaggedTemplateExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TaggedTemplateExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTemplateElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TemplateElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTemplateLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TemplateLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isYieldExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "YieldExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isAwaitExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AwaitExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImport$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Import") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBigIntLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BigIntLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportNamespaceSpecifier$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportNamespaceSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isOptionalMemberExpression$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OptionalMemberExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isOptionalCallExpression$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OptionalCallExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassPrivateProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassPrivateProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassPrivateMethod$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassPrivateMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPrivateName$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PrivateName") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isAnyTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AnyTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isArrayTypeAnnotation$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrayTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBooleanTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BooleanTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBooleanLiteralTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BooleanLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNullLiteralTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NullLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClassImplements$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassImplements") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareClass$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareClass") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareFunction$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareFunction") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareInterface$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareInterface") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareModule$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareModule") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareModuleExports$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareModuleExports") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareTypeAlias$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareTypeAlias") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareOpaqueType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareOpaqueType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareVariable$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareVariable") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareExportDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareExportDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareExportAllDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareExportAllDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclaredPredicate$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclaredPredicate") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExistsTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExistsTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionTypeParam$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionTypeParam") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isGenericTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "GenericTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isInferredPredicate$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InferredPredicate") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isInterfaceExtends$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterfaceExtends") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isInterfaceDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterfaceDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isInterfaceTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterfaceTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isIntersectionTypeAnnotation$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "IntersectionTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isMixedTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "MixedTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEmptyTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EmptyTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNullableTypeAnnotation$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NullableTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNumberLiteralTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumberLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNumberTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumberTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeInternalSlot$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeInternalSlot") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeCallProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeCallProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeIndexer$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeIndexer") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeSpreadProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeSpreadProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isOpaqueType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OpaqueType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isQualifiedTypeIdentifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "QualifiedTypeIdentifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isStringLiteralTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StringLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isStringTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StringTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSymbolTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SymbolTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isThisTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ThisTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTupleTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TupleTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeofTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeofTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeAlias$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeAlias") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeAnnotation$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeCastExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeCastExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeParameter$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeParameter") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeParameterDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeParameterDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeParameterInstantiation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeParameterInstantiation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isUnionTypeAnnotation$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UnionTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isVariance$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Variance") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isVoidTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "VoidTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumBooleanBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumBooleanBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumNumberBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumNumberBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumStringBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumStringBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumSymbolBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumSymbolBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumBooleanMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumBooleanMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumNumberMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumNumberMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumStringMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumStringMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumDefaultedMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumDefaultedMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isIndexedAccessType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "IndexedAccessType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isOptionalIndexedAccessType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OptionalIndexedAccessType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXAttribute$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXAttribute") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXClosingElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXClosingElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXEmptyExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXEmptyExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXExpressionContainer$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXExpressionContainer") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXSpreadChild$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXSpreadChild") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXIdentifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXIdentifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXMemberExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXMemberExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXNamespacedName$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXNamespacedName") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXOpeningElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXOpeningElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXSpreadAttribute$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXSpreadAttribute") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXText$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXText") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXFragment$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXFragment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXOpeningFragment$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXOpeningFragment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXClosingFragment$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXClosingFragment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNoop$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Noop") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPlaceholder$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Placeholder") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isV8IntrinsicIdentifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "V8IntrinsicIdentifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isArgumentPlaceholder$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArgumentPlaceholder") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBindExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BindExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImportAttribute$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportAttribute") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDecorator$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Decorator") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDoExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DoExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportDefaultSpecifier$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportDefaultSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isRecordExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RecordExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTupleExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TupleExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDecimalLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DecimalLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isStaticBlock(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StaticBlock") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isModuleExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ModuleExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTopicReference(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TopicReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPipelineTopicExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PipelineTopicExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPipelineBareFunction$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PipelineBareFunction") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPipelinePrimaryTopicReference$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PipelinePrimaryTopicReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSParameterProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSParameterProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSDeclareFunction$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSDeclareFunction") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSDeclareMethod$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSDeclareMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSQualifiedName$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSQualifiedName") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSCallSignatureDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSCallSignatureDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSConstructSignatureDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSConstructSignatureDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSPropertySignature$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSPropertySignature") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSMethodSignature$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSMethodSignature") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIndexSignature$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIndexSignature") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSAnyKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSAnyKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSBooleanKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSBooleanKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSBigIntKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSBigIntKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIntrinsicKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIntrinsicKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNeverKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNeverKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNullKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNullKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNumberKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNumberKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSObjectKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSObjectKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSStringKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSStringKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSSymbolKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSSymbolKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSUndefinedKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSUndefinedKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSUnknownKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSUnknownKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSVoidKeyword$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSVoidKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSThisType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSThisType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSFunctionType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSFunctionType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSConstructorType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSConstructorType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeReference$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypePredicate$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypePredicate") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeQuery$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeQuery") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSArrayType$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSArrayType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTupleType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTupleType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSOptionalType$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSOptionalType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSRestType$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSRestType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNamedTupleMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNamedTupleMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSUnionType$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSUnionType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIntersectionType$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIntersectionType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSConditionalType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSConditionalType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSInferType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSInferType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSParenthesizedType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSParenthesizedType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeOperator$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeOperator") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIndexedAccessType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIndexedAccessType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSMappedType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSMappedType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSLiteralType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSLiteralType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSExpressionWithTypeArguments$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSExpressionWithTypeArguments") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSInterfaceDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSInterfaceDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSInterfaceBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSInterfaceBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeAliasDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeAliasDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSAsExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSAsExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeAssertion$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeAssertion") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSEnumDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSEnumDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSEnumMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSEnumMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSModuleDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSModuleDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSModuleBlock$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSModuleBlock") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSImportType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSImportType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSImportEqualsDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSImportEqualsDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSExternalModuleReference$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSExternalModuleReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNonNullExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNonNullExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSExportAssignment$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSExportAssignment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNamespaceExportDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNamespaceExportDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeParameterInstantiation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeParameterInstantiation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeParameterDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeParameterDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeParameter$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeParameter") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ArrayExpression" === nodeType || "AssignmentExpression" === nodeType || "BinaryExpression" === nodeType || "CallExpression" === nodeType || "ConditionalExpression" === nodeType || "FunctionExpression" === nodeType || "Identifier" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "LogicalExpression" === nodeType || "MemberExpression" === nodeType || "NewExpression" === nodeType || "ObjectExpression" === nodeType || "SequenceExpression" === nodeType || "ParenthesizedExpression" === nodeType || "ThisExpression" === nodeType || "UnaryExpression" === nodeType || "UpdateExpression" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "MetaProperty" === nodeType || "Super" === nodeType || "TaggedTemplateExpression" === nodeType || "TemplateLiteral" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType || "Import" === nodeType || "BigIntLiteral" === nodeType || "OptionalMemberExpression" === nodeType || "OptionalCallExpression" === nodeType || "TypeCastExpression" === nodeType || "JSXElement" === nodeType || "JSXFragment" === nodeType || "BindExpression" === nodeType || "DoExpression" === nodeType || "RecordExpression" === nodeType || "TupleExpression" === nodeType || "DecimalLiteral" === nodeType || "ModuleExpression" === nodeType || "TopicReference" === nodeType || "PipelineTopicExpression" === nodeType || "PipelineBareFunction" === nodeType || "PipelinePrimaryTopicReference" === nodeType || "TSAsExpression" === nodeType || "TSTypeAssertion" === nodeType || "TSNonNullExpression" === nodeType || nodeType === "Placeholder" && ("Expression" === node.expectedNode || "Identifier" === node.expectedNode || "StringLiteral" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBinary$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BinaryExpression" === nodeType || "LogicalExpression" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isScopable$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "ClassDeclaration" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "StaticBlock" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBlockParent$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "StaticBlock" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isBlock$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BlockStatement" === nodeType || "Program" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isStatement$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BlockStatement" === nodeType || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "DebuggerStatement" === nodeType || "DoWhileStatement" === nodeType || "EmptyStatement" === nodeType || "ExpressionStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "IfStatement" === nodeType || "LabeledStatement" === nodeType || "ReturnStatement" === nodeType || "SwitchStatement" === nodeType || "ThrowStatement" === nodeType || "TryStatement" === nodeType || "VariableDeclaration" === nodeType || "WhileStatement" === nodeType || "WithStatement" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ForOfStatement" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || "TSImportEqualsDeclaration" === nodeType || "TSExportAssignment" === nodeType || "TSNamespaceExportDeclaration" === nodeType || nodeType === "Placeholder" && ("Statement" === node.expectedNode || "Declaration" === node.expectedNode || "BlockStatement" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTerminatorless$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isCompletionStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isConditional$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ConditionalExpression" === nodeType || "IfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isLoop$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "WhileStatement" === nodeType || "ForOfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isWhile$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("DoWhileStatement" === nodeType || "WhileStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExpressionWrapper$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ExpressionStatement" === nodeType || "ParenthesizedExpression" === nodeType || "TypeCastExpression" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFor$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ForInStatement" === nodeType || "ForStatement" === nodeType || "ForOfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isForXStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ForInStatement" === nodeType || "ForOfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFunction$7(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionParent$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPureish$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "ArrowFunctionExpression" === nodeType || "BigIntLiteral" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("FunctionDeclaration" === nodeType || "VariableDeclaration" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || nodeType === "Placeholder" && "Declaration" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPatternLike$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("Identifier" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isLVal$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("Identifier" === nodeType || "MemberExpression" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || "TSParameterProperty" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSEntityName$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("Identifier" === nodeType || "TSQualifiedName" === nodeType || nodeType === "Placeholder" && "Identifier" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isLiteral$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "TemplateLiteral" === nodeType || "BigIntLiteral" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isImmutable$5(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "BigIntLiteral" === nodeType || "JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXOpeningElement" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType || "DecimalLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isUserWhitespacable$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ObjectMethod" === nodeType || "ObjectProperty" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isMethod$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ObjectMethod" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ObjectMethod" === nodeType || "ObjectProperty" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isProperty$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ObjectProperty" === nodeType || "ClassProperty" === nodeType || "ClassPrivateProperty" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isUnaryLike$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("UnaryExpression" === nodeType || "SpreadElement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPattern$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && "Pattern" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isClass$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ClassExpression" === nodeType || "ClassDeclaration" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isModuleDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isExportDeclaration$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isModuleSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ExportSpecifier" === nodeType || "ImportDefaultSpecifier" === nodeType || "ImportNamespaceSpecifier" === nodeType || "ImportSpecifier" === nodeType || "ExportNamespaceSpecifier" === nodeType || "ExportDefaultSpecifier" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isPrivate$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("ClassPrivateProperty" === nodeType || "ClassPrivateMethod" === nodeType || "PrivateName" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFlow$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ClassImplements" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "DeclaredPredicate" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "FunctionTypeParam" === nodeType || "GenericTypeAnnotation" === nodeType || "InferredPredicate" === nodeType || "InterfaceExtends" === nodeType || "InterfaceDeclaration" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType || "OpaqueType" === nodeType || "QualifiedTypeIdentifier" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "TypeAlias" === nodeType || "TypeAnnotation" === nodeType || "TypeCastExpression" === nodeType || "TypeParameter" === nodeType || "TypeParameterDeclaration" === nodeType || "TypeParameterInstantiation" === nodeType || "UnionTypeAnnotation" === nodeType || "Variance" === nodeType || "VoidTypeAnnotation" === nodeType || "IndexedAccessType" === nodeType || "OptionalIndexedAccessType" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "GenericTypeAnnotation" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "UnionTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType || "IndexedAccessType" === nodeType || "OptionalIndexedAccessType" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowBaseAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("AnyTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowPredicate$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("DeclaredPredicate" === nodeType || "InferredPredicate" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumBody$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("EnumBooleanBody" === nodeType || "EnumNumberBody" === nodeType || "EnumStringBody" === nodeType || "EnumSymbolBody" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumMember$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("EnumBooleanMember" === nodeType || "EnumNumberMember" === nodeType || "EnumStringMember" === nodeType || "EnumDefaultedMember" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isJSX$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXEmptyExpression" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXIdentifier" === nodeType || "JSXMemberExpression" === nodeType || "JSXNamespacedName" === nodeType || "JSXOpeningElement" === nodeType || "JSXSpreadAttribute" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeElement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("TSCallSignatureDeclaration" === nodeType || "TSConstructSignatureDeclaration" === nodeType || "TSPropertySignature" === nodeType || "TSMethodSignature" === nodeType || "TSIndexSignature" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSIntrinsicKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSFunctionType" === nodeType || "TSConstructorType" === nodeType || "TSTypeReference" === nodeType || "TSTypePredicate" === nodeType || "TSTypeQuery" === nodeType || "TSTypeLiteral" === nodeType || "TSArrayType" === nodeType || "TSTupleType" === nodeType || "TSOptionalType" === nodeType || "TSRestType" === nodeType || "TSUnionType" === nodeType || "TSIntersectionType" === nodeType || "TSConditionalType" === nodeType || "TSInferType" === nodeType || "TSParenthesizedType" === nodeType || "TSTypeOperator" === nodeType || "TSIndexedAccessType" === nodeType || "TSMappedType" === nodeType || "TSLiteralType" === nodeType || "TSExpressionWithTypeArguments" === nodeType || "TSImportType" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isTSBaseType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if ("TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSIntrinsicKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSLiteralType" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isNumberLiteral$1(node, opts) {
      console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumberLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isRegexLiteral$1(node, opts) {
      console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RegexLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isRestProperty$1(node, opts) {
      console.trace("The node type RestProperty has been renamed to RestElement");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RestProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    function isSpreadProperty$1(node, opts) {
      console.trace("The node type SpreadProperty has been renamed to SpreadElement");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SpreadProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual$1.default)(node, opts);
        }
      }

      return false;
    }

    Object.defineProperty(matchesPattern$3, "__esModule", {
      value: true
    });
    matchesPattern$3.default = matchesPattern$2;

    var _generated$M = generated$8;

    function matchesPattern$2(member, match, allowPartial) {
      if (!(0, _generated$M.isMemberExpression)(member)) return false;
      const parts = Array.isArray(match) ? match : match.split(".");
      const nodes = [];
      let node;

      for (node = member; (0, _generated$M.isMemberExpression)(node); node = node.object) {
        nodes.push(node.property);
      }

      nodes.push(node);
      if (nodes.length < parts.length) return false;
      if (!allowPartial && nodes.length > parts.length) return false;

      for (let i = 0, j = nodes.length - 1; i < parts.length; i++, j--) {
        const node = nodes[j];
        let value;

        if ((0, _generated$M.isIdentifier)(node)) {
          value = node.name;
        } else if ((0, _generated$M.isStringLiteral)(node)) {
          value = node.value;
        } else if ((0, _generated$M.isThisExpression)(node)) {
          value = "this";
        } else {
          return false;
        }

        if (parts[i] !== value) return false;
      }

      return true;
    }

    Object.defineProperty(buildMatchMemberExpression$3, "__esModule", {
      value: true
    });
    buildMatchMemberExpression$3.default = buildMatchMemberExpression$2;

    var _matchesPattern$1 = matchesPattern$3;

    function buildMatchMemberExpression$2(match, allowPartial) {
      const parts = match.split(".");
      return member => (0, _matchesPattern$1.default)(member, parts, allowPartial);
    }

    Object.defineProperty(isReactComponent$4, "__esModule", {
      value: true
    });
    isReactComponent$4.default = void 0;

    var _buildMatchMemberExpression$1 = buildMatchMemberExpression$3;

    const isReactComponent$3 = (0, _buildMatchMemberExpression$1.default)("React.Component");
    var _default$8 = isReactComponent$3;
    isReactComponent$4.default = _default$8;

    var isCompatTag$3 = {};

    Object.defineProperty(isCompatTag$3, "__esModule", {
      value: true
    });
    isCompatTag$3.default = isCompatTag$2;

    function isCompatTag$2(tagName) {
      return !!tagName && /^[a-z]/.test(tagName);
    }

    var buildChildren$3 = {};

    var cleanJSXElementLiteralChild$3 = {};

    var generated$7 = {};

    var builder$3 = {};

    var definitions$1 = {};

    let fastProto = null;

    // Creates an object with permanently fast properties in V8. See Toon Verwaest's
    // post https://medium.com/@tverwaes/setting-up-prototypes-in-v8-ec9c9491dfe2#5f62
    // for more details. Use %HasFastProperties(object) and the Node.js flag
    // --allow-natives-syntax to check whether an object has fast properties.
    function FastObject(o) {
    	// A prototype object will have "fast properties" enabled once it is checked
    	// against the inline property cache of a function, e.g. fastProto.property:
    	// https://github.com/v8/v8/blob/6.0.122/test/mjsunit/fast-prototype.js#L48-L63
    	if (fastProto !== null && typeof fastProto.property) {
    		const result = fastProto;
    		fastProto = FastObject.prototype = null;
    		return result;
    	}
    	fastProto = FastObject.prototype = o == null ? Object.create(null) : o;
    	return new FastObject;
    }

    // Initialize the inline property cache of FastObject
    FastObject();

    var toFastProperties = function toFastproperties(o) {
    	return FastObject(o);
    };

    var global$1 = (typeof global !== "undefined" ? global :
      typeof self !== "undefined" ? self :
      typeof window !== "undefined" ? window : {});

    // shim for using process in browser
    // based off https://github.com/defunctzombie/node-process/blob/master/browser.js

    function defaultSetTimout() {
        throw new Error('setTimeout has not been defined');
    }
    function defaultClearTimeout () {
        throw new Error('clearTimeout has not been defined');
    }
    var cachedSetTimeout = defaultSetTimout;
    var cachedClearTimeout = defaultClearTimeout;
    if (typeof global$1.setTimeout === 'function') {
        cachedSetTimeout = setTimeout;
    }
    if (typeof global$1.clearTimeout === 'function') {
        cachedClearTimeout = clearTimeout;
    }

    function runTimeout(fun) {
        if (cachedSetTimeout === setTimeout) {
            //normal enviroments in sane situations
            return setTimeout(fun, 0);
        }
        // if setTimeout wasn't available but was latter defined
        if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
            cachedSetTimeout = setTimeout;
            return setTimeout(fun, 0);
        }
        try {
            // when when somebody has screwed with setTimeout but no I.E. maddness
            return cachedSetTimeout(fun, 0);
        } catch(e){
            try {
                // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
                return cachedSetTimeout.call(null, fun, 0);
            } catch(e){
                // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
                return cachedSetTimeout.call(this, fun, 0);
            }
        }


    }
    function runClearTimeout(marker) {
        if (cachedClearTimeout === clearTimeout) {
            //normal enviroments in sane situations
            return clearTimeout(marker);
        }
        // if clearTimeout wasn't available but was latter defined
        if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
            cachedClearTimeout = clearTimeout;
            return clearTimeout(marker);
        }
        try {
            // when when somebody has screwed with setTimeout but no I.E. maddness
            return cachedClearTimeout(marker);
        } catch (e){
            try {
                // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
                return cachedClearTimeout.call(null, marker);
            } catch (e){
                // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
                // Some versions of I.E. have different rules for clearTimeout vs setTimeout
                return cachedClearTimeout.call(this, marker);
            }
        }



    }
    var queue = [];
    var draining = false;
    var currentQueue;
    var queueIndex = -1;

    function cleanUpNextTick() {
        if (!draining || !currentQueue) {
            return;
        }
        draining = false;
        if (currentQueue.length) {
            queue = currentQueue.concat(queue);
        } else {
            queueIndex = -1;
        }
        if (queue.length) {
            drainQueue();
        }
    }

    function drainQueue() {
        if (draining) {
            return;
        }
        var timeout = runTimeout(cleanUpNextTick);
        draining = true;

        var len = queue.length;
        while(len) {
            currentQueue = queue;
            queue = [];
            while (++queueIndex < len) {
                if (currentQueue) {
                    currentQueue[queueIndex].run();
                }
            }
            queueIndex = -1;
            len = queue.length;
        }
        currentQueue = null;
        draining = false;
        runClearTimeout(timeout);
    }
    function nextTick(fun) {
        var args = new Array(arguments.length - 1);
        if (arguments.length > 1) {
            for (var i = 1; i < arguments.length; i++) {
                args[i - 1] = arguments[i];
            }
        }
        queue.push(new Item(fun, args));
        if (queue.length === 1 && !draining) {
            runTimeout(drainQueue);
        }
    }
    // v8 likes predictible objects
    function Item(fun, array) {
        this.fun = fun;
        this.array = array;
    }
    Item.prototype.run = function () {
        this.fun.apply(null, this.array);
    };
    var title = 'browser';
    var platform = 'browser';
    var browser = true;
    var env = {};
    var argv = [];
    var version = ''; // empty string to avoid regexp issues
    var versions = {};
    var release = {};
    var config = {};

    function noop$3() {}

    var on = noop$3;
    var addListener = noop$3;
    var once = noop$3;
    var off = noop$3;
    var removeListener = noop$3;
    var removeAllListeners = noop$3;
    var emit = noop$3;

    function binding(name) {
        throw new Error('process.binding is not supported');
    }

    function cwd () { return '/' }
    function chdir (dir) {
        throw new Error('process.chdir is not supported');
    }function umask() { return 0; }

    // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
    var performance = global$1.performance || {};
    var performanceNow =
      performance.now        ||
      performance.mozNow     ||
      performance.msNow      ||
      performance.oNow       ||
      performance.webkitNow  ||
      function(){ return (new Date()).getTime() };

    // generate timestamp or delta
    // see http://nodejs.org/api/process.html#process_process_hrtime
    function hrtime(previousTimestamp){
      var clocktime = performanceNow.call(performance)*1e-3;
      var seconds = Math.floor(clocktime);
      var nanoseconds = Math.floor((clocktime%1)*1e9);
      if (previousTimestamp) {
        seconds = seconds - previousTimestamp[0];
        nanoseconds = nanoseconds - previousTimestamp[1];
        if (nanoseconds<0) {
          seconds--;
          nanoseconds += 1e9;
        }
      }
      return [seconds,nanoseconds]
    }

    var startTime = new Date();
    function uptime() {
      var currentTime = new Date();
      var dif = currentTime - startTime;
      return dif / 1000;
    }

    var browser$1 = {
      nextTick: nextTick,
      title: title,
      browser: browser,
      env: env,
      argv: argv,
      version: version,
      versions: versions,
      on: on,
      addListener: addListener,
      once: once,
      off: off,
      removeListener: removeListener,
      removeAllListeners: removeAllListeners,
      emit: emit,
      binding: binding,
      cwd: cwd,
      chdir: chdir,
      umask: umask,
      hrtime: hrtime,
      platform: platform,
      release: release,
      config: config,
      uptime: uptime
    };

    var process$1 = browser$1;

    var core$1 = {};

    var is$1 = {};

    var isType$2 = {};

    var hasRequiredIsType$1;

    function requireIsType$1 () {
    	if (hasRequiredIsType$1) return isType$2;
    	hasRequiredIsType$1 = 1;

    	Object.defineProperty(isType$2, "__esModule", {
    	  value: true
    	});
    	isType$2.default = isType;

    	var _definitions = requireDefinitions$1();

    	function isType(nodeType, targetType) {
    	  if (nodeType === targetType) return true;
    	  if (_definitions.ALIAS_KEYS[targetType]) return false;
    	  const aliases = _definitions.FLIPPED_ALIAS_KEYS[targetType];

    	  if (aliases) {
    	    if (aliases[0] === nodeType) return true;

    	    for (const alias of aliases) {
    	      if (nodeType === alias) return true;
    	    }
    	  }

    	  return false;
    	}
    	return isType$2;
    }

    var isPlaceholderType$1 = {};

    var hasRequiredIsPlaceholderType$1;

    function requireIsPlaceholderType$1 () {
    	if (hasRequiredIsPlaceholderType$1) return isPlaceholderType$1;
    	hasRequiredIsPlaceholderType$1 = 1;

    	Object.defineProperty(isPlaceholderType$1, "__esModule", {
    	  value: true
    	});
    	isPlaceholderType$1.default = isPlaceholderType;

    	var _definitions = requireDefinitions$1();

    	function isPlaceholderType(placeholderType, targetType) {
    	  if (placeholderType === targetType) return true;
    	  const aliases = _definitions.PLACEHOLDERS_ALIAS[placeholderType];

    	  if (aliases) {
    	    for (const alias of aliases) {
    	      if (targetType === alias) return true;
    	    }
    	  }

    	  return false;
    	}
    	return isPlaceholderType$1;
    }

    var hasRequiredIs$1;

    function requireIs$1 () {
    	if (hasRequiredIs$1) return is$1;
    	hasRequiredIs$1 = 1;

    	Object.defineProperty(is$1, "__esModule", {
    	  value: true
    	});
    	is$1.default = is;

    	var _shallowEqual = shallowEqual$3;

    	var _isType = requireIsType$1();

    	var _isPlaceholderType = requireIsPlaceholderType$1();

    	var _definitions = requireDefinitions$1();

    	function is(type, node, opts) {
    	  if (!node) return false;
    	  const matches = (0, _isType.default)(node.type, type);

    	  if (!matches) {
    	    if (!opts && node.type === "Placeholder" && type in _definitions.FLIPPED_ALIAS_KEYS) {
    	      return (0, _isPlaceholderType.default)(node.expectedNode, type);
    	    }

    	    return false;
    	  }

    	  if (typeof opts === "undefined") {
    	    return true;
    	  } else {
    	    return (0, _shallowEqual.default)(node, opts);
    	  }
    	}
    	return is$1;
    }

    var isValidIdentifier$3 = {};

    var lib$5 = {};

    var identifier$2 = {};

    Object.defineProperty(identifier$2, "__esModule", {
      value: true
    });
    identifier$2.isIdentifierStart = isIdentifierStart$3;
    identifier$2.isIdentifierChar = isIdentifierChar$3;
    identifier$2.isIdentifierName = isIdentifierName$1;
    let nonASCIIidentifierStartChars$3 = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u0870-\u0887\u0889-\u088e\u08a0-\u08c9\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c5d\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cdd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u1711\u171f-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4c\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c88\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7ca\ua7d0\ua7d1\ua7d3\ua7d5-\ua7d9\ua7f2-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";
    let nonASCIIidentifierChars$3 = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u0898-\u089f\u08ca-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3c\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u180f-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf-\u1ace\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1dff\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f";
    const nonASCIIidentifierStart$3 = new RegExp("[" + nonASCIIidentifierStartChars$3 + "]");
    const nonASCIIidentifier$3 = new RegExp("[" + nonASCIIidentifierStartChars$3 + nonASCIIidentifierChars$3 + "]");
    nonASCIIidentifierStartChars$3 = nonASCIIidentifierChars$3 = null;
    const astralIdentifierStartCodes$3 = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1070, 4050, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 46, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 482, 44, 11, 6, 17, 0, 322, 29, 19, 43, 1269, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4152, 8, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
    const astralIdentifierCodes$3 = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 357, 0, 62, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

    function isInAstralSet$3(code, set) {
      let pos = 0x10000;

      for (let i = 0, length = set.length; i < length; i += 2) {
        pos += set[i];
        if (pos > code) return false;
        pos += set[i + 1];
        if (pos >= code) return true;
      }

      return false;
    }

    function isIdentifierStart$3(code) {
      if (code < 65) return code === 36;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;

      if (code <= 0xffff) {
        return code >= 0xaa && nonASCIIidentifierStart$3.test(String.fromCharCode(code));
      }

      return isInAstralSet$3(code, astralIdentifierStartCodes$3);
    }

    function isIdentifierChar$3(code) {
      if (code < 48) return code === 36;
      if (code < 58) return true;
      if (code < 65) return false;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;

      if (code <= 0xffff) {
        return code >= 0xaa && nonASCIIidentifier$3.test(String.fromCharCode(code));
      }

      return isInAstralSet$3(code, astralIdentifierStartCodes$3) || isInAstralSet$3(code, astralIdentifierCodes$3);
    }

    function isIdentifierName$1(name) {
      let isFirst = true;

      for (let i = 0; i < name.length; i++) {
        let cp = name.charCodeAt(i);

        if ((cp & 0xfc00) === 0xd800 && i + 1 < name.length) {
          const trail = name.charCodeAt(++i);

          if ((trail & 0xfc00) === 0xdc00) {
            cp = 0x10000 + ((cp & 0x3ff) << 10) + (trail & 0x3ff);
          }
        }

        if (isFirst) {
          isFirst = false;

          if (!isIdentifierStart$3(cp)) {
            return false;
          }
        } else if (!isIdentifierChar$3(cp)) {
          return false;
        }
      }

      return !isFirst;
    }

    var keyword$1 = {};

    Object.defineProperty(keyword$1, "__esModule", {
      value: true
    });
    keyword$1.isReservedWord = isReservedWord$3;
    keyword$1.isStrictReservedWord = isStrictReservedWord$3;
    keyword$1.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord$3;
    keyword$1.isStrictBindReservedWord = isStrictBindReservedWord$3;
    keyword$1.isKeyword = isKeyword$3;
    const reservedWords$3 = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    const keywords$4 = new Set(reservedWords$3.keyword);
    const reservedWordsStrictSet$3 = new Set(reservedWords$3.strict);
    const reservedWordsStrictBindSet$3 = new Set(reservedWords$3.strictBind);

    function isReservedWord$3(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }

    function isStrictReservedWord$3(word, inModule) {
      return isReservedWord$3(word, inModule) || reservedWordsStrictSet$3.has(word);
    }

    function isStrictBindOnlyReservedWord$3(word) {
      return reservedWordsStrictBindSet$3.has(word);
    }

    function isStrictBindReservedWord$3(word, inModule) {
      return isStrictReservedWord$3(word, inModule) || isStrictBindOnlyReservedWord$3(word);
    }

    function isKeyword$3(word) {
      return keywords$4.has(word);
    }

    (function (exports) {

    	Object.defineProperty(exports, "__esModule", {
    	  value: true
    	});
    	Object.defineProperty(exports, "isIdentifierName", {
    	  enumerable: true,
    	  get: function () {
    	    return _identifier.isIdentifierName;
    	  }
    	});
    	Object.defineProperty(exports, "isIdentifierChar", {
    	  enumerable: true,
    	  get: function () {
    	    return _identifier.isIdentifierChar;
    	  }
    	});
    	Object.defineProperty(exports, "isIdentifierStart", {
    	  enumerable: true,
    	  get: function () {
    	    return _identifier.isIdentifierStart;
    	  }
    	});
    	Object.defineProperty(exports, "isReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isStrictBindOnlyReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isStrictBindOnlyReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isStrictBindReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isStrictBindReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isStrictReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isStrictReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isKeyword;
    	  }
    	});

    	var _identifier = identifier$2;

    	var _keyword = keyword$1;
    } (lib$5));

    Object.defineProperty(isValidIdentifier$3, "__esModule", {
      value: true
    });
    isValidIdentifier$3.default = isValidIdentifier$2;

    var _helperValidatorIdentifier$2 = lib$5;

    function isValidIdentifier$2(name, reserved = true) {
      if (typeof name !== "string") return false;

      if (reserved) {
        if ((0, _helperValidatorIdentifier$2.isKeyword)(name) || (0, _helperValidatorIdentifier$2.isStrictReservedWord)(name, true)) {
          return false;
        }
      }

      return (0, _helperValidatorIdentifier$2.isIdentifierName)(name);
    }

    var constants$1 = {};

    Object.defineProperty(constants$1, "__esModule", {
      value: true
    });
    constants$1.NOT_LOCAL_BINDING = constants$1.BLOCK_SCOPED_SYMBOL = constants$1.INHERIT_KEYS = constants$1.UNARY_OPERATORS = constants$1.STRING_UNARY_OPERATORS = constants$1.NUMBER_UNARY_OPERATORS = constants$1.BOOLEAN_UNARY_OPERATORS = constants$1.ASSIGNMENT_OPERATORS = constants$1.BINARY_OPERATORS = constants$1.NUMBER_BINARY_OPERATORS = constants$1.BOOLEAN_BINARY_OPERATORS = constants$1.COMPARISON_BINARY_OPERATORS = constants$1.EQUALITY_BINARY_OPERATORS = constants$1.BOOLEAN_NUMBER_BINARY_OPERATORS = constants$1.UPDATE_OPERATORS = constants$1.LOGICAL_OPERATORS = constants$1.COMMENT_KEYS = constants$1.FOR_INIT_KEYS = constants$1.FLATTENABLE_KEYS = constants$1.STATEMENT_OR_BLOCK_KEYS = void 0;
    const STATEMENT_OR_BLOCK_KEYS$1 = ["consequent", "body", "alternate"];
    constants$1.STATEMENT_OR_BLOCK_KEYS = STATEMENT_OR_BLOCK_KEYS$1;
    const FLATTENABLE_KEYS$1 = ["body", "expressions"];
    constants$1.FLATTENABLE_KEYS = FLATTENABLE_KEYS$1;
    const FOR_INIT_KEYS$1 = ["left", "init"];
    constants$1.FOR_INIT_KEYS = FOR_INIT_KEYS$1;
    const COMMENT_KEYS$1 = ["leadingComments", "trailingComments", "innerComments"];
    constants$1.COMMENT_KEYS = COMMENT_KEYS$1;
    const LOGICAL_OPERATORS$1 = ["||", "&&", "??"];
    constants$1.LOGICAL_OPERATORS = LOGICAL_OPERATORS$1;
    const UPDATE_OPERATORS$1 = ["++", "--"];
    constants$1.UPDATE_OPERATORS = UPDATE_OPERATORS$1;
    const BOOLEAN_NUMBER_BINARY_OPERATORS$1 = [">", "<", ">=", "<="];
    constants$1.BOOLEAN_NUMBER_BINARY_OPERATORS = BOOLEAN_NUMBER_BINARY_OPERATORS$1;
    const EQUALITY_BINARY_OPERATORS$1 = ["==", "===", "!=", "!=="];
    constants$1.EQUALITY_BINARY_OPERATORS = EQUALITY_BINARY_OPERATORS$1;
    const COMPARISON_BINARY_OPERATORS$1 = [...EQUALITY_BINARY_OPERATORS$1, "in", "instanceof"];
    constants$1.COMPARISON_BINARY_OPERATORS = COMPARISON_BINARY_OPERATORS$1;
    const BOOLEAN_BINARY_OPERATORS$1 = [...COMPARISON_BINARY_OPERATORS$1, ...BOOLEAN_NUMBER_BINARY_OPERATORS$1];
    constants$1.BOOLEAN_BINARY_OPERATORS = BOOLEAN_BINARY_OPERATORS$1;
    const NUMBER_BINARY_OPERATORS$1 = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
    constants$1.NUMBER_BINARY_OPERATORS = NUMBER_BINARY_OPERATORS$1;
    const BINARY_OPERATORS$1 = ["+", ...NUMBER_BINARY_OPERATORS$1, ...BOOLEAN_BINARY_OPERATORS$1];
    constants$1.BINARY_OPERATORS = BINARY_OPERATORS$1;
    const ASSIGNMENT_OPERATORS$1 = ["=", "+=", ...NUMBER_BINARY_OPERATORS$1.map(op => op + "="), ...LOGICAL_OPERATORS$1.map(op => op + "=")];
    constants$1.ASSIGNMENT_OPERATORS = ASSIGNMENT_OPERATORS$1;
    const BOOLEAN_UNARY_OPERATORS$1 = ["delete", "!"];
    constants$1.BOOLEAN_UNARY_OPERATORS = BOOLEAN_UNARY_OPERATORS$1;
    const NUMBER_UNARY_OPERATORS$1 = ["+", "-", "~"];
    constants$1.NUMBER_UNARY_OPERATORS = NUMBER_UNARY_OPERATORS$1;
    const STRING_UNARY_OPERATORS$1 = ["typeof"];
    constants$1.STRING_UNARY_OPERATORS = STRING_UNARY_OPERATORS$1;
    const UNARY_OPERATORS$1 = ["void", "throw", ...BOOLEAN_UNARY_OPERATORS$1, ...NUMBER_UNARY_OPERATORS$1, ...STRING_UNARY_OPERATORS$1];
    constants$1.UNARY_OPERATORS = UNARY_OPERATORS$1;
    const INHERIT_KEYS$1 = {
      optional: ["typeAnnotation", "typeParameters", "returnType"],
      force: ["start", "loc", "end"]
    };
    constants$1.INHERIT_KEYS = INHERIT_KEYS$1;
    const BLOCK_SCOPED_SYMBOL$1 = Symbol.for("var used to be block scoped");
    constants$1.BLOCK_SCOPED_SYMBOL = BLOCK_SCOPED_SYMBOL$1;
    const NOT_LOCAL_BINDING$1 = Symbol.for("should not be considered a local binding");
    constants$1.NOT_LOCAL_BINDING = NOT_LOCAL_BINDING$1;

    var utils$1 = {};

    var validate$1 = {};

    var hasRequiredValidate$1;

    function requireValidate$1 () {
    	if (hasRequiredValidate$1) return validate$1;
    	hasRequiredValidate$1 = 1;

    	Object.defineProperty(validate$1, "__esModule", {
    	  value: true
    	});
    	validate$1.default = validate;
    	validate$1.validateField = validateField;
    	validate$1.validateChild = validateChild;

    	var _definitions = requireDefinitions$1();

    	function validate(node, key, val) {
    	  if (!node) return;
    	  const fields = _definitions.NODE_FIELDS[node.type];
    	  if (!fields) return;
    	  const field = fields[key];
    	  validateField(node, key, val, field);
    	  validateChild(node, key, val);
    	}

    	function validateField(node, key, val, field) {
    	  if (!(field != null && field.validate)) return;
    	  if (field.optional && val == null) return;
    	  field.validate(node, key, val);
    	}

    	function validateChild(node, key, val) {
    	  if (val == null) return;
    	  const validate = _definitions.NODE_PARENT_VALIDATIONS[val.type];
    	  if (!validate) return;
    	  validate(node, key, val);
    	}
    	return validate$1;
    }

    var hasRequiredUtils$1;

    function requireUtils$1 () {
    	if (hasRequiredUtils$1) return utils$1;
    	hasRequiredUtils$1 = 1;

    	Object.defineProperty(utils$1, "__esModule", {
    	  value: true
    	});
    	utils$1.validate = validate;
    	utils$1.typeIs = typeIs;
    	utils$1.validateType = validateType;
    	utils$1.validateOptional = validateOptional;
    	utils$1.validateOptionalType = validateOptionalType;
    	utils$1.arrayOf = arrayOf;
    	utils$1.arrayOfType = arrayOfType;
    	utils$1.validateArrayOfType = validateArrayOfType;
    	utils$1.assertEach = assertEach;
    	utils$1.assertOneOf = assertOneOf;
    	utils$1.assertNodeType = assertNodeType;
    	utils$1.assertNodeOrValueType = assertNodeOrValueType;
    	utils$1.assertValueType = assertValueType;
    	utils$1.assertShape = assertShape;
    	utils$1.assertOptionalChainStart = assertOptionalChainStart;
    	utils$1.chain = chain;
    	utils$1.default = defineType;
    	utils$1.NODE_PARENT_VALIDATIONS = utils$1.DEPRECATED_KEYS = utils$1.BUILDER_KEYS = utils$1.NODE_FIELDS = utils$1.FLIPPED_ALIAS_KEYS = utils$1.ALIAS_KEYS = utils$1.VISITOR_KEYS = void 0;

    	var _is = requireIs$1();

    	var _validate = requireValidate$1();

    	const VISITOR_KEYS = {};
    	utils$1.VISITOR_KEYS = VISITOR_KEYS;
    	const ALIAS_KEYS = {};
    	utils$1.ALIAS_KEYS = ALIAS_KEYS;
    	const FLIPPED_ALIAS_KEYS = {};
    	utils$1.FLIPPED_ALIAS_KEYS = FLIPPED_ALIAS_KEYS;
    	const NODE_FIELDS = {};
    	utils$1.NODE_FIELDS = NODE_FIELDS;
    	const BUILDER_KEYS = {};
    	utils$1.BUILDER_KEYS = BUILDER_KEYS;
    	const DEPRECATED_KEYS = {};
    	utils$1.DEPRECATED_KEYS = DEPRECATED_KEYS;
    	const NODE_PARENT_VALIDATIONS = {};
    	utils$1.NODE_PARENT_VALIDATIONS = NODE_PARENT_VALIDATIONS;

    	function getType(val) {
    	  if (Array.isArray(val)) {
    	    return "array";
    	  } else if (val === null) {
    	    return "null";
    	  } else {
    	    return typeof val;
    	  }
    	}

    	function validate(validate) {
    	  return {
    	    validate
    	  };
    	}

    	function typeIs(typeName) {
    	  return typeof typeName === "string" ? assertNodeType(typeName) : assertNodeType(...typeName);
    	}

    	function validateType(typeName) {
    	  return validate(typeIs(typeName));
    	}

    	function validateOptional(validate) {
    	  return {
    	    validate,
    	    optional: true
    	  };
    	}

    	function validateOptionalType(typeName) {
    	  return {
    	    validate: typeIs(typeName),
    	    optional: true
    	  };
    	}

    	function arrayOf(elementType) {
    	  return chain(assertValueType("array"), assertEach(elementType));
    	}

    	function arrayOfType(typeName) {
    	  return arrayOf(typeIs(typeName));
    	}

    	function validateArrayOfType(typeName) {
    	  return validate(arrayOfType(typeName));
    	}

    	function assertEach(callback) {
    	  function validator(node, key, val) {
    	    if (!Array.isArray(val)) return;

    	    for (let i = 0; i < val.length; i++) {
    	      const subkey = `${key}[${i}]`;
    	      const v = val[i];
    	      callback(node, subkey, v);
    	      if (process$1.env.BABEL_TYPES_8_BREAKING) (0, _validate.validateChild)(node, subkey, v);
    	    }
    	  }

    	  validator.each = callback;
    	  return validator;
    	}

    	function assertOneOf(...values) {
    	  function validate(node, key, val) {
    	    if (values.indexOf(val) < 0) {
    	      throw new TypeError(`Property ${key} expected value to be one of ${JSON.stringify(values)} but got ${JSON.stringify(val)}`);
    	    }
    	  }

    	  validate.oneOf = values;
    	  return validate;
    	}

    	function assertNodeType(...types) {
    	  function validate(node, key, val) {
    	    for (const type of types) {
    	      if ((0, _is.default)(type, val)) {
    	        (0, _validate.validateChild)(node, key, val);
    	        return;
    	      }
    	    }

    	    throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
    	  }

    	  validate.oneOfNodeTypes = types;
    	  return validate;
    	}

    	function assertNodeOrValueType(...types) {
    	  function validate(node, key, val) {
    	    for (const type of types) {
    	      if (getType(val) === type || (0, _is.default)(type, val)) {
    	        (0, _validate.validateChild)(node, key, val);
    	        return;
    	      }
    	    }

    	    throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
    	  }

    	  validate.oneOfNodeOrValueTypes = types;
    	  return validate;
    	}

    	function assertValueType(type) {
    	  function validate(node, key, val) {
    	    const valid = getType(val) === type;

    	    if (!valid) {
    	      throw new TypeError(`Property ${key} expected type of ${type} but got ${getType(val)}`);
    	    }
    	  }

    	  validate.type = type;
    	  return validate;
    	}

    	function assertShape(shape) {
    	  function validate(node, key, val) {
    	    const errors = [];

    	    for (const property of Object.keys(shape)) {
    	      try {
    	        (0, _validate.validateField)(node, property, val[property], shape[property]);
    	      } catch (error) {
    	        if (error instanceof TypeError) {
    	          errors.push(error.message);
    	          continue;
    	        }

    	        throw error;
    	      }
    	    }

    	    if (errors.length) {
    	      throw new TypeError(`Property ${key} of ${node.type} expected to have the following:\n${errors.join("\n")}`);
    	    }
    	  }

    	  validate.shapeOf = shape;
    	  return validate;
    	}

    	function assertOptionalChainStart() {
    	  function validate(node) {
    	    var _current;

    	    let current = node;

    	    while (node) {
    	      const {
    	        type
    	      } = current;

    	      if (type === "OptionalCallExpression") {
    	        if (current.optional) return;
    	        current = current.callee;
    	        continue;
    	      }

    	      if (type === "OptionalMemberExpression") {
    	        if (current.optional) return;
    	        current = current.object;
    	        continue;
    	      }

    	      break;
    	    }

    	    throw new TypeError(`Non-optional ${node.type} must chain from an optional OptionalMemberExpression or OptionalCallExpression. Found chain from ${(_current = current) == null ? void 0 : _current.type}`);
    	  }

    	  return validate;
    	}

    	function chain(...fns) {
    	  function validate(...args) {
    	    for (const fn of fns) {
    	      fn(...args);
    	    }
    	  }

    	  validate.chainOf = fns;

    	  if (fns.length >= 2 && "type" in fns[0] && fns[0].type === "array" && !("each" in fns[1])) {
    	    throw new Error(`An assertValueType("array") validator can only be followed by an assertEach(...) validator.`);
    	  }

    	  return validate;
    	}

    	const validTypeOpts = ["aliases", "builder", "deprecatedAlias", "fields", "inherits", "visitor", "validate"];
    	const validFieldKeys = ["default", "optional", "validate"];

    	function defineType(type, opts = {}) {
    	  const inherits = opts.inherits && store[opts.inherits] || {};
    	  let fields = opts.fields;

    	  if (!fields) {
    	    fields = {};

    	    if (inherits.fields) {
    	      const keys = Object.getOwnPropertyNames(inherits.fields);

    	      for (const key of keys) {
    	        const field = inherits.fields[key];
    	        const def = field.default;

    	        if (Array.isArray(def) ? def.length > 0 : def && typeof def === "object") {
    	          throw new Error("field defaults can only be primitives or empty arrays currently");
    	        }

    	        fields[key] = {
    	          default: Array.isArray(def) ? [] : def,
    	          optional: field.optional,
    	          validate: field.validate
    	        };
    	      }
    	    }
    	  }

    	  const visitor = opts.visitor || inherits.visitor || [];
    	  const aliases = opts.aliases || inherits.aliases || [];
    	  const builder = opts.builder || inherits.builder || opts.visitor || [];

    	  for (const k of Object.keys(opts)) {
    	    if (validTypeOpts.indexOf(k) === -1) {
    	      throw new Error(`Unknown type option "${k}" on ${type}`);
    	    }
    	  }

    	  if (opts.deprecatedAlias) {
    	    DEPRECATED_KEYS[opts.deprecatedAlias] = type;
    	  }

    	  for (const key of visitor.concat(builder)) {
    	    fields[key] = fields[key] || {};
    	  }

    	  for (const key of Object.keys(fields)) {
    	    const field = fields[key];

    	    if (field.default !== undefined && builder.indexOf(key) === -1) {
    	      field.optional = true;
    	    }

    	    if (field.default === undefined) {
    	      field.default = null;
    	    } else if (!field.validate && field.default != null) {
    	      field.validate = assertValueType(getType(field.default));
    	    }

    	    for (const k of Object.keys(field)) {
    	      if (validFieldKeys.indexOf(k) === -1) {
    	        throw new Error(`Unknown field key "${k}" on ${type}.${key}`);
    	      }
    	    }
    	  }

    	  VISITOR_KEYS[type] = opts.visitor = visitor;
    	  BUILDER_KEYS[type] = opts.builder = builder;
    	  NODE_FIELDS[type] = opts.fields = fields;
    	  ALIAS_KEYS[type] = opts.aliases = aliases;
    	  aliases.forEach(alias => {
    	    FLIPPED_ALIAS_KEYS[alias] = FLIPPED_ALIAS_KEYS[alias] || [];
    	    FLIPPED_ALIAS_KEYS[alias].push(type);
    	  });

    	  if (opts.validate) {
    	    NODE_PARENT_VALIDATIONS[type] = opts.validate;
    	  }

    	  store[type] = opts;
    	}

    	const store = {};
    	return utils$1;
    }

    var hasRequiredCore$1;

    function requireCore$1 () {
    	if (hasRequiredCore$1) return core$1;
    	hasRequiredCore$1 = 1;

    	Object.defineProperty(core$1, "__esModule", {
    	  value: true
    	});
    	core$1.classMethodOrDeclareMethodCommon = core$1.classMethodOrPropertyCommon = core$1.patternLikeCommon = core$1.functionDeclarationCommon = core$1.functionTypeAnnotationCommon = core$1.functionCommon = void 0;

    	var _is = requireIs$1();

    	var _isValidIdentifier = isValidIdentifier$3;

    	var _helperValidatorIdentifier = lib$5;

    	var _constants = constants$1;

    	var _utils = requireUtils$1();

    	(0, _utils.default)("ArrayExpression", {
    	  fields: {
    	    elements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "Expression", "SpreadElement"))),
    	      default: !process$1.env.BABEL_TYPES_8_BREAKING ? [] : undefined
    	    }
    	  },
    	  visitor: ["elements"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("AssignmentExpression", {
    	  fields: {
    	    operator: {
    	      validate: function () {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) {
    	          return (0, _utils.assertValueType)("string");
    	        }

    	        const identifier = (0, _utils.assertOneOf)(..._constants.ASSIGNMENT_OPERATORS);
    	        const pattern = (0, _utils.assertOneOf)("=");
    	        return function (node, key, val) {
    	          const validator = (0, _is.default)("Pattern", node.left) ? pattern : identifier;
    	          validator(node, key, val);
    	        };
    	      }()
    	    },
    	    left: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  builder: ["operator", "left", "right"],
    	  visitor: ["left", "right"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("BinaryExpression", {
    	  builder: ["operator", "left", "right"],
    	  fields: {
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.BINARY_OPERATORS)
    	    },
    	    left: {
    	      validate: function () {
    	        const expression = (0, _utils.assertNodeType)("Expression");
    	        const inOp = (0, _utils.assertNodeType)("Expression", "PrivateName");

    	        const validator = function (node, key, val) {
    	          const validator = node.operator === "in" ? inOp : expression;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "PrivateName"];
    	        return validator;
    	      }()
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  visitor: ["left", "right"],
    	  aliases: ["Binary", "Expression"]
    	});
    	(0, _utils.default)("InterpreterDirective", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("Directive", {
    	  visitor: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertNodeType)("DirectiveLiteral")
    	    }
    	  }
    	});
    	(0, _utils.default)("DirectiveLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("BlockStatement", {
    	  builder: ["body", "directives"],
    	  visitor: ["directives", "body"],
    	  fields: {
    	    directives: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Directive"))),
    	      default: []
    	    },
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent", "Block", "Statement"]
    	});
    	(0, _utils.default)("BreakStatement", {
    	  visitor: ["label"],
    	  fields: {
    	    label: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    }
    	  },
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"]
    	});
    	(0, _utils.default)("CallExpression", {
    	  visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
    	  builder: ["callee", "arguments"],
    	  aliases: ["Expression"],
    	  fields: Object.assign({
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression", "V8IntrinsicIdentifier")
    	    },
    	    arguments: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement", "JSXNamespacedName", "ArgumentPlaceholder")))
    	    }
    	  }, !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	    optional: {
    	      validate: (0, _utils.assertOneOf)(true, false),
    	      optional: true
    	    }
    	  } : {}, {
    	    typeArguments: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
    	      optional: true
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("CatchClause", {
    	  visitor: ["param", "body"],
    	  fields: {
    	    param: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent"]
    	});
    	(0, _utils.default)("ConditionalExpression", {
    	  visitor: ["test", "consequent", "alternate"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    consequent: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    alternate: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  aliases: ["Expression", "Conditional"]
    	});
    	(0, _utils.default)("ContinueStatement", {
    	  visitor: ["label"],
    	  fields: {
    	    label: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    }
    	  },
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"]
    	});
    	(0, _utils.default)("DebuggerStatement", {
    	  aliases: ["Statement"]
    	});
    	(0, _utils.default)("DoWhileStatement", {
    	  visitor: ["test", "body"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  },
    	  aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"]
    	});
    	(0, _utils.default)("EmptyStatement", {
    	  aliases: ["Statement"]
    	});
    	(0, _utils.default)("ExpressionStatement", {
    	  visitor: ["expression"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  aliases: ["Statement", "ExpressionWrapper"]
    	});
    	(0, _utils.default)("File", {
    	  builder: ["program", "comments", "tokens"],
    	  visitor: ["program"],
    	  fields: {
    	    program: {
    	      validate: (0, _utils.assertNodeType)("Program")
    	    },
    	    comments: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? Object.assign(() => {}, {
    	        each: {
    	          oneOfNodeTypes: ["CommentBlock", "CommentLine"]
    	        }
    	      }) : (0, _utils.assertEach)((0, _utils.assertNodeType)("CommentBlock", "CommentLine")),
    	      optional: true
    	    },
    	    tokens: {
    	      validate: (0, _utils.assertEach)(Object.assign(() => {}, {
    	        type: "any"
    	      })),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ForInStatement", {
    	  visitor: ["left", "right", "body"],
    	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    	  fields: {
    	    left: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("VariableDeclaration", "LVal") : (0, _utils.assertNodeType)("VariableDeclaration", "Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("ForStatement", {
    	  visitor: ["init", "test", "update", "body"],
    	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop"],
    	  fields: {
    	    init: {
    	      validate: (0, _utils.assertNodeType)("VariableDeclaration", "Expression"),
    	      optional: true
    	    },
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    update: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	const functionCommon = {
    	  params: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Identifier", "Pattern", "RestElement")))
    	  },
    	  generator: {
    	    default: false
    	  },
    	  async: {
    	    default: false
    	  }
    	};
    	core$1.functionCommon = functionCommon;
    	const functionTypeAnnotationCommon = {
    	  returnType: {
    	    validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	    optional: true
    	  },
    	  typeParameters: {
    	    validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    	    optional: true
    	  }
    	};
    	core$1.functionTypeAnnotationCommon = functionTypeAnnotationCommon;
    	const functionDeclarationCommon = Object.assign({}, functionCommon, {
    	  declare: {
    	    validate: (0, _utils.assertValueType)("boolean"),
    	    optional: true
    	  },
    	  id: {
    	    validate: (0, _utils.assertNodeType)("Identifier"),
    	    optional: true
    	  }
    	});
    	core$1.functionDeclarationCommon = functionDeclarationCommon;
    	(0, _utils.default)("FunctionDeclaration", {
    	  builder: ["id", "params", "body", "generator", "async"],
    	  visitor: ["id", "params", "body", "returnType", "typeParameters"],
    	  fields: Object.assign({}, functionDeclarationCommon, functionTypeAnnotationCommon, {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }),
    	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Statement", "Pureish", "Declaration"],
    	  validate: function () {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return () => {};
    	    const identifier = (0, _utils.assertNodeType)("Identifier");
    	    return function (parent, key, node) {
    	      if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
    	        identifier(node, "id", node.id);
    	      }
    	    };
    	  }()
    	});
    	(0, _utils.default)("FunctionExpression", {
    	  inherits: "FunctionDeclaration",
    	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  })
    	});
    	const patternLikeCommon = {
    	  typeAnnotation: {
    	    validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	    optional: true
    	  },
    	  decorators: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator")))
    	  }
    	};
    	core$1.patternLikeCommon = patternLikeCommon;
    	(0, _utils.default)("Identifier", {
    	  builder: ["name"],
    	  visitor: ["typeAnnotation", "decorators"],
    	  aliases: ["Expression", "PatternLike", "LVal", "TSEntityName"],
    	  fields: Object.assign({}, patternLikeCommon, {
    	    name: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (!(0, _isValidIdentifier.default)(val, false)) {
    	          throw new TypeError(`"${val}" is not a valid identifier name`);
    	        }
    	      }, {
    	        type: "string"
    	      }))
    	    },
    	    optional: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  }),

    	  validate(parent, key, node) {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	    const match = /\.(\w+)$/.exec(key);
    	    if (!match) return;
    	    const [, parentKey] = match;
    	    const nonComp = {
    	      computed: false
    	    };

    	    if (parentKey === "property") {
    	      if ((0, _is.default)("MemberExpression", parent, nonComp)) return;
    	      if ((0, _is.default)("OptionalMemberExpression", parent, nonComp)) return;
    	    } else if (parentKey === "key") {
    	      if ((0, _is.default)("Property", parent, nonComp)) return;
    	      if ((0, _is.default)("Method", parent, nonComp)) return;
    	    } else if (parentKey === "exported") {
    	      if ((0, _is.default)("ExportSpecifier", parent)) return;
    	    } else if (parentKey === "imported") {
    	      if ((0, _is.default)("ImportSpecifier", parent, {
    	        imported: node
    	      })) return;
    	    } else if (parentKey === "meta") {
    	      if ((0, _is.default)("MetaProperty", parent, {
    	        meta: node
    	      })) return;
    	    }

    	    if (((0, _helperValidatorIdentifier.isKeyword)(node.name) || (0, _helperValidatorIdentifier.isReservedWord)(node.name, false)) && node.name !== "this") {
    	      throw new TypeError(`"${node.name}" is not a valid identifier`);
    	    }
    	  }

    	});
    	(0, _utils.default)("IfStatement", {
    	  visitor: ["test", "consequent", "alternate"],
    	  aliases: ["Statement", "Conditional"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    consequent: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    },
    	    alternate: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("LabeledStatement", {
    	  visitor: ["label", "body"],
    	  aliases: ["Statement"],
    	  fields: {
    	    label: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("StringLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("NumericLiteral", {
    	  builder: ["value"],
    	  deprecatedAlias: "NumberLiteral",
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("number")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("NullLiteral", {
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("BooleanLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("boolean")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("RegExpLiteral", {
    	  builder: ["pattern", "flags"],
    	  deprecatedAlias: "RegexLiteral",
    	  aliases: ["Expression", "Pureish", "Literal"],
    	  fields: {
    	    pattern: {
    	      validate: (0, _utils.assertValueType)("string")
    	    },
    	    flags: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	        const invalid = /[^gimsuy]/.exec(val);

    	        if (invalid) {
    	          throw new TypeError(`"${invalid[0]}" is not a valid RegExp flag`);
    	        }
    	      }, {
    	        type: "string"
    	      })),
    	      default: ""
    	    }
    	  }
    	});
    	(0, _utils.default)("LogicalExpression", {
    	  builder: ["operator", "left", "right"],
    	  visitor: ["left", "right"],
    	  aliases: ["Binary", "Expression"],
    	  fields: {
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.LOGICAL_OPERATORS)
    	    },
    	    left: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("MemberExpression", {
    	  builder: ["object", "property", "computed", ...(!process$1.env.BABEL_TYPES_8_BREAKING ? ["optional"] : [])],
    	  visitor: ["object", "property"],
    	  aliases: ["Expression", "LVal"],
    	  fields: Object.assign({
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    property: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier", "PrivateName");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier", "PrivateName"];
    	        return validator;
    	      }()
    	    },
    	    computed: {
    	      default: false
    	    }
    	  }, !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	    optional: {
    	      validate: (0, _utils.assertOneOf)(true, false),
    	      optional: true
    	    }
    	  } : {})
    	});
    	(0, _utils.default)("NewExpression", {
    	  inherits: "CallExpression"
    	});
    	(0, _utils.default)("Program", {
    	  visitor: ["directives", "body"],
    	  builder: ["body", "directives", "sourceType", "interpreter"],
    	  fields: {
    	    sourceFile: {
    	      validate: (0, _utils.assertValueType)("string")
    	    },
    	    sourceType: {
    	      validate: (0, _utils.assertOneOf)("script", "module"),
    	      default: "script"
    	    },
    	    interpreter: {
    	      validate: (0, _utils.assertNodeType)("InterpreterDirective"),
    	      default: null,
    	      optional: true
    	    },
    	    directives: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Directive"))),
    	      default: []
    	    },
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent", "Block"]
    	});
    	(0, _utils.default)("ObjectExpression", {
    	  visitor: ["properties"],
    	  aliases: ["Expression"],
    	  fields: {
    	    properties: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ObjectMethod", "ObjectProperty", "SpreadElement")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ObjectMethod", {
    	  builder: ["kind", "key", "params", "body", "computed", "generator", "async"],
    	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
    	    kind: Object.assign({
    	      validate: (0, _utils.assertOneOf)("method", "get", "set")
    	    }, !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	      default: "method"
    	    } : {}),
    	    computed: {
    	      default: false
    	    },
    	    key: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
    	        return validator;
    	      }()
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }),
    	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    	  aliases: ["UserWhitespacable", "Function", "Scopable", "BlockParent", "FunctionParent", "Method", "ObjectMember"]
    	});
    	(0, _utils.default)("ObjectProperty", {
    	  builder: ["key", "value", "computed", "shorthand", ...(!process$1.env.BABEL_TYPES_8_BREAKING ? ["decorators"] : [])],
    	  fields: {
    	    computed: {
    	      default: false
    	    },
    	    key: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
    	        return validator;
    	      }()
    	    },
    	    value: {
    	      validate: (0, _utils.assertNodeType)("Expression", "PatternLike")
    	    },
    	    shorthand: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && node.computed) {
    	          throw new TypeError("Property shorthand of ObjectProperty cannot be true if computed is true");
    	        }
    	      }, {
    	        type: "boolean"
    	      }), function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && !(0, _is.default)("Identifier", node.key)) {
    	          throw new TypeError("Property shorthand of ObjectProperty cannot be true if key is not an Identifier");
    	        }
    	      }),
    	      default: false
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  },
    	  visitor: ["key", "value", "decorators"],
    	  aliases: ["UserWhitespacable", "Property", "ObjectMember"],
    	  validate: function () {
    	    const pattern = (0, _utils.assertNodeType)("Identifier", "Pattern");
    	    const expression = (0, _utils.assertNodeType)("Expression");
    	    return function (parent, key, node) {
    	      if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	      const validator = (0, _is.default)("ObjectPattern", parent) ? pattern : expression;
    	      validator(node, "value", node.value);
    	    };
    	  }()
    	});
    	(0, _utils.default)("RestElement", {
    	  visitor: ["argument", "typeAnnotation"],
    	  builder: ["argument"],
    	  aliases: ["LVal", "PatternLike"],
    	  deprecatedAlias: "RestProperty",
    	  fields: Object.assign({}, patternLikeCommon, {
    	    argument: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern", "MemberExpression")
    	    },
    	    optional: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  }),

    	  validate(parent, key) {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	    const match = /(\w+)\[(\d+)\]/.exec(key);
    	    if (!match) throw new Error("Internal Babel error: malformed key.");
    	    const [, listKey, index] = match;

    	    if (parent[listKey].length > index + 1) {
    	      throw new TypeError(`RestElement must be last element of ${listKey}`);
    	    }
    	  }

    	});
    	(0, _utils.default)("ReturnStatement", {
    	  visitor: ["argument"],
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("SequenceExpression", {
    	  visitor: ["expressions"],
    	  fields: {
    	    expressions: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression")))
    	    }
    	  },
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("ParenthesizedExpression", {
    	  visitor: ["expression"],
    	  aliases: ["Expression", "ExpressionWrapper"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("SwitchCase", {
    	  visitor: ["test", "consequent"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    consequent: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  }
    	});
    	(0, _utils.default)("SwitchStatement", {
    	  visitor: ["discriminant", "cases"],
    	  aliases: ["Statement", "BlockParent", "Scopable"],
    	  fields: {
    	    discriminant: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    cases: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("SwitchCase")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ThisExpression", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("ThrowStatement", {
    	  visitor: ["argument"],
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("TryStatement", {
    	  visitor: ["block", "handler", "finalizer"],
    	  aliases: ["Statement"],
    	  fields: {
    	    block: {
    	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("BlockStatement"), Object.assign(function (node) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (!node.handler && !node.finalizer) {
    	          throw new TypeError("TryStatement expects either a handler or finalizer, or both");
    	        }
    	      }, {
    	        oneOfNodeTypes: ["BlockStatement"]
    	      }))
    	    },
    	    handler: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("CatchClause")
    	    },
    	    finalizer: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }
    	});
    	(0, _utils.default)("UnaryExpression", {
    	  builder: ["operator", "argument", "prefix"],
    	  fields: {
    	    prefix: {
    	      default: true
    	    },
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.UNARY_OPERATORS)
    	    }
    	  },
    	  visitor: ["argument"],
    	  aliases: ["UnaryLike", "Expression"]
    	});
    	(0, _utils.default)("UpdateExpression", {
    	  builder: ["operator", "argument", "prefix"],
    	  fields: {
    	    prefix: {
    	      default: false
    	    },
    	    argument: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("Expression") : (0, _utils.assertNodeType)("Identifier", "MemberExpression")
    	    },
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.UPDATE_OPERATORS)
    	    }
    	  },
    	  visitor: ["argument"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("VariableDeclaration", {
    	  builder: ["kind", "declarations"],
    	  visitor: ["declarations"],
    	  aliases: ["Statement", "Declaration"],
    	  fields: {
    	    declare: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    kind: {
    	      validate: (0, _utils.assertOneOf)("var", "let", "const")
    	    },
    	    declarations: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("VariableDeclarator")))
    	    }
    	  },

    	  validate(parent, key, node) {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	    if (!(0, _is.default)("ForXStatement", parent, {
    	      left: node
    	    })) return;

    	    if (node.declarations.length !== 1) {
    	      throw new TypeError(`Exactly one VariableDeclarator is required in the VariableDeclaration of a ${parent.type}`);
    	    }
    	  }

    	});
    	(0, _utils.default)("VariableDeclarator", {
    	  visitor: ["id", "init"],
    	  fields: {
    	    id: {
    	      validate: function () {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) {
    	          return (0, _utils.assertNodeType)("LVal");
    	        }

    	        const normal = (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern");
    	        const without = (0, _utils.assertNodeType)("Identifier");
    	        return function (node, key, val) {
    	          const validator = node.init ? normal : without;
    	          validator(node, key, val);
    	        };
    	      }()
    	    },
    	    definite: {
    	      optional: true,
    	      validate: (0, _utils.assertValueType)("boolean")
    	    },
    	    init: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("WhileStatement", {
    	  visitor: ["test", "body"],
    	  aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("WithStatement", {
    	  visitor: ["object", "body"],
    	  aliases: ["Statement"],
    	  fields: {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("AssignmentPattern", {
    	  visitor: ["left", "right", "decorators"],
    	  builder: ["left", "right"],
    	  aliases: ["Pattern", "PatternLike", "LVal"],
    	  fields: Object.assign({}, patternLikeCommon, {
    	    left: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "ObjectPattern", "ArrayPattern", "MemberExpression")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("ArrayPattern", {
    	  visitor: ["elements", "typeAnnotation"],
    	  builder: ["elements"],
    	  aliases: ["Pattern", "PatternLike", "LVal"],
    	  fields: Object.assign({}, patternLikeCommon, {
    	    elements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "PatternLike")))
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    optional: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("ArrowFunctionExpression", {
    	  builder: ["params", "body", "async"],
    	  visitor: ["params", "body", "returnType", "typeParameters"],
    	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
    	    expression: {
    	      validate: (0, _utils.assertValueType)("boolean")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement", "Expression")
    	    }
    	  })
    	});
    	(0, _utils.default)("ClassBody", {
    	  visitor: ["body"],
    	  fields: {
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ClassMethod", "ClassPrivateMethod", "ClassProperty", "ClassPrivateProperty", "TSDeclareMethod", "TSIndexSignature")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassExpression", {
    	  builder: ["id", "superClass", "body", "decorators"],
    	  visitor: ["id", "body", "superClass", "mixins", "typeParameters", "superTypeParameters", "implements", "decorators"],
    	  aliases: ["Scopable", "Class", "Expression"],
    	  fields: {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("ClassBody")
    	    },
    	    superClass: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    superTypeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    },
    	    implements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    mixins: {
    	      validate: (0, _utils.assertNodeType)("InterfaceExtends"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassDeclaration", {
    	  inherits: "ClassExpression",
    	  aliases: ["Scopable", "Class", "Statement", "Declaration"],
    	  fields: {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("ClassBody")
    	    },
    	    superClass: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    superTypeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    },
    	    implements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    mixins: {
    	      validate: (0, _utils.assertNodeType)("InterfaceExtends"),
    	      optional: true
    	    },
    	    declare: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    abstract: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  },
    	  validate: function () {
    	    const identifier = (0, _utils.assertNodeType)("Identifier");
    	    return function (parent, key, node) {
    	      if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	      if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
    	        identifier(node, "id", node.id);
    	      }
    	    };
    	  }()
    	});
    	(0, _utils.default)("ExportAllDeclaration", {
    	  visitor: ["source"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    	  fields: {
    	    source: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral")
    	    },
    	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value")),
    	    assertions: {
    	      optional: true,
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportAttribute")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ExportDefaultDeclaration", {
    	  visitor: ["declaration"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    	  fields: {
    	    declaration: {
    	      validate: (0, _utils.assertNodeType)("FunctionDeclaration", "TSDeclareFunction", "ClassDeclaration", "Expression")
    	    },
    	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("value"))
    	  }
    	});
    	(0, _utils.default)("ExportNamedDeclaration", {
    	  visitor: ["declaration", "specifiers", "source"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    	  fields: {
    	    declaration: {
    	      optional: true,
    	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("Declaration"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && node.specifiers.length) {
    	          throw new TypeError("Only declaration or specifiers is allowed on ExportNamedDeclaration");
    	        }
    	      }, {
    	        oneOfNodeTypes: ["Declaration"]
    	      }), function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && node.source) {
    	          throw new TypeError("Cannot export a declaration from a source");
    	        }
    	      })
    	    },
    	    assertions: {
    	      optional: true,
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportAttribute")))
    	    },
    	    specifiers: {
    	      default: [],
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)(function () {
    	        const sourced = (0, _utils.assertNodeType)("ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier");
    	        const sourceless = (0, _utils.assertNodeType)("ExportSpecifier");
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return sourced;
    	        return function (node, key, val) {
    	          const validator = node.source ? sourced : sourceless;
    	          validator(node, key, val);
    	        };
    	      }()))
    	    },
    	    source: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral"),
    	      optional: true
    	    },
    	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
    	  }
    	});
    	(0, _utils.default)("ExportSpecifier", {
    	  visitor: ["local", "exported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    exported: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
    	    }
    	  }
    	});
    	(0, _utils.default)("ForOfStatement", {
    	  visitor: ["left", "right", "body"],
    	  builder: ["left", "right", "body", "await"],
    	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    	  fields: {
    	    left: {
    	      validate: function () {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) {
    	          return (0, _utils.assertNodeType)("VariableDeclaration", "LVal");
    	        }

    	        const declaration = (0, _utils.assertNodeType)("VariableDeclaration");
    	        const lval = (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern");
    	        return function (node, key, val) {
    	          if ((0, _is.default)("VariableDeclaration", val)) {
    	            declaration(node, key, val);
    	          } else {
    	            lval(node, key, val);
    	          }
    	        };
    	      }()
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    },
    	    await: {
    	      default: false
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportDeclaration", {
    	  visitor: ["specifiers", "source"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration"],
    	  fields: {
    	    assertions: {
    	      optional: true,
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportAttribute")))
    	    },
    	    specifiers: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier")))
    	    },
    	    source: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral")
    	    },
    	    importKind: {
    	      validate: (0, _utils.assertOneOf)("type", "typeof", "value"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportDefaultSpecifier", {
    	  visitor: ["local"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportNamespaceSpecifier", {
    	  visitor: ["local"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportSpecifier", {
    	  visitor: ["local", "imported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    imported: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
    	    },
    	    importKind: {
    	      validate: (0, _utils.assertOneOf)("type", "typeof"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("MetaProperty", {
    	  visitor: ["meta", "property"],
    	  aliases: ["Expression"],
    	  fields: {
    	    meta: {
    	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("Identifier"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	        let property;

    	        switch (val.name) {
    	          case "function":
    	            property = "sent";
    	            break;

    	          case "new":
    	            property = "target";
    	            break;

    	          case "import":
    	            property = "meta";
    	            break;
    	        }

    	        if (!(0, _is.default)("Identifier", node.property, {
    	          name: property
    	        })) {
    	          throw new TypeError("Unrecognised MetaProperty");
    	        }
    	      }, {
    	        oneOfNodeTypes: ["Identifier"]
    	      }))
    	    },
    	    property: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	const classMethodOrPropertyCommon = {
    	  abstract: {
    	    validate: (0, _utils.assertValueType)("boolean"),
    	    optional: true
    	  },
    	  accessibility: {
    	    validate: (0, _utils.assertOneOf)("public", "private", "protected"),
    	    optional: true
    	  },
    	  static: {
    	    default: false
    	  },
    	  override: {
    	    default: false
    	  },
    	  computed: {
    	    default: false
    	  },
    	  optional: {
    	    validate: (0, _utils.assertValueType)("boolean"),
    	    optional: true
    	  },
    	  key: {
    	    validate: (0, _utils.chain)(function () {
    	      const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
    	      const computed = (0, _utils.assertNodeType)("Expression");
    	      return function (node, key, val) {
    	        const validator = node.computed ? computed : normal;
    	        validator(node, key, val);
    	      };
    	    }(), (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "Expression"))
    	  }
    	};
    	core$1.classMethodOrPropertyCommon = classMethodOrPropertyCommon;
    	const classMethodOrDeclareMethodCommon = Object.assign({}, functionCommon, classMethodOrPropertyCommon, {
    	  params: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Identifier", "Pattern", "RestElement", "TSParameterProperty")))
    	  },
    	  kind: {
    	    validate: (0, _utils.assertOneOf)("get", "set", "method", "constructor"),
    	    default: "method"
    	  },
    	  access: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("public", "private", "protected")),
    	    optional: true
    	  },
    	  decorators: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	    optional: true
    	  }
    	});
    	core$1.classMethodOrDeclareMethodCommon = classMethodOrDeclareMethodCommon;
    	(0, _utils.default)("ClassMethod", {
    	  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
    	  builder: ["kind", "key", "params", "body", "computed", "static", "generator", "async"],
    	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    	  fields: Object.assign({}, classMethodOrDeclareMethodCommon, functionTypeAnnotationCommon, {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  })
    	});
    	(0, _utils.default)("ObjectPattern", {
    	  visitor: ["properties", "typeAnnotation", "decorators"],
    	  builder: ["properties"],
    	  aliases: ["Pattern", "PatternLike", "LVal"],
    	  fields: Object.assign({}, patternLikeCommon, {
    	    properties: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("RestElement", "ObjectProperty")))
    	    }
    	  })
    	});
    	(0, _utils.default)("SpreadElement", {
    	  visitor: ["argument"],
    	  aliases: ["UnaryLike"],
    	  deprecatedAlias: "SpreadProperty",
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("Super", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("TaggedTemplateExpression", {
    	  visitor: ["tag", "quasi", "typeParameters"],
    	  builder: ["tag", "quasi"],
    	  aliases: ["Expression"],
    	  fields: {
    	    tag: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    quasi: {
    	      validate: (0, _utils.assertNodeType)("TemplateLiteral")
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("TemplateElement", {
    	  builder: ["value", "tail"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertShape)({
    	        raw: {
    	          validate: (0, _utils.assertValueType)("string")
    	        },
    	        cooked: {
    	          validate: (0, _utils.assertValueType)("string"),
    	          optional: true
    	        }
    	      })
    	    },
    	    tail: {
    	      default: false
    	    }
    	  }
    	});
    	(0, _utils.default)("TemplateLiteral", {
    	  visitor: ["quasis", "expressions"],
    	  aliases: ["Expression", "Literal"],
    	  fields: {
    	    quasis: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TemplateElement")))
    	    },
    	    expressions: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "TSType")), function (node, key, val) {
    	        if (node.quasis.length !== val.length + 1) {
    	          throw new TypeError(`Number of ${node.type} quasis should be exactly one more than the number of expressions.\nExpected ${val.length + 1} quasis but got ${node.quasis.length}`);
    	        }
    	      })
    	    }
    	  }
    	});
    	(0, _utils.default)("YieldExpression", {
    	  builder: ["argument", "delegate"],
    	  visitor: ["argument"],
    	  aliases: ["Expression", "Terminatorless"],
    	  fields: {
    	    delegate: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && !node.argument) {
    	          throw new TypeError("Property delegate of YieldExpression cannot be true if there is no argument");
    	        }
    	      }, {
    	        type: "boolean"
    	      })),
    	      default: false
    	    },
    	    argument: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("AwaitExpression", {
    	  builder: ["argument"],
    	  visitor: ["argument"],
    	  aliases: ["Expression", "Terminatorless"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("Import", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("BigIntLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("ExportNamespaceSpecifier", {
    	  visitor: ["exported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    exported: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("OptionalMemberExpression", {
    	  builder: ["object", "property", "computed", "optional"],
    	  visitor: ["object", "property"],
    	  aliases: ["Expression"],
    	  fields: {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    property: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier"];
    	        return validator;
    	      }()
    	    },
    	    computed: {
    	      default: false
    	    },
    	    optional: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
    	    }
    	  }
    	});
    	(0, _utils.default)("OptionalCallExpression", {
    	  visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
    	  builder: ["callee", "arguments", "optional"],
    	  aliases: ["Expression"],
    	  fields: {
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    arguments: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement", "JSXNamespacedName", "ArgumentPlaceholder")))
    	    },
    	    optional: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
    	    },
    	    typeArguments: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
    	      optional: true
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassProperty", {
    	  visitor: ["key", "value", "typeAnnotation", "decorators"],
    	  builder: ["key", "value", "typeAnnotation", "decorators", "computed", "static"],
    	  aliases: ["Property"],
    	  fields: Object.assign({}, classMethodOrPropertyCommon, {
    	    value: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    definite: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    typeAnnotation: {
    	      validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    readonly: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    declare: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    variance: {
    	      validate: (0, _utils.assertNodeType)("Variance"),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("ClassPrivateProperty", {
    	  visitor: ["key", "value", "decorators", "typeAnnotation"],
    	  builder: ["key", "value", "decorators", "static"],
    	  aliases: ["Property", "Private"],
    	  fields: {
    	    key: {
    	      validate: (0, _utils.assertNodeType)("PrivateName")
    	    },
    	    value: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    typeAnnotation: {
    	      validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    readonly: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    definite: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    variance: {
    	      validate: (0, _utils.assertNodeType)("Variance"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassPrivateMethod", {
    	  builder: ["kind", "key", "params", "body", "static"],
    	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    	  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method", "Private"],
    	  fields: Object.assign({}, classMethodOrDeclareMethodCommon, functionTypeAnnotationCommon, {
    	    key: {
    	      validate: (0, _utils.assertNodeType)("PrivateName")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  })
    	});
    	(0, _utils.default)("PrivateName", {
    	  visitor: ["id"],
    	  aliases: ["Private"],
    	  fields: {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	return core$1;
    }

    var flow$4 = {};

    var hasRequiredFlow$1;

    function requireFlow$1 () {
    	if (hasRequiredFlow$1) return flow$4;
    	hasRequiredFlow$1 = 1;

    	var _utils = requireUtils$1();

    	const defineInterfaceishType = (name, typeParameterType = "TypeParameterDeclaration") => {
    	  (0, _utils.default)(name, {
    	    builder: ["id", "typeParameters", "extends", "body"],
    	    visitor: ["id", "typeParameters", "extends", "mixins", "implements", "body"],
    	    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	    fields: {
    	      id: (0, _utils.validateType)("Identifier"),
    	      typeParameters: (0, _utils.validateOptionalType)(typeParameterType),
    	      extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
    	      mixins: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
    	      implements: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ClassImplements")),
    	      body: (0, _utils.validateType)("ObjectTypeAnnotation")
    	    }
    	  });
    	};

    	(0, _utils.default)("AnyTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ArrayTypeAnnotation", {
    	  visitor: ["elementType"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    elementType: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("BooleanTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("BooleanLiteralTypeAnnotation", {
    	  builder: ["value"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    value: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("NullLiteralTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ClassImplements", {
    	  visitor: ["id", "typeParameters"],
    	  aliases: ["Flow"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
    	  }
    	});
    	defineInterfaceishType("DeclareClass");
    	(0, _utils.default)("DeclareFunction", {
    	  visitor: ["id"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    predicate: (0, _utils.validateOptionalType)("DeclaredPredicate")
    	  }
    	});
    	defineInterfaceishType("DeclareInterface");
    	(0, _utils.default)("DeclareModule", {
    	  builder: ["id", "body", "kind"],
    	  visitor: ["id", "body"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    body: (0, _utils.validateType)("BlockStatement"),
    	    kind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("CommonJS", "ES"))
    	  }
    	});
    	(0, _utils.default)("DeclareModuleExports", {
    	  visitor: ["typeAnnotation"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
    	  }
    	});
    	(0, _utils.default)("DeclareTypeAlias", {
    	  visitor: ["id", "typeParameters", "right"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    right: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("DeclareOpaqueType", {
    	  visitor: ["id", "typeParameters", "supertype"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    supertype: (0, _utils.validateOptionalType)("FlowType"),
    	    impltype: (0, _utils.validateOptionalType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("DeclareVariable", {
    	  visitor: ["id"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	(0, _utils.default)("DeclareExportDeclaration", {
    	  visitor: ["declaration", "specifiers", "source"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    declaration: (0, _utils.validateOptionalType)("Flow"),
    	    specifiers: (0, _utils.validateOptional)((0, _utils.arrayOfType)(["ExportSpecifier", "ExportNamespaceSpecifier"])),
    	    source: (0, _utils.validateOptionalType)("StringLiteral"),
    	    default: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("DeclareExportAllDeclaration", {
    	  visitor: ["source"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    source: (0, _utils.validateType)("StringLiteral"),
    	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
    	  }
    	});
    	(0, _utils.default)("DeclaredPredicate", {
    	  visitor: ["value"],
    	  aliases: ["Flow", "FlowPredicate"],
    	  fields: {
    	    value: (0, _utils.validateType)("Flow")
    	  }
    	});
    	(0, _utils.default)("ExistsTypeAnnotation", {
    	  aliases: ["Flow", "FlowType"]
    	});
    	(0, _utils.default)("FunctionTypeAnnotation", {
    	  visitor: ["typeParameters", "params", "rest", "returnType"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    params: (0, _utils.validate)((0, _utils.arrayOfType)("FunctionTypeParam")),
    	    rest: (0, _utils.validateOptionalType)("FunctionTypeParam"),
    	    this: (0, _utils.validateOptionalType)("FunctionTypeParam"),
    	    returnType: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("FunctionTypeParam", {
    	  visitor: ["name", "typeAnnotation"],
    	  aliases: ["Flow"],
    	  fields: {
    	    name: (0, _utils.validateOptionalType)("Identifier"),
    	    typeAnnotation: (0, _utils.validateType)("FlowType"),
    	    optional: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("GenericTypeAnnotation", {
    	  visitor: ["id", "typeParameters"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"]),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("InferredPredicate", {
    	  aliases: ["Flow", "FlowPredicate"]
    	});
    	(0, _utils.default)("InterfaceExtends", {
    	  visitor: ["id", "typeParameters"],
    	  aliases: ["Flow"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"]),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
    	  }
    	});
    	defineInterfaceishType("InterfaceDeclaration");
    	(0, _utils.default)("InterfaceTypeAnnotation", {
    	  visitor: ["extends", "body"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
    	    body: (0, _utils.validateType)("ObjectTypeAnnotation")
    	  }
    	});
    	(0, _utils.default)("IntersectionTypeAnnotation", {
    	  visitor: ["types"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("MixedTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("EmptyTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("NullableTypeAnnotation", {
    	  visitor: ["typeAnnotation"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("NumberLiteralTypeAnnotation", {
    	  builder: ["value"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    value: (0, _utils.validate)((0, _utils.assertValueType)("number"))
    	  }
    	});
    	(0, _utils.default)("NumberTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ObjectTypeAnnotation", {
    	  visitor: ["properties", "indexers", "callProperties", "internalSlots"],
    	  aliases: ["Flow", "FlowType"],
    	  builder: ["properties", "indexers", "callProperties", "internalSlots", "exact"],
    	  fields: {
    	    properties: (0, _utils.validate)((0, _utils.arrayOfType)(["ObjectTypeProperty", "ObjectTypeSpreadProperty"])),
    	    indexers: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeIndexer")),
    	    callProperties: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeCallProperty")),
    	    internalSlots: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeInternalSlot")),
    	    exact: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      default: false
    	    },
    	    inexact: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeInternalSlot", {
    	  visitor: ["id", "value", "optional", "static", "method"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    value: (0, _utils.validateType)("FlowType"),
    	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    method: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeCallProperty", {
    	  visitor: ["value"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    value: (0, _utils.validateType)("FlowType"),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeIndexer", {
    	  visitor: ["id", "key", "value", "variance"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    id: (0, _utils.validateOptionalType)("Identifier"),
    	    key: (0, _utils.validateType)("FlowType"),
    	    value: (0, _utils.validateType)("FlowType"),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    variance: (0, _utils.validateOptionalType)("Variance")
    	  }
    	});
    	(0, _utils.default)("ObjectTypeProperty", {
    	  visitor: ["key", "value", "variance"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    key: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    value: (0, _utils.validateType)("FlowType"),
    	    kind: (0, _utils.validate)((0, _utils.assertOneOf)("init", "get", "set")),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    proto: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    variance: (0, _utils.validateOptionalType)("Variance"),
    	    method: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeSpreadProperty", {
    	  visitor: ["argument"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    argument: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("OpaqueType", {
    	  visitor: ["id", "typeParameters", "supertype", "impltype"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    supertype: (0, _utils.validateOptionalType)("FlowType"),
    	    impltype: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("QualifiedTypeIdentifier", {
    	  visitor: ["id", "qualification"],
    	  aliases: ["Flow"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    qualification: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"])
    	  }
    	});
    	(0, _utils.default)("StringLiteralTypeAnnotation", {
    	  builder: ["value"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    value: (0, _utils.validate)((0, _utils.assertValueType)("string"))
    	  }
    	});
    	(0, _utils.default)("StringTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("SymbolTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ThisTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("TupleTypeAnnotation", {
    	  visitor: ["types"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("TypeofTypeAnnotation", {
    	  visitor: ["argument"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    argument: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("TypeAlias", {
    	  visitor: ["id", "typeParameters", "right"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    right: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("TypeAnnotation", {
    	  aliases: ["Flow"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("TypeCastExpression", {
    	  visitor: ["expression", "typeAnnotation"],
    	  aliases: ["Flow", "ExpressionWrapper", "Expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression"),
    	    typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
    	  }
    	});
    	(0, _utils.default)("TypeParameter", {
    	  aliases: ["Flow"],
    	  visitor: ["bound", "default", "variance"],
    	  fields: {
    	    name: (0, _utils.validate)((0, _utils.assertValueType)("string")),
    	    bound: (0, _utils.validateOptionalType)("TypeAnnotation"),
    	    default: (0, _utils.validateOptionalType)("FlowType"),
    	    variance: (0, _utils.validateOptionalType)("Variance")
    	  }
    	});
    	(0, _utils.default)("TypeParameterDeclaration", {
    	  aliases: ["Flow"],
    	  visitor: ["params"],
    	  fields: {
    	    params: (0, _utils.validate)((0, _utils.arrayOfType)("TypeParameter"))
    	  }
    	});
    	(0, _utils.default)("TypeParameterInstantiation", {
    	  aliases: ["Flow"],
    	  visitor: ["params"],
    	  fields: {
    	    params: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("UnionTypeAnnotation", {
    	  visitor: ["types"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("Variance", {
    	  aliases: ["Flow"],
    	  builder: ["kind"],
    	  fields: {
    	    kind: (0, _utils.validate)((0, _utils.assertOneOf)("minus", "plus"))
    	  }
    	});
    	(0, _utils.default)("VoidTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("EnumDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "body"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    body: (0, _utils.validateType)(["EnumBooleanBody", "EnumNumberBody", "EnumStringBody", "EnumSymbolBody"])
    	  }
    	});
    	(0, _utils.default)("EnumBooleanBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    explicitType: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    members: (0, _utils.validateArrayOfType)("EnumBooleanMember"),
    	    hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("EnumNumberBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    explicitType: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    members: (0, _utils.validateArrayOfType)("EnumNumberMember"),
    	    hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("EnumStringBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    explicitType: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    members: (0, _utils.validateArrayOfType)(["EnumStringMember", "EnumDefaultedMember"]),
    	    hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("EnumSymbolBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    members: (0, _utils.validateArrayOfType)("EnumDefaultedMember"),
    	    hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("EnumBooleanMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    init: (0, _utils.validateType)("BooleanLiteral")
    	  }
    	});
    	(0, _utils.default)("EnumNumberMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id", "init"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    init: (0, _utils.validateType)("NumericLiteral")
    	  }
    	});
    	(0, _utils.default)("EnumStringMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id", "init"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    init: (0, _utils.validateType)("StringLiteral")
    	  }
    	});
    	(0, _utils.default)("EnumDefaultedMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	(0, _utils.default)("IndexedAccessType", {
    	  visitor: ["objectType", "indexType"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    objectType: (0, _utils.validateType)("FlowType"),
    	    indexType: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("OptionalIndexedAccessType", {
    	  visitor: ["objectType", "indexType"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    objectType: (0, _utils.validateType)("FlowType"),
    	    indexType: (0, _utils.validateType)("FlowType"),
    	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	return flow$4;
    }

    var jsx$4 = {};

    var hasRequiredJsx$1;

    function requireJsx$1 () {
    	if (hasRequiredJsx$1) return jsx$4;
    	hasRequiredJsx$1 = 1;

    	var _utils = requireUtils$1();

    	(0, _utils.default)("JSXAttribute", {
    	  visitor: ["name", "value"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXNamespacedName")
    	    },
    	    value: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("JSXElement", "JSXFragment", "StringLiteral", "JSXExpressionContainer")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXClosingElement", {
    	  visitor: ["name"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXElement", {
    	  builder: ["openingElement", "closingElement", "children", "selfClosing"],
    	  visitor: ["openingElement", "children", "closingElement"],
    	  aliases: ["JSX", "Immutable", "Expression"],
    	  fields: {
    	    openingElement: {
    	      validate: (0, _utils.assertNodeType)("JSXOpeningElement")
    	    },
    	    closingElement: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("JSXClosingElement")
    	    },
    	    children: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
    	    },
    	    selfClosing: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXEmptyExpression", {
    	  aliases: ["JSX"]
    	});
    	(0, _utils.default)("JSXExpressionContainer", {
    	  visitor: ["expression"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression", "JSXEmptyExpression")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXSpreadChild", {
    	  visitor: ["expression"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXIdentifier", {
    	  builder: ["name"],
    	  aliases: ["JSX"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXMemberExpression", {
    	  visitor: ["object", "property"],
    	  aliases: ["JSX"],
    	  fields: {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("JSXMemberExpression", "JSXIdentifier")
    	    },
    	    property: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXNamespacedName", {
    	  visitor: ["namespace", "name"],
    	  aliases: ["JSX"],
    	  fields: {
    	    namespace: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
    	    },
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXOpeningElement", {
    	  builder: ["name", "attributes", "selfClosing"],
    	  visitor: ["name", "attributes"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
    	    },
    	    selfClosing: {
    	      default: false
    	    },
    	    attributes: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXAttribute", "JSXSpreadAttribute")))
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXSpreadAttribute", {
    	  visitor: ["argument"],
    	  aliases: ["JSX"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXText", {
    	  aliases: ["JSX", "Immutable"],
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXFragment", {
    	  builder: ["openingFragment", "closingFragment", "children"],
    	  visitor: ["openingFragment", "children", "closingFragment"],
    	  aliases: ["JSX", "Immutable", "Expression"],
    	  fields: {
    	    openingFragment: {
    	      validate: (0, _utils.assertNodeType)("JSXOpeningFragment")
    	    },
    	    closingFragment: {
    	      validate: (0, _utils.assertNodeType)("JSXClosingFragment")
    	    },
    	    children: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXOpeningFragment", {
    	  aliases: ["JSX", "Immutable"]
    	});
    	(0, _utils.default)("JSXClosingFragment", {
    	  aliases: ["JSX", "Immutable"]
    	});
    	return jsx$4;
    }

    var misc$1 = {};

    var placeholders$3 = {};

    var hasRequiredPlaceholders$1;

    function requirePlaceholders$1 () {
    	if (hasRequiredPlaceholders$1) return placeholders$3;
    	hasRequiredPlaceholders$1 = 1;

    	Object.defineProperty(placeholders$3, "__esModule", {
    	  value: true
    	});
    	placeholders$3.PLACEHOLDERS_FLIPPED_ALIAS = placeholders$3.PLACEHOLDERS_ALIAS = placeholders$3.PLACEHOLDERS = void 0;

    	var _utils = requireUtils$1();

    	const PLACEHOLDERS = ["Identifier", "StringLiteral", "Expression", "Statement", "Declaration", "BlockStatement", "ClassBody", "Pattern"];
    	placeholders$3.PLACEHOLDERS = PLACEHOLDERS;
    	const PLACEHOLDERS_ALIAS = {
    	  Declaration: ["Statement"],
    	  Pattern: ["PatternLike", "LVal"]
    	};
    	placeholders$3.PLACEHOLDERS_ALIAS = PLACEHOLDERS_ALIAS;

    	for (const type of PLACEHOLDERS) {
    	  const alias = _utils.ALIAS_KEYS[type];
    	  if (alias != null && alias.length) PLACEHOLDERS_ALIAS[type] = alias;
    	}

    	const PLACEHOLDERS_FLIPPED_ALIAS = {};
    	placeholders$3.PLACEHOLDERS_FLIPPED_ALIAS = PLACEHOLDERS_FLIPPED_ALIAS;
    	Object.keys(PLACEHOLDERS_ALIAS).forEach(type => {
    	  PLACEHOLDERS_ALIAS[type].forEach(alias => {
    	    if (!Object.hasOwnProperty.call(PLACEHOLDERS_FLIPPED_ALIAS, alias)) {
    	      PLACEHOLDERS_FLIPPED_ALIAS[alias] = [];
    	    }

    	    PLACEHOLDERS_FLIPPED_ALIAS[alias].push(type);
    	  });
    	});
    	return placeholders$3;
    }

    var hasRequiredMisc$1;

    function requireMisc$1 () {
    	if (hasRequiredMisc$1) return misc$1;
    	hasRequiredMisc$1 = 1;

    	var _utils = requireUtils$1();

    	var _placeholders = requirePlaceholders$1();

    	{
    	  (0, _utils.default)("Noop", {
    	    visitor: []
    	  });
    	}
    	(0, _utils.default)("Placeholder", {
    	  visitor: [],
    	  builder: ["expectedNode", "name"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    expectedNode: {
    	      validate: (0, _utils.assertOneOf)(..._placeholders.PLACEHOLDERS)
    	    }
    	  }
    	});
    	(0, _utils.default)("V8IntrinsicIdentifier", {
    	  builder: ["name"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	return misc$1;
    }

    var experimental$1 = {};

    var hasRequiredExperimental$1;

    function requireExperimental$1 () {
    	if (hasRequiredExperimental$1) return experimental$1;
    	hasRequiredExperimental$1 = 1;

    	var _utils = requireUtils$1();

    	(0, _utils.default)("ArgumentPlaceholder", {});
    	(0, _utils.default)("BindExpression", {
    	  visitor: ["object", "callee"],
    	  aliases: ["Expression"],
    	  fields: !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	    object: {
    	      validate: Object.assign(() => {}, {
    	        oneOfNodeTypes: ["Expression"]
    	      })
    	    },
    	    callee: {
    	      validate: Object.assign(() => {}, {
    	        oneOfNodeTypes: ["Expression"]
    	      })
    	    }
    	  } : {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportAttribute", {
    	  visitor: ["key", "value"],
    	  fields: {
    	    key: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
    	    },
    	    value: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral")
    	    }
    	  }
    	});
    	(0, _utils.default)("Decorator", {
    	  visitor: ["expression"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("DoExpression", {
    	  visitor: ["body"],
    	  builder: ["body", "async"],
    	  aliases: ["Expression"],
    	  fields: {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    },
    	    async: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      default: false
    	    }
    	  }
    	});
    	(0, _utils.default)("ExportDefaultSpecifier", {
    	  visitor: ["exported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    exported: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("RecordExpression", {
    	  visitor: ["properties"],
    	  aliases: ["Expression"],
    	  fields: {
    	    properties: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ObjectProperty", "SpreadElement")))
    	    }
    	  }
    	});
    	(0, _utils.default)("TupleExpression", {
    	  fields: {
    	    elements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement"))),
    	      default: []
    	    }
    	  },
    	  visitor: ["elements"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("DecimalLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("StaticBlock", {
    	  visitor: ["body"],
    	  fields: {
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent"]
    	});
    	(0, _utils.default)("ModuleExpression", {
    	  visitor: ["body"],
    	  fields: {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Program")
    	    }
    	  },
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("TopicReference", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("PipelineTopicExpression", {
    	  builder: ["expression"],
    	  visitor: ["expression"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("PipelineBareFunction", {
    	  builder: ["callee"],
    	  visitor: ["callee"],
    	  fields: {
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("PipelinePrimaryTopicReference", {
    	  aliases: ["Expression"]
    	});
    	return experimental$1;
    }

    var typescript$4 = {};

    var hasRequiredTypescript$1;

    function requireTypescript$1 () {
    	if (hasRequiredTypescript$1) return typescript$4;
    	hasRequiredTypescript$1 = 1;

    	var _utils = requireUtils$1();

    	var _core = requireCore$1();

    	var _is = requireIs$1();

    	const bool = (0, _utils.assertValueType)("boolean");
    	const tSFunctionTypeAnnotationCommon = {
    	  returnType: {
    	    validate: (0, _utils.assertNodeType)("TSTypeAnnotation", "Noop"),
    	    optional: true
    	  },
    	  typeParameters: {
    	    validate: (0, _utils.assertNodeType)("TSTypeParameterDeclaration", "Noop"),
    	    optional: true
    	  }
    	};
    	(0, _utils.default)("TSParameterProperty", {
    	  aliases: ["LVal"],
    	  visitor: ["parameter"],
    	  fields: {
    	    accessibility: {
    	      validate: (0, _utils.assertOneOf)("public", "private", "protected"),
    	      optional: true
    	    },
    	    readonly: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    parameter: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "AssignmentPattern")
    	    },
    	    override: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("TSDeclareFunction", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "typeParameters", "params", "returnType"],
    	  fields: Object.assign({}, _core.functionDeclarationCommon, tSFunctionTypeAnnotationCommon)
    	});
    	(0, _utils.default)("TSDeclareMethod", {
    	  visitor: ["decorators", "key", "typeParameters", "params", "returnType"],
    	  fields: Object.assign({}, _core.classMethodOrDeclareMethodCommon, tSFunctionTypeAnnotationCommon)
    	});
    	(0, _utils.default)("TSQualifiedName", {
    	  aliases: ["TSEntityName"],
    	  visitor: ["left", "right"],
    	  fields: {
    	    left: (0, _utils.validateType)("TSEntityName"),
    	    right: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	const signatureDeclarationCommon = {
    	  typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
    	  parameters: (0, _utils.validateArrayOfType)(["Identifier", "RestElement"]),
    	  typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
    	};
    	const callConstructSignatureDeclaration = {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["typeParameters", "parameters", "typeAnnotation"],
    	  fields: signatureDeclarationCommon
    	};
    	(0, _utils.default)("TSCallSignatureDeclaration", callConstructSignatureDeclaration);
    	(0, _utils.default)("TSConstructSignatureDeclaration", callConstructSignatureDeclaration);
    	const namedTypeElementCommon = {
    	  key: (0, _utils.validateType)("Expression"),
    	  computed: (0, _utils.validate)(bool),
    	  optional: (0, _utils.validateOptional)(bool)
    	};
    	(0, _utils.default)("TSPropertySignature", {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["key", "typeAnnotation", "initializer"],
    	  fields: Object.assign({}, namedTypeElementCommon, {
    	    readonly: (0, _utils.validateOptional)(bool),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
    	    initializer: (0, _utils.validateOptionalType)("Expression"),
    	    kind: {
    	      validate: (0, _utils.assertOneOf)("get", "set")
    	    }
    	  })
    	});
    	(0, _utils.default)("TSMethodSignature", {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["key", "typeParameters", "parameters", "typeAnnotation"],
    	  fields: Object.assign({}, signatureDeclarationCommon, namedTypeElementCommon, {
    	    kind: {
    	      validate: (0, _utils.assertOneOf)("method", "get", "set")
    	    }
    	  })
    	});
    	(0, _utils.default)("TSIndexSignature", {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["parameters", "typeAnnotation"],
    	  fields: {
    	    readonly: (0, _utils.validateOptional)(bool),
    	    static: (0, _utils.validateOptional)(bool),
    	    parameters: (0, _utils.validateArrayOfType)("Identifier"),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
    	  }
    	});
    	const tsKeywordTypes = ["TSAnyKeyword", "TSBooleanKeyword", "TSBigIntKeyword", "TSIntrinsicKeyword", "TSNeverKeyword", "TSNullKeyword", "TSNumberKeyword", "TSObjectKeyword", "TSStringKeyword", "TSSymbolKeyword", "TSUndefinedKeyword", "TSUnknownKeyword", "TSVoidKeyword"];

    	for (const type of tsKeywordTypes) {
    	  (0, _utils.default)(type, {
    	    aliases: ["TSType", "TSBaseType"],
    	    visitor: [],
    	    fields: {}
    	  });
    	}

    	(0, _utils.default)("TSThisType", {
    	  aliases: ["TSType", "TSBaseType"],
    	  visitor: [],
    	  fields: {}
    	});
    	const fnOrCtrBase = {
    	  aliases: ["TSType"],
    	  visitor: ["typeParameters", "parameters", "typeAnnotation"]
    	};
    	(0, _utils.default)("TSFunctionType", Object.assign({}, fnOrCtrBase, {
    	  fields: signatureDeclarationCommon
    	}));
    	(0, _utils.default)("TSConstructorType", Object.assign({}, fnOrCtrBase, {
    	  fields: Object.assign({}, signatureDeclarationCommon, {
    	    abstract: (0, _utils.validateOptional)(bool)
    	  })
    	}));
    	(0, _utils.default)("TSTypeReference", {
    	  aliases: ["TSType"],
    	  visitor: ["typeName", "typeParameters"],
    	  fields: {
    	    typeName: (0, _utils.validateType)("TSEntityName"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("TSTypePredicate", {
    	  aliases: ["TSType"],
    	  visitor: ["parameterName", "typeAnnotation"],
    	  builder: ["parameterName", "typeAnnotation", "asserts"],
    	  fields: {
    	    parameterName: (0, _utils.validateType)(["Identifier", "TSThisType"]),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
    	    asserts: (0, _utils.validateOptional)(bool)
    	  }
    	});
    	(0, _utils.default)("TSTypeQuery", {
    	  aliases: ["TSType"],
    	  visitor: ["exprName"],
    	  fields: {
    	    exprName: (0, _utils.validateType)(["TSEntityName", "TSImportType"])
    	  }
    	});
    	(0, _utils.default)("TSTypeLiteral", {
    	  aliases: ["TSType"],
    	  visitor: ["members"],
    	  fields: {
    	    members: (0, _utils.validateArrayOfType)("TSTypeElement")
    	  }
    	});
    	(0, _utils.default)("TSArrayType", {
    	  aliases: ["TSType"],
    	  visitor: ["elementType"],
    	  fields: {
    	    elementType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSTupleType", {
    	  aliases: ["TSType"],
    	  visitor: ["elementTypes"],
    	  fields: {
    	    elementTypes: (0, _utils.validateArrayOfType)(["TSType", "TSNamedTupleMember"])
    	  }
    	});
    	(0, _utils.default)("TSOptionalType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSRestType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSNamedTupleMember", {
    	  visitor: ["label", "elementType"],
    	  builder: ["label", "elementType", "optional"],
    	  fields: {
    	    label: (0, _utils.validateType)("Identifier"),
    	    optional: {
    	      validate: bool,
    	      default: false
    	    },
    	    elementType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	const unionOrIntersection = {
    	  aliases: ["TSType"],
    	  visitor: ["types"],
    	  fields: {
    	    types: (0, _utils.validateArrayOfType)("TSType")
    	  }
    	};
    	(0, _utils.default)("TSUnionType", unionOrIntersection);
    	(0, _utils.default)("TSIntersectionType", unionOrIntersection);
    	(0, _utils.default)("TSConditionalType", {
    	  aliases: ["TSType"],
    	  visitor: ["checkType", "extendsType", "trueType", "falseType"],
    	  fields: {
    	    checkType: (0, _utils.validateType)("TSType"),
    	    extendsType: (0, _utils.validateType)("TSType"),
    	    trueType: (0, _utils.validateType)("TSType"),
    	    falseType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSInferType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeParameter"],
    	  fields: {
    	    typeParameter: (0, _utils.validateType)("TSTypeParameter")
    	  }
    	});
    	(0, _utils.default)("TSParenthesizedType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSTypeOperator", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    operator: (0, _utils.validate)((0, _utils.assertValueType)("string")),
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSIndexedAccessType", {
    	  aliases: ["TSType"],
    	  visitor: ["objectType", "indexType"],
    	  fields: {
    	    objectType: (0, _utils.validateType)("TSType"),
    	    indexType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSMappedType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeParameter", "typeAnnotation", "nameType"],
    	  fields: {
    	    readonly: (0, _utils.validateOptional)(bool),
    	    typeParameter: (0, _utils.validateType)("TSTypeParameter"),
    	    optional: (0, _utils.validateOptional)(bool),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSType"),
    	    nameType: (0, _utils.validateOptionalType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSLiteralType", {
    	  aliases: ["TSType", "TSBaseType"],
    	  visitor: ["literal"],
    	  fields: {
    	    literal: {
    	      validate: function () {
    	        const unaryExpression = (0, _utils.assertNodeType)("NumericLiteral", "BigIntLiteral");
    	        const unaryOperator = (0, _utils.assertOneOf)("-");
    	        const literal = (0, _utils.assertNodeType)("NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral");

    	        function validator(parent, key, node) {
    	          if ((0, _is.default)("UnaryExpression", node)) {
    	            unaryOperator(node, "operator", node.operator);
    	            unaryExpression(node, "argument", node.argument);
    	          } else {
    	            literal(parent, key, node);
    	          }
    	        }

    	        validator.oneOfNodeTypes = ["NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral", "UnaryExpression"];
    	        return validator;
    	      }()
    	    }
    	  }
    	});
    	(0, _utils.default)("TSExpressionWithTypeArguments", {
    	  aliases: ["TSType"],
    	  visitor: ["expression", "typeParameters"],
    	  fields: {
    	    expression: (0, _utils.validateType)("TSEntityName"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("TSInterfaceDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "typeParameters", "extends", "body"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
    	    extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("TSExpressionWithTypeArguments")),
    	    body: (0, _utils.validateType)("TSInterfaceBody")
    	  }
    	});
    	(0, _utils.default)("TSInterfaceBody", {
    	  visitor: ["body"],
    	  fields: {
    	    body: (0, _utils.validateArrayOfType)("TSTypeElement")
    	  }
    	});
    	(0, _utils.default)("TSTypeAliasDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "typeParameters", "typeAnnotation"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSAsExpression", {
    	  aliases: ["Expression"],
    	  visitor: ["expression", "typeAnnotation"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression"),
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSTypeAssertion", {
    	  aliases: ["Expression"],
    	  visitor: ["typeAnnotation", "expression"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType"),
    	    expression: (0, _utils.validateType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSEnumDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "members"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    const: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    members: (0, _utils.validateArrayOfType)("TSEnumMember"),
    	    initializer: (0, _utils.validateOptionalType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSEnumMember", {
    	  visitor: ["id", "initializer"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    initializer: (0, _utils.validateOptionalType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSModuleDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "body"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    global: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    body: (0, _utils.validateType)(["TSModuleBlock", "TSModuleDeclaration"])
    	  }
    	});
    	(0, _utils.default)("TSModuleBlock", {
    	  aliases: ["Scopable", "Block", "BlockParent"],
    	  visitor: ["body"],
    	  fields: {
    	    body: (0, _utils.validateArrayOfType)("Statement")
    	  }
    	});
    	(0, _utils.default)("TSImportType", {
    	  aliases: ["TSType"],
    	  visitor: ["argument", "qualifier", "typeParameters"],
    	  fields: {
    	    argument: (0, _utils.validateType)("StringLiteral"),
    	    qualifier: (0, _utils.validateOptionalType)("TSEntityName"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("TSImportEqualsDeclaration", {
    	  aliases: ["Statement"],
    	  visitor: ["id", "moduleReference"],
    	  fields: {
    	    isExport: (0, _utils.validate)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    moduleReference: (0, _utils.validateType)(["TSEntityName", "TSExternalModuleReference"]),
    	    importKind: {
    	      validate: (0, _utils.assertOneOf)("type", "value"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("TSExternalModuleReference", {
    	  visitor: ["expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("StringLiteral")
    	  }
    	});
    	(0, _utils.default)("TSNonNullExpression", {
    	  aliases: ["Expression"],
    	  visitor: ["expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSExportAssignment", {
    	  aliases: ["Statement"],
    	  visitor: ["expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSNamespaceExportDeclaration", {
    	  aliases: ["Statement"],
    	  visitor: ["id"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	(0, _utils.default)("TSTypeAnnotation", {
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: {
    	      validate: (0, _utils.assertNodeType)("TSType")
    	    }
    	  }
    	});
    	(0, _utils.default)("TSTypeParameterInstantiation", {
    	  visitor: ["params"],
    	  fields: {
    	    params: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSType")))
    	    }
    	  }
    	});
    	(0, _utils.default)("TSTypeParameterDeclaration", {
    	  visitor: ["params"],
    	  fields: {
    	    params: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSTypeParameter")))
    	    }
    	  }
    	});
    	(0, _utils.default)("TSTypeParameter", {
    	  builder: ["constraint", "default", "name"],
    	  visitor: ["constraint", "default"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertValueType)("string")
    	    },
    	    constraint: {
    	      validate: (0, _utils.assertNodeType)("TSType"),
    	      optional: true
    	    },
    	    default: {
    	      validate: (0, _utils.assertNodeType)("TSType"),
    	      optional: true
    	    }
    	  }
    	});
    	return typescript$4;
    }

    var hasRequiredDefinitions$1;

    function requireDefinitions$1 () {
    	if (hasRequiredDefinitions$1) return definitions$1;
    	hasRequiredDefinitions$1 = 1;
    	(function (exports) {

    		Object.defineProperty(exports, "__esModule", {
    		  value: true
    		});
    		Object.defineProperty(exports, "VISITOR_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.VISITOR_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "ALIAS_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.ALIAS_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "FLIPPED_ALIAS_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.FLIPPED_ALIAS_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "NODE_FIELDS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.NODE_FIELDS;
    		  }
    		});
    		Object.defineProperty(exports, "BUILDER_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.BUILDER_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "DEPRECATED_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.DEPRECATED_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "NODE_PARENT_VALIDATIONS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.NODE_PARENT_VALIDATIONS;
    		  }
    		});
    		Object.defineProperty(exports, "PLACEHOLDERS", {
    		  enumerable: true,
    		  get: function () {
    		    return _placeholders.PLACEHOLDERS;
    		  }
    		});
    		Object.defineProperty(exports, "PLACEHOLDERS_ALIAS", {
    		  enumerable: true,
    		  get: function () {
    		    return _placeholders.PLACEHOLDERS_ALIAS;
    		  }
    		});
    		Object.defineProperty(exports, "PLACEHOLDERS_FLIPPED_ALIAS", {
    		  enumerable: true,
    		  get: function () {
    		    return _placeholders.PLACEHOLDERS_FLIPPED_ALIAS;
    		  }
    		});
    		exports.TYPES = void 0;

    		var _toFastProperties = toFastProperties;

    		requireCore$1();

    		requireFlow$1();

    		requireJsx$1();

    		requireMisc$1();

    		requireExperimental$1();

    		requireTypescript$1();

    		var _utils = requireUtils$1();

    		var _placeholders = requirePlaceholders$1();

    		_toFastProperties(_utils.VISITOR_KEYS);

    		_toFastProperties(_utils.ALIAS_KEYS);

    		_toFastProperties(_utils.FLIPPED_ALIAS_KEYS);

    		_toFastProperties(_utils.NODE_FIELDS);

    		_toFastProperties(_utils.BUILDER_KEYS);

    		_toFastProperties(_utils.DEPRECATED_KEYS);

    		_toFastProperties(_placeholders.PLACEHOLDERS_ALIAS);

    		_toFastProperties(_placeholders.PLACEHOLDERS_FLIPPED_ALIAS);

    		const TYPES = Object.keys(_utils.VISITOR_KEYS).concat(Object.keys(_utils.FLIPPED_ALIAS_KEYS)).concat(Object.keys(_utils.DEPRECATED_KEYS));
    		exports.TYPES = TYPES;
    } (definitions$1));
    	return definitions$1;
    }

    Object.defineProperty(builder$3, "__esModule", {
      value: true
    });
    builder$3.default = builder$2;

    var _definitions$d = requireDefinitions$1();

    var _validate$1 = requireValidate$1();

    function builder$2(type, ...args) {
      const keys = _definitions$d.BUILDER_KEYS[type];
      const countArgs = args.length;

      if (countArgs > keys.length) {
        throw new Error(`${type}: Too many arguments passed. Received ${countArgs} but can receive no more than ${keys.length}`);
      }

      const node = {
        type
      };
      let i = 0;
      keys.forEach(key => {
        const field = _definitions$d.NODE_FIELDS[type][key];
        let arg;
        if (i < countArgs) arg = args[i];

        if (arg === undefined) {
          arg = Array.isArray(field.default) ? [] : field.default;
        }

        node[key] = arg;
        i++;
      });

      for (const key of Object.keys(node)) {
        (0, _validate$1.default)(node, key, node[key]);
      }

      return node;
    }

    Object.defineProperty(generated$7, "__esModule", {
      value: true
    });
    generated$7.arrayExpression = arrayExpression;
    generated$7.assignmentExpression = assignmentExpression;
    generated$7.binaryExpression = binaryExpression;
    generated$7.interpreterDirective = interpreterDirective;
    generated$7.directive = directive;
    generated$7.directiveLiteral = directiveLiteral;
    generated$7.blockStatement = blockStatement;
    generated$7.breakStatement = breakStatement;
    generated$7.callExpression = callExpression;
    generated$7.catchClause = catchClause;
    generated$7.conditionalExpression = conditionalExpression;
    generated$7.continueStatement = continueStatement;
    generated$7.debuggerStatement = debuggerStatement;
    generated$7.doWhileStatement = doWhileStatement;
    generated$7.emptyStatement = emptyStatement;
    generated$7.expressionStatement = expressionStatement;
    generated$7.file = file;
    generated$7.forInStatement = forInStatement;
    generated$7.forStatement = forStatement;
    generated$7.functionDeclaration = functionDeclaration;
    generated$7.functionExpression = functionExpression;
    generated$7.identifier = identifier$1;
    generated$7.ifStatement = ifStatement;
    generated$7.labeledStatement = labeledStatement;
    generated$7.stringLiteral = stringLiteral;
    generated$7.numericLiteral = numericLiteral;
    generated$7.nullLiteral = nullLiteral;
    generated$7.booleanLiteral = booleanLiteral;
    generated$7.regExpLiteral = regExpLiteral;
    generated$7.logicalExpression = logicalExpression;
    generated$7.memberExpression = memberExpression;
    generated$7.newExpression = newExpression;
    generated$7.program = program;
    generated$7.objectExpression = objectExpression;
    generated$7.objectMethod = objectMethod;
    generated$7.objectProperty = objectProperty;
    generated$7.restElement = restElement;
    generated$7.returnStatement = returnStatement;
    generated$7.sequenceExpression = sequenceExpression;
    generated$7.parenthesizedExpression = parenthesizedExpression;
    generated$7.switchCase = switchCase;
    generated$7.switchStatement = switchStatement;
    generated$7.thisExpression = thisExpression;
    generated$7.throwStatement = throwStatement;
    generated$7.tryStatement = tryStatement;
    generated$7.unaryExpression = unaryExpression;
    generated$7.updateExpression = updateExpression;
    generated$7.variableDeclaration = variableDeclaration;
    generated$7.variableDeclarator = variableDeclarator;
    generated$7.whileStatement = whileStatement;
    generated$7.withStatement = withStatement;
    generated$7.assignmentPattern = assignmentPattern;
    generated$7.arrayPattern = arrayPattern;
    generated$7.arrowFunctionExpression = arrowFunctionExpression;
    generated$7.classBody = classBody;
    generated$7.classExpression = classExpression;
    generated$7.classDeclaration = classDeclaration;
    generated$7.exportAllDeclaration = exportAllDeclaration;
    generated$7.exportDefaultDeclaration = exportDefaultDeclaration;
    generated$7.exportNamedDeclaration = exportNamedDeclaration;
    generated$7.exportSpecifier = exportSpecifier;
    generated$7.forOfStatement = forOfStatement;
    generated$7.importDeclaration = importDeclaration;
    generated$7.importDefaultSpecifier = importDefaultSpecifier;
    generated$7.importNamespaceSpecifier = importNamespaceSpecifier;
    generated$7.importSpecifier = importSpecifier;
    generated$7.metaProperty = metaProperty;
    generated$7.classMethod = classMethod;
    generated$7.objectPattern = objectPattern;
    generated$7.spreadElement = spreadElement;
    generated$7.super = _super;
    generated$7.taggedTemplateExpression = taggedTemplateExpression;
    generated$7.templateElement = templateElement;
    generated$7.templateLiteral = templateLiteral;
    generated$7.yieldExpression = yieldExpression;
    generated$7.awaitExpression = awaitExpression;
    generated$7.import = _import;
    generated$7.bigIntLiteral = bigIntLiteral;
    generated$7.exportNamespaceSpecifier = exportNamespaceSpecifier;
    generated$7.optionalMemberExpression = optionalMemberExpression;
    generated$7.optionalCallExpression = optionalCallExpression;
    generated$7.classProperty = classProperty;
    generated$7.classPrivateProperty = classPrivateProperty;
    generated$7.classPrivateMethod = classPrivateMethod;
    generated$7.privateName = privateName;
    generated$7.anyTypeAnnotation = anyTypeAnnotation;
    generated$7.arrayTypeAnnotation = arrayTypeAnnotation;
    generated$7.booleanTypeAnnotation = booleanTypeAnnotation;
    generated$7.booleanLiteralTypeAnnotation = booleanLiteralTypeAnnotation;
    generated$7.nullLiteralTypeAnnotation = nullLiteralTypeAnnotation;
    generated$7.classImplements = classImplements;
    generated$7.declareClass = declareClass;
    generated$7.declareFunction = declareFunction;
    generated$7.declareInterface = declareInterface;
    generated$7.declareModule = declareModule;
    generated$7.declareModuleExports = declareModuleExports;
    generated$7.declareTypeAlias = declareTypeAlias;
    generated$7.declareOpaqueType = declareOpaqueType;
    generated$7.declareVariable = declareVariable;
    generated$7.declareExportDeclaration = declareExportDeclaration;
    generated$7.declareExportAllDeclaration = declareExportAllDeclaration;
    generated$7.declaredPredicate = declaredPredicate;
    generated$7.existsTypeAnnotation = existsTypeAnnotation;
    generated$7.functionTypeAnnotation = functionTypeAnnotation;
    generated$7.functionTypeParam = functionTypeParam;
    generated$7.genericTypeAnnotation = genericTypeAnnotation;
    generated$7.inferredPredicate = inferredPredicate;
    generated$7.interfaceExtends = interfaceExtends;
    generated$7.interfaceDeclaration = interfaceDeclaration;
    generated$7.interfaceTypeAnnotation = interfaceTypeAnnotation;
    generated$7.intersectionTypeAnnotation = intersectionTypeAnnotation;
    generated$7.mixedTypeAnnotation = mixedTypeAnnotation;
    generated$7.emptyTypeAnnotation = emptyTypeAnnotation;
    generated$7.nullableTypeAnnotation = nullableTypeAnnotation;
    generated$7.numberLiteralTypeAnnotation = numberLiteralTypeAnnotation;
    generated$7.numberTypeAnnotation = numberTypeAnnotation;
    generated$7.objectTypeAnnotation = objectTypeAnnotation;
    generated$7.objectTypeInternalSlot = objectTypeInternalSlot;
    generated$7.objectTypeCallProperty = objectTypeCallProperty;
    generated$7.objectTypeIndexer = objectTypeIndexer;
    generated$7.objectTypeProperty = objectTypeProperty;
    generated$7.objectTypeSpreadProperty = objectTypeSpreadProperty;
    generated$7.opaqueType = opaqueType;
    generated$7.qualifiedTypeIdentifier = qualifiedTypeIdentifier;
    generated$7.stringLiteralTypeAnnotation = stringLiteralTypeAnnotation;
    generated$7.stringTypeAnnotation = stringTypeAnnotation;
    generated$7.symbolTypeAnnotation = symbolTypeAnnotation;
    generated$7.thisTypeAnnotation = thisTypeAnnotation;
    generated$7.tupleTypeAnnotation = tupleTypeAnnotation;
    generated$7.typeofTypeAnnotation = typeofTypeAnnotation;
    generated$7.typeAlias = typeAlias;
    generated$7.typeAnnotation = typeAnnotation;
    generated$7.typeCastExpression = typeCastExpression;
    generated$7.typeParameter = typeParameter;
    generated$7.typeParameterDeclaration = typeParameterDeclaration;
    generated$7.typeParameterInstantiation = typeParameterInstantiation;
    generated$7.unionTypeAnnotation = unionTypeAnnotation;
    generated$7.variance = variance;
    generated$7.voidTypeAnnotation = voidTypeAnnotation;
    generated$7.enumDeclaration = enumDeclaration;
    generated$7.enumBooleanBody = enumBooleanBody;
    generated$7.enumNumberBody = enumNumberBody;
    generated$7.enumStringBody = enumStringBody;
    generated$7.enumSymbolBody = enumSymbolBody;
    generated$7.enumBooleanMember = enumBooleanMember;
    generated$7.enumNumberMember = enumNumberMember;
    generated$7.enumStringMember = enumStringMember;
    generated$7.enumDefaultedMember = enumDefaultedMember;
    generated$7.indexedAccessType = indexedAccessType;
    generated$7.optionalIndexedAccessType = optionalIndexedAccessType;
    generated$7.jSXAttribute = generated$7.jsxAttribute = jsxAttribute;
    generated$7.jSXClosingElement = generated$7.jsxClosingElement = jsxClosingElement;
    generated$7.jSXElement = generated$7.jsxElement = jsxElement;
    generated$7.jSXEmptyExpression = generated$7.jsxEmptyExpression = jsxEmptyExpression;
    generated$7.jSXExpressionContainer = generated$7.jsxExpressionContainer = jsxExpressionContainer;
    generated$7.jSXSpreadChild = generated$7.jsxSpreadChild = jsxSpreadChild;
    generated$7.jSXIdentifier = generated$7.jsxIdentifier = jsxIdentifier;
    generated$7.jSXMemberExpression = generated$7.jsxMemberExpression = jsxMemberExpression;
    generated$7.jSXNamespacedName = generated$7.jsxNamespacedName = jsxNamespacedName;
    generated$7.jSXOpeningElement = generated$7.jsxOpeningElement = jsxOpeningElement;
    generated$7.jSXSpreadAttribute = generated$7.jsxSpreadAttribute = jsxSpreadAttribute;
    generated$7.jSXText = generated$7.jsxText = jsxText;
    generated$7.jSXFragment = generated$7.jsxFragment = jsxFragment;
    generated$7.jSXOpeningFragment = generated$7.jsxOpeningFragment = jsxOpeningFragment;
    generated$7.jSXClosingFragment = generated$7.jsxClosingFragment = jsxClosingFragment;
    generated$7.noop = noop$2;
    generated$7.placeholder = placeholder;
    generated$7.v8IntrinsicIdentifier = v8IntrinsicIdentifier;
    generated$7.argumentPlaceholder = argumentPlaceholder;
    generated$7.bindExpression = bindExpression;
    generated$7.importAttribute = importAttribute;
    generated$7.decorator = decorator;
    generated$7.doExpression = doExpression;
    generated$7.exportDefaultSpecifier = exportDefaultSpecifier;
    generated$7.recordExpression = recordExpression;
    generated$7.tupleExpression = tupleExpression;
    generated$7.decimalLiteral = decimalLiteral;
    generated$7.staticBlock = staticBlock;
    generated$7.moduleExpression = moduleExpression;
    generated$7.topicReference = topicReference;
    generated$7.pipelineTopicExpression = pipelineTopicExpression;
    generated$7.pipelineBareFunction = pipelineBareFunction;
    generated$7.pipelinePrimaryTopicReference = pipelinePrimaryTopicReference;
    generated$7.tSParameterProperty = generated$7.tsParameterProperty = tsParameterProperty;
    generated$7.tSDeclareFunction = generated$7.tsDeclareFunction = tsDeclareFunction;
    generated$7.tSDeclareMethod = generated$7.tsDeclareMethod = tsDeclareMethod;
    generated$7.tSQualifiedName = generated$7.tsQualifiedName = tsQualifiedName;
    generated$7.tSCallSignatureDeclaration = generated$7.tsCallSignatureDeclaration = tsCallSignatureDeclaration;
    generated$7.tSConstructSignatureDeclaration = generated$7.tsConstructSignatureDeclaration = tsConstructSignatureDeclaration;
    generated$7.tSPropertySignature = generated$7.tsPropertySignature = tsPropertySignature;
    generated$7.tSMethodSignature = generated$7.tsMethodSignature = tsMethodSignature;
    generated$7.tSIndexSignature = generated$7.tsIndexSignature = tsIndexSignature;
    generated$7.tSAnyKeyword = generated$7.tsAnyKeyword = tsAnyKeyword;
    generated$7.tSBooleanKeyword = generated$7.tsBooleanKeyword = tsBooleanKeyword;
    generated$7.tSBigIntKeyword = generated$7.tsBigIntKeyword = tsBigIntKeyword;
    generated$7.tSIntrinsicKeyword = generated$7.tsIntrinsicKeyword = tsIntrinsicKeyword;
    generated$7.tSNeverKeyword = generated$7.tsNeverKeyword = tsNeverKeyword;
    generated$7.tSNullKeyword = generated$7.tsNullKeyword = tsNullKeyword;
    generated$7.tSNumberKeyword = generated$7.tsNumberKeyword = tsNumberKeyword;
    generated$7.tSObjectKeyword = generated$7.tsObjectKeyword = tsObjectKeyword;
    generated$7.tSStringKeyword = generated$7.tsStringKeyword = tsStringKeyword;
    generated$7.tSSymbolKeyword = generated$7.tsSymbolKeyword = tsSymbolKeyword;
    generated$7.tSUndefinedKeyword = generated$7.tsUndefinedKeyword = tsUndefinedKeyword;
    generated$7.tSUnknownKeyword = generated$7.tsUnknownKeyword = tsUnknownKeyword;
    generated$7.tSVoidKeyword = generated$7.tsVoidKeyword = tsVoidKeyword;
    generated$7.tSThisType = generated$7.tsThisType = tsThisType;
    generated$7.tSFunctionType = generated$7.tsFunctionType = tsFunctionType;
    generated$7.tSConstructorType = generated$7.tsConstructorType = tsConstructorType;
    generated$7.tSTypeReference = generated$7.tsTypeReference = tsTypeReference;
    generated$7.tSTypePredicate = generated$7.tsTypePredicate = tsTypePredicate;
    generated$7.tSTypeQuery = generated$7.tsTypeQuery = tsTypeQuery;
    generated$7.tSTypeLiteral = generated$7.tsTypeLiteral = tsTypeLiteral;
    generated$7.tSArrayType = generated$7.tsArrayType = tsArrayType;
    generated$7.tSTupleType = generated$7.tsTupleType = tsTupleType;
    generated$7.tSOptionalType = generated$7.tsOptionalType = tsOptionalType;
    generated$7.tSRestType = generated$7.tsRestType = tsRestType;
    generated$7.tSNamedTupleMember = generated$7.tsNamedTupleMember = tsNamedTupleMember;
    generated$7.tSUnionType = generated$7.tsUnionType = tsUnionType;
    generated$7.tSIntersectionType = generated$7.tsIntersectionType = tsIntersectionType;
    generated$7.tSConditionalType = generated$7.tsConditionalType = tsConditionalType;
    generated$7.tSInferType = generated$7.tsInferType = tsInferType;
    generated$7.tSParenthesizedType = generated$7.tsParenthesizedType = tsParenthesizedType;
    generated$7.tSTypeOperator = generated$7.tsTypeOperator = tsTypeOperator;
    generated$7.tSIndexedAccessType = generated$7.tsIndexedAccessType = tsIndexedAccessType;
    generated$7.tSMappedType = generated$7.tsMappedType = tsMappedType;
    generated$7.tSLiteralType = generated$7.tsLiteralType = tsLiteralType;
    generated$7.tSExpressionWithTypeArguments = generated$7.tsExpressionWithTypeArguments = tsExpressionWithTypeArguments;
    generated$7.tSInterfaceDeclaration = generated$7.tsInterfaceDeclaration = tsInterfaceDeclaration;
    generated$7.tSInterfaceBody = generated$7.tsInterfaceBody = tsInterfaceBody;
    generated$7.tSTypeAliasDeclaration = generated$7.tsTypeAliasDeclaration = tsTypeAliasDeclaration;
    generated$7.tSAsExpression = generated$7.tsAsExpression = tsAsExpression;
    generated$7.tSTypeAssertion = generated$7.tsTypeAssertion = tsTypeAssertion;
    generated$7.tSEnumDeclaration = generated$7.tsEnumDeclaration = tsEnumDeclaration;
    generated$7.tSEnumMember = generated$7.tsEnumMember = tsEnumMember;
    generated$7.tSModuleDeclaration = generated$7.tsModuleDeclaration = tsModuleDeclaration;
    generated$7.tSModuleBlock = generated$7.tsModuleBlock = tsModuleBlock;
    generated$7.tSImportType = generated$7.tsImportType = tsImportType;
    generated$7.tSImportEqualsDeclaration = generated$7.tsImportEqualsDeclaration = tsImportEqualsDeclaration;
    generated$7.tSExternalModuleReference = generated$7.tsExternalModuleReference = tsExternalModuleReference;
    generated$7.tSNonNullExpression = generated$7.tsNonNullExpression = tsNonNullExpression;
    generated$7.tSExportAssignment = generated$7.tsExportAssignment = tsExportAssignment;
    generated$7.tSNamespaceExportDeclaration = generated$7.tsNamespaceExportDeclaration = tsNamespaceExportDeclaration;
    generated$7.tSTypeAnnotation = generated$7.tsTypeAnnotation = tsTypeAnnotation;
    generated$7.tSTypeParameterInstantiation = generated$7.tsTypeParameterInstantiation = tsTypeParameterInstantiation;
    generated$7.tSTypeParameterDeclaration = generated$7.tsTypeParameterDeclaration = tsTypeParameterDeclaration;
    generated$7.tSTypeParameter = generated$7.tsTypeParameter = tsTypeParameter;
    generated$7.numberLiteral = NumberLiteral$1;
    generated$7.regexLiteral = RegexLiteral$1;
    generated$7.restProperty = RestProperty$1;
    generated$7.spreadProperty = SpreadProperty$1;

    var _builder$1 = builder$3;

    function arrayExpression(elements) {
      return (0, _builder$1.default)("ArrayExpression", ...arguments);
    }

    function assignmentExpression(operator, left, right) {
      return (0, _builder$1.default)("AssignmentExpression", ...arguments);
    }

    function binaryExpression(operator, left, right) {
      return (0, _builder$1.default)("BinaryExpression", ...arguments);
    }

    function interpreterDirective(value) {
      return (0, _builder$1.default)("InterpreterDirective", ...arguments);
    }

    function directive(value) {
      return (0, _builder$1.default)("Directive", ...arguments);
    }

    function directiveLiteral(value) {
      return (0, _builder$1.default)("DirectiveLiteral", ...arguments);
    }

    function blockStatement(body, directives) {
      return (0, _builder$1.default)("BlockStatement", ...arguments);
    }

    function breakStatement(label) {
      return (0, _builder$1.default)("BreakStatement", ...arguments);
    }

    function callExpression(callee, _arguments) {
      return (0, _builder$1.default)("CallExpression", ...arguments);
    }

    function catchClause(param, body) {
      return (0, _builder$1.default)("CatchClause", ...arguments);
    }

    function conditionalExpression(test, consequent, alternate) {
      return (0, _builder$1.default)("ConditionalExpression", ...arguments);
    }

    function continueStatement(label) {
      return (0, _builder$1.default)("ContinueStatement", ...arguments);
    }

    function debuggerStatement() {
      return (0, _builder$1.default)("DebuggerStatement", ...arguments);
    }

    function doWhileStatement(test, body) {
      return (0, _builder$1.default)("DoWhileStatement", ...arguments);
    }

    function emptyStatement() {
      return (0, _builder$1.default)("EmptyStatement", ...arguments);
    }

    function expressionStatement(expression) {
      return (0, _builder$1.default)("ExpressionStatement", ...arguments);
    }

    function file(program, comments, tokens) {
      return (0, _builder$1.default)("File", ...arguments);
    }

    function forInStatement(left, right, body) {
      return (0, _builder$1.default)("ForInStatement", ...arguments);
    }

    function forStatement(init, test, update, body) {
      return (0, _builder$1.default)("ForStatement", ...arguments);
    }

    function functionDeclaration(id, params, body, generator, async) {
      return (0, _builder$1.default)("FunctionDeclaration", ...arguments);
    }

    function functionExpression(id, params, body, generator, async) {
      return (0, _builder$1.default)("FunctionExpression", ...arguments);
    }

    function identifier$1(name) {
      return (0, _builder$1.default)("Identifier", ...arguments);
    }

    function ifStatement(test, consequent, alternate) {
      return (0, _builder$1.default)("IfStatement", ...arguments);
    }

    function labeledStatement(label, body) {
      return (0, _builder$1.default)("LabeledStatement", ...arguments);
    }

    function stringLiteral(value) {
      return (0, _builder$1.default)("StringLiteral", ...arguments);
    }

    function numericLiteral(value) {
      return (0, _builder$1.default)("NumericLiteral", ...arguments);
    }

    function nullLiteral() {
      return (0, _builder$1.default)("NullLiteral", ...arguments);
    }

    function booleanLiteral(value) {
      return (0, _builder$1.default)("BooleanLiteral", ...arguments);
    }

    function regExpLiteral(pattern, flags) {
      return (0, _builder$1.default)("RegExpLiteral", ...arguments);
    }

    function logicalExpression(operator, left, right) {
      return (0, _builder$1.default)("LogicalExpression", ...arguments);
    }

    function memberExpression(object, property, computed, optional) {
      return (0, _builder$1.default)("MemberExpression", ...arguments);
    }

    function newExpression(callee, _arguments) {
      return (0, _builder$1.default)("NewExpression", ...arguments);
    }

    function program(body, directives, sourceType, interpreter) {
      return (0, _builder$1.default)("Program", ...arguments);
    }

    function objectExpression(properties) {
      return (0, _builder$1.default)("ObjectExpression", ...arguments);
    }

    function objectMethod(kind, key, params, body, computed, generator, async) {
      return (0, _builder$1.default)("ObjectMethod", ...arguments);
    }

    function objectProperty(key, value, computed, shorthand, decorators) {
      return (0, _builder$1.default)("ObjectProperty", ...arguments);
    }

    function restElement(argument) {
      return (0, _builder$1.default)("RestElement", ...arguments);
    }

    function returnStatement(argument) {
      return (0, _builder$1.default)("ReturnStatement", ...arguments);
    }

    function sequenceExpression(expressions) {
      return (0, _builder$1.default)("SequenceExpression", ...arguments);
    }

    function parenthesizedExpression(expression) {
      return (0, _builder$1.default)("ParenthesizedExpression", ...arguments);
    }

    function switchCase(test, consequent) {
      return (0, _builder$1.default)("SwitchCase", ...arguments);
    }

    function switchStatement(discriminant, cases) {
      return (0, _builder$1.default)("SwitchStatement", ...arguments);
    }

    function thisExpression() {
      return (0, _builder$1.default)("ThisExpression", ...arguments);
    }

    function throwStatement(argument) {
      return (0, _builder$1.default)("ThrowStatement", ...arguments);
    }

    function tryStatement(block, handler, finalizer) {
      return (0, _builder$1.default)("TryStatement", ...arguments);
    }

    function unaryExpression(operator, argument, prefix) {
      return (0, _builder$1.default)("UnaryExpression", ...arguments);
    }

    function updateExpression(operator, argument, prefix) {
      return (0, _builder$1.default)("UpdateExpression", ...arguments);
    }

    function variableDeclaration(kind, declarations) {
      return (0, _builder$1.default)("VariableDeclaration", ...arguments);
    }

    function variableDeclarator(id, init) {
      return (0, _builder$1.default)("VariableDeclarator", ...arguments);
    }

    function whileStatement(test, body) {
      return (0, _builder$1.default)("WhileStatement", ...arguments);
    }

    function withStatement(object, body) {
      return (0, _builder$1.default)("WithStatement", ...arguments);
    }

    function assignmentPattern(left, right) {
      return (0, _builder$1.default)("AssignmentPattern", ...arguments);
    }

    function arrayPattern(elements) {
      return (0, _builder$1.default)("ArrayPattern", ...arguments);
    }

    function arrowFunctionExpression(params, body, async) {
      return (0, _builder$1.default)("ArrowFunctionExpression", ...arguments);
    }

    function classBody(body) {
      return (0, _builder$1.default)("ClassBody", ...arguments);
    }

    function classExpression(id, superClass, body, decorators) {
      return (0, _builder$1.default)("ClassExpression", ...arguments);
    }

    function classDeclaration(id, superClass, body, decorators) {
      return (0, _builder$1.default)("ClassDeclaration", ...arguments);
    }

    function exportAllDeclaration(source) {
      return (0, _builder$1.default)("ExportAllDeclaration", ...arguments);
    }

    function exportDefaultDeclaration(declaration) {
      return (0, _builder$1.default)("ExportDefaultDeclaration", ...arguments);
    }

    function exportNamedDeclaration(declaration, specifiers, source) {
      return (0, _builder$1.default)("ExportNamedDeclaration", ...arguments);
    }

    function exportSpecifier(local, exported) {
      return (0, _builder$1.default)("ExportSpecifier", ...arguments);
    }

    function forOfStatement(left, right, body, _await) {
      return (0, _builder$1.default)("ForOfStatement", ...arguments);
    }

    function importDeclaration(specifiers, source) {
      return (0, _builder$1.default)("ImportDeclaration", ...arguments);
    }

    function importDefaultSpecifier(local) {
      return (0, _builder$1.default)("ImportDefaultSpecifier", ...arguments);
    }

    function importNamespaceSpecifier(local) {
      return (0, _builder$1.default)("ImportNamespaceSpecifier", ...arguments);
    }

    function importSpecifier(local, imported) {
      return (0, _builder$1.default)("ImportSpecifier", ...arguments);
    }

    function metaProperty(meta, property) {
      return (0, _builder$1.default)("MetaProperty", ...arguments);
    }

    function classMethod(kind, key, params, body, computed, _static, generator, async) {
      return (0, _builder$1.default)("ClassMethod", ...arguments);
    }

    function objectPattern(properties) {
      return (0, _builder$1.default)("ObjectPattern", ...arguments);
    }

    function spreadElement(argument) {
      return (0, _builder$1.default)("SpreadElement", ...arguments);
    }

    function _super() {
      return (0, _builder$1.default)("Super", ...arguments);
    }

    function taggedTemplateExpression(tag, quasi) {
      return (0, _builder$1.default)("TaggedTemplateExpression", ...arguments);
    }

    function templateElement(value, tail) {
      return (0, _builder$1.default)("TemplateElement", ...arguments);
    }

    function templateLiteral(quasis, expressions) {
      return (0, _builder$1.default)("TemplateLiteral", ...arguments);
    }

    function yieldExpression(argument, delegate) {
      return (0, _builder$1.default)("YieldExpression", ...arguments);
    }

    function awaitExpression(argument) {
      return (0, _builder$1.default)("AwaitExpression", ...arguments);
    }

    function _import() {
      return (0, _builder$1.default)("Import", ...arguments);
    }

    function bigIntLiteral(value) {
      return (0, _builder$1.default)("BigIntLiteral", ...arguments);
    }

    function exportNamespaceSpecifier(exported) {
      return (0, _builder$1.default)("ExportNamespaceSpecifier", ...arguments);
    }

    function optionalMemberExpression(object, property, computed, optional) {
      return (0, _builder$1.default)("OptionalMemberExpression", ...arguments);
    }

    function optionalCallExpression(callee, _arguments, optional) {
      return (0, _builder$1.default)("OptionalCallExpression", ...arguments);
    }

    function classProperty(key, value, typeAnnotation, decorators, computed, _static) {
      return (0, _builder$1.default)("ClassProperty", ...arguments);
    }

    function classPrivateProperty(key, value, decorators, _static) {
      return (0, _builder$1.default)("ClassPrivateProperty", ...arguments);
    }

    function classPrivateMethod(kind, key, params, body, _static) {
      return (0, _builder$1.default)("ClassPrivateMethod", ...arguments);
    }

    function privateName(id) {
      return (0, _builder$1.default)("PrivateName", ...arguments);
    }

    function anyTypeAnnotation() {
      return (0, _builder$1.default)("AnyTypeAnnotation", ...arguments);
    }

    function arrayTypeAnnotation(elementType) {
      return (0, _builder$1.default)("ArrayTypeAnnotation", ...arguments);
    }

    function booleanTypeAnnotation() {
      return (0, _builder$1.default)("BooleanTypeAnnotation", ...arguments);
    }

    function booleanLiteralTypeAnnotation(value) {
      return (0, _builder$1.default)("BooleanLiteralTypeAnnotation", ...arguments);
    }

    function nullLiteralTypeAnnotation() {
      return (0, _builder$1.default)("NullLiteralTypeAnnotation", ...arguments);
    }

    function classImplements(id, typeParameters) {
      return (0, _builder$1.default)("ClassImplements", ...arguments);
    }

    function declareClass(id, typeParameters, _extends, body) {
      return (0, _builder$1.default)("DeclareClass", ...arguments);
    }

    function declareFunction(id) {
      return (0, _builder$1.default)("DeclareFunction", ...arguments);
    }

    function declareInterface(id, typeParameters, _extends, body) {
      return (0, _builder$1.default)("DeclareInterface", ...arguments);
    }

    function declareModule(id, body, kind) {
      return (0, _builder$1.default)("DeclareModule", ...arguments);
    }

    function declareModuleExports(typeAnnotation) {
      return (0, _builder$1.default)("DeclareModuleExports", ...arguments);
    }

    function declareTypeAlias(id, typeParameters, right) {
      return (0, _builder$1.default)("DeclareTypeAlias", ...arguments);
    }

    function declareOpaqueType(id, typeParameters, supertype) {
      return (0, _builder$1.default)("DeclareOpaqueType", ...arguments);
    }

    function declareVariable(id) {
      return (0, _builder$1.default)("DeclareVariable", ...arguments);
    }

    function declareExportDeclaration(declaration, specifiers, source) {
      return (0, _builder$1.default)("DeclareExportDeclaration", ...arguments);
    }

    function declareExportAllDeclaration(source) {
      return (0, _builder$1.default)("DeclareExportAllDeclaration", ...arguments);
    }

    function declaredPredicate(value) {
      return (0, _builder$1.default)("DeclaredPredicate", ...arguments);
    }

    function existsTypeAnnotation() {
      return (0, _builder$1.default)("ExistsTypeAnnotation", ...arguments);
    }

    function functionTypeAnnotation(typeParameters, params, rest, returnType) {
      return (0, _builder$1.default)("FunctionTypeAnnotation", ...arguments);
    }

    function functionTypeParam(name, typeAnnotation) {
      return (0, _builder$1.default)("FunctionTypeParam", ...arguments);
    }

    function genericTypeAnnotation(id, typeParameters) {
      return (0, _builder$1.default)("GenericTypeAnnotation", ...arguments);
    }

    function inferredPredicate() {
      return (0, _builder$1.default)("InferredPredicate", ...arguments);
    }

    function interfaceExtends(id, typeParameters) {
      return (0, _builder$1.default)("InterfaceExtends", ...arguments);
    }

    function interfaceDeclaration(id, typeParameters, _extends, body) {
      return (0, _builder$1.default)("InterfaceDeclaration", ...arguments);
    }

    function interfaceTypeAnnotation(_extends, body) {
      return (0, _builder$1.default)("InterfaceTypeAnnotation", ...arguments);
    }

    function intersectionTypeAnnotation(types) {
      return (0, _builder$1.default)("IntersectionTypeAnnotation", ...arguments);
    }

    function mixedTypeAnnotation() {
      return (0, _builder$1.default)("MixedTypeAnnotation", ...arguments);
    }

    function emptyTypeAnnotation() {
      return (0, _builder$1.default)("EmptyTypeAnnotation", ...arguments);
    }

    function nullableTypeAnnotation(typeAnnotation) {
      return (0, _builder$1.default)("NullableTypeAnnotation", ...arguments);
    }

    function numberLiteralTypeAnnotation(value) {
      return (0, _builder$1.default)("NumberLiteralTypeAnnotation", ...arguments);
    }

    function numberTypeAnnotation() {
      return (0, _builder$1.default)("NumberTypeAnnotation", ...arguments);
    }

    function objectTypeAnnotation(properties, indexers, callProperties, internalSlots, exact) {
      return (0, _builder$1.default)("ObjectTypeAnnotation", ...arguments);
    }

    function objectTypeInternalSlot(id, value, optional, _static, method) {
      return (0, _builder$1.default)("ObjectTypeInternalSlot", ...arguments);
    }

    function objectTypeCallProperty(value) {
      return (0, _builder$1.default)("ObjectTypeCallProperty", ...arguments);
    }

    function objectTypeIndexer(id, key, value, variance) {
      return (0, _builder$1.default)("ObjectTypeIndexer", ...arguments);
    }

    function objectTypeProperty(key, value, variance) {
      return (0, _builder$1.default)("ObjectTypeProperty", ...arguments);
    }

    function objectTypeSpreadProperty(argument) {
      return (0, _builder$1.default)("ObjectTypeSpreadProperty", ...arguments);
    }

    function opaqueType(id, typeParameters, supertype, impltype) {
      return (0, _builder$1.default)("OpaqueType", ...arguments);
    }

    function qualifiedTypeIdentifier(id, qualification) {
      return (0, _builder$1.default)("QualifiedTypeIdentifier", ...arguments);
    }

    function stringLiteralTypeAnnotation(value) {
      return (0, _builder$1.default)("StringLiteralTypeAnnotation", ...arguments);
    }

    function stringTypeAnnotation() {
      return (0, _builder$1.default)("StringTypeAnnotation", ...arguments);
    }

    function symbolTypeAnnotation() {
      return (0, _builder$1.default)("SymbolTypeAnnotation", ...arguments);
    }

    function thisTypeAnnotation() {
      return (0, _builder$1.default)("ThisTypeAnnotation", ...arguments);
    }

    function tupleTypeAnnotation(types) {
      return (0, _builder$1.default)("TupleTypeAnnotation", ...arguments);
    }

    function typeofTypeAnnotation(argument) {
      return (0, _builder$1.default)("TypeofTypeAnnotation", ...arguments);
    }

    function typeAlias(id, typeParameters, right) {
      return (0, _builder$1.default)("TypeAlias", ...arguments);
    }

    function typeAnnotation(typeAnnotation) {
      return (0, _builder$1.default)("TypeAnnotation", ...arguments);
    }

    function typeCastExpression(expression, typeAnnotation) {
      return (0, _builder$1.default)("TypeCastExpression", ...arguments);
    }

    function typeParameter(bound, _default, variance) {
      return (0, _builder$1.default)("TypeParameter", ...arguments);
    }

    function typeParameterDeclaration(params) {
      return (0, _builder$1.default)("TypeParameterDeclaration", ...arguments);
    }

    function typeParameterInstantiation(params) {
      return (0, _builder$1.default)("TypeParameterInstantiation", ...arguments);
    }

    function unionTypeAnnotation(types) {
      return (0, _builder$1.default)("UnionTypeAnnotation", ...arguments);
    }

    function variance(kind) {
      return (0, _builder$1.default)("Variance", ...arguments);
    }

    function voidTypeAnnotation() {
      return (0, _builder$1.default)("VoidTypeAnnotation", ...arguments);
    }

    function enumDeclaration(id, body) {
      return (0, _builder$1.default)("EnumDeclaration", ...arguments);
    }

    function enumBooleanBody(members) {
      return (0, _builder$1.default)("EnumBooleanBody", ...arguments);
    }

    function enumNumberBody(members) {
      return (0, _builder$1.default)("EnumNumberBody", ...arguments);
    }

    function enumStringBody(members) {
      return (0, _builder$1.default)("EnumStringBody", ...arguments);
    }

    function enumSymbolBody(members) {
      return (0, _builder$1.default)("EnumSymbolBody", ...arguments);
    }

    function enumBooleanMember(id) {
      return (0, _builder$1.default)("EnumBooleanMember", ...arguments);
    }

    function enumNumberMember(id, init) {
      return (0, _builder$1.default)("EnumNumberMember", ...arguments);
    }

    function enumStringMember(id, init) {
      return (0, _builder$1.default)("EnumStringMember", ...arguments);
    }

    function enumDefaultedMember(id) {
      return (0, _builder$1.default)("EnumDefaultedMember", ...arguments);
    }

    function indexedAccessType(objectType, indexType) {
      return (0, _builder$1.default)("IndexedAccessType", ...arguments);
    }

    function optionalIndexedAccessType(objectType, indexType) {
      return (0, _builder$1.default)("OptionalIndexedAccessType", ...arguments);
    }

    function jsxAttribute(name, value) {
      return (0, _builder$1.default)("JSXAttribute", ...arguments);
    }

    function jsxClosingElement(name) {
      return (0, _builder$1.default)("JSXClosingElement", ...arguments);
    }

    function jsxElement(openingElement, closingElement, children, selfClosing) {
      return (0, _builder$1.default)("JSXElement", ...arguments);
    }

    function jsxEmptyExpression() {
      return (0, _builder$1.default)("JSXEmptyExpression", ...arguments);
    }

    function jsxExpressionContainer(expression) {
      return (0, _builder$1.default)("JSXExpressionContainer", ...arguments);
    }

    function jsxSpreadChild(expression) {
      return (0, _builder$1.default)("JSXSpreadChild", ...arguments);
    }

    function jsxIdentifier(name) {
      return (0, _builder$1.default)("JSXIdentifier", ...arguments);
    }

    function jsxMemberExpression(object, property) {
      return (0, _builder$1.default)("JSXMemberExpression", ...arguments);
    }

    function jsxNamespacedName(namespace, name) {
      return (0, _builder$1.default)("JSXNamespacedName", ...arguments);
    }

    function jsxOpeningElement(name, attributes, selfClosing) {
      return (0, _builder$1.default)("JSXOpeningElement", ...arguments);
    }

    function jsxSpreadAttribute(argument) {
      return (0, _builder$1.default)("JSXSpreadAttribute", ...arguments);
    }

    function jsxText(value) {
      return (0, _builder$1.default)("JSXText", ...arguments);
    }

    function jsxFragment(openingFragment, closingFragment, children) {
      return (0, _builder$1.default)("JSXFragment", ...arguments);
    }

    function jsxOpeningFragment() {
      return (0, _builder$1.default)("JSXOpeningFragment", ...arguments);
    }

    function jsxClosingFragment() {
      return (0, _builder$1.default)("JSXClosingFragment", ...arguments);
    }

    function noop$2() {
      return (0, _builder$1.default)("Noop", ...arguments);
    }

    function placeholder(expectedNode, name) {
      return (0, _builder$1.default)("Placeholder", ...arguments);
    }

    function v8IntrinsicIdentifier(name) {
      return (0, _builder$1.default)("V8IntrinsicIdentifier", ...arguments);
    }

    function argumentPlaceholder() {
      return (0, _builder$1.default)("ArgumentPlaceholder", ...arguments);
    }

    function bindExpression(object, callee) {
      return (0, _builder$1.default)("BindExpression", ...arguments);
    }

    function importAttribute(key, value) {
      return (0, _builder$1.default)("ImportAttribute", ...arguments);
    }

    function decorator(expression) {
      return (0, _builder$1.default)("Decorator", ...arguments);
    }

    function doExpression(body, async) {
      return (0, _builder$1.default)("DoExpression", ...arguments);
    }

    function exportDefaultSpecifier(exported) {
      return (0, _builder$1.default)("ExportDefaultSpecifier", ...arguments);
    }

    function recordExpression(properties) {
      return (0, _builder$1.default)("RecordExpression", ...arguments);
    }

    function tupleExpression(elements) {
      return (0, _builder$1.default)("TupleExpression", ...arguments);
    }

    function decimalLiteral(value) {
      return (0, _builder$1.default)("DecimalLiteral", ...arguments);
    }

    function staticBlock(body) {
      return (0, _builder$1.default)("StaticBlock", ...arguments);
    }

    function moduleExpression(body) {
      return (0, _builder$1.default)("ModuleExpression", ...arguments);
    }

    function topicReference() {
      return (0, _builder$1.default)("TopicReference", ...arguments);
    }

    function pipelineTopicExpression(expression) {
      return (0, _builder$1.default)("PipelineTopicExpression", ...arguments);
    }

    function pipelineBareFunction(callee) {
      return (0, _builder$1.default)("PipelineBareFunction", ...arguments);
    }

    function pipelinePrimaryTopicReference() {
      return (0, _builder$1.default)("PipelinePrimaryTopicReference", ...arguments);
    }

    function tsParameterProperty(parameter) {
      return (0, _builder$1.default)("TSParameterProperty", ...arguments);
    }

    function tsDeclareFunction(id, typeParameters, params, returnType) {
      return (0, _builder$1.default)("TSDeclareFunction", ...arguments);
    }

    function tsDeclareMethod(decorators, key, typeParameters, params, returnType) {
      return (0, _builder$1.default)("TSDeclareMethod", ...arguments);
    }

    function tsQualifiedName(left, right) {
      return (0, _builder$1.default)("TSQualifiedName", ...arguments);
    }

    function tsCallSignatureDeclaration(typeParameters, parameters, typeAnnotation) {
      return (0, _builder$1.default)("TSCallSignatureDeclaration", ...arguments);
    }

    function tsConstructSignatureDeclaration(typeParameters, parameters, typeAnnotation) {
      return (0, _builder$1.default)("TSConstructSignatureDeclaration", ...arguments);
    }

    function tsPropertySignature(key, typeAnnotation, initializer) {
      return (0, _builder$1.default)("TSPropertySignature", ...arguments);
    }

    function tsMethodSignature(key, typeParameters, parameters, typeAnnotation) {
      return (0, _builder$1.default)("TSMethodSignature", ...arguments);
    }

    function tsIndexSignature(parameters, typeAnnotation) {
      return (0, _builder$1.default)("TSIndexSignature", ...arguments);
    }

    function tsAnyKeyword() {
      return (0, _builder$1.default)("TSAnyKeyword", ...arguments);
    }

    function tsBooleanKeyword() {
      return (0, _builder$1.default)("TSBooleanKeyword", ...arguments);
    }

    function tsBigIntKeyword() {
      return (0, _builder$1.default)("TSBigIntKeyword", ...arguments);
    }

    function tsIntrinsicKeyword() {
      return (0, _builder$1.default)("TSIntrinsicKeyword", ...arguments);
    }

    function tsNeverKeyword() {
      return (0, _builder$1.default)("TSNeverKeyword", ...arguments);
    }

    function tsNullKeyword() {
      return (0, _builder$1.default)("TSNullKeyword", ...arguments);
    }

    function tsNumberKeyword() {
      return (0, _builder$1.default)("TSNumberKeyword", ...arguments);
    }

    function tsObjectKeyword() {
      return (0, _builder$1.default)("TSObjectKeyword", ...arguments);
    }

    function tsStringKeyword() {
      return (0, _builder$1.default)("TSStringKeyword", ...arguments);
    }

    function tsSymbolKeyword() {
      return (0, _builder$1.default)("TSSymbolKeyword", ...arguments);
    }

    function tsUndefinedKeyword() {
      return (0, _builder$1.default)("TSUndefinedKeyword", ...arguments);
    }

    function tsUnknownKeyword() {
      return (0, _builder$1.default)("TSUnknownKeyword", ...arguments);
    }

    function tsVoidKeyword() {
      return (0, _builder$1.default)("TSVoidKeyword", ...arguments);
    }

    function tsThisType() {
      return (0, _builder$1.default)("TSThisType", ...arguments);
    }

    function tsFunctionType(typeParameters, parameters, typeAnnotation) {
      return (0, _builder$1.default)("TSFunctionType", ...arguments);
    }

    function tsConstructorType(typeParameters, parameters, typeAnnotation) {
      return (0, _builder$1.default)("TSConstructorType", ...arguments);
    }

    function tsTypeReference(typeName, typeParameters) {
      return (0, _builder$1.default)("TSTypeReference", ...arguments);
    }

    function tsTypePredicate(parameterName, typeAnnotation, asserts) {
      return (0, _builder$1.default)("TSTypePredicate", ...arguments);
    }

    function tsTypeQuery(exprName) {
      return (0, _builder$1.default)("TSTypeQuery", ...arguments);
    }

    function tsTypeLiteral(members) {
      return (0, _builder$1.default)("TSTypeLiteral", ...arguments);
    }

    function tsArrayType(elementType) {
      return (0, _builder$1.default)("TSArrayType", ...arguments);
    }

    function tsTupleType(elementTypes) {
      return (0, _builder$1.default)("TSTupleType", ...arguments);
    }

    function tsOptionalType(typeAnnotation) {
      return (0, _builder$1.default)("TSOptionalType", ...arguments);
    }

    function tsRestType(typeAnnotation) {
      return (0, _builder$1.default)("TSRestType", ...arguments);
    }

    function tsNamedTupleMember(label, elementType, optional) {
      return (0, _builder$1.default)("TSNamedTupleMember", ...arguments);
    }

    function tsUnionType(types) {
      return (0, _builder$1.default)("TSUnionType", ...arguments);
    }

    function tsIntersectionType(types) {
      return (0, _builder$1.default)("TSIntersectionType", ...arguments);
    }

    function tsConditionalType(checkType, extendsType, trueType, falseType) {
      return (0, _builder$1.default)("TSConditionalType", ...arguments);
    }

    function tsInferType(typeParameter) {
      return (0, _builder$1.default)("TSInferType", ...arguments);
    }

    function tsParenthesizedType(typeAnnotation) {
      return (0, _builder$1.default)("TSParenthesizedType", ...arguments);
    }

    function tsTypeOperator(typeAnnotation) {
      return (0, _builder$1.default)("TSTypeOperator", ...arguments);
    }

    function tsIndexedAccessType(objectType, indexType) {
      return (0, _builder$1.default)("TSIndexedAccessType", ...arguments);
    }

    function tsMappedType(typeParameter, typeAnnotation, nameType) {
      return (0, _builder$1.default)("TSMappedType", ...arguments);
    }

    function tsLiteralType(literal) {
      return (0, _builder$1.default)("TSLiteralType", ...arguments);
    }

    function tsExpressionWithTypeArguments(expression, typeParameters) {
      return (0, _builder$1.default)("TSExpressionWithTypeArguments", ...arguments);
    }

    function tsInterfaceDeclaration(id, typeParameters, _extends, body) {
      return (0, _builder$1.default)("TSInterfaceDeclaration", ...arguments);
    }

    function tsInterfaceBody(body) {
      return (0, _builder$1.default)("TSInterfaceBody", ...arguments);
    }

    function tsTypeAliasDeclaration(id, typeParameters, typeAnnotation) {
      return (0, _builder$1.default)("TSTypeAliasDeclaration", ...arguments);
    }

    function tsAsExpression(expression, typeAnnotation) {
      return (0, _builder$1.default)("TSAsExpression", ...arguments);
    }

    function tsTypeAssertion(typeAnnotation, expression) {
      return (0, _builder$1.default)("TSTypeAssertion", ...arguments);
    }

    function tsEnumDeclaration(id, members) {
      return (0, _builder$1.default)("TSEnumDeclaration", ...arguments);
    }

    function tsEnumMember(id, initializer) {
      return (0, _builder$1.default)("TSEnumMember", ...arguments);
    }

    function tsModuleDeclaration(id, body) {
      return (0, _builder$1.default)("TSModuleDeclaration", ...arguments);
    }

    function tsModuleBlock(body) {
      return (0, _builder$1.default)("TSModuleBlock", ...arguments);
    }

    function tsImportType(argument, qualifier, typeParameters) {
      return (0, _builder$1.default)("TSImportType", ...arguments);
    }

    function tsImportEqualsDeclaration(id, moduleReference) {
      return (0, _builder$1.default)("TSImportEqualsDeclaration", ...arguments);
    }

    function tsExternalModuleReference(expression) {
      return (0, _builder$1.default)("TSExternalModuleReference", ...arguments);
    }

    function tsNonNullExpression(expression) {
      return (0, _builder$1.default)("TSNonNullExpression", ...arguments);
    }

    function tsExportAssignment(expression) {
      return (0, _builder$1.default)("TSExportAssignment", ...arguments);
    }

    function tsNamespaceExportDeclaration(id) {
      return (0, _builder$1.default)("TSNamespaceExportDeclaration", ...arguments);
    }

    function tsTypeAnnotation(typeAnnotation) {
      return (0, _builder$1.default)("TSTypeAnnotation", ...arguments);
    }

    function tsTypeParameterInstantiation(params) {
      return (0, _builder$1.default)("TSTypeParameterInstantiation", ...arguments);
    }

    function tsTypeParameterDeclaration(params) {
      return (0, _builder$1.default)("TSTypeParameterDeclaration", ...arguments);
    }

    function tsTypeParameter(constraint, _default, name) {
      return (0, _builder$1.default)("TSTypeParameter", ...arguments);
    }

    function NumberLiteral$1(...args) {
      console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
      return (0, _builder$1.default)("NumberLiteral", ...args);
    }

    function RegexLiteral$1(...args) {
      console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
      return (0, _builder$1.default)("RegexLiteral", ...args);
    }

    function RestProperty$1(...args) {
      console.trace("The node type RestProperty has been renamed to RestElement");
      return (0, _builder$1.default)("RestProperty", ...args);
    }

    function SpreadProperty$1(...args) {
      console.trace("The node type SpreadProperty has been renamed to SpreadElement");
      return (0, _builder$1.default)("SpreadProperty", ...args);
    }

    Object.defineProperty(cleanJSXElementLiteralChild$3, "__esModule", {
      value: true
    });
    cleanJSXElementLiteralChild$3.default = cleanJSXElementLiteralChild$2;

    var _generated$L = generated$7;

    function cleanJSXElementLiteralChild$2(child, args) {
      const lines = child.value.split(/\r\n|\n|\r/);
      let lastNonEmptyLine = 0;

      for (let i = 0; i < lines.length; i++) {
        if (lines[i].match(/[^ \t]/)) {
          lastNonEmptyLine = i;
        }
      }

      let str = "";

      for (let i = 0; i < lines.length; i++) {
        const line = lines[i];
        const isFirstLine = i === 0;
        const isLastLine = i === lines.length - 1;
        const isLastNonEmptyLine = i === lastNonEmptyLine;
        let trimmedLine = line.replace(/\t/g, " ");

        if (!isFirstLine) {
          trimmedLine = trimmedLine.replace(/^[ ]+/, "");
        }

        if (!isLastLine) {
          trimmedLine = trimmedLine.replace(/[ ]+$/, "");
        }

        if (trimmedLine) {
          if (!isLastNonEmptyLine) {
            trimmedLine += " ";
          }

          str += trimmedLine;
        }
      }

      if (str) args.push((0, _generated$L.stringLiteral)(str));
    }

    Object.defineProperty(buildChildren$3, "__esModule", {
      value: true
    });
    buildChildren$3.default = buildChildren$2;

    var _generated$K = generated$8;

    var _cleanJSXElementLiteralChild$1 = cleanJSXElementLiteralChild$3;

    function buildChildren$2(node) {
      const elements = [];

      for (let i = 0; i < node.children.length; i++) {
        let child = node.children[i];

        if ((0, _generated$K.isJSXText)(child)) {
          (0, _cleanJSXElementLiteralChild$1.default)(child, elements);
          continue;
        }

        if ((0, _generated$K.isJSXExpressionContainer)(child)) child = child.expression;
        if ((0, _generated$K.isJSXEmptyExpression)(child)) continue;
        elements.push(child);
      }

      return elements;
    }

    var assertNode$3 = {};

    var isNode$4 = {};

    Object.defineProperty(isNode$4, "__esModule", {
      value: true
    });
    isNode$4.default = isNode$3;

    var _definitions$c = requireDefinitions$1();

    function isNode$3(node) {
      return !!(node && _definitions$c.VISITOR_KEYS[node.type]);
    }

    Object.defineProperty(assertNode$3, "__esModule", {
      value: true
    });
    assertNode$3.default = assertNode$2;

    var _isNode$1 = isNode$4;

    function assertNode$2(node) {
      if (!(0, _isNode$1.default)(node)) {
        var _node$type;

        const type = (_node$type = node == null ? void 0 : node.type) != null ? _node$type : JSON.stringify(node);
        throw new TypeError(`Not a valid node of type "${type}"`);
      }
    }

    var generated$6 = {};

    Object.defineProperty(generated$6, "__esModule", {
      value: true
    });
    generated$6.assertArrayExpression = assertArrayExpression$1;
    generated$6.assertAssignmentExpression = assertAssignmentExpression$1;
    generated$6.assertBinaryExpression = assertBinaryExpression$1;
    generated$6.assertInterpreterDirective = assertInterpreterDirective$1;
    generated$6.assertDirective = assertDirective$1;
    generated$6.assertDirectiveLiteral = assertDirectiveLiteral$1;
    generated$6.assertBlockStatement = assertBlockStatement$1;
    generated$6.assertBreakStatement = assertBreakStatement$1;
    generated$6.assertCallExpression = assertCallExpression$1;
    generated$6.assertCatchClause = assertCatchClause$1;
    generated$6.assertConditionalExpression = assertConditionalExpression$1;
    generated$6.assertContinueStatement = assertContinueStatement$1;
    generated$6.assertDebuggerStatement = assertDebuggerStatement$1;
    generated$6.assertDoWhileStatement = assertDoWhileStatement$1;
    generated$6.assertEmptyStatement = assertEmptyStatement$1;
    generated$6.assertExpressionStatement = assertExpressionStatement$1;
    generated$6.assertFile = assertFile$1;
    generated$6.assertForInStatement = assertForInStatement$1;
    generated$6.assertForStatement = assertForStatement$1;
    generated$6.assertFunctionDeclaration = assertFunctionDeclaration$1;
    generated$6.assertFunctionExpression = assertFunctionExpression$1;
    generated$6.assertIdentifier = assertIdentifier$1;
    generated$6.assertIfStatement = assertIfStatement$1;
    generated$6.assertLabeledStatement = assertLabeledStatement$1;
    generated$6.assertStringLiteral = assertStringLiteral$1;
    generated$6.assertNumericLiteral = assertNumericLiteral$1;
    generated$6.assertNullLiteral = assertNullLiteral$1;
    generated$6.assertBooleanLiteral = assertBooleanLiteral$1;
    generated$6.assertRegExpLiteral = assertRegExpLiteral$1;
    generated$6.assertLogicalExpression = assertLogicalExpression$1;
    generated$6.assertMemberExpression = assertMemberExpression$1;
    generated$6.assertNewExpression = assertNewExpression$1;
    generated$6.assertProgram = assertProgram$1;
    generated$6.assertObjectExpression = assertObjectExpression$1;
    generated$6.assertObjectMethod = assertObjectMethod$1;
    generated$6.assertObjectProperty = assertObjectProperty$1;
    generated$6.assertRestElement = assertRestElement$1;
    generated$6.assertReturnStatement = assertReturnStatement$1;
    generated$6.assertSequenceExpression = assertSequenceExpression$1;
    generated$6.assertParenthesizedExpression = assertParenthesizedExpression$1;
    generated$6.assertSwitchCase = assertSwitchCase$1;
    generated$6.assertSwitchStatement = assertSwitchStatement$1;
    generated$6.assertThisExpression = assertThisExpression$1;
    generated$6.assertThrowStatement = assertThrowStatement$1;
    generated$6.assertTryStatement = assertTryStatement$1;
    generated$6.assertUnaryExpression = assertUnaryExpression$1;
    generated$6.assertUpdateExpression = assertUpdateExpression$1;
    generated$6.assertVariableDeclaration = assertVariableDeclaration$1;
    generated$6.assertVariableDeclarator = assertVariableDeclarator$1;
    generated$6.assertWhileStatement = assertWhileStatement$1;
    generated$6.assertWithStatement = assertWithStatement$1;
    generated$6.assertAssignmentPattern = assertAssignmentPattern$1;
    generated$6.assertArrayPattern = assertArrayPattern$1;
    generated$6.assertArrowFunctionExpression = assertArrowFunctionExpression$1;
    generated$6.assertClassBody = assertClassBody$1;
    generated$6.assertClassExpression = assertClassExpression$1;
    generated$6.assertClassDeclaration = assertClassDeclaration$1;
    generated$6.assertExportAllDeclaration = assertExportAllDeclaration$1;
    generated$6.assertExportDefaultDeclaration = assertExportDefaultDeclaration$1;
    generated$6.assertExportNamedDeclaration = assertExportNamedDeclaration$1;
    generated$6.assertExportSpecifier = assertExportSpecifier$1;
    generated$6.assertForOfStatement = assertForOfStatement$1;
    generated$6.assertImportDeclaration = assertImportDeclaration$1;
    generated$6.assertImportDefaultSpecifier = assertImportDefaultSpecifier$1;
    generated$6.assertImportNamespaceSpecifier = assertImportNamespaceSpecifier$1;
    generated$6.assertImportSpecifier = assertImportSpecifier$1;
    generated$6.assertMetaProperty = assertMetaProperty$1;
    generated$6.assertClassMethod = assertClassMethod$1;
    generated$6.assertObjectPattern = assertObjectPattern$1;
    generated$6.assertSpreadElement = assertSpreadElement$1;
    generated$6.assertSuper = assertSuper$1;
    generated$6.assertTaggedTemplateExpression = assertTaggedTemplateExpression$1;
    generated$6.assertTemplateElement = assertTemplateElement$1;
    generated$6.assertTemplateLiteral = assertTemplateLiteral$1;
    generated$6.assertYieldExpression = assertYieldExpression$1;
    generated$6.assertAwaitExpression = assertAwaitExpression$1;
    generated$6.assertImport = assertImport$1;
    generated$6.assertBigIntLiteral = assertBigIntLiteral$1;
    generated$6.assertExportNamespaceSpecifier = assertExportNamespaceSpecifier$1;
    generated$6.assertOptionalMemberExpression = assertOptionalMemberExpression$1;
    generated$6.assertOptionalCallExpression = assertOptionalCallExpression$1;
    generated$6.assertClassProperty = assertClassProperty$1;
    generated$6.assertClassPrivateProperty = assertClassPrivateProperty$1;
    generated$6.assertClassPrivateMethod = assertClassPrivateMethod$1;
    generated$6.assertPrivateName = assertPrivateName$1;
    generated$6.assertAnyTypeAnnotation = assertAnyTypeAnnotation$1;
    generated$6.assertArrayTypeAnnotation = assertArrayTypeAnnotation$1;
    generated$6.assertBooleanTypeAnnotation = assertBooleanTypeAnnotation$1;
    generated$6.assertBooleanLiteralTypeAnnotation = assertBooleanLiteralTypeAnnotation$1;
    generated$6.assertNullLiteralTypeAnnotation = assertNullLiteralTypeAnnotation$1;
    generated$6.assertClassImplements = assertClassImplements$1;
    generated$6.assertDeclareClass = assertDeclareClass$1;
    generated$6.assertDeclareFunction = assertDeclareFunction$1;
    generated$6.assertDeclareInterface = assertDeclareInterface$1;
    generated$6.assertDeclareModule = assertDeclareModule$1;
    generated$6.assertDeclareModuleExports = assertDeclareModuleExports$1;
    generated$6.assertDeclareTypeAlias = assertDeclareTypeAlias$1;
    generated$6.assertDeclareOpaqueType = assertDeclareOpaqueType$1;
    generated$6.assertDeclareVariable = assertDeclareVariable$1;
    generated$6.assertDeclareExportDeclaration = assertDeclareExportDeclaration$1;
    generated$6.assertDeclareExportAllDeclaration = assertDeclareExportAllDeclaration$1;
    generated$6.assertDeclaredPredicate = assertDeclaredPredicate$1;
    generated$6.assertExistsTypeAnnotation = assertExistsTypeAnnotation$1;
    generated$6.assertFunctionTypeAnnotation = assertFunctionTypeAnnotation$1;
    generated$6.assertFunctionTypeParam = assertFunctionTypeParam$1;
    generated$6.assertGenericTypeAnnotation = assertGenericTypeAnnotation$1;
    generated$6.assertInferredPredicate = assertInferredPredicate$1;
    generated$6.assertInterfaceExtends = assertInterfaceExtends$1;
    generated$6.assertInterfaceDeclaration = assertInterfaceDeclaration$1;
    generated$6.assertInterfaceTypeAnnotation = assertInterfaceTypeAnnotation$1;
    generated$6.assertIntersectionTypeAnnotation = assertIntersectionTypeAnnotation$1;
    generated$6.assertMixedTypeAnnotation = assertMixedTypeAnnotation$1;
    generated$6.assertEmptyTypeAnnotation = assertEmptyTypeAnnotation$1;
    generated$6.assertNullableTypeAnnotation = assertNullableTypeAnnotation$1;
    generated$6.assertNumberLiteralTypeAnnotation = assertNumberLiteralTypeAnnotation$1;
    generated$6.assertNumberTypeAnnotation = assertNumberTypeAnnotation$1;
    generated$6.assertObjectTypeAnnotation = assertObjectTypeAnnotation$1;
    generated$6.assertObjectTypeInternalSlot = assertObjectTypeInternalSlot$1;
    generated$6.assertObjectTypeCallProperty = assertObjectTypeCallProperty$1;
    generated$6.assertObjectTypeIndexer = assertObjectTypeIndexer$1;
    generated$6.assertObjectTypeProperty = assertObjectTypeProperty$1;
    generated$6.assertObjectTypeSpreadProperty = assertObjectTypeSpreadProperty$1;
    generated$6.assertOpaqueType = assertOpaqueType$1;
    generated$6.assertQualifiedTypeIdentifier = assertQualifiedTypeIdentifier$1;
    generated$6.assertStringLiteralTypeAnnotation = assertStringLiteralTypeAnnotation$1;
    generated$6.assertStringTypeAnnotation = assertStringTypeAnnotation$1;
    generated$6.assertSymbolTypeAnnotation = assertSymbolTypeAnnotation$1;
    generated$6.assertThisTypeAnnotation = assertThisTypeAnnotation$1;
    generated$6.assertTupleTypeAnnotation = assertTupleTypeAnnotation$1;
    generated$6.assertTypeofTypeAnnotation = assertTypeofTypeAnnotation$1;
    generated$6.assertTypeAlias = assertTypeAlias$1;
    generated$6.assertTypeAnnotation = assertTypeAnnotation$1;
    generated$6.assertTypeCastExpression = assertTypeCastExpression$1;
    generated$6.assertTypeParameter = assertTypeParameter$1;
    generated$6.assertTypeParameterDeclaration = assertTypeParameterDeclaration$1;
    generated$6.assertTypeParameterInstantiation = assertTypeParameterInstantiation$1;
    generated$6.assertUnionTypeAnnotation = assertUnionTypeAnnotation$1;
    generated$6.assertVariance = assertVariance$1;
    generated$6.assertVoidTypeAnnotation = assertVoidTypeAnnotation$1;
    generated$6.assertEnumDeclaration = assertEnumDeclaration$1;
    generated$6.assertEnumBooleanBody = assertEnumBooleanBody$1;
    generated$6.assertEnumNumberBody = assertEnumNumberBody$1;
    generated$6.assertEnumStringBody = assertEnumStringBody$1;
    generated$6.assertEnumSymbolBody = assertEnumSymbolBody$1;
    generated$6.assertEnumBooleanMember = assertEnumBooleanMember$1;
    generated$6.assertEnumNumberMember = assertEnumNumberMember$1;
    generated$6.assertEnumStringMember = assertEnumStringMember$1;
    generated$6.assertEnumDefaultedMember = assertEnumDefaultedMember$1;
    generated$6.assertIndexedAccessType = assertIndexedAccessType;
    generated$6.assertOptionalIndexedAccessType = assertOptionalIndexedAccessType;
    generated$6.assertJSXAttribute = assertJSXAttribute$1;
    generated$6.assertJSXClosingElement = assertJSXClosingElement$1;
    generated$6.assertJSXElement = assertJSXElement$1;
    generated$6.assertJSXEmptyExpression = assertJSXEmptyExpression$1;
    generated$6.assertJSXExpressionContainer = assertJSXExpressionContainer$1;
    generated$6.assertJSXSpreadChild = assertJSXSpreadChild$1;
    generated$6.assertJSXIdentifier = assertJSXIdentifier$1;
    generated$6.assertJSXMemberExpression = assertJSXMemberExpression$1;
    generated$6.assertJSXNamespacedName = assertJSXNamespacedName$1;
    generated$6.assertJSXOpeningElement = assertJSXOpeningElement$1;
    generated$6.assertJSXSpreadAttribute = assertJSXSpreadAttribute$1;
    generated$6.assertJSXText = assertJSXText$1;
    generated$6.assertJSXFragment = assertJSXFragment$1;
    generated$6.assertJSXOpeningFragment = assertJSXOpeningFragment$1;
    generated$6.assertJSXClosingFragment = assertJSXClosingFragment$1;
    generated$6.assertNoop = assertNoop$1;
    generated$6.assertPlaceholder = assertPlaceholder$1;
    generated$6.assertV8IntrinsicIdentifier = assertV8IntrinsicIdentifier$1;
    generated$6.assertArgumentPlaceholder = assertArgumentPlaceholder$1;
    generated$6.assertBindExpression = assertBindExpression$1;
    generated$6.assertImportAttribute = assertImportAttribute$1;
    generated$6.assertDecorator = assertDecorator$1;
    generated$6.assertDoExpression = assertDoExpression$1;
    generated$6.assertExportDefaultSpecifier = assertExportDefaultSpecifier$1;
    generated$6.assertRecordExpression = assertRecordExpression$1;
    generated$6.assertTupleExpression = assertTupleExpression$1;
    generated$6.assertDecimalLiteral = assertDecimalLiteral;
    generated$6.assertStaticBlock = assertStaticBlock;
    generated$6.assertModuleExpression = assertModuleExpression;
    generated$6.assertTopicReference = assertTopicReference;
    generated$6.assertPipelineTopicExpression = assertPipelineTopicExpression$1;
    generated$6.assertPipelineBareFunction = assertPipelineBareFunction$1;
    generated$6.assertPipelinePrimaryTopicReference = assertPipelinePrimaryTopicReference$1;
    generated$6.assertTSParameterProperty = assertTSParameterProperty$1;
    generated$6.assertTSDeclareFunction = assertTSDeclareFunction$1;
    generated$6.assertTSDeclareMethod = assertTSDeclareMethod$1;
    generated$6.assertTSQualifiedName = assertTSQualifiedName$1;
    generated$6.assertTSCallSignatureDeclaration = assertTSCallSignatureDeclaration$1;
    generated$6.assertTSConstructSignatureDeclaration = assertTSConstructSignatureDeclaration$1;
    generated$6.assertTSPropertySignature = assertTSPropertySignature$1;
    generated$6.assertTSMethodSignature = assertTSMethodSignature$1;
    generated$6.assertTSIndexSignature = assertTSIndexSignature$1;
    generated$6.assertTSAnyKeyword = assertTSAnyKeyword$1;
    generated$6.assertTSBooleanKeyword = assertTSBooleanKeyword$1;
    generated$6.assertTSBigIntKeyword = assertTSBigIntKeyword$1;
    generated$6.assertTSIntrinsicKeyword = assertTSIntrinsicKeyword;
    generated$6.assertTSNeverKeyword = assertTSNeverKeyword$1;
    generated$6.assertTSNullKeyword = assertTSNullKeyword$1;
    generated$6.assertTSNumberKeyword = assertTSNumberKeyword$1;
    generated$6.assertTSObjectKeyword = assertTSObjectKeyword$1;
    generated$6.assertTSStringKeyword = assertTSStringKeyword$1;
    generated$6.assertTSSymbolKeyword = assertTSSymbolKeyword$1;
    generated$6.assertTSUndefinedKeyword = assertTSUndefinedKeyword$1;
    generated$6.assertTSUnknownKeyword = assertTSUnknownKeyword$1;
    generated$6.assertTSVoidKeyword = assertTSVoidKeyword$1;
    generated$6.assertTSThisType = assertTSThisType$1;
    generated$6.assertTSFunctionType = assertTSFunctionType$1;
    generated$6.assertTSConstructorType = assertTSConstructorType$1;
    generated$6.assertTSTypeReference = assertTSTypeReference$1;
    generated$6.assertTSTypePredicate = assertTSTypePredicate$1;
    generated$6.assertTSTypeQuery = assertTSTypeQuery$1;
    generated$6.assertTSTypeLiteral = assertTSTypeLiteral$1;
    generated$6.assertTSArrayType = assertTSArrayType$1;
    generated$6.assertTSTupleType = assertTSTupleType$1;
    generated$6.assertTSOptionalType = assertTSOptionalType$1;
    generated$6.assertTSRestType = assertTSRestType$1;
    generated$6.assertTSNamedTupleMember = assertTSNamedTupleMember;
    generated$6.assertTSUnionType = assertTSUnionType$1;
    generated$6.assertTSIntersectionType = assertTSIntersectionType$1;
    generated$6.assertTSConditionalType = assertTSConditionalType$1;
    generated$6.assertTSInferType = assertTSInferType$1;
    generated$6.assertTSParenthesizedType = assertTSParenthesizedType$1;
    generated$6.assertTSTypeOperator = assertTSTypeOperator$1;
    generated$6.assertTSIndexedAccessType = assertTSIndexedAccessType$1;
    generated$6.assertTSMappedType = assertTSMappedType$1;
    generated$6.assertTSLiteralType = assertTSLiteralType$1;
    generated$6.assertTSExpressionWithTypeArguments = assertTSExpressionWithTypeArguments$1;
    generated$6.assertTSInterfaceDeclaration = assertTSInterfaceDeclaration$1;
    generated$6.assertTSInterfaceBody = assertTSInterfaceBody$1;
    generated$6.assertTSTypeAliasDeclaration = assertTSTypeAliasDeclaration$1;
    generated$6.assertTSAsExpression = assertTSAsExpression$1;
    generated$6.assertTSTypeAssertion = assertTSTypeAssertion$1;
    generated$6.assertTSEnumDeclaration = assertTSEnumDeclaration$1;
    generated$6.assertTSEnumMember = assertTSEnumMember$1;
    generated$6.assertTSModuleDeclaration = assertTSModuleDeclaration$1;
    generated$6.assertTSModuleBlock = assertTSModuleBlock$1;
    generated$6.assertTSImportType = assertTSImportType$1;
    generated$6.assertTSImportEqualsDeclaration = assertTSImportEqualsDeclaration$1;
    generated$6.assertTSExternalModuleReference = assertTSExternalModuleReference$1;
    generated$6.assertTSNonNullExpression = assertTSNonNullExpression$1;
    generated$6.assertTSExportAssignment = assertTSExportAssignment$1;
    generated$6.assertTSNamespaceExportDeclaration = assertTSNamespaceExportDeclaration$1;
    generated$6.assertTSTypeAnnotation = assertTSTypeAnnotation$1;
    generated$6.assertTSTypeParameterInstantiation = assertTSTypeParameterInstantiation$1;
    generated$6.assertTSTypeParameterDeclaration = assertTSTypeParameterDeclaration$1;
    generated$6.assertTSTypeParameter = assertTSTypeParameter$1;
    generated$6.assertExpression = assertExpression$1;
    generated$6.assertBinary = assertBinary$1;
    generated$6.assertScopable = assertScopable$1;
    generated$6.assertBlockParent = assertBlockParent$1;
    generated$6.assertBlock = assertBlock$1;
    generated$6.assertStatement = assertStatement$1;
    generated$6.assertTerminatorless = assertTerminatorless$1;
    generated$6.assertCompletionStatement = assertCompletionStatement$1;
    generated$6.assertConditional = assertConditional$1;
    generated$6.assertLoop = assertLoop$1;
    generated$6.assertWhile = assertWhile$1;
    generated$6.assertExpressionWrapper = assertExpressionWrapper$1;
    generated$6.assertFor = assertFor$1;
    generated$6.assertForXStatement = assertForXStatement$1;
    generated$6.assertFunction = assertFunction$1;
    generated$6.assertFunctionParent = assertFunctionParent$1;
    generated$6.assertPureish = assertPureish$1;
    generated$6.assertDeclaration = assertDeclaration$1;
    generated$6.assertPatternLike = assertPatternLike$1;
    generated$6.assertLVal = assertLVal$1;
    generated$6.assertTSEntityName = assertTSEntityName$1;
    generated$6.assertLiteral = assertLiteral$1;
    generated$6.assertImmutable = assertImmutable$1;
    generated$6.assertUserWhitespacable = assertUserWhitespacable$1;
    generated$6.assertMethod = assertMethod$1;
    generated$6.assertObjectMember = assertObjectMember$1;
    generated$6.assertProperty = assertProperty$1;
    generated$6.assertUnaryLike = assertUnaryLike$1;
    generated$6.assertPattern = assertPattern$1;
    generated$6.assertClass = assertClass$1;
    generated$6.assertModuleDeclaration = assertModuleDeclaration$1;
    generated$6.assertExportDeclaration = assertExportDeclaration$1;
    generated$6.assertModuleSpecifier = assertModuleSpecifier$1;
    generated$6.assertPrivate = assertPrivate$1;
    generated$6.assertFlow = assertFlow$1;
    generated$6.assertFlowType = assertFlowType$1;
    generated$6.assertFlowBaseAnnotation = assertFlowBaseAnnotation$1;
    generated$6.assertFlowDeclaration = assertFlowDeclaration$1;
    generated$6.assertFlowPredicate = assertFlowPredicate$1;
    generated$6.assertEnumBody = assertEnumBody$1;
    generated$6.assertEnumMember = assertEnumMember$1;
    generated$6.assertJSX = assertJSX$1;
    generated$6.assertTSTypeElement = assertTSTypeElement$1;
    generated$6.assertTSType = assertTSType$1;
    generated$6.assertTSBaseType = assertTSBaseType$1;
    generated$6.assertNumberLiteral = assertNumberLiteral$1;
    generated$6.assertRegexLiteral = assertRegexLiteral$1;
    generated$6.assertRestProperty = assertRestProperty$1;
    generated$6.assertSpreadProperty = assertSpreadProperty$1;

    var _is$1 = requireIs$1();

    function assert$3(type, node, opts) {
      if (!(0, _is$1.default)(type, node, opts)) {
        throw new Error(`Expected type "${type}" with option ${JSON.stringify(opts)}, ` + `but instead got "${node.type}".`);
      }
    }

    function assertArrayExpression$1(node, opts) {
      assert$3("ArrayExpression", node, opts);
    }

    function assertAssignmentExpression$1(node, opts) {
      assert$3("AssignmentExpression", node, opts);
    }

    function assertBinaryExpression$1(node, opts) {
      assert$3("BinaryExpression", node, opts);
    }

    function assertInterpreterDirective$1(node, opts) {
      assert$3("InterpreterDirective", node, opts);
    }

    function assertDirective$1(node, opts) {
      assert$3("Directive", node, opts);
    }

    function assertDirectiveLiteral$1(node, opts) {
      assert$3("DirectiveLiteral", node, opts);
    }

    function assertBlockStatement$1(node, opts) {
      assert$3("BlockStatement", node, opts);
    }

    function assertBreakStatement$1(node, opts) {
      assert$3("BreakStatement", node, opts);
    }

    function assertCallExpression$1(node, opts) {
      assert$3("CallExpression", node, opts);
    }

    function assertCatchClause$1(node, opts) {
      assert$3("CatchClause", node, opts);
    }

    function assertConditionalExpression$1(node, opts) {
      assert$3("ConditionalExpression", node, opts);
    }

    function assertContinueStatement$1(node, opts) {
      assert$3("ContinueStatement", node, opts);
    }

    function assertDebuggerStatement$1(node, opts) {
      assert$3("DebuggerStatement", node, opts);
    }

    function assertDoWhileStatement$1(node, opts) {
      assert$3("DoWhileStatement", node, opts);
    }

    function assertEmptyStatement$1(node, opts) {
      assert$3("EmptyStatement", node, opts);
    }

    function assertExpressionStatement$1(node, opts) {
      assert$3("ExpressionStatement", node, opts);
    }

    function assertFile$1(node, opts) {
      assert$3("File", node, opts);
    }

    function assertForInStatement$1(node, opts) {
      assert$3("ForInStatement", node, opts);
    }

    function assertForStatement$1(node, opts) {
      assert$3("ForStatement", node, opts);
    }

    function assertFunctionDeclaration$1(node, opts) {
      assert$3("FunctionDeclaration", node, opts);
    }

    function assertFunctionExpression$1(node, opts) {
      assert$3("FunctionExpression", node, opts);
    }

    function assertIdentifier$1(node, opts) {
      assert$3("Identifier", node, opts);
    }

    function assertIfStatement$1(node, opts) {
      assert$3("IfStatement", node, opts);
    }

    function assertLabeledStatement$1(node, opts) {
      assert$3("LabeledStatement", node, opts);
    }

    function assertStringLiteral$1(node, opts) {
      assert$3("StringLiteral", node, opts);
    }

    function assertNumericLiteral$1(node, opts) {
      assert$3("NumericLiteral", node, opts);
    }

    function assertNullLiteral$1(node, opts) {
      assert$3("NullLiteral", node, opts);
    }

    function assertBooleanLiteral$1(node, opts) {
      assert$3("BooleanLiteral", node, opts);
    }

    function assertRegExpLiteral$1(node, opts) {
      assert$3("RegExpLiteral", node, opts);
    }

    function assertLogicalExpression$1(node, opts) {
      assert$3("LogicalExpression", node, opts);
    }

    function assertMemberExpression$1(node, opts) {
      assert$3("MemberExpression", node, opts);
    }

    function assertNewExpression$1(node, opts) {
      assert$3("NewExpression", node, opts);
    }

    function assertProgram$1(node, opts) {
      assert$3("Program", node, opts);
    }

    function assertObjectExpression$1(node, opts) {
      assert$3("ObjectExpression", node, opts);
    }

    function assertObjectMethod$1(node, opts) {
      assert$3("ObjectMethod", node, opts);
    }

    function assertObjectProperty$1(node, opts) {
      assert$3("ObjectProperty", node, opts);
    }

    function assertRestElement$1(node, opts) {
      assert$3("RestElement", node, opts);
    }

    function assertReturnStatement$1(node, opts) {
      assert$3("ReturnStatement", node, opts);
    }

    function assertSequenceExpression$1(node, opts) {
      assert$3("SequenceExpression", node, opts);
    }

    function assertParenthesizedExpression$1(node, opts) {
      assert$3("ParenthesizedExpression", node, opts);
    }

    function assertSwitchCase$1(node, opts) {
      assert$3("SwitchCase", node, opts);
    }

    function assertSwitchStatement$1(node, opts) {
      assert$3("SwitchStatement", node, opts);
    }

    function assertThisExpression$1(node, opts) {
      assert$3("ThisExpression", node, opts);
    }

    function assertThrowStatement$1(node, opts) {
      assert$3("ThrowStatement", node, opts);
    }

    function assertTryStatement$1(node, opts) {
      assert$3("TryStatement", node, opts);
    }

    function assertUnaryExpression$1(node, opts) {
      assert$3("UnaryExpression", node, opts);
    }

    function assertUpdateExpression$1(node, opts) {
      assert$3("UpdateExpression", node, opts);
    }

    function assertVariableDeclaration$1(node, opts) {
      assert$3("VariableDeclaration", node, opts);
    }

    function assertVariableDeclarator$1(node, opts) {
      assert$3("VariableDeclarator", node, opts);
    }

    function assertWhileStatement$1(node, opts) {
      assert$3("WhileStatement", node, opts);
    }

    function assertWithStatement$1(node, opts) {
      assert$3("WithStatement", node, opts);
    }

    function assertAssignmentPattern$1(node, opts) {
      assert$3("AssignmentPattern", node, opts);
    }

    function assertArrayPattern$1(node, opts) {
      assert$3("ArrayPattern", node, opts);
    }

    function assertArrowFunctionExpression$1(node, opts) {
      assert$3("ArrowFunctionExpression", node, opts);
    }

    function assertClassBody$1(node, opts) {
      assert$3("ClassBody", node, opts);
    }

    function assertClassExpression$1(node, opts) {
      assert$3("ClassExpression", node, opts);
    }

    function assertClassDeclaration$1(node, opts) {
      assert$3("ClassDeclaration", node, opts);
    }

    function assertExportAllDeclaration$1(node, opts) {
      assert$3("ExportAllDeclaration", node, opts);
    }

    function assertExportDefaultDeclaration$1(node, opts) {
      assert$3("ExportDefaultDeclaration", node, opts);
    }

    function assertExportNamedDeclaration$1(node, opts) {
      assert$3("ExportNamedDeclaration", node, opts);
    }

    function assertExportSpecifier$1(node, opts) {
      assert$3("ExportSpecifier", node, opts);
    }

    function assertForOfStatement$1(node, opts) {
      assert$3("ForOfStatement", node, opts);
    }

    function assertImportDeclaration$1(node, opts) {
      assert$3("ImportDeclaration", node, opts);
    }

    function assertImportDefaultSpecifier$1(node, opts) {
      assert$3("ImportDefaultSpecifier", node, opts);
    }

    function assertImportNamespaceSpecifier$1(node, opts) {
      assert$3("ImportNamespaceSpecifier", node, opts);
    }

    function assertImportSpecifier$1(node, opts) {
      assert$3("ImportSpecifier", node, opts);
    }

    function assertMetaProperty$1(node, opts) {
      assert$3("MetaProperty", node, opts);
    }

    function assertClassMethod$1(node, opts) {
      assert$3("ClassMethod", node, opts);
    }

    function assertObjectPattern$1(node, opts) {
      assert$3("ObjectPattern", node, opts);
    }

    function assertSpreadElement$1(node, opts) {
      assert$3("SpreadElement", node, opts);
    }

    function assertSuper$1(node, opts) {
      assert$3("Super", node, opts);
    }

    function assertTaggedTemplateExpression$1(node, opts) {
      assert$3("TaggedTemplateExpression", node, opts);
    }

    function assertTemplateElement$1(node, opts) {
      assert$3("TemplateElement", node, opts);
    }

    function assertTemplateLiteral$1(node, opts) {
      assert$3("TemplateLiteral", node, opts);
    }

    function assertYieldExpression$1(node, opts) {
      assert$3("YieldExpression", node, opts);
    }

    function assertAwaitExpression$1(node, opts) {
      assert$3("AwaitExpression", node, opts);
    }

    function assertImport$1(node, opts) {
      assert$3("Import", node, opts);
    }

    function assertBigIntLiteral$1(node, opts) {
      assert$3("BigIntLiteral", node, opts);
    }

    function assertExportNamespaceSpecifier$1(node, opts) {
      assert$3("ExportNamespaceSpecifier", node, opts);
    }

    function assertOptionalMemberExpression$1(node, opts) {
      assert$3("OptionalMemberExpression", node, opts);
    }

    function assertOptionalCallExpression$1(node, opts) {
      assert$3("OptionalCallExpression", node, opts);
    }

    function assertClassProperty$1(node, opts) {
      assert$3("ClassProperty", node, opts);
    }

    function assertClassPrivateProperty$1(node, opts) {
      assert$3("ClassPrivateProperty", node, opts);
    }

    function assertClassPrivateMethod$1(node, opts) {
      assert$3("ClassPrivateMethod", node, opts);
    }

    function assertPrivateName$1(node, opts) {
      assert$3("PrivateName", node, opts);
    }

    function assertAnyTypeAnnotation$1(node, opts) {
      assert$3("AnyTypeAnnotation", node, opts);
    }

    function assertArrayTypeAnnotation$1(node, opts) {
      assert$3("ArrayTypeAnnotation", node, opts);
    }

    function assertBooleanTypeAnnotation$1(node, opts) {
      assert$3("BooleanTypeAnnotation", node, opts);
    }

    function assertBooleanLiteralTypeAnnotation$1(node, opts) {
      assert$3("BooleanLiteralTypeAnnotation", node, opts);
    }

    function assertNullLiteralTypeAnnotation$1(node, opts) {
      assert$3("NullLiteralTypeAnnotation", node, opts);
    }

    function assertClassImplements$1(node, opts) {
      assert$3("ClassImplements", node, opts);
    }

    function assertDeclareClass$1(node, opts) {
      assert$3("DeclareClass", node, opts);
    }

    function assertDeclareFunction$1(node, opts) {
      assert$3("DeclareFunction", node, opts);
    }

    function assertDeclareInterface$1(node, opts) {
      assert$3("DeclareInterface", node, opts);
    }

    function assertDeclareModule$1(node, opts) {
      assert$3("DeclareModule", node, opts);
    }

    function assertDeclareModuleExports$1(node, opts) {
      assert$3("DeclareModuleExports", node, opts);
    }

    function assertDeclareTypeAlias$1(node, opts) {
      assert$3("DeclareTypeAlias", node, opts);
    }

    function assertDeclareOpaqueType$1(node, opts) {
      assert$3("DeclareOpaqueType", node, opts);
    }

    function assertDeclareVariable$1(node, opts) {
      assert$3("DeclareVariable", node, opts);
    }

    function assertDeclareExportDeclaration$1(node, opts) {
      assert$3("DeclareExportDeclaration", node, opts);
    }

    function assertDeclareExportAllDeclaration$1(node, opts) {
      assert$3("DeclareExportAllDeclaration", node, opts);
    }

    function assertDeclaredPredicate$1(node, opts) {
      assert$3("DeclaredPredicate", node, opts);
    }

    function assertExistsTypeAnnotation$1(node, opts) {
      assert$3("ExistsTypeAnnotation", node, opts);
    }

    function assertFunctionTypeAnnotation$1(node, opts) {
      assert$3("FunctionTypeAnnotation", node, opts);
    }

    function assertFunctionTypeParam$1(node, opts) {
      assert$3("FunctionTypeParam", node, opts);
    }

    function assertGenericTypeAnnotation$1(node, opts) {
      assert$3("GenericTypeAnnotation", node, opts);
    }

    function assertInferredPredicate$1(node, opts) {
      assert$3("InferredPredicate", node, opts);
    }

    function assertInterfaceExtends$1(node, opts) {
      assert$3("InterfaceExtends", node, opts);
    }

    function assertInterfaceDeclaration$1(node, opts) {
      assert$3("InterfaceDeclaration", node, opts);
    }

    function assertInterfaceTypeAnnotation$1(node, opts) {
      assert$3("InterfaceTypeAnnotation", node, opts);
    }

    function assertIntersectionTypeAnnotation$1(node, opts) {
      assert$3("IntersectionTypeAnnotation", node, opts);
    }

    function assertMixedTypeAnnotation$1(node, opts) {
      assert$3("MixedTypeAnnotation", node, opts);
    }

    function assertEmptyTypeAnnotation$1(node, opts) {
      assert$3("EmptyTypeAnnotation", node, opts);
    }

    function assertNullableTypeAnnotation$1(node, opts) {
      assert$3("NullableTypeAnnotation", node, opts);
    }

    function assertNumberLiteralTypeAnnotation$1(node, opts) {
      assert$3("NumberLiteralTypeAnnotation", node, opts);
    }

    function assertNumberTypeAnnotation$1(node, opts) {
      assert$3("NumberTypeAnnotation", node, opts);
    }

    function assertObjectTypeAnnotation$1(node, opts) {
      assert$3("ObjectTypeAnnotation", node, opts);
    }

    function assertObjectTypeInternalSlot$1(node, opts) {
      assert$3("ObjectTypeInternalSlot", node, opts);
    }

    function assertObjectTypeCallProperty$1(node, opts) {
      assert$3("ObjectTypeCallProperty", node, opts);
    }

    function assertObjectTypeIndexer$1(node, opts) {
      assert$3("ObjectTypeIndexer", node, opts);
    }

    function assertObjectTypeProperty$1(node, opts) {
      assert$3("ObjectTypeProperty", node, opts);
    }

    function assertObjectTypeSpreadProperty$1(node, opts) {
      assert$3("ObjectTypeSpreadProperty", node, opts);
    }

    function assertOpaqueType$1(node, opts) {
      assert$3("OpaqueType", node, opts);
    }

    function assertQualifiedTypeIdentifier$1(node, opts) {
      assert$3("QualifiedTypeIdentifier", node, opts);
    }

    function assertStringLiteralTypeAnnotation$1(node, opts) {
      assert$3("StringLiteralTypeAnnotation", node, opts);
    }

    function assertStringTypeAnnotation$1(node, opts) {
      assert$3("StringTypeAnnotation", node, opts);
    }

    function assertSymbolTypeAnnotation$1(node, opts) {
      assert$3("SymbolTypeAnnotation", node, opts);
    }

    function assertThisTypeAnnotation$1(node, opts) {
      assert$3("ThisTypeAnnotation", node, opts);
    }

    function assertTupleTypeAnnotation$1(node, opts) {
      assert$3("TupleTypeAnnotation", node, opts);
    }

    function assertTypeofTypeAnnotation$1(node, opts) {
      assert$3("TypeofTypeAnnotation", node, opts);
    }

    function assertTypeAlias$1(node, opts) {
      assert$3("TypeAlias", node, opts);
    }

    function assertTypeAnnotation$1(node, opts) {
      assert$3("TypeAnnotation", node, opts);
    }

    function assertTypeCastExpression$1(node, opts) {
      assert$3("TypeCastExpression", node, opts);
    }

    function assertTypeParameter$1(node, opts) {
      assert$3("TypeParameter", node, opts);
    }

    function assertTypeParameterDeclaration$1(node, opts) {
      assert$3("TypeParameterDeclaration", node, opts);
    }

    function assertTypeParameterInstantiation$1(node, opts) {
      assert$3("TypeParameterInstantiation", node, opts);
    }

    function assertUnionTypeAnnotation$1(node, opts) {
      assert$3("UnionTypeAnnotation", node, opts);
    }

    function assertVariance$1(node, opts) {
      assert$3("Variance", node, opts);
    }

    function assertVoidTypeAnnotation$1(node, opts) {
      assert$3("VoidTypeAnnotation", node, opts);
    }

    function assertEnumDeclaration$1(node, opts) {
      assert$3("EnumDeclaration", node, opts);
    }

    function assertEnumBooleanBody$1(node, opts) {
      assert$3("EnumBooleanBody", node, opts);
    }

    function assertEnumNumberBody$1(node, opts) {
      assert$3("EnumNumberBody", node, opts);
    }

    function assertEnumStringBody$1(node, opts) {
      assert$3("EnumStringBody", node, opts);
    }

    function assertEnumSymbolBody$1(node, opts) {
      assert$3("EnumSymbolBody", node, opts);
    }

    function assertEnumBooleanMember$1(node, opts) {
      assert$3("EnumBooleanMember", node, opts);
    }

    function assertEnumNumberMember$1(node, opts) {
      assert$3("EnumNumberMember", node, opts);
    }

    function assertEnumStringMember$1(node, opts) {
      assert$3("EnumStringMember", node, opts);
    }

    function assertEnumDefaultedMember$1(node, opts) {
      assert$3("EnumDefaultedMember", node, opts);
    }

    function assertIndexedAccessType(node, opts) {
      assert$3("IndexedAccessType", node, opts);
    }

    function assertOptionalIndexedAccessType(node, opts) {
      assert$3("OptionalIndexedAccessType", node, opts);
    }

    function assertJSXAttribute$1(node, opts) {
      assert$3("JSXAttribute", node, opts);
    }

    function assertJSXClosingElement$1(node, opts) {
      assert$3("JSXClosingElement", node, opts);
    }

    function assertJSXElement$1(node, opts) {
      assert$3("JSXElement", node, opts);
    }

    function assertJSXEmptyExpression$1(node, opts) {
      assert$3("JSXEmptyExpression", node, opts);
    }

    function assertJSXExpressionContainer$1(node, opts) {
      assert$3("JSXExpressionContainer", node, opts);
    }

    function assertJSXSpreadChild$1(node, opts) {
      assert$3("JSXSpreadChild", node, opts);
    }

    function assertJSXIdentifier$1(node, opts) {
      assert$3("JSXIdentifier", node, opts);
    }

    function assertJSXMemberExpression$1(node, opts) {
      assert$3("JSXMemberExpression", node, opts);
    }

    function assertJSXNamespacedName$1(node, opts) {
      assert$3("JSXNamespacedName", node, opts);
    }

    function assertJSXOpeningElement$1(node, opts) {
      assert$3("JSXOpeningElement", node, opts);
    }

    function assertJSXSpreadAttribute$1(node, opts) {
      assert$3("JSXSpreadAttribute", node, opts);
    }

    function assertJSXText$1(node, opts) {
      assert$3("JSXText", node, opts);
    }

    function assertJSXFragment$1(node, opts) {
      assert$3("JSXFragment", node, opts);
    }

    function assertJSXOpeningFragment$1(node, opts) {
      assert$3("JSXOpeningFragment", node, opts);
    }

    function assertJSXClosingFragment$1(node, opts) {
      assert$3("JSXClosingFragment", node, opts);
    }

    function assertNoop$1(node, opts) {
      assert$3("Noop", node, opts);
    }

    function assertPlaceholder$1(node, opts) {
      assert$3("Placeholder", node, opts);
    }

    function assertV8IntrinsicIdentifier$1(node, opts) {
      assert$3("V8IntrinsicIdentifier", node, opts);
    }

    function assertArgumentPlaceholder$1(node, opts) {
      assert$3("ArgumentPlaceholder", node, opts);
    }

    function assertBindExpression$1(node, opts) {
      assert$3("BindExpression", node, opts);
    }

    function assertImportAttribute$1(node, opts) {
      assert$3("ImportAttribute", node, opts);
    }

    function assertDecorator$1(node, opts) {
      assert$3("Decorator", node, opts);
    }

    function assertDoExpression$1(node, opts) {
      assert$3("DoExpression", node, opts);
    }

    function assertExportDefaultSpecifier$1(node, opts) {
      assert$3("ExportDefaultSpecifier", node, opts);
    }

    function assertRecordExpression$1(node, opts) {
      assert$3("RecordExpression", node, opts);
    }

    function assertTupleExpression$1(node, opts) {
      assert$3("TupleExpression", node, opts);
    }

    function assertDecimalLiteral(node, opts) {
      assert$3("DecimalLiteral", node, opts);
    }

    function assertStaticBlock(node, opts) {
      assert$3("StaticBlock", node, opts);
    }

    function assertModuleExpression(node, opts) {
      assert$3("ModuleExpression", node, opts);
    }

    function assertTopicReference(node, opts) {
      assert$3("TopicReference", node, opts);
    }

    function assertPipelineTopicExpression$1(node, opts) {
      assert$3("PipelineTopicExpression", node, opts);
    }

    function assertPipelineBareFunction$1(node, opts) {
      assert$3("PipelineBareFunction", node, opts);
    }

    function assertPipelinePrimaryTopicReference$1(node, opts) {
      assert$3("PipelinePrimaryTopicReference", node, opts);
    }

    function assertTSParameterProperty$1(node, opts) {
      assert$3("TSParameterProperty", node, opts);
    }

    function assertTSDeclareFunction$1(node, opts) {
      assert$3("TSDeclareFunction", node, opts);
    }

    function assertTSDeclareMethod$1(node, opts) {
      assert$3("TSDeclareMethod", node, opts);
    }

    function assertTSQualifiedName$1(node, opts) {
      assert$3("TSQualifiedName", node, opts);
    }

    function assertTSCallSignatureDeclaration$1(node, opts) {
      assert$3("TSCallSignatureDeclaration", node, opts);
    }

    function assertTSConstructSignatureDeclaration$1(node, opts) {
      assert$3("TSConstructSignatureDeclaration", node, opts);
    }

    function assertTSPropertySignature$1(node, opts) {
      assert$3("TSPropertySignature", node, opts);
    }

    function assertTSMethodSignature$1(node, opts) {
      assert$3("TSMethodSignature", node, opts);
    }

    function assertTSIndexSignature$1(node, opts) {
      assert$3("TSIndexSignature", node, opts);
    }

    function assertTSAnyKeyword$1(node, opts) {
      assert$3("TSAnyKeyword", node, opts);
    }

    function assertTSBooleanKeyword$1(node, opts) {
      assert$3("TSBooleanKeyword", node, opts);
    }

    function assertTSBigIntKeyword$1(node, opts) {
      assert$3("TSBigIntKeyword", node, opts);
    }

    function assertTSIntrinsicKeyword(node, opts) {
      assert$3("TSIntrinsicKeyword", node, opts);
    }

    function assertTSNeverKeyword$1(node, opts) {
      assert$3("TSNeverKeyword", node, opts);
    }

    function assertTSNullKeyword$1(node, opts) {
      assert$3("TSNullKeyword", node, opts);
    }

    function assertTSNumberKeyword$1(node, opts) {
      assert$3("TSNumberKeyword", node, opts);
    }

    function assertTSObjectKeyword$1(node, opts) {
      assert$3("TSObjectKeyword", node, opts);
    }

    function assertTSStringKeyword$1(node, opts) {
      assert$3("TSStringKeyword", node, opts);
    }

    function assertTSSymbolKeyword$1(node, opts) {
      assert$3("TSSymbolKeyword", node, opts);
    }

    function assertTSUndefinedKeyword$1(node, opts) {
      assert$3("TSUndefinedKeyword", node, opts);
    }

    function assertTSUnknownKeyword$1(node, opts) {
      assert$3("TSUnknownKeyword", node, opts);
    }

    function assertTSVoidKeyword$1(node, opts) {
      assert$3("TSVoidKeyword", node, opts);
    }

    function assertTSThisType$1(node, opts) {
      assert$3("TSThisType", node, opts);
    }

    function assertTSFunctionType$1(node, opts) {
      assert$3("TSFunctionType", node, opts);
    }

    function assertTSConstructorType$1(node, opts) {
      assert$3("TSConstructorType", node, opts);
    }

    function assertTSTypeReference$1(node, opts) {
      assert$3("TSTypeReference", node, opts);
    }

    function assertTSTypePredicate$1(node, opts) {
      assert$3("TSTypePredicate", node, opts);
    }

    function assertTSTypeQuery$1(node, opts) {
      assert$3("TSTypeQuery", node, opts);
    }

    function assertTSTypeLiteral$1(node, opts) {
      assert$3("TSTypeLiteral", node, opts);
    }

    function assertTSArrayType$1(node, opts) {
      assert$3("TSArrayType", node, opts);
    }

    function assertTSTupleType$1(node, opts) {
      assert$3("TSTupleType", node, opts);
    }

    function assertTSOptionalType$1(node, opts) {
      assert$3("TSOptionalType", node, opts);
    }

    function assertTSRestType$1(node, opts) {
      assert$3("TSRestType", node, opts);
    }

    function assertTSNamedTupleMember(node, opts) {
      assert$3("TSNamedTupleMember", node, opts);
    }

    function assertTSUnionType$1(node, opts) {
      assert$3("TSUnionType", node, opts);
    }

    function assertTSIntersectionType$1(node, opts) {
      assert$3("TSIntersectionType", node, opts);
    }

    function assertTSConditionalType$1(node, opts) {
      assert$3("TSConditionalType", node, opts);
    }

    function assertTSInferType$1(node, opts) {
      assert$3("TSInferType", node, opts);
    }

    function assertTSParenthesizedType$1(node, opts) {
      assert$3("TSParenthesizedType", node, opts);
    }

    function assertTSTypeOperator$1(node, opts) {
      assert$3("TSTypeOperator", node, opts);
    }

    function assertTSIndexedAccessType$1(node, opts) {
      assert$3("TSIndexedAccessType", node, opts);
    }

    function assertTSMappedType$1(node, opts) {
      assert$3("TSMappedType", node, opts);
    }

    function assertTSLiteralType$1(node, opts) {
      assert$3("TSLiteralType", node, opts);
    }

    function assertTSExpressionWithTypeArguments$1(node, opts) {
      assert$3("TSExpressionWithTypeArguments", node, opts);
    }

    function assertTSInterfaceDeclaration$1(node, opts) {
      assert$3("TSInterfaceDeclaration", node, opts);
    }

    function assertTSInterfaceBody$1(node, opts) {
      assert$3("TSInterfaceBody", node, opts);
    }

    function assertTSTypeAliasDeclaration$1(node, opts) {
      assert$3("TSTypeAliasDeclaration", node, opts);
    }

    function assertTSAsExpression$1(node, opts) {
      assert$3("TSAsExpression", node, opts);
    }

    function assertTSTypeAssertion$1(node, opts) {
      assert$3("TSTypeAssertion", node, opts);
    }

    function assertTSEnumDeclaration$1(node, opts) {
      assert$3("TSEnumDeclaration", node, opts);
    }

    function assertTSEnumMember$1(node, opts) {
      assert$3("TSEnumMember", node, opts);
    }

    function assertTSModuleDeclaration$1(node, opts) {
      assert$3("TSModuleDeclaration", node, opts);
    }

    function assertTSModuleBlock$1(node, opts) {
      assert$3("TSModuleBlock", node, opts);
    }

    function assertTSImportType$1(node, opts) {
      assert$3("TSImportType", node, opts);
    }

    function assertTSImportEqualsDeclaration$1(node, opts) {
      assert$3("TSImportEqualsDeclaration", node, opts);
    }

    function assertTSExternalModuleReference$1(node, opts) {
      assert$3("TSExternalModuleReference", node, opts);
    }

    function assertTSNonNullExpression$1(node, opts) {
      assert$3("TSNonNullExpression", node, opts);
    }

    function assertTSExportAssignment$1(node, opts) {
      assert$3("TSExportAssignment", node, opts);
    }

    function assertTSNamespaceExportDeclaration$1(node, opts) {
      assert$3("TSNamespaceExportDeclaration", node, opts);
    }

    function assertTSTypeAnnotation$1(node, opts) {
      assert$3("TSTypeAnnotation", node, opts);
    }

    function assertTSTypeParameterInstantiation$1(node, opts) {
      assert$3("TSTypeParameterInstantiation", node, opts);
    }

    function assertTSTypeParameterDeclaration$1(node, opts) {
      assert$3("TSTypeParameterDeclaration", node, opts);
    }

    function assertTSTypeParameter$1(node, opts) {
      assert$3("TSTypeParameter", node, opts);
    }

    function assertExpression$1(node, opts) {
      assert$3("Expression", node, opts);
    }

    function assertBinary$1(node, opts) {
      assert$3("Binary", node, opts);
    }

    function assertScopable$1(node, opts) {
      assert$3("Scopable", node, opts);
    }

    function assertBlockParent$1(node, opts) {
      assert$3("BlockParent", node, opts);
    }

    function assertBlock$1(node, opts) {
      assert$3("Block", node, opts);
    }

    function assertStatement$1(node, opts) {
      assert$3("Statement", node, opts);
    }

    function assertTerminatorless$1(node, opts) {
      assert$3("Terminatorless", node, opts);
    }

    function assertCompletionStatement$1(node, opts) {
      assert$3("CompletionStatement", node, opts);
    }

    function assertConditional$1(node, opts) {
      assert$3("Conditional", node, opts);
    }

    function assertLoop$1(node, opts) {
      assert$3("Loop", node, opts);
    }

    function assertWhile$1(node, opts) {
      assert$3("While", node, opts);
    }

    function assertExpressionWrapper$1(node, opts) {
      assert$3("ExpressionWrapper", node, opts);
    }

    function assertFor$1(node, opts) {
      assert$3("For", node, opts);
    }

    function assertForXStatement$1(node, opts) {
      assert$3("ForXStatement", node, opts);
    }

    function assertFunction$1(node, opts) {
      assert$3("Function", node, opts);
    }

    function assertFunctionParent$1(node, opts) {
      assert$3("FunctionParent", node, opts);
    }

    function assertPureish$1(node, opts) {
      assert$3("Pureish", node, opts);
    }

    function assertDeclaration$1(node, opts) {
      assert$3("Declaration", node, opts);
    }

    function assertPatternLike$1(node, opts) {
      assert$3("PatternLike", node, opts);
    }

    function assertLVal$1(node, opts) {
      assert$3("LVal", node, opts);
    }

    function assertTSEntityName$1(node, opts) {
      assert$3("TSEntityName", node, opts);
    }

    function assertLiteral$1(node, opts) {
      assert$3("Literal", node, opts);
    }

    function assertImmutable$1(node, opts) {
      assert$3("Immutable", node, opts);
    }

    function assertUserWhitespacable$1(node, opts) {
      assert$3("UserWhitespacable", node, opts);
    }

    function assertMethod$1(node, opts) {
      assert$3("Method", node, opts);
    }

    function assertObjectMember$1(node, opts) {
      assert$3("ObjectMember", node, opts);
    }

    function assertProperty$1(node, opts) {
      assert$3("Property", node, opts);
    }

    function assertUnaryLike$1(node, opts) {
      assert$3("UnaryLike", node, opts);
    }

    function assertPattern$1(node, opts) {
      assert$3("Pattern", node, opts);
    }

    function assertClass$1(node, opts) {
      assert$3("Class", node, opts);
    }

    function assertModuleDeclaration$1(node, opts) {
      assert$3("ModuleDeclaration", node, opts);
    }

    function assertExportDeclaration$1(node, opts) {
      assert$3("ExportDeclaration", node, opts);
    }

    function assertModuleSpecifier$1(node, opts) {
      assert$3("ModuleSpecifier", node, opts);
    }

    function assertPrivate$1(node, opts) {
      assert$3("Private", node, opts);
    }

    function assertFlow$1(node, opts) {
      assert$3("Flow", node, opts);
    }

    function assertFlowType$1(node, opts) {
      assert$3("FlowType", node, opts);
    }

    function assertFlowBaseAnnotation$1(node, opts) {
      assert$3("FlowBaseAnnotation", node, opts);
    }

    function assertFlowDeclaration$1(node, opts) {
      assert$3("FlowDeclaration", node, opts);
    }

    function assertFlowPredicate$1(node, opts) {
      assert$3("FlowPredicate", node, opts);
    }

    function assertEnumBody$1(node, opts) {
      assert$3("EnumBody", node, opts);
    }

    function assertEnumMember$1(node, opts) {
      assert$3("EnumMember", node, opts);
    }

    function assertJSX$1(node, opts) {
      assert$3("JSX", node, opts);
    }

    function assertTSTypeElement$1(node, opts) {
      assert$3("TSTypeElement", node, opts);
    }

    function assertTSType$1(node, opts) {
      assert$3("TSType", node, opts);
    }

    function assertTSBaseType$1(node, opts) {
      assert$3("TSBaseType", node, opts);
    }

    function assertNumberLiteral$1(node, opts) {
      console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
      assert$3("NumberLiteral", node, opts);
    }

    function assertRegexLiteral$1(node, opts) {
      console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
      assert$3("RegexLiteral", node, opts);
    }

    function assertRestProperty$1(node, opts) {
      console.trace("The node type RestProperty has been renamed to RestElement");
      assert$3("RestProperty", node, opts);
    }

    function assertSpreadProperty$1(node, opts) {
      console.trace("The node type SpreadProperty has been renamed to SpreadElement");
      assert$3("SpreadProperty", node, opts);
    }

    var createTypeAnnotationBasedOnTypeof$3 = {};

    Object.defineProperty(createTypeAnnotationBasedOnTypeof$3, "__esModule", {
      value: true
    });
    createTypeAnnotationBasedOnTypeof$3.default = createTypeAnnotationBasedOnTypeof$2;

    var _generated$J = generated$7;

    function createTypeAnnotationBasedOnTypeof$2(type) {
      if (type === "string") {
        return (0, _generated$J.stringTypeAnnotation)();
      } else if (type === "number") {
        return (0, _generated$J.numberTypeAnnotation)();
      } else if (type === "undefined") {
        return (0, _generated$J.voidTypeAnnotation)();
      } else if (type === "boolean") {
        return (0, _generated$J.booleanTypeAnnotation)();
      } else if (type === "function") {
        return (0, _generated$J.genericTypeAnnotation)((0, _generated$J.identifier)("Function"));
      } else if (type === "object") {
        return (0, _generated$J.genericTypeAnnotation)((0, _generated$J.identifier)("Object"));
      } else if (type === "symbol") {
        return (0, _generated$J.genericTypeAnnotation)((0, _generated$J.identifier)("Symbol"));
      } else if (type === "bigint") {
        return (0, _generated$J.anyTypeAnnotation)();
      } else {
        throw new Error("Invalid typeof value: " + type);
      }
    }

    var createFlowUnionType$3 = {};

    var removeTypeDuplicates$7 = {};

    Object.defineProperty(removeTypeDuplicates$7, "__esModule", {
      value: true
    });
    removeTypeDuplicates$7.default = removeTypeDuplicates$6;

    var _generated$I = generated$8;

    function getQualifiedName(node) {
      return (0, _generated$I.isIdentifier)(node) ? node.name : `${node.id.name}.${getQualifiedName(node.qualification)}`;
    }

    function removeTypeDuplicates$6(nodes) {
      const generics = {};
      const bases = {};
      const typeGroups = new Set();
      const types = [];

      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (!node) continue;

        if (types.indexOf(node) >= 0) {
          continue;
        }

        if ((0, _generated$I.isAnyTypeAnnotation)(node)) {
          return [node];
        }

        if ((0, _generated$I.isFlowBaseAnnotation)(node)) {
          bases[node.type] = node;
          continue;
        }

        if ((0, _generated$I.isUnionTypeAnnotation)(node)) {
          if (!typeGroups.has(node.types)) {
            nodes = nodes.concat(node.types);
            typeGroups.add(node.types);
          }

          continue;
        }

        if ((0, _generated$I.isGenericTypeAnnotation)(node)) {
          const name = getQualifiedName(node.id);

          if (generics[name]) {
            let existing = generics[name];

            if (existing.typeParameters) {
              if (node.typeParameters) {
                existing.typeParameters.params = removeTypeDuplicates$6(existing.typeParameters.params.concat(node.typeParameters.params));
              }
            } else {
              existing = node.typeParameters;
            }
          } else {
            generics[name] = node;
          }

          continue;
        }

        types.push(node);
      }

      for (const type of Object.keys(bases)) {
        types.push(bases[type]);
      }

      for (const name of Object.keys(generics)) {
        types.push(generics[name]);
      }

      return types;
    }

    Object.defineProperty(createFlowUnionType$3, "__esModule", {
      value: true
    });
    createFlowUnionType$3.default = createFlowUnionType$2;

    var _generated$H = generated$7;

    var _removeTypeDuplicates$3 = removeTypeDuplicates$7;

    function createFlowUnionType$2(types) {
      const flattened = (0, _removeTypeDuplicates$3.default)(types);

      if (flattened.length === 1) {
        return flattened[0];
      } else {
        return (0, _generated$H.unionTypeAnnotation)(flattened);
      }
    }

    var createTSUnionType$3 = {};

    var removeTypeDuplicates$5 = {};

    Object.defineProperty(removeTypeDuplicates$5, "__esModule", {
      value: true
    });
    removeTypeDuplicates$5.default = removeTypeDuplicates$4;

    var _generated$G = generated$8;

    function removeTypeDuplicates$4(nodes) {
      const generics = {};
      const bases = {};
      const typeGroups = new Set();
      const types = [];

      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (!node) continue;

        if (types.indexOf(node) >= 0) {
          continue;
        }

        if ((0, _generated$G.isTSAnyKeyword)(node)) {
          return [node];
        }

        if ((0, _generated$G.isTSBaseType)(node)) {
          bases[node.type] = node;
          continue;
        }

        if ((0, _generated$G.isTSUnionType)(node)) {
          if (!typeGroups.has(node.types)) {
            nodes.push(...node.types);
            typeGroups.add(node.types);
          }

          continue;
        }

        types.push(node);
      }

      for (const type of Object.keys(bases)) {
        types.push(bases[type]);
      }

      for (const name of Object.keys(generics)) {
        types.push(generics[name]);
      }

      return types;
    }

    Object.defineProperty(createTSUnionType$3, "__esModule", {
      value: true
    });
    createTSUnionType$3.default = createTSUnionType$2;

    var _generated$F = generated$7;

    var _removeTypeDuplicates$2 = removeTypeDuplicates$5;

    function createTSUnionType$2(typeAnnotations) {
      const types = typeAnnotations.map(type => type.typeAnnotation);
      const flattened = (0, _removeTypeDuplicates$2.default)(types);

      if (flattened.length === 1) {
        return flattened[0];
      } else {
        return (0, _generated$F.tsUnionType)(flattened);
      }
    }

    var uppercase = {};

    (function (exports) {

    	Object.defineProperty(exports, "__esModule", {
    	  value: true
    	});
    	Object.defineProperty(exports, "ArrayExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.arrayExpression;
    	  }
    	});
    	Object.defineProperty(exports, "AssignmentExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.assignmentExpression;
    	  }
    	});
    	Object.defineProperty(exports, "BinaryExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.binaryExpression;
    	  }
    	});
    	Object.defineProperty(exports, "InterpreterDirective", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.interpreterDirective;
    	  }
    	});
    	Object.defineProperty(exports, "Directive", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.directive;
    	  }
    	});
    	Object.defineProperty(exports, "DirectiveLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.directiveLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "BlockStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.blockStatement;
    	  }
    	});
    	Object.defineProperty(exports, "BreakStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.breakStatement;
    	  }
    	});
    	Object.defineProperty(exports, "CallExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.callExpression;
    	  }
    	});
    	Object.defineProperty(exports, "CatchClause", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.catchClause;
    	  }
    	});
    	Object.defineProperty(exports, "ConditionalExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.conditionalExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ContinueStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.continueStatement;
    	  }
    	});
    	Object.defineProperty(exports, "DebuggerStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.debuggerStatement;
    	  }
    	});
    	Object.defineProperty(exports, "DoWhileStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.doWhileStatement;
    	  }
    	});
    	Object.defineProperty(exports, "EmptyStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.emptyStatement;
    	  }
    	});
    	Object.defineProperty(exports, "ExpressionStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.expressionStatement;
    	  }
    	});
    	Object.defineProperty(exports, "File", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.file;
    	  }
    	});
    	Object.defineProperty(exports, "ForInStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.forInStatement;
    	  }
    	});
    	Object.defineProperty(exports, "ForStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.forStatement;
    	  }
    	});
    	Object.defineProperty(exports, "FunctionDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.functionDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "FunctionExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.functionExpression;
    	  }
    	});
    	Object.defineProperty(exports, "Identifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.identifier;
    	  }
    	});
    	Object.defineProperty(exports, "IfStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.ifStatement;
    	  }
    	});
    	Object.defineProperty(exports, "LabeledStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.labeledStatement;
    	  }
    	});
    	Object.defineProperty(exports, "StringLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.stringLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "NumericLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.numericLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "NullLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.nullLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "BooleanLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.booleanLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "RegExpLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.regExpLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "LogicalExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.logicalExpression;
    	  }
    	});
    	Object.defineProperty(exports, "MemberExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.memberExpression;
    	  }
    	});
    	Object.defineProperty(exports, "NewExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.newExpression;
    	  }
    	});
    	Object.defineProperty(exports, "Program", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.program;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectMethod", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectMethod;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectProperty;
    	  }
    	});
    	Object.defineProperty(exports, "RestElement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.restElement;
    	  }
    	});
    	Object.defineProperty(exports, "ReturnStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.returnStatement;
    	  }
    	});
    	Object.defineProperty(exports, "SequenceExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.sequenceExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ParenthesizedExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.parenthesizedExpression;
    	  }
    	});
    	Object.defineProperty(exports, "SwitchCase", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.switchCase;
    	  }
    	});
    	Object.defineProperty(exports, "SwitchStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.switchStatement;
    	  }
    	});
    	Object.defineProperty(exports, "ThisExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.thisExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ThrowStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.throwStatement;
    	  }
    	});
    	Object.defineProperty(exports, "TryStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tryStatement;
    	  }
    	});
    	Object.defineProperty(exports, "UnaryExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.unaryExpression;
    	  }
    	});
    	Object.defineProperty(exports, "UpdateExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.updateExpression;
    	  }
    	});
    	Object.defineProperty(exports, "VariableDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.variableDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "VariableDeclarator", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.variableDeclarator;
    	  }
    	});
    	Object.defineProperty(exports, "WhileStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.whileStatement;
    	  }
    	});
    	Object.defineProperty(exports, "WithStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.withStatement;
    	  }
    	});
    	Object.defineProperty(exports, "AssignmentPattern", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.assignmentPattern;
    	  }
    	});
    	Object.defineProperty(exports, "ArrayPattern", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.arrayPattern;
    	  }
    	});
    	Object.defineProperty(exports, "ArrowFunctionExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.arrowFunctionExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ClassBody", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classBody;
    	  }
    	});
    	Object.defineProperty(exports, "ClassExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ClassDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "ExportAllDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.exportAllDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "ExportDefaultDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.exportDefaultDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "ExportNamedDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.exportNamedDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "ExportSpecifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.exportSpecifier;
    	  }
    	});
    	Object.defineProperty(exports, "ForOfStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.forOfStatement;
    	  }
    	});
    	Object.defineProperty(exports, "ImportDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.importDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "ImportDefaultSpecifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.importDefaultSpecifier;
    	  }
    	});
    	Object.defineProperty(exports, "ImportNamespaceSpecifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.importNamespaceSpecifier;
    	  }
    	});
    	Object.defineProperty(exports, "ImportSpecifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.importSpecifier;
    	  }
    	});
    	Object.defineProperty(exports, "MetaProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.metaProperty;
    	  }
    	});
    	Object.defineProperty(exports, "ClassMethod", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classMethod;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectPattern", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectPattern;
    	  }
    	});
    	Object.defineProperty(exports, "SpreadElement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.spreadElement;
    	  }
    	});
    	Object.defineProperty(exports, "Super", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.super;
    	  }
    	});
    	Object.defineProperty(exports, "TaggedTemplateExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.taggedTemplateExpression;
    	  }
    	});
    	Object.defineProperty(exports, "TemplateElement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.templateElement;
    	  }
    	});
    	Object.defineProperty(exports, "TemplateLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.templateLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "YieldExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.yieldExpression;
    	  }
    	});
    	Object.defineProperty(exports, "AwaitExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.awaitExpression;
    	  }
    	});
    	Object.defineProperty(exports, "Import", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.import;
    	  }
    	});
    	Object.defineProperty(exports, "BigIntLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.bigIntLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "ExportNamespaceSpecifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.exportNamespaceSpecifier;
    	  }
    	});
    	Object.defineProperty(exports, "OptionalMemberExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.optionalMemberExpression;
    	  }
    	});
    	Object.defineProperty(exports, "OptionalCallExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.optionalCallExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ClassProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classProperty;
    	  }
    	});
    	Object.defineProperty(exports, "ClassPrivateProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classPrivateProperty;
    	  }
    	});
    	Object.defineProperty(exports, "ClassPrivateMethod", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classPrivateMethod;
    	  }
    	});
    	Object.defineProperty(exports, "PrivateName", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.privateName;
    	  }
    	});
    	Object.defineProperty(exports, "AnyTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.anyTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "ArrayTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.arrayTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "BooleanTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.booleanTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "BooleanLiteralTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.booleanLiteralTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "NullLiteralTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.nullLiteralTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "ClassImplements", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.classImplements;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareClass", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareClass;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareFunction", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareFunction;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareInterface", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareInterface;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareModule", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareModule;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareModuleExports", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareModuleExports;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareTypeAlias", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareTypeAlias;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareOpaqueType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareOpaqueType;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareVariable", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareVariable;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareExportDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareExportDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "DeclareExportAllDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declareExportAllDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "DeclaredPredicate", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.declaredPredicate;
    	  }
    	});
    	Object.defineProperty(exports, "ExistsTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.existsTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "FunctionTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.functionTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "FunctionTypeParam", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.functionTypeParam;
    	  }
    	});
    	Object.defineProperty(exports, "GenericTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.genericTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "InferredPredicate", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.inferredPredicate;
    	  }
    	});
    	Object.defineProperty(exports, "InterfaceExtends", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.interfaceExtends;
    	  }
    	});
    	Object.defineProperty(exports, "InterfaceDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.interfaceDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "InterfaceTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.interfaceTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "IntersectionTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.intersectionTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "MixedTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.mixedTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "EmptyTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.emptyTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "NullableTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.nullableTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "NumberLiteralTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.numberLiteralTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "NumberTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.numberTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectTypeInternalSlot", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectTypeInternalSlot;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectTypeCallProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectTypeCallProperty;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectTypeIndexer", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectTypeIndexer;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectTypeProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectTypeProperty;
    	  }
    	});
    	Object.defineProperty(exports, "ObjectTypeSpreadProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.objectTypeSpreadProperty;
    	  }
    	});
    	Object.defineProperty(exports, "OpaqueType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.opaqueType;
    	  }
    	});
    	Object.defineProperty(exports, "QualifiedTypeIdentifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.qualifiedTypeIdentifier;
    	  }
    	});
    	Object.defineProperty(exports, "StringLiteralTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.stringLiteralTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "StringTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.stringTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "SymbolTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.symbolTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "ThisTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.thisTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "TupleTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tupleTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "TypeofTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeofTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "TypeAlias", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeAlias;
    	  }
    	});
    	Object.defineProperty(exports, "TypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "TypeCastExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeCastExpression;
    	  }
    	});
    	Object.defineProperty(exports, "TypeParameter", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeParameter;
    	  }
    	});
    	Object.defineProperty(exports, "TypeParameterDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeParameterDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TypeParameterInstantiation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.typeParameterInstantiation;
    	  }
    	});
    	Object.defineProperty(exports, "UnionTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.unionTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "Variance", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.variance;
    	  }
    	});
    	Object.defineProperty(exports, "VoidTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.voidTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "EnumDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "EnumBooleanBody", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumBooleanBody;
    	  }
    	});
    	Object.defineProperty(exports, "EnumNumberBody", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumNumberBody;
    	  }
    	});
    	Object.defineProperty(exports, "EnumStringBody", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumStringBody;
    	  }
    	});
    	Object.defineProperty(exports, "EnumSymbolBody", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumSymbolBody;
    	  }
    	});
    	Object.defineProperty(exports, "EnumBooleanMember", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumBooleanMember;
    	  }
    	});
    	Object.defineProperty(exports, "EnumNumberMember", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumNumberMember;
    	  }
    	});
    	Object.defineProperty(exports, "EnumStringMember", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumStringMember;
    	  }
    	});
    	Object.defineProperty(exports, "EnumDefaultedMember", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.enumDefaultedMember;
    	  }
    	});
    	Object.defineProperty(exports, "IndexedAccessType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.indexedAccessType;
    	  }
    	});
    	Object.defineProperty(exports, "OptionalIndexedAccessType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.optionalIndexedAccessType;
    	  }
    	});
    	Object.defineProperty(exports, "JSXAttribute", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxAttribute;
    	  }
    	});
    	Object.defineProperty(exports, "JSXClosingElement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxClosingElement;
    	  }
    	});
    	Object.defineProperty(exports, "JSXElement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxElement;
    	  }
    	});
    	Object.defineProperty(exports, "JSXEmptyExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxEmptyExpression;
    	  }
    	});
    	Object.defineProperty(exports, "JSXExpressionContainer", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxExpressionContainer;
    	  }
    	});
    	Object.defineProperty(exports, "JSXSpreadChild", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxSpreadChild;
    	  }
    	});
    	Object.defineProperty(exports, "JSXIdentifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxIdentifier;
    	  }
    	});
    	Object.defineProperty(exports, "JSXMemberExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxMemberExpression;
    	  }
    	});
    	Object.defineProperty(exports, "JSXNamespacedName", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxNamespacedName;
    	  }
    	});
    	Object.defineProperty(exports, "JSXOpeningElement", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxOpeningElement;
    	  }
    	});
    	Object.defineProperty(exports, "JSXSpreadAttribute", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxSpreadAttribute;
    	  }
    	});
    	Object.defineProperty(exports, "JSXText", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxText;
    	  }
    	});
    	Object.defineProperty(exports, "JSXFragment", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxFragment;
    	  }
    	});
    	Object.defineProperty(exports, "JSXOpeningFragment", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxOpeningFragment;
    	  }
    	});
    	Object.defineProperty(exports, "JSXClosingFragment", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.jsxClosingFragment;
    	  }
    	});
    	Object.defineProperty(exports, "Noop", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.noop;
    	  }
    	});
    	Object.defineProperty(exports, "Placeholder", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.placeholder;
    	  }
    	});
    	Object.defineProperty(exports, "V8IntrinsicIdentifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.v8IntrinsicIdentifier;
    	  }
    	});
    	Object.defineProperty(exports, "ArgumentPlaceholder", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.argumentPlaceholder;
    	  }
    	});
    	Object.defineProperty(exports, "BindExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.bindExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ImportAttribute", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.importAttribute;
    	  }
    	});
    	Object.defineProperty(exports, "Decorator", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.decorator;
    	  }
    	});
    	Object.defineProperty(exports, "DoExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.doExpression;
    	  }
    	});
    	Object.defineProperty(exports, "ExportDefaultSpecifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.exportDefaultSpecifier;
    	  }
    	});
    	Object.defineProperty(exports, "RecordExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.recordExpression;
    	  }
    	});
    	Object.defineProperty(exports, "TupleExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tupleExpression;
    	  }
    	});
    	Object.defineProperty(exports, "DecimalLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.decimalLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "StaticBlock", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.staticBlock;
    	  }
    	});
    	Object.defineProperty(exports, "ModuleExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.moduleExpression;
    	  }
    	});
    	Object.defineProperty(exports, "TopicReference", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.topicReference;
    	  }
    	});
    	Object.defineProperty(exports, "PipelineTopicExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.pipelineTopicExpression;
    	  }
    	});
    	Object.defineProperty(exports, "PipelineBareFunction", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.pipelineBareFunction;
    	  }
    	});
    	Object.defineProperty(exports, "PipelinePrimaryTopicReference", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.pipelinePrimaryTopicReference;
    	  }
    	});
    	Object.defineProperty(exports, "TSParameterProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsParameterProperty;
    	  }
    	});
    	Object.defineProperty(exports, "TSDeclareFunction", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsDeclareFunction;
    	  }
    	});
    	Object.defineProperty(exports, "TSDeclareMethod", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsDeclareMethod;
    	  }
    	});
    	Object.defineProperty(exports, "TSQualifiedName", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsQualifiedName;
    	  }
    	});
    	Object.defineProperty(exports, "TSCallSignatureDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsCallSignatureDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSConstructSignatureDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsConstructSignatureDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSPropertySignature", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsPropertySignature;
    	  }
    	});
    	Object.defineProperty(exports, "TSMethodSignature", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsMethodSignature;
    	  }
    	});
    	Object.defineProperty(exports, "TSIndexSignature", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsIndexSignature;
    	  }
    	});
    	Object.defineProperty(exports, "TSAnyKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsAnyKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSBooleanKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsBooleanKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSBigIntKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsBigIntKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSIntrinsicKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsIntrinsicKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSNeverKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsNeverKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSNullKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsNullKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSNumberKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsNumberKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSObjectKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsObjectKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSStringKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsStringKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSSymbolKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsSymbolKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSUndefinedKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsUndefinedKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSUnknownKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsUnknownKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSVoidKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsVoidKeyword;
    	  }
    	});
    	Object.defineProperty(exports, "TSThisType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsThisType;
    	  }
    	});
    	Object.defineProperty(exports, "TSFunctionType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsFunctionType;
    	  }
    	});
    	Object.defineProperty(exports, "TSConstructorType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsConstructorType;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeReference", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeReference;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypePredicate", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypePredicate;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeQuery", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeQuery;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "TSArrayType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsArrayType;
    	  }
    	});
    	Object.defineProperty(exports, "TSTupleType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTupleType;
    	  }
    	});
    	Object.defineProperty(exports, "TSOptionalType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsOptionalType;
    	  }
    	});
    	Object.defineProperty(exports, "TSRestType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsRestType;
    	  }
    	});
    	Object.defineProperty(exports, "TSNamedTupleMember", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsNamedTupleMember;
    	  }
    	});
    	Object.defineProperty(exports, "TSUnionType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsUnionType;
    	  }
    	});
    	Object.defineProperty(exports, "TSIntersectionType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsIntersectionType;
    	  }
    	});
    	Object.defineProperty(exports, "TSConditionalType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsConditionalType;
    	  }
    	});
    	Object.defineProperty(exports, "TSInferType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsInferType;
    	  }
    	});
    	Object.defineProperty(exports, "TSParenthesizedType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsParenthesizedType;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeOperator", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeOperator;
    	  }
    	});
    	Object.defineProperty(exports, "TSIndexedAccessType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsIndexedAccessType;
    	  }
    	});
    	Object.defineProperty(exports, "TSMappedType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsMappedType;
    	  }
    	});
    	Object.defineProperty(exports, "TSLiteralType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsLiteralType;
    	  }
    	});
    	Object.defineProperty(exports, "TSExpressionWithTypeArguments", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsExpressionWithTypeArguments;
    	  }
    	});
    	Object.defineProperty(exports, "TSInterfaceDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsInterfaceDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSInterfaceBody", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsInterfaceBody;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeAliasDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeAliasDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSAsExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsAsExpression;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeAssertion", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeAssertion;
    	  }
    	});
    	Object.defineProperty(exports, "TSEnumDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsEnumDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSEnumMember", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsEnumMember;
    	  }
    	});
    	Object.defineProperty(exports, "TSModuleDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsModuleDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSModuleBlock", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsModuleBlock;
    	  }
    	});
    	Object.defineProperty(exports, "TSImportType", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsImportType;
    	  }
    	});
    	Object.defineProperty(exports, "TSImportEqualsDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsImportEqualsDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSExternalModuleReference", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsExternalModuleReference;
    	  }
    	});
    	Object.defineProperty(exports, "TSNonNullExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsNonNullExpression;
    	  }
    	});
    	Object.defineProperty(exports, "TSExportAssignment", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsExportAssignment;
    	  }
    	});
    	Object.defineProperty(exports, "TSNamespaceExportDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsNamespaceExportDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeAnnotation;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeParameterInstantiation", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeParameterInstantiation;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeParameterDeclaration", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeParameterDeclaration;
    	  }
    	});
    	Object.defineProperty(exports, "TSTypeParameter", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.tsTypeParameter;
    	  }
    	});
    	Object.defineProperty(exports, "NumberLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.numberLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "RegexLiteral", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.regexLiteral;
    	  }
    	});
    	Object.defineProperty(exports, "RestProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.restProperty;
    	  }
    	});
    	Object.defineProperty(exports, "SpreadProperty", {
    	  enumerable: true,
    	  get: function () {
    	    return _index.spreadProperty;
    	  }
    	});

    	var _index = generated$7;
    } (uppercase));

    var cloneNode$3 = {};

    Object.defineProperty(cloneNode$3, "__esModule", {
      value: true
    });
    cloneNode$3.default = cloneNode$2;

    var _definitions$b = requireDefinitions$1();

    var _generated$E = generated$8;

    const has$2 = Function.call.bind(Object.prototype.hasOwnProperty);

    function cloneIfNode$1(obj, deep, withoutLoc) {
      if (obj && typeof obj.type === "string") {
        return cloneNode$2(obj, deep, withoutLoc);
      }

      return obj;
    }

    function cloneIfNodeOrArray$1(obj, deep, withoutLoc) {
      if (Array.isArray(obj)) {
        return obj.map(node => cloneIfNode$1(node, deep, withoutLoc));
      }

      return cloneIfNode$1(obj, deep, withoutLoc);
    }

    function cloneNode$2(node, deep = true, withoutLoc = false) {
      if (!node) return node;
      const {
        type
      } = node;
      const newNode = {
        type: node.type
      };

      if ((0, _generated$E.isIdentifier)(node)) {
        newNode.name = node.name;

        if (has$2(node, "optional") && typeof node.optional === "boolean") {
          newNode.optional = node.optional;
        }

        if (has$2(node, "typeAnnotation")) {
          newNode.typeAnnotation = deep ? cloneIfNodeOrArray$1(node.typeAnnotation, true, withoutLoc) : node.typeAnnotation;
        }
      } else if (!has$2(_definitions$b.NODE_FIELDS, type)) {
        throw new Error(`Unknown node type: "${type}"`);
      } else {
        for (const field of Object.keys(_definitions$b.NODE_FIELDS[type])) {
          if (has$2(node, field)) {
            if (deep) {
              newNode[field] = (0, _generated$E.isFile)(node) && field === "comments" ? maybeCloneComments$1(node.comments, deep, withoutLoc) : cloneIfNodeOrArray$1(node[field], true, withoutLoc);
            } else {
              newNode[field] = node[field];
            }
          }
        }
      }

      if (has$2(node, "loc")) {
        if (withoutLoc) {
          newNode.loc = null;
        } else {
          newNode.loc = node.loc;
        }
      }

      if (has$2(node, "leadingComments")) {
        newNode.leadingComments = maybeCloneComments$1(node.leadingComments, deep, withoutLoc);
      }

      if (has$2(node, "innerComments")) {
        newNode.innerComments = maybeCloneComments$1(node.innerComments, deep, withoutLoc);
      }

      if (has$2(node, "trailingComments")) {
        newNode.trailingComments = maybeCloneComments$1(node.trailingComments, deep, withoutLoc);
      }

      if (has$2(node, "extra")) {
        newNode.extra = Object.assign({}, node.extra);
      }

      return newNode;
    }

    function maybeCloneComments$1(comments, deep, withoutLoc) {
      if (!comments || !deep) {
        return comments;
      }

      return comments.map(({
        type,
        value,
        loc
      }) => {
        if (withoutLoc) {
          return {
            type,
            value,
            loc: null
          };
        }

        return {
          type,
          value,
          loc
        };
      });
    }

    var clone$4 = {};

    Object.defineProperty(clone$4, "__esModule", {
      value: true
    });
    clone$4.default = clone$3;

    var _cloneNode$b = cloneNode$3;

    function clone$3(node) {
      return (0, _cloneNode$b.default)(node, false);
    }

    var cloneDeep$3 = {};

    Object.defineProperty(cloneDeep$3, "__esModule", {
      value: true
    });
    cloneDeep$3.default = cloneDeep$2;

    var _cloneNode$a = cloneNode$3;

    function cloneDeep$2(node) {
      return (0, _cloneNode$a.default)(node);
    }

    var cloneDeepWithoutLoc$3 = {};

    Object.defineProperty(cloneDeepWithoutLoc$3, "__esModule", {
      value: true
    });
    cloneDeepWithoutLoc$3.default = cloneDeepWithoutLoc$2;

    var _cloneNode$9 = cloneNode$3;

    function cloneDeepWithoutLoc$2(node) {
      return (0, _cloneNode$9.default)(node, true, true);
    }

    var cloneWithoutLoc$3 = {};

    Object.defineProperty(cloneWithoutLoc$3, "__esModule", {
      value: true
    });
    cloneWithoutLoc$3.default = cloneWithoutLoc$2;

    var _cloneNode$8 = cloneNode$3;

    function cloneWithoutLoc$2(node) {
      return (0, _cloneNode$8.default)(node, false, true);
    }

    var addComment$3 = {};

    var addComments$3 = {};

    Object.defineProperty(addComments$3, "__esModule", {
      value: true
    });
    addComments$3.default = addComments$2;

    function addComments$2(node, type, comments) {
      if (!comments || !node) return node;
      const key = `${type}Comments`;

      if (node[key]) {
        if (type === "leading") {
          node[key] = comments.concat(node[key]);
        } else {
          node[key].push(...comments);
        }
      } else {
        node[key] = comments;
      }

      return node;
    }

    Object.defineProperty(addComment$3, "__esModule", {
      value: true
    });
    addComment$3.default = addComment$2;

    var _addComments$1 = addComments$3;

    function addComment$2(node, type, content, line) {
      return (0, _addComments$1.default)(node, type, [{
        type: line ? "CommentLine" : "CommentBlock",
        value: content
      }]);
    }

    var inheritInnerComments$3 = {};

    var inherit$3 = {};

    Object.defineProperty(inherit$3, "__esModule", {
      value: true
    });
    inherit$3.default = inherit$2;

    function inherit$2(key, child, parent) {
      if (child && parent) {
        child[key] = Array.from(new Set([].concat(child[key], parent[key]).filter(Boolean)));
      }
    }

    Object.defineProperty(inheritInnerComments$3, "__esModule", {
      value: true
    });
    inheritInnerComments$3.default = inheritInnerComments$2;

    var _inherit$5 = inherit$3;

    function inheritInnerComments$2(child, parent) {
      (0, _inherit$5.default)("innerComments", child, parent);
    }

    var inheritLeadingComments$3 = {};

    Object.defineProperty(inheritLeadingComments$3, "__esModule", {
      value: true
    });
    inheritLeadingComments$3.default = inheritLeadingComments$2;

    var _inherit$4 = inherit$3;

    function inheritLeadingComments$2(child, parent) {
      (0, _inherit$4.default)("leadingComments", child, parent);
    }

    var inheritsComments$3 = {};

    var inheritTrailingComments$3 = {};

    Object.defineProperty(inheritTrailingComments$3, "__esModule", {
      value: true
    });
    inheritTrailingComments$3.default = inheritTrailingComments$2;

    var _inherit$3 = inherit$3;

    function inheritTrailingComments$2(child, parent) {
      (0, _inherit$3.default)("trailingComments", child, parent);
    }

    Object.defineProperty(inheritsComments$3, "__esModule", {
      value: true
    });
    inheritsComments$3.default = inheritsComments$2;

    var _inheritTrailingComments$1 = inheritTrailingComments$3;

    var _inheritLeadingComments$1 = inheritLeadingComments$3;

    var _inheritInnerComments$1 = inheritInnerComments$3;

    function inheritsComments$2(child, parent) {
      (0, _inheritTrailingComments$1.default)(child, parent);
      (0, _inheritLeadingComments$1.default)(child, parent);
      (0, _inheritInnerComments$1.default)(child, parent);
      return child;
    }

    var removeComments$3 = {};

    Object.defineProperty(removeComments$3, "__esModule", {
      value: true
    });
    removeComments$3.default = removeComments$2;

    var _constants$9 = constants$1;

    function removeComments$2(node) {
      _constants$9.COMMENT_KEYS.forEach(key => {
        node[key] = null;
      });

      return node;
    }

    var generated$5 = {};

    Object.defineProperty(generated$5, "__esModule", {
      value: true
    });
    generated$5.TSBASETYPE_TYPES = generated$5.TSTYPE_TYPES = generated$5.TSTYPEELEMENT_TYPES = generated$5.JSX_TYPES = generated$5.ENUMMEMBER_TYPES = generated$5.ENUMBODY_TYPES = generated$5.FLOWPREDICATE_TYPES = generated$5.FLOWDECLARATION_TYPES = generated$5.FLOWBASEANNOTATION_TYPES = generated$5.FLOWTYPE_TYPES = generated$5.FLOW_TYPES = generated$5.PRIVATE_TYPES = generated$5.MODULESPECIFIER_TYPES = generated$5.EXPORTDECLARATION_TYPES = generated$5.MODULEDECLARATION_TYPES = generated$5.CLASS_TYPES = generated$5.PATTERN_TYPES = generated$5.UNARYLIKE_TYPES = generated$5.PROPERTY_TYPES = generated$5.OBJECTMEMBER_TYPES = generated$5.METHOD_TYPES = generated$5.USERWHITESPACABLE_TYPES = generated$5.IMMUTABLE_TYPES = generated$5.LITERAL_TYPES = generated$5.TSENTITYNAME_TYPES = generated$5.LVAL_TYPES = generated$5.PATTERNLIKE_TYPES = generated$5.DECLARATION_TYPES = generated$5.PUREISH_TYPES = generated$5.FUNCTIONPARENT_TYPES = generated$5.FUNCTION_TYPES = generated$5.FORXSTATEMENT_TYPES = generated$5.FOR_TYPES = generated$5.EXPRESSIONWRAPPER_TYPES = generated$5.WHILE_TYPES = generated$5.LOOP_TYPES = generated$5.CONDITIONAL_TYPES = generated$5.COMPLETIONSTATEMENT_TYPES = generated$5.TERMINATORLESS_TYPES = generated$5.STATEMENT_TYPES = generated$5.BLOCK_TYPES = generated$5.BLOCKPARENT_TYPES = generated$5.SCOPABLE_TYPES = generated$5.BINARY_TYPES = generated$5.EXPRESSION_TYPES = void 0;

    var _definitions$a = requireDefinitions$1();

    const EXPRESSION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Expression"];
    generated$5.EXPRESSION_TYPES = EXPRESSION_TYPES$1;
    const BINARY_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Binary"];
    generated$5.BINARY_TYPES = BINARY_TYPES$1;
    const SCOPABLE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Scopable"];
    generated$5.SCOPABLE_TYPES = SCOPABLE_TYPES$1;
    const BLOCKPARENT_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["BlockParent"];
    generated$5.BLOCKPARENT_TYPES = BLOCKPARENT_TYPES$1;
    const BLOCK_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Block"];
    generated$5.BLOCK_TYPES = BLOCK_TYPES$1;
    const STATEMENT_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Statement"];
    generated$5.STATEMENT_TYPES = STATEMENT_TYPES$1;
    const TERMINATORLESS_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Terminatorless"];
    generated$5.TERMINATORLESS_TYPES = TERMINATORLESS_TYPES$1;
    const COMPLETIONSTATEMENT_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["CompletionStatement"];
    generated$5.COMPLETIONSTATEMENT_TYPES = COMPLETIONSTATEMENT_TYPES$1;
    const CONDITIONAL_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Conditional"];
    generated$5.CONDITIONAL_TYPES = CONDITIONAL_TYPES$1;
    const LOOP_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Loop"];
    generated$5.LOOP_TYPES = LOOP_TYPES$1;
    const WHILE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["While"];
    generated$5.WHILE_TYPES = WHILE_TYPES$1;
    const EXPRESSIONWRAPPER_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["ExpressionWrapper"];
    generated$5.EXPRESSIONWRAPPER_TYPES = EXPRESSIONWRAPPER_TYPES$1;
    const FOR_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["For"];
    generated$5.FOR_TYPES = FOR_TYPES$1;
    const FORXSTATEMENT_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["ForXStatement"];
    generated$5.FORXSTATEMENT_TYPES = FORXSTATEMENT_TYPES$1;
    const FUNCTION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Function"];
    generated$5.FUNCTION_TYPES = FUNCTION_TYPES$1;
    const FUNCTIONPARENT_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["FunctionParent"];
    generated$5.FUNCTIONPARENT_TYPES = FUNCTIONPARENT_TYPES$1;
    const PUREISH_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Pureish"];
    generated$5.PUREISH_TYPES = PUREISH_TYPES$1;
    const DECLARATION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Declaration"];
    generated$5.DECLARATION_TYPES = DECLARATION_TYPES$1;
    const PATTERNLIKE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["PatternLike"];
    generated$5.PATTERNLIKE_TYPES = PATTERNLIKE_TYPES$1;
    const LVAL_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["LVal"];
    generated$5.LVAL_TYPES = LVAL_TYPES$1;
    const TSENTITYNAME_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["TSEntityName"];
    generated$5.TSENTITYNAME_TYPES = TSENTITYNAME_TYPES$1;
    const LITERAL_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Literal"];
    generated$5.LITERAL_TYPES = LITERAL_TYPES$1;
    const IMMUTABLE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Immutable"];
    generated$5.IMMUTABLE_TYPES = IMMUTABLE_TYPES$1;
    const USERWHITESPACABLE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["UserWhitespacable"];
    generated$5.USERWHITESPACABLE_TYPES = USERWHITESPACABLE_TYPES$1;
    const METHOD_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Method"];
    generated$5.METHOD_TYPES = METHOD_TYPES$1;
    const OBJECTMEMBER_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["ObjectMember"];
    generated$5.OBJECTMEMBER_TYPES = OBJECTMEMBER_TYPES$1;
    const PROPERTY_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Property"];
    generated$5.PROPERTY_TYPES = PROPERTY_TYPES$1;
    const UNARYLIKE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["UnaryLike"];
    generated$5.UNARYLIKE_TYPES = UNARYLIKE_TYPES$1;
    const PATTERN_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Pattern"];
    generated$5.PATTERN_TYPES = PATTERN_TYPES$1;
    const CLASS_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Class"];
    generated$5.CLASS_TYPES = CLASS_TYPES$1;
    const MODULEDECLARATION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["ModuleDeclaration"];
    generated$5.MODULEDECLARATION_TYPES = MODULEDECLARATION_TYPES$1;
    const EXPORTDECLARATION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["ExportDeclaration"];
    generated$5.EXPORTDECLARATION_TYPES = EXPORTDECLARATION_TYPES$1;
    const MODULESPECIFIER_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["ModuleSpecifier"];
    generated$5.MODULESPECIFIER_TYPES = MODULESPECIFIER_TYPES$1;
    const PRIVATE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Private"];
    generated$5.PRIVATE_TYPES = PRIVATE_TYPES$1;
    const FLOW_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["Flow"];
    generated$5.FLOW_TYPES = FLOW_TYPES$1;
    const FLOWTYPE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["FlowType"];
    generated$5.FLOWTYPE_TYPES = FLOWTYPE_TYPES$1;
    const FLOWBASEANNOTATION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["FlowBaseAnnotation"];
    generated$5.FLOWBASEANNOTATION_TYPES = FLOWBASEANNOTATION_TYPES$1;
    const FLOWDECLARATION_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["FlowDeclaration"];
    generated$5.FLOWDECLARATION_TYPES = FLOWDECLARATION_TYPES$1;
    const FLOWPREDICATE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["FlowPredicate"];
    generated$5.FLOWPREDICATE_TYPES = FLOWPREDICATE_TYPES$1;
    const ENUMBODY_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["EnumBody"];
    generated$5.ENUMBODY_TYPES = ENUMBODY_TYPES$1;
    const ENUMMEMBER_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["EnumMember"];
    generated$5.ENUMMEMBER_TYPES = ENUMMEMBER_TYPES$1;
    const JSX_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["JSX"];
    generated$5.JSX_TYPES = JSX_TYPES$1;
    const TSTYPEELEMENT_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["TSTypeElement"];
    generated$5.TSTYPEELEMENT_TYPES = TSTYPEELEMENT_TYPES$1;
    const TSTYPE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["TSType"];
    generated$5.TSTYPE_TYPES = TSTYPE_TYPES$1;
    const TSBASETYPE_TYPES$1 = _definitions$a.FLIPPED_ALIAS_KEYS["TSBaseType"];
    generated$5.TSBASETYPE_TYPES = TSBASETYPE_TYPES$1;

    var ensureBlock$3 = {};

    var toBlock$3 = {};

    Object.defineProperty(toBlock$3, "__esModule", {
      value: true
    });
    toBlock$3.default = toBlock$2;

    var _generated$D = generated$8;

    var _generated2$7 = generated$7;

    function toBlock$2(node, parent) {
      if ((0, _generated$D.isBlockStatement)(node)) {
        return node;
      }

      let blockNodes = [];

      if ((0, _generated$D.isEmptyStatement)(node)) {
        blockNodes = [];
      } else {
        if (!(0, _generated$D.isStatement)(node)) {
          if ((0, _generated$D.isFunction)(parent)) {
            node = (0, _generated2$7.returnStatement)(node);
          } else {
            node = (0, _generated2$7.expressionStatement)(node);
          }
        }

        blockNodes = [node];
      }

      return (0, _generated2$7.blockStatement)(blockNodes);
    }

    Object.defineProperty(ensureBlock$3, "__esModule", {
      value: true
    });
    ensureBlock$3.default = ensureBlock$2;

    var _toBlock$1 = toBlock$3;

    function ensureBlock$2(node, key = "body") {
      return node[key] = (0, _toBlock$1.default)(node[key], node);
    }

    var toBindingIdentifierName$3 = {};

    var toIdentifier$3 = {};

    Object.defineProperty(toIdentifier$3, "__esModule", {
      value: true
    });
    toIdentifier$3.default = toIdentifier$2;

    var _isValidIdentifier$5 = isValidIdentifier$3;

    var _helperValidatorIdentifier$1 = lib$5;

    function toIdentifier$2(input) {
      input = input + "";
      let name = "";

      for (const c of input) {
        name += (0, _helperValidatorIdentifier$1.isIdentifierChar)(c.codePointAt(0)) ? c : "-";
      }

      name = name.replace(/^[-0-9]+/, "");
      name = name.replace(/[-\s]+(.)?/g, function (match, c) {
        return c ? c.toUpperCase() : "";
      });

      if (!(0, _isValidIdentifier$5.default)(name)) {
        name = `_${name}`;
      }

      return name || "_";
    }

    Object.defineProperty(toBindingIdentifierName$3, "__esModule", {
      value: true
    });
    toBindingIdentifierName$3.default = toBindingIdentifierName$2;

    var _toIdentifier$1 = toIdentifier$3;

    function toBindingIdentifierName$2(name) {
      name = (0, _toIdentifier$1.default)(name);
      if (name === "eval" || name === "arguments") name = "_" + name;
      return name;
    }

    var toComputedKey$3 = {};

    Object.defineProperty(toComputedKey$3, "__esModule", {
      value: true
    });
    toComputedKey$3.default = toComputedKey$2;

    var _generated$C = generated$8;

    var _generated2$6 = generated$7;

    function toComputedKey$2(node, key = node.key || node.property) {
      if (!node.computed && (0, _generated$C.isIdentifier)(key)) key = (0, _generated2$6.stringLiteral)(key.name);
      return key;
    }

    var toExpression$3 = {};

    Object.defineProperty(toExpression$3, "__esModule", {
      value: true
    });
    toExpression$3.default = void 0;

    var _generated$B = generated$8;

    var _default$7 = toExpression$2;
    toExpression$3.default = _default$7;

    function toExpression$2(node) {
      if ((0, _generated$B.isExpressionStatement)(node)) {
        node = node.expression;
      }

      if ((0, _generated$B.isExpression)(node)) {
        return node;
      }

      if ((0, _generated$B.isClass)(node)) {
        node.type = "ClassExpression";
      } else if ((0, _generated$B.isFunction)(node)) {
        node.type = "FunctionExpression";
      }

      if (!(0, _generated$B.isExpression)(node)) {
        throw new Error(`cannot turn ${node.type} to an expression`);
      }

      return node;
    }

    var toKeyAlias$3 = {};

    var removePropertiesDeep$3 = {};

    var traverseFast$3 = {};

    Object.defineProperty(traverseFast$3, "__esModule", {
      value: true
    });
    traverseFast$3.default = traverseFast$2;

    var _definitions$9 = requireDefinitions$1();

    function traverseFast$2(node, enter, opts) {
      if (!node) return;
      const keys = _definitions$9.VISITOR_KEYS[node.type];
      if (!keys) return;
      opts = opts || {};
      enter(node, opts);

      for (const key of keys) {
        const subNode = node[key];

        if (Array.isArray(subNode)) {
          for (const node of subNode) {
            traverseFast$2(node, enter, opts);
          }
        } else {
          traverseFast$2(subNode, enter, opts);
        }
      }
    }

    var removeProperties$3 = {};

    Object.defineProperty(removeProperties$3, "__esModule", {
      value: true
    });
    removeProperties$3.default = removeProperties$2;

    var _constants$8 = constants$1;

    const CLEAR_KEYS$1 = ["tokens", "start", "end", "loc", "raw", "rawValue"];

    const CLEAR_KEYS_PLUS_COMMENTS$1 = _constants$8.COMMENT_KEYS.concat(["comments"]).concat(CLEAR_KEYS$1);

    function removeProperties$2(node, opts = {}) {
      const map = opts.preserveComments ? CLEAR_KEYS$1 : CLEAR_KEYS_PLUS_COMMENTS$1;

      for (const key of map) {
        if (node[key] != null) node[key] = undefined;
      }

      for (const key of Object.keys(node)) {
        if (key[0] === "_" && node[key] != null) node[key] = undefined;
      }

      const symbols = Object.getOwnPropertySymbols(node);

      for (const sym of symbols) {
        node[sym] = null;
      }
    }

    Object.defineProperty(removePropertiesDeep$3, "__esModule", {
      value: true
    });
    removePropertiesDeep$3.default = removePropertiesDeep$2;

    var _traverseFast$1 = traverseFast$3;

    var _removeProperties$1 = removeProperties$3;

    function removePropertiesDeep$2(tree, opts) {
      (0, _traverseFast$1.default)(tree, _removeProperties$1.default, opts);
      return tree;
    }

    Object.defineProperty(toKeyAlias$3, "__esModule", {
      value: true
    });
    toKeyAlias$3.default = toKeyAlias$2;

    var _generated$A = generated$8;

    var _cloneNode$7 = cloneNode$3;

    var _removePropertiesDeep$1 = removePropertiesDeep$3;

    function toKeyAlias$2(node, key = node.key) {
      let alias;

      if (node.kind === "method") {
        return toKeyAlias$2.increment() + "";
      } else if ((0, _generated$A.isIdentifier)(key)) {
        alias = key.name;
      } else if ((0, _generated$A.isStringLiteral)(key)) {
        alias = JSON.stringify(key.value);
      } else {
        alias = JSON.stringify((0, _removePropertiesDeep$1.default)((0, _cloneNode$7.default)(key)));
      }

      if (node.computed) {
        alias = `[${alias}]`;
      }

      if (node.static) {
        alias = `static:${alias}`;
      }

      return alias;
    }

    toKeyAlias$2.uid = 0;

    toKeyAlias$2.increment = function () {
      if (toKeyAlias$2.uid >= Number.MAX_SAFE_INTEGER) {
        return toKeyAlias$2.uid = 0;
      } else {
        return toKeyAlias$2.uid++;
      }
    };

    var toSequenceExpression$3 = {};

    var gatherSequenceExpressions$3 = {};

    var getBindingIdentifiers$3 = {};

    Object.defineProperty(getBindingIdentifiers$3, "__esModule", {
      value: true
    });
    getBindingIdentifiers$3.default = getBindingIdentifiers$2;

    var _generated$z = generated$8;

    function getBindingIdentifiers$2(node, duplicates, outerOnly) {
      let search = [].concat(node);
      const ids = Object.create(null);

      while (search.length) {
        const id = search.shift();
        if (!id) continue;
        const keys = getBindingIdentifiers$2.keys[id.type];

        if ((0, _generated$z.isIdentifier)(id)) {
          if (duplicates) {
            const _ids = ids[id.name] = ids[id.name] || [];

            _ids.push(id);
          } else {
            ids[id.name] = id;
          }

          continue;
        }

        if ((0, _generated$z.isExportDeclaration)(id) && !(0, _generated$z.isExportAllDeclaration)(id)) {
          if ((0, _generated$z.isDeclaration)(id.declaration)) {
            search.push(id.declaration);
          }

          continue;
        }

        if (outerOnly) {
          if ((0, _generated$z.isFunctionDeclaration)(id)) {
            search.push(id.id);
            continue;
          }

          if ((0, _generated$z.isFunctionExpression)(id)) {
            continue;
          }
        }

        if (keys) {
          for (let i = 0; i < keys.length; i++) {
            const key = keys[i];

            if (id[key]) {
              search = search.concat(id[key]);
            }
          }
        }
      }

      return ids;
    }

    getBindingIdentifiers$2.keys = {
      DeclareClass: ["id"],
      DeclareFunction: ["id"],
      DeclareModule: ["id"],
      DeclareVariable: ["id"],
      DeclareInterface: ["id"],
      DeclareTypeAlias: ["id"],
      DeclareOpaqueType: ["id"],
      InterfaceDeclaration: ["id"],
      TypeAlias: ["id"],
      OpaqueType: ["id"],
      CatchClause: ["param"],
      LabeledStatement: ["label"],
      UnaryExpression: ["argument"],
      AssignmentExpression: ["left"],
      ImportSpecifier: ["local"],
      ImportNamespaceSpecifier: ["local"],
      ImportDefaultSpecifier: ["local"],
      ImportDeclaration: ["specifiers"],
      ExportSpecifier: ["exported"],
      ExportNamespaceSpecifier: ["exported"],
      ExportDefaultSpecifier: ["exported"],
      FunctionDeclaration: ["id", "params"],
      FunctionExpression: ["id", "params"],
      ArrowFunctionExpression: ["params"],
      ObjectMethod: ["params"],
      ClassMethod: ["params"],
      ClassPrivateMethod: ["params"],
      ForInStatement: ["left"],
      ForOfStatement: ["left"],
      ClassDeclaration: ["id"],
      ClassExpression: ["id"],
      RestElement: ["argument"],
      UpdateExpression: ["argument"],
      ObjectProperty: ["value"],
      AssignmentPattern: ["left"],
      ArrayPattern: ["elements"],
      ObjectPattern: ["properties"],
      VariableDeclaration: ["declarations"],
      VariableDeclarator: ["id"]
    };

    Object.defineProperty(gatherSequenceExpressions$3, "__esModule", {
      value: true
    });
    gatherSequenceExpressions$3.default = gatherSequenceExpressions$2;

    var _getBindingIdentifiers$5 = getBindingIdentifiers$3;

    var _generated$y = generated$8;

    var _generated2$5 = generated$7;

    var _cloneNode$6 = cloneNode$3;

    function gatherSequenceExpressions$2(nodes, scope, declars) {
      const exprs = [];
      let ensureLastUndefined = true;

      for (const node of nodes) {
        if (!(0, _generated$y.isEmptyStatement)(node)) {
          ensureLastUndefined = false;
        }

        if ((0, _generated$y.isExpression)(node)) {
          exprs.push(node);
        } else if ((0, _generated$y.isExpressionStatement)(node)) {
          exprs.push(node.expression);
        } else if ((0, _generated$y.isVariableDeclaration)(node)) {
          if (node.kind !== "var") return;

          for (const declar of node.declarations) {
            const bindings = (0, _getBindingIdentifiers$5.default)(declar);

            for (const key of Object.keys(bindings)) {
              declars.push({
                kind: node.kind,
                id: (0, _cloneNode$6.default)(bindings[key])
              });
            }

            if (declar.init) {
              exprs.push((0, _generated2$5.assignmentExpression)("=", declar.id, declar.init));
            }
          }

          ensureLastUndefined = true;
        } else if ((0, _generated$y.isIfStatement)(node)) {
          const consequent = node.consequent ? gatherSequenceExpressions$2([node.consequent], scope, declars) : scope.buildUndefinedNode();
          const alternate = node.alternate ? gatherSequenceExpressions$2([node.alternate], scope, declars) : scope.buildUndefinedNode();
          if (!consequent || !alternate) return;
          exprs.push((0, _generated2$5.conditionalExpression)(node.test, consequent, alternate));
        } else if ((0, _generated$y.isBlockStatement)(node)) {
          const body = gatherSequenceExpressions$2(node.body, scope, declars);
          if (!body) return;
          exprs.push(body);
        } else if ((0, _generated$y.isEmptyStatement)(node)) {
          if (nodes.indexOf(node) === 0) {
            ensureLastUndefined = true;
          }
        } else {
          return;
        }
      }

      if (ensureLastUndefined) {
        exprs.push(scope.buildUndefinedNode());
      }

      if (exprs.length === 1) {
        return exprs[0];
      } else {
        return (0, _generated2$5.sequenceExpression)(exprs);
      }
    }

    Object.defineProperty(toSequenceExpression$3, "__esModule", {
      value: true
    });
    toSequenceExpression$3.default = toSequenceExpression$2;

    var _gatherSequenceExpressions$1 = gatherSequenceExpressions$3;

    function toSequenceExpression$2(nodes, scope) {
      if (!(nodes != null && nodes.length)) return;
      const declars = [];
      const result = (0, _gatherSequenceExpressions$1.default)(nodes, scope, declars);
      if (!result) return;

      for (const declar of declars) {
        scope.push(declar);
      }

      return result;
    }

    var toStatement$3 = {};

    Object.defineProperty(toStatement$3, "__esModule", {
      value: true
    });
    toStatement$3.default = void 0;

    var _generated$x = generated$8;

    var _generated2$4 = generated$7;

    var _default$6 = toStatement$2;
    toStatement$3.default = _default$6;

    function toStatement$2(node, ignore) {
      if ((0, _generated$x.isStatement)(node)) {
        return node;
      }

      let mustHaveId = false;
      let newType;

      if ((0, _generated$x.isClass)(node)) {
        mustHaveId = true;
        newType = "ClassDeclaration";
      } else if ((0, _generated$x.isFunction)(node)) {
        mustHaveId = true;
        newType = "FunctionDeclaration";
      } else if ((0, _generated$x.isAssignmentExpression)(node)) {
        return (0, _generated2$4.expressionStatement)(node);
      }

      if (mustHaveId && !node.id) {
        newType = false;
      }

      if (!newType) {
        if (ignore) {
          return false;
        } else {
          throw new Error(`cannot turn ${node.type} to a statement`);
        }
      }

      node.type = newType;
      return node;
    }

    var valueToNode$3 = {};

    Object.defineProperty(valueToNode$3, "__esModule", {
      value: true
    });
    valueToNode$3.default = void 0;

    var _isValidIdentifier$4 = isValidIdentifier$3;

    var _generated$w = generated$7;

    var _default$5 = valueToNode$2;
    valueToNode$3.default = _default$5;
    const objectToString$2 = Function.call.bind(Object.prototype.toString);

    function isRegExp$1(value) {
      return objectToString$2(value) === "[object RegExp]";
    }

    function isPlainObject$1(value) {
      if (typeof value !== "object" || value === null || Object.prototype.toString.call(value) !== "[object Object]") {
        return false;
      }

      const proto = Object.getPrototypeOf(value);
      return proto === null || Object.getPrototypeOf(proto) === null;
    }

    function valueToNode$2(value) {
      if (value === undefined) {
        return (0, _generated$w.identifier)("undefined");
      }

      if (value === true || value === false) {
        return (0, _generated$w.booleanLiteral)(value);
      }

      if (value === null) {
        return (0, _generated$w.nullLiteral)();
      }

      if (typeof value === "string") {
        return (0, _generated$w.stringLiteral)(value);
      }

      if (typeof value === "number") {
        let result;

        if (Number.isFinite(value)) {
          result = (0, _generated$w.numericLiteral)(Math.abs(value));
        } else {
          let numerator;

          if (Number.isNaN(value)) {
            numerator = (0, _generated$w.numericLiteral)(0);
          } else {
            numerator = (0, _generated$w.numericLiteral)(1);
          }

          result = (0, _generated$w.binaryExpression)("/", numerator, (0, _generated$w.numericLiteral)(0));
        }

        if (value < 0 || Object.is(value, -0)) {
          result = (0, _generated$w.unaryExpression)("-", result);
        }

        return result;
      }

      if (isRegExp$1(value)) {
        const pattern = value.source;
        const flags = value.toString().match(/\/([a-z]+|)$/)[1];
        return (0, _generated$w.regExpLiteral)(pattern, flags);
      }

      if (Array.isArray(value)) {
        return (0, _generated$w.arrayExpression)(value.map(valueToNode$2));
      }

      if (isPlainObject$1(value)) {
        const props = [];

        for (const key of Object.keys(value)) {
          let nodeKey;

          if ((0, _isValidIdentifier$4.default)(key)) {
            nodeKey = (0, _generated$w.identifier)(key);
          } else {
            nodeKey = (0, _generated$w.stringLiteral)(key);
          }

          props.push((0, _generated$w.objectProperty)(nodeKey, valueToNode$2(value[key])));
        }

        return (0, _generated$w.objectExpression)(props);
      }

      throw new Error("don't know how to turn this value into a node");
    }

    var appendToMemberExpression$3 = {};

    Object.defineProperty(appendToMemberExpression$3, "__esModule", {
      value: true
    });
    appendToMemberExpression$3.default = appendToMemberExpression$2;

    var _generated$v = generated$7;

    function appendToMemberExpression$2(member, append, computed = false) {
      member.object = (0, _generated$v.memberExpression)(member.object, member.property, member.computed);
      member.property = append;
      member.computed = !!computed;
      return member;
    }

    var inherits$3 = {};

    Object.defineProperty(inherits$3, "__esModule", {
      value: true
    });
    inherits$3.default = inherits$2;

    var _constants$7 = constants$1;

    var _inheritsComments$1 = inheritsComments$3;

    function inherits$2(child, parent) {
      if (!child || !parent) return child;

      for (const key of _constants$7.INHERIT_KEYS.optional) {
        if (child[key] == null) {
          child[key] = parent[key];
        }
      }

      for (const key of Object.keys(parent)) {
        if (key[0] === "_" && key !== "__clone") child[key] = parent[key];
      }

      for (const key of _constants$7.INHERIT_KEYS.force) {
        child[key] = parent[key];
      }

      (0, _inheritsComments$1.default)(child, parent);
      return child;
    }

    var prependToMemberExpression$3 = {};

    Object.defineProperty(prependToMemberExpression$3, "__esModule", {
      value: true
    });
    prependToMemberExpression$3.default = prependToMemberExpression$2;

    var _generated$u = generated$7;

    function prependToMemberExpression$2(member, prepend) {
      member.object = (0, _generated$u.memberExpression)(prepend, member.object);
      return member;
    }

    var getOuterBindingIdentifiers$3 = {};

    Object.defineProperty(getOuterBindingIdentifiers$3, "__esModule", {
      value: true
    });
    getOuterBindingIdentifiers$3.default = void 0;

    var _getBindingIdentifiers$4 = getBindingIdentifiers$3;

    var _default$4 = getOuterBindingIdentifiers$2;
    getOuterBindingIdentifiers$3.default = _default$4;

    function getOuterBindingIdentifiers$2(node, duplicates) {
      return (0, _getBindingIdentifiers$4.default)(node, duplicates, true);
    }

    var traverse$3 = {};

    Object.defineProperty(traverse$3, "__esModule", {
      value: true
    });
    traverse$3.default = traverse$2;

    var _definitions$8 = requireDefinitions$1();

    function traverse$2(node, handlers, state) {
      if (typeof handlers === "function") {
        handlers = {
          enter: handlers
        };
      }

      const {
        enter,
        exit
      } = handlers;
      traverseSimpleImpl$1(node, enter, exit, state, []);
    }

    function traverseSimpleImpl$1(node, enter, exit, state, ancestors) {
      const keys = _definitions$8.VISITOR_KEYS[node.type];
      if (!keys) return;
      if (enter) enter(node, ancestors, state);

      for (const key of keys) {
        const subNode = node[key];

        if (Array.isArray(subNode)) {
          for (let i = 0; i < subNode.length; i++) {
            const child = subNode[i];
            if (!child) continue;
            ancestors.push({
              node,
              key,
              index: i
            });
            traverseSimpleImpl$1(child, enter, exit, state, ancestors);
            ancestors.pop();
          }
        } else if (subNode) {
          ancestors.push({
            node,
            key
          });
          traverseSimpleImpl$1(subNode, enter, exit, state, ancestors);
          ancestors.pop();
        }
      }

      if (exit) exit(node, ancestors, state);
    }

    var isBinding$3 = {};

    Object.defineProperty(isBinding$3, "__esModule", {
      value: true
    });
    isBinding$3.default = isBinding$2;

    var _getBindingIdentifiers$3 = getBindingIdentifiers$3;

    function isBinding$2(node, parent, grandparent) {
      if (grandparent && node.type === "Identifier" && parent.type === "ObjectProperty" && grandparent.type === "ObjectExpression") {
        return false;
      }

      const keys = _getBindingIdentifiers$3.default.keys[parent.type];

      if (keys) {
        for (let i = 0; i < keys.length; i++) {
          const key = keys[i];
          const val = parent[key];

          if (Array.isArray(val)) {
            if (val.indexOf(node) >= 0) return true;
          } else {
            if (val === node) return true;
          }
        }
      }

      return false;
    }

    var isBlockScoped$3 = {};

    var isLet$3 = {};

    Object.defineProperty(isLet$3, "__esModule", {
      value: true
    });
    isLet$3.default = isLet$2;

    var _generated$t = generated$8;

    var _constants$6 = constants$1;

    function isLet$2(node) {
      return (0, _generated$t.isVariableDeclaration)(node) && (node.kind !== "var" || node[_constants$6.BLOCK_SCOPED_SYMBOL]);
    }

    Object.defineProperty(isBlockScoped$3, "__esModule", {
      value: true
    });
    isBlockScoped$3.default = isBlockScoped$2;

    var _generated$s = generated$8;

    var _isLet$1 = isLet$3;

    function isBlockScoped$2(node) {
      return (0, _generated$s.isFunctionDeclaration)(node) || (0, _generated$s.isClassDeclaration)(node) || (0, _isLet$1.default)(node);
    }

    var isImmutable$4 = {};

    Object.defineProperty(isImmutable$4, "__esModule", {
      value: true
    });
    isImmutable$4.default = isImmutable$3;

    var _isType$1 = requireIsType$1();

    var _generated$r = generated$8;

    function isImmutable$3(node) {
      if ((0, _isType$1.default)(node.type, "Immutable")) return true;

      if ((0, _generated$r.isIdentifier)(node)) {
        if (node.name === "undefined") {
          return true;
        } else {
          return false;
        }
      }

      return false;
    }

    var isNodesEquivalent$3 = {};

    Object.defineProperty(isNodesEquivalent$3, "__esModule", {
      value: true
    });
    isNodesEquivalent$3.default = isNodesEquivalent$2;

    var _definitions$7 = requireDefinitions$1();

    function isNodesEquivalent$2(a, b) {
      if (typeof a !== "object" || typeof b !== "object" || a == null || b == null) {
        return a === b;
      }

      if (a.type !== b.type) {
        return false;
      }

      const fields = Object.keys(_definitions$7.NODE_FIELDS[a.type] || a.type);
      const visitorKeys = _definitions$7.VISITOR_KEYS[a.type];

      for (const field of fields) {
        if (typeof a[field] !== typeof b[field]) {
          return false;
        }

        if (a[field] == null && b[field] == null) {
          continue;
        } else if (a[field] == null || b[field] == null) {
          return false;
        }

        if (Array.isArray(a[field])) {
          if (!Array.isArray(b[field])) {
            return false;
          }

          if (a[field].length !== b[field].length) {
            return false;
          }

          for (let i = 0; i < a[field].length; i++) {
            if (!isNodesEquivalent$2(a[field][i], b[field][i])) {
              return false;
            }
          }

          continue;
        }

        if (typeof a[field] === "object" && !(visitorKeys != null && visitorKeys.includes(field))) {
          for (const key of Object.keys(a[field])) {
            if (a[field][key] !== b[field][key]) {
              return false;
            }
          }

          continue;
        }

        if (!isNodesEquivalent$2(a[field], b[field])) {
          return false;
        }
      }

      return true;
    }

    var isReferenced$3 = {};

    Object.defineProperty(isReferenced$3, "__esModule", {
      value: true
    });
    isReferenced$3.default = isReferenced$2;

    function isReferenced$2(node, parent, grandparent) {
      switch (parent.type) {
        case "MemberExpression":
        case "OptionalMemberExpression":
          if (parent.property === node) {
            return !!parent.computed;
          }

          return parent.object === node;

        case "JSXMemberExpression":
          return parent.object === node;

        case "VariableDeclarator":
          return parent.init === node;

        case "ArrowFunctionExpression":
          return parent.body === node;

        case "PrivateName":
          return false;

        case "ClassMethod":
        case "ClassPrivateMethod":
        case "ObjectMethod":
          if (parent.key === node) {
            return !!parent.computed;
          }

          return false;

        case "ObjectProperty":
          if (parent.key === node) {
            return !!parent.computed;
          }

          return !grandparent || grandparent.type !== "ObjectPattern";

        case "ClassProperty":
          if (parent.key === node) {
            return !!parent.computed;
          }

          return true;

        case "ClassPrivateProperty":
          return parent.key !== node;

        case "ClassDeclaration":
        case "ClassExpression":
          return parent.superClass === node;

        case "AssignmentExpression":
          return parent.right === node;

        case "AssignmentPattern":
          return parent.right === node;

        case "LabeledStatement":
          return false;

        case "CatchClause":
          return false;

        case "RestElement":
          return false;

        case "BreakStatement":
        case "ContinueStatement":
          return false;

        case "FunctionDeclaration":
        case "FunctionExpression":
          return false;

        case "ExportNamespaceSpecifier":
        case "ExportDefaultSpecifier":
          return false;

        case "ExportSpecifier":
          if (grandparent != null && grandparent.source) {
            return false;
          }

          return parent.local === node;

        case "ImportDefaultSpecifier":
        case "ImportNamespaceSpecifier":
        case "ImportSpecifier":
          return false;

        case "ImportAttribute":
          return false;

        case "JSXAttribute":
          return false;

        case "ObjectPattern":
        case "ArrayPattern":
          return false;

        case "MetaProperty":
          return false;

        case "ObjectTypeProperty":
          return parent.key !== node;

        case "TSEnumMember":
          return parent.id !== node;

        case "TSPropertySignature":
          if (parent.key === node) {
            return !!parent.computed;
          }

          return true;
      }

      return true;
    }

    var isScope$3 = {};

    Object.defineProperty(isScope$3, "__esModule", {
      value: true
    });
    isScope$3.default = isScope$2;

    var _generated$q = generated$8;

    function isScope$2(node, parent) {
      if ((0, _generated$q.isBlockStatement)(node) && ((0, _generated$q.isFunction)(parent) || (0, _generated$q.isCatchClause)(parent))) {
        return false;
      }

      if ((0, _generated$q.isPattern)(node) && ((0, _generated$q.isFunction)(parent) || (0, _generated$q.isCatchClause)(parent))) {
        return true;
      }

      return (0, _generated$q.isScopable)(node);
    }

    var isSpecifierDefault$3 = {};

    Object.defineProperty(isSpecifierDefault$3, "__esModule", {
      value: true
    });
    isSpecifierDefault$3.default = isSpecifierDefault$2;

    var _generated$p = generated$8;

    function isSpecifierDefault$2(specifier) {
      return (0, _generated$p.isImportDefaultSpecifier)(specifier) || (0, _generated$p.isIdentifier)(specifier.imported || specifier.exported, {
        name: "default"
      });
    }

    var isValidES3Identifier$3 = {};

    Object.defineProperty(isValidES3Identifier$3, "__esModule", {
      value: true
    });
    isValidES3Identifier$3.default = isValidES3Identifier$2;

    var _isValidIdentifier$3 = isValidIdentifier$3;

    const RESERVED_WORDS_ES3_ONLY$1 = new Set(["abstract", "boolean", "byte", "char", "double", "enum", "final", "float", "goto", "implements", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "volatile"]);

    function isValidES3Identifier$2(name) {
      return (0, _isValidIdentifier$3.default)(name) && !RESERVED_WORDS_ES3_ONLY$1.has(name);
    }

    var isVar$3 = {};

    Object.defineProperty(isVar$3, "__esModule", {
      value: true
    });
    isVar$3.default = isVar$2;

    var _generated$o = generated$8;

    var _constants$5 = constants$1;

    function isVar$2(node) {
      return (0, _generated$o.isVariableDeclaration)(node, {
        kind: "var"
      }) && !node[_constants$5.BLOCK_SCOPED_SYMBOL];
    }

    var generated$4 = {};

    (function (exports) {

    	Object.defineProperty(exports, "__esModule", {
    	  value: true
    	});
    	var _exportNames = {
    	  react: true,
    	  assertNode: true,
    	  createTypeAnnotationBasedOnTypeof: true,
    	  createUnionTypeAnnotation: true,
    	  createFlowUnionType: true,
    	  createTSUnionType: true,
    	  cloneNode: true,
    	  clone: true,
    	  cloneDeep: true,
    	  cloneDeepWithoutLoc: true,
    	  cloneWithoutLoc: true,
    	  addComment: true,
    	  addComments: true,
    	  inheritInnerComments: true,
    	  inheritLeadingComments: true,
    	  inheritsComments: true,
    	  inheritTrailingComments: true,
    	  removeComments: true,
    	  ensureBlock: true,
    	  toBindingIdentifierName: true,
    	  toBlock: true,
    	  toComputedKey: true,
    	  toExpression: true,
    	  toIdentifier: true,
    	  toKeyAlias: true,
    	  toSequenceExpression: true,
    	  toStatement: true,
    	  valueToNode: true,
    	  appendToMemberExpression: true,
    	  inherits: true,
    	  prependToMemberExpression: true,
    	  removeProperties: true,
    	  removePropertiesDeep: true,
    	  removeTypeDuplicates: true,
    	  getBindingIdentifiers: true,
    	  getOuterBindingIdentifiers: true,
    	  traverse: true,
    	  traverseFast: true,
    	  shallowEqual: true,
    	  is: true,
    	  isBinding: true,
    	  isBlockScoped: true,
    	  isImmutable: true,
    	  isLet: true,
    	  isNode: true,
    	  isNodesEquivalent: true,
    	  isPlaceholderType: true,
    	  isReferenced: true,
    	  isScope: true,
    	  isSpecifierDefault: true,
    	  isType: true,
    	  isValidES3Identifier: true,
    	  isValidIdentifier: true,
    	  isVar: true,
    	  matchesPattern: true,
    	  validate: true,
    	  buildMatchMemberExpression: true
    	};
    	Object.defineProperty(exports, "assertNode", {
    	  enumerable: true,
    	  get: function () {
    	    return _assertNode.default;
    	  }
    	});
    	Object.defineProperty(exports, "createTypeAnnotationBasedOnTypeof", {
    	  enumerable: true,
    	  get: function () {
    	    return _createTypeAnnotationBasedOnTypeof.default;
    	  }
    	});
    	Object.defineProperty(exports, "createUnionTypeAnnotation", {
    	  enumerable: true,
    	  get: function () {
    	    return _createFlowUnionType.default;
    	  }
    	});
    	Object.defineProperty(exports, "createFlowUnionType", {
    	  enumerable: true,
    	  get: function () {
    	    return _createFlowUnionType.default;
    	  }
    	});
    	Object.defineProperty(exports, "createTSUnionType", {
    	  enumerable: true,
    	  get: function () {
    	    return _createTSUnionType.default;
    	  }
    	});
    	Object.defineProperty(exports, "cloneNode", {
    	  enumerable: true,
    	  get: function () {
    	    return _cloneNode.default;
    	  }
    	});
    	Object.defineProperty(exports, "clone", {
    	  enumerable: true,
    	  get: function () {
    	    return _clone.default;
    	  }
    	});
    	Object.defineProperty(exports, "cloneDeep", {
    	  enumerable: true,
    	  get: function () {
    	    return _cloneDeep.default;
    	  }
    	});
    	Object.defineProperty(exports, "cloneDeepWithoutLoc", {
    	  enumerable: true,
    	  get: function () {
    	    return _cloneDeepWithoutLoc.default;
    	  }
    	});
    	Object.defineProperty(exports, "cloneWithoutLoc", {
    	  enumerable: true,
    	  get: function () {
    	    return _cloneWithoutLoc.default;
    	  }
    	});
    	Object.defineProperty(exports, "addComment", {
    	  enumerable: true,
    	  get: function () {
    	    return _addComment.default;
    	  }
    	});
    	Object.defineProperty(exports, "addComments", {
    	  enumerable: true,
    	  get: function () {
    	    return _addComments.default;
    	  }
    	});
    	Object.defineProperty(exports, "inheritInnerComments", {
    	  enumerable: true,
    	  get: function () {
    	    return _inheritInnerComments.default;
    	  }
    	});
    	Object.defineProperty(exports, "inheritLeadingComments", {
    	  enumerable: true,
    	  get: function () {
    	    return _inheritLeadingComments.default;
    	  }
    	});
    	Object.defineProperty(exports, "inheritsComments", {
    	  enumerable: true,
    	  get: function () {
    	    return _inheritsComments.default;
    	  }
    	});
    	Object.defineProperty(exports, "inheritTrailingComments", {
    	  enumerable: true,
    	  get: function () {
    	    return _inheritTrailingComments.default;
    	  }
    	});
    	Object.defineProperty(exports, "removeComments", {
    	  enumerable: true,
    	  get: function () {
    	    return _removeComments.default;
    	  }
    	});
    	Object.defineProperty(exports, "ensureBlock", {
    	  enumerable: true,
    	  get: function () {
    	    return _ensureBlock.default;
    	  }
    	});
    	Object.defineProperty(exports, "toBindingIdentifierName", {
    	  enumerable: true,
    	  get: function () {
    	    return _toBindingIdentifierName.default;
    	  }
    	});
    	Object.defineProperty(exports, "toBlock", {
    	  enumerable: true,
    	  get: function () {
    	    return _toBlock.default;
    	  }
    	});
    	Object.defineProperty(exports, "toComputedKey", {
    	  enumerable: true,
    	  get: function () {
    	    return _toComputedKey.default;
    	  }
    	});
    	Object.defineProperty(exports, "toExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _toExpression.default;
    	  }
    	});
    	Object.defineProperty(exports, "toIdentifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _toIdentifier.default;
    	  }
    	});
    	Object.defineProperty(exports, "toKeyAlias", {
    	  enumerable: true,
    	  get: function () {
    	    return _toKeyAlias.default;
    	  }
    	});
    	Object.defineProperty(exports, "toSequenceExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _toSequenceExpression.default;
    	  }
    	});
    	Object.defineProperty(exports, "toStatement", {
    	  enumerable: true,
    	  get: function () {
    	    return _toStatement.default;
    	  }
    	});
    	Object.defineProperty(exports, "valueToNode", {
    	  enumerable: true,
    	  get: function () {
    	    return _valueToNode.default;
    	  }
    	});
    	Object.defineProperty(exports, "appendToMemberExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _appendToMemberExpression.default;
    	  }
    	});
    	Object.defineProperty(exports, "inherits", {
    	  enumerable: true,
    	  get: function () {
    	    return _inherits.default;
    	  }
    	});
    	Object.defineProperty(exports, "prependToMemberExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _prependToMemberExpression.default;
    	  }
    	});
    	Object.defineProperty(exports, "removeProperties", {
    	  enumerable: true,
    	  get: function () {
    	    return _removeProperties.default;
    	  }
    	});
    	Object.defineProperty(exports, "removePropertiesDeep", {
    	  enumerable: true,
    	  get: function () {
    	    return _removePropertiesDeep.default;
    	  }
    	});
    	Object.defineProperty(exports, "removeTypeDuplicates", {
    	  enumerable: true,
    	  get: function () {
    	    return _removeTypeDuplicates.default;
    	  }
    	});
    	Object.defineProperty(exports, "getBindingIdentifiers", {
    	  enumerable: true,
    	  get: function () {
    	    return _getBindingIdentifiers.default;
    	  }
    	});
    	Object.defineProperty(exports, "getOuterBindingIdentifiers", {
    	  enumerable: true,
    	  get: function () {
    	    return _getOuterBindingIdentifiers.default;
    	  }
    	});
    	Object.defineProperty(exports, "traverse", {
    	  enumerable: true,
    	  get: function () {
    	    return _traverse.default;
    	  }
    	});
    	Object.defineProperty(exports, "traverseFast", {
    	  enumerable: true,
    	  get: function () {
    	    return _traverseFast.default;
    	  }
    	});
    	Object.defineProperty(exports, "shallowEqual", {
    	  enumerable: true,
    	  get: function () {
    	    return _shallowEqual.default;
    	  }
    	});
    	Object.defineProperty(exports, "is", {
    	  enumerable: true,
    	  get: function () {
    	    return _is.default;
    	  }
    	});
    	Object.defineProperty(exports, "isBinding", {
    	  enumerable: true,
    	  get: function () {
    	    return _isBinding.default;
    	  }
    	});
    	Object.defineProperty(exports, "isBlockScoped", {
    	  enumerable: true,
    	  get: function () {
    	    return _isBlockScoped.default;
    	  }
    	});
    	Object.defineProperty(exports, "isImmutable", {
    	  enumerable: true,
    	  get: function () {
    	    return _isImmutable.default;
    	  }
    	});
    	Object.defineProperty(exports, "isLet", {
    	  enumerable: true,
    	  get: function () {
    	    return _isLet.default;
    	  }
    	});
    	Object.defineProperty(exports, "isNode", {
    	  enumerable: true,
    	  get: function () {
    	    return _isNode.default;
    	  }
    	});
    	Object.defineProperty(exports, "isNodesEquivalent", {
    	  enumerable: true,
    	  get: function () {
    	    return _isNodesEquivalent.default;
    	  }
    	});
    	Object.defineProperty(exports, "isPlaceholderType", {
    	  enumerable: true,
    	  get: function () {
    	    return _isPlaceholderType.default;
    	  }
    	});
    	Object.defineProperty(exports, "isReferenced", {
    	  enumerable: true,
    	  get: function () {
    	    return _isReferenced.default;
    	  }
    	});
    	Object.defineProperty(exports, "isScope", {
    	  enumerable: true,
    	  get: function () {
    	    return _isScope.default;
    	  }
    	});
    	Object.defineProperty(exports, "isSpecifierDefault", {
    	  enumerable: true,
    	  get: function () {
    	    return _isSpecifierDefault.default;
    	  }
    	});
    	Object.defineProperty(exports, "isType", {
    	  enumerable: true,
    	  get: function () {
    	    return _isType.default;
    	  }
    	});
    	Object.defineProperty(exports, "isValidES3Identifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _isValidES3Identifier.default;
    	  }
    	});
    	Object.defineProperty(exports, "isValidIdentifier", {
    	  enumerable: true,
    	  get: function () {
    	    return _isValidIdentifier.default;
    	  }
    	});
    	Object.defineProperty(exports, "isVar", {
    	  enumerable: true,
    	  get: function () {
    	    return _isVar.default;
    	  }
    	});
    	Object.defineProperty(exports, "matchesPattern", {
    	  enumerable: true,
    	  get: function () {
    	    return _matchesPattern.default;
    	  }
    	});
    	Object.defineProperty(exports, "validate", {
    	  enumerable: true,
    	  get: function () {
    	    return _validate.default;
    	  }
    	});
    	Object.defineProperty(exports, "buildMatchMemberExpression", {
    	  enumerable: true,
    	  get: function () {
    	    return _buildMatchMemberExpression.default;
    	  }
    	});
    	exports.react = void 0;

    	var _isReactComponent = isReactComponent$4;

    	var _isCompatTag = isCompatTag$3;

    	var _buildChildren = buildChildren$3;

    	var _assertNode = assertNode$3;

    	var _generated = generated$6;

    	Object.keys(_generated).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _generated[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _generated[key];
    	    }
    	  });
    	});

    	var _createTypeAnnotationBasedOnTypeof = createTypeAnnotationBasedOnTypeof$3;

    	var _createFlowUnionType = createFlowUnionType$3;

    	var _createTSUnionType = createTSUnionType$3;

    	var _generated2 = generated$7;

    	Object.keys(_generated2).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _generated2[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _generated2[key];
    	    }
    	  });
    	});

    	var _uppercase = uppercase;

    	Object.keys(_uppercase).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _uppercase[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _uppercase[key];
    	    }
    	  });
    	});

    	var _cloneNode = cloneNode$3;

    	var _clone = clone$4;

    	var _cloneDeep = cloneDeep$3;

    	var _cloneDeepWithoutLoc = cloneDeepWithoutLoc$3;

    	var _cloneWithoutLoc = cloneWithoutLoc$3;

    	var _addComment = addComment$3;

    	var _addComments = addComments$3;

    	var _inheritInnerComments = inheritInnerComments$3;

    	var _inheritLeadingComments = inheritLeadingComments$3;

    	var _inheritsComments = inheritsComments$3;

    	var _inheritTrailingComments = inheritTrailingComments$3;

    	var _removeComments = removeComments$3;

    	var _generated3 = generated$5;

    	Object.keys(_generated3).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _generated3[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _generated3[key];
    	    }
    	  });
    	});

    	var _constants = constants$1;

    	Object.keys(_constants).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _constants[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _constants[key];
    	    }
    	  });
    	});

    	var _ensureBlock = ensureBlock$3;

    	var _toBindingIdentifierName = toBindingIdentifierName$3;

    	var _toBlock = toBlock$3;

    	var _toComputedKey = toComputedKey$3;

    	var _toExpression = toExpression$3;

    	var _toIdentifier = toIdentifier$3;

    	var _toKeyAlias = toKeyAlias$3;

    	var _toSequenceExpression = toSequenceExpression$3;

    	var _toStatement = toStatement$3;

    	var _valueToNode = valueToNode$3;

    	var _definitions = requireDefinitions$1();

    	Object.keys(_definitions).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _definitions[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _definitions[key];
    	    }
    	  });
    	});

    	var _appendToMemberExpression = appendToMemberExpression$3;

    	var _inherits = inherits$3;

    	var _prependToMemberExpression = prependToMemberExpression$3;

    	var _removeProperties = removeProperties$3;

    	var _removePropertiesDeep = removePropertiesDeep$3;

    	var _removeTypeDuplicates = removeTypeDuplicates$7;

    	var _getBindingIdentifiers = getBindingIdentifiers$3;

    	var _getOuterBindingIdentifiers = getOuterBindingIdentifiers$3;

    	var _traverse = traverse$3;

    	Object.keys(_traverse).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _traverse[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _traverse[key];
    	    }
    	  });
    	});

    	var _traverseFast = traverseFast$3;

    	var _shallowEqual = shallowEqual$3;

    	var _is = requireIs$1();

    	var _isBinding = isBinding$3;

    	var _isBlockScoped = isBlockScoped$3;

    	var _isImmutable = isImmutable$4;

    	var _isLet = isLet$3;

    	var _isNode = isNode$4;

    	var _isNodesEquivalent = isNodesEquivalent$3;

    	var _isPlaceholderType = requireIsPlaceholderType$1();

    	var _isReferenced = isReferenced$3;

    	var _isScope = isScope$3;

    	var _isSpecifierDefault = isSpecifierDefault$3;

    	var _isType = requireIsType$1();

    	var _isValidES3Identifier = isValidES3Identifier$3;

    	var _isValidIdentifier = isValidIdentifier$3;

    	var _isVar = isVar$3;

    	var _matchesPattern = matchesPattern$3;

    	var _validate = requireValidate$1();

    	var _buildMatchMemberExpression = buildMatchMemberExpression$3;

    	var _generated4 = generated$8;

    	Object.keys(_generated4).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _generated4[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _generated4[key];
    	    }
    	  });
    	});

    	var _generated5 = generated$4;

    	Object.keys(_generated5).forEach(function (key) {
    	  if (key === "default" || key === "__esModule") return;
    	  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
    	  if (key in exports && exports[key] === _generated5[key]) return;
    	  Object.defineProperty(exports, key, {
    	    enumerable: true,
    	    get: function () {
    	      return _generated5[key];
    	    }
    	  });
    	});
    	const react = {
    	  isReactComponent: _isReactComponent.default,
    	  isCompatTag: _isCompatTag.default,
    	  buildChildren: _buildChildren.default
    	};
    	exports.react = react;
    } (lib$6));

    /* This Source Code Form is subject to the terms of the Mozilla Public
     * License, v. 2.0. If a copy of the MPL was not distributed with this
     * file, You can obtain one at <http://mozilla.org/MPL/2.0/>. */

    function createSimplePath(ancestors) {
      if (ancestors.length === 0) {
        return null;
      }

      // Slice the array because babel-types traverse may continue mutating
      // the ancestors array in later traversal logic.
      return new SimplePath(ancestors.slice());
    }

    /**
     * Mimics @babel/traverse's NodePath API in a simpler fashion that isn't as
     * heavy, but still allows the ease of passing paths around to process nested
     * AST structures.
     */
    class SimplePath {
      _index;
      _ancestors;
      _ancestor;

      _parentPath;

      constructor(ancestors, index = ancestors.length - 1) {
        if (index < 0 || index >= ancestors.length) {
          console.error(ancestors);
          throw new Error("Created invalid path");
        }

        this._ancestors = ancestors;
        this._ancestor = ancestors[index];
        this._index = index;
      }

      get parentPath() {
        let path = this._parentPath;
        if (path === undefined) {
          if (this._index === 0) {
            path = null;
          } else {
            path = new SimplePath(this._ancestors, this._index - 1);
          }
          this._parentPath = path;
        }

        return path;
      }

      get parent() {
        return this._ancestor.node;
      }

      get node() {
        const { node, key, index } = this._ancestor;

        if (typeof index === "number") {
          return node[key][index];
        }

        return node[key];
      }

      get key() {
        return this._ancestor.key;
      }

      set node(replacement) {
        if (this.type !== "Identifier") {
          throw new Error(
            "Replacing anything other than leaf nodes is undefined behavior " +
              "in t.traverse()"
          );
        }

        const { node, key, index } = this._ancestor;
        if (typeof index === "number") {
          node[key][index] = replacement;
        } else {
          node[key] = replacement;
        }
      }

      get type() {
        return this.node.type;
      }

      get inList() {
        return typeof this._ancestor.index === "number";
      }

      get containerIndex() {
        const { index } = this._ancestor;

        if (typeof index !== "number") {
          throw new Error("Cannot get index of non-array node");
        }

        return index;
      }

      get depth() {
        return this._index;
      }

      replace(node) {
        this.node = node;
      }

      find(predicate) {
        for (let path = this; path; path = path.parentPath) {
          if (predicate(path)) {
            return path;
          }
        }
        return null;
      }

      findParent(predicate) {
        if (!this.parentPath) {
          throw new Error("Cannot use findParent on root path");
        }

        return this.parentPath.find(predicate);
      }

      getSibling(offset) {
        const { node, key, index } = this._ancestor;

        if (typeof index !== "number") {
          throw new Error("Non-array nodes do not have siblings");
        }

        const container = node[key];

        const siblingIndex = index + offset;
        if (siblingIndex < 0 || siblingIndex >= container.length) {
          return null;
        }

        return new SimplePath(
          this._ancestors.slice(0, -1).concat([{ node, key, index: siblingIndex }])
        );
      }
    }

    var dist = {};

    var lib$4 = {};

    var isReactComponent$2 = {};

    var buildMatchMemberExpression$1 = {};

    var matchesPattern$1 = {};

    var generated$3 = {};

    var shallowEqual$1 = {};

    Object.defineProperty(shallowEqual$1, "__esModule", {
      value: true
    });
    shallowEqual$1.default = shallowEqual;

    function shallowEqual(actual, expected) {
      const keys = Object.keys(expected);

      for (const key of keys) {
        if (actual[key] !== expected[key]) {
          return false;
        }
      }

      return true;
    }

    Object.defineProperty(generated$3, "__esModule", {
      value: true
    });
    generated$3.isArrayExpression = isArrayExpression$1;
    generated$3.isAssignmentExpression = isAssignmentExpression$2;
    generated$3.isBinaryExpression = isBinaryExpression$1;
    generated$3.isInterpreterDirective = isInterpreterDirective;
    generated$3.isDirective = isDirective;
    generated$3.isDirectiveLiteral = isDirectiveLiteral;
    generated$3.isBlockStatement = isBlockStatement$1;
    generated$3.isBreakStatement = isBreakStatement;
    generated$3.isCallExpression = isCallExpression$4;
    generated$3.isCatchClause = isCatchClause;
    generated$3.isConditionalExpression = isConditionalExpression$1;
    generated$3.isContinueStatement = isContinueStatement;
    generated$3.isDebuggerStatement = isDebuggerStatement;
    generated$3.isDoWhileStatement = isDoWhileStatement;
    generated$3.isEmptyStatement = isEmptyStatement$1;
    generated$3.isExpressionStatement = isExpressionStatement$2;
    generated$3.isFile = isFile$1;
    generated$3.isForInStatement = isForInStatement$1;
    generated$3.isForStatement = isForStatement$2;
    generated$3.isFunctionDeclaration = isFunctionDeclaration;
    generated$3.isFunctionExpression = isFunctionExpression;
    generated$3.isIdentifier = isIdentifier$3;
    generated$3.isIfStatement = isIfStatement$2;
    generated$3.isLabeledStatement = isLabeledStatement;
    generated$3.isStringLiteral = isStringLiteral$1;
    generated$3.isNumericLiteral = isNumericLiteral;
    generated$3.isNullLiteral = isNullLiteral;
    generated$3.isBooleanLiteral = isBooleanLiteral;
    generated$3.isRegExpLiteral = isRegExpLiteral;
    generated$3.isLogicalExpression = isLogicalExpression$1;
    generated$3.isMemberExpression = isMemberExpression$4;
    generated$3.isNewExpression = isNewExpression$3;
    generated$3.isProgram = isProgram$1;
    generated$3.isObjectExpression = isObjectExpression$1;
    generated$3.isObjectMethod = isObjectMethod;
    generated$3.isObjectProperty = isObjectProperty;
    generated$3.isRestElement = isRestElement;
    generated$3.isReturnStatement = isReturnStatement$1;
    generated$3.isSequenceExpression = isSequenceExpression$1;
    generated$3.isParenthesizedExpression = isParenthesizedExpression;
    generated$3.isSwitchCase = isSwitchCase;
    generated$3.isSwitchStatement = isSwitchStatement$1;
    generated$3.isThisExpression = isThisExpression;
    generated$3.isThrowStatement = isThrowStatement$1;
    generated$3.isTryStatement = isTryStatement;
    generated$3.isUnaryExpression = isUnaryExpression;
    generated$3.isUpdateExpression = isUpdateExpression;
    generated$3.isVariableDeclaration = isVariableDeclaration;
    generated$3.isVariableDeclarator = isVariableDeclarator$1;
    generated$3.isWhileStatement = isWhileStatement$1;
    generated$3.isWithStatement = isWithStatement;
    generated$3.isAssignmentPattern = isAssignmentPattern$1;
    generated$3.isArrayPattern = isArrayPattern;
    generated$3.isArrowFunctionExpression = isArrowFunctionExpression$1;
    generated$3.isClassBody = isClassBody;
    generated$3.isClassExpression = isClassExpression$1;
    generated$3.isClassDeclaration = isClassDeclaration$2;
    generated$3.isExportAllDeclaration = isExportAllDeclaration;
    generated$3.isExportDefaultDeclaration = isExportDefaultDeclaration$2;
    generated$3.isExportNamedDeclaration = isExportNamedDeclaration$1;
    generated$3.isExportSpecifier = isExportSpecifier;
    generated$3.isForOfStatement = isForOfStatement$1;
    generated$3.isImportDeclaration = isImportDeclaration;
    generated$3.isImportDefaultSpecifier = isImportDefaultSpecifier$1;
    generated$3.isImportNamespaceSpecifier = isImportNamespaceSpecifier$1;
    generated$3.isImportSpecifier = isImportSpecifier;
    generated$3.isMetaProperty = isMetaProperty;
    generated$3.isClassMethod = isClassMethod;
    generated$3.isObjectPattern = isObjectPattern$1;
    generated$3.isSpreadElement = isSpreadElement;
    generated$3.isSuper = isSuper;
    generated$3.isTaggedTemplateExpression = isTaggedTemplateExpression$1;
    generated$3.isTemplateElement = isTemplateElement;
    generated$3.isTemplateLiteral = isTemplateLiteral;
    generated$3.isYieldExpression = isYieldExpression$1;
    generated$3.isAnyTypeAnnotation = isAnyTypeAnnotation;
    generated$3.isArrayTypeAnnotation = isArrayTypeAnnotation$1;
    generated$3.isBooleanTypeAnnotation = isBooleanTypeAnnotation;
    generated$3.isBooleanLiteralTypeAnnotation = isBooleanLiteralTypeAnnotation;
    generated$3.isNullLiteralTypeAnnotation = isNullLiteralTypeAnnotation;
    generated$3.isClassImplements = isClassImplements;
    generated$3.isDeclareClass = isDeclareClass;
    generated$3.isDeclareFunction = isDeclareFunction;
    generated$3.isDeclareInterface = isDeclareInterface;
    generated$3.isDeclareModule = isDeclareModule;
    generated$3.isDeclareModuleExports = isDeclareModuleExports;
    generated$3.isDeclareTypeAlias = isDeclareTypeAlias;
    generated$3.isDeclareOpaqueType = isDeclareOpaqueType;
    generated$3.isDeclareVariable = isDeclareVariable;
    generated$3.isDeclareExportDeclaration = isDeclareExportDeclaration;
    generated$3.isDeclareExportAllDeclaration = isDeclareExportAllDeclaration;
    generated$3.isDeclaredPredicate = isDeclaredPredicate;
    generated$3.isExistsTypeAnnotation = isExistsTypeAnnotation;
    generated$3.isFunctionTypeAnnotation = isFunctionTypeAnnotation;
    generated$3.isFunctionTypeParam = isFunctionTypeParam;
    generated$3.isGenericTypeAnnotation = isGenericTypeAnnotation;
    generated$3.isInferredPredicate = isInferredPredicate;
    generated$3.isInterfaceExtends = isInterfaceExtends;
    generated$3.isInterfaceDeclaration = isInterfaceDeclaration;
    generated$3.isInterfaceTypeAnnotation = isInterfaceTypeAnnotation;
    generated$3.isIntersectionTypeAnnotation = isIntersectionTypeAnnotation$1;
    generated$3.isMixedTypeAnnotation = isMixedTypeAnnotation;
    generated$3.isEmptyTypeAnnotation = isEmptyTypeAnnotation;
    generated$3.isNullableTypeAnnotation = isNullableTypeAnnotation$1;
    generated$3.isNumberLiteralTypeAnnotation = isNumberLiteralTypeAnnotation;
    generated$3.isNumberTypeAnnotation = isNumberTypeAnnotation;
    generated$3.isObjectTypeAnnotation = isObjectTypeAnnotation;
    generated$3.isObjectTypeInternalSlot = isObjectTypeInternalSlot;
    generated$3.isObjectTypeCallProperty = isObjectTypeCallProperty;
    generated$3.isObjectTypeIndexer = isObjectTypeIndexer;
    generated$3.isObjectTypeProperty = isObjectTypeProperty;
    generated$3.isObjectTypeSpreadProperty = isObjectTypeSpreadProperty;
    generated$3.isOpaqueType = isOpaqueType;
    generated$3.isQualifiedTypeIdentifier = isQualifiedTypeIdentifier;
    generated$3.isStringLiteralTypeAnnotation = isStringLiteralTypeAnnotation;
    generated$3.isStringTypeAnnotation = isStringTypeAnnotation;
    generated$3.isSymbolTypeAnnotation = isSymbolTypeAnnotation;
    generated$3.isThisTypeAnnotation = isThisTypeAnnotation;
    generated$3.isTupleTypeAnnotation = isTupleTypeAnnotation;
    generated$3.isTypeofTypeAnnotation = isTypeofTypeAnnotation;
    generated$3.isTypeAlias = isTypeAlias;
    generated$3.isTypeAnnotation = isTypeAnnotation$1;
    generated$3.isTypeCastExpression = isTypeCastExpression;
    generated$3.isTypeParameter = isTypeParameter;
    generated$3.isTypeParameterDeclaration = isTypeParameterDeclaration;
    generated$3.isTypeParameterInstantiation = isTypeParameterInstantiation;
    generated$3.isUnionTypeAnnotation = isUnionTypeAnnotation$1;
    generated$3.isVariance = isVariance;
    generated$3.isVoidTypeAnnotation = isVoidTypeAnnotation;
    generated$3.isEnumDeclaration = isEnumDeclaration;
    generated$3.isEnumBooleanBody = isEnumBooleanBody;
    generated$3.isEnumNumberBody = isEnumNumberBody;
    generated$3.isEnumStringBody = isEnumStringBody;
    generated$3.isEnumSymbolBody = isEnumSymbolBody;
    generated$3.isEnumBooleanMember = isEnumBooleanMember;
    generated$3.isEnumNumberMember = isEnumNumberMember;
    generated$3.isEnumStringMember = isEnumStringMember;
    generated$3.isEnumDefaultedMember = isEnumDefaultedMember;
    generated$3.isJSXAttribute = isJSXAttribute;
    generated$3.isJSXClosingElement = isJSXClosingElement;
    generated$3.isJSXElement = isJSXElement;
    generated$3.isJSXEmptyExpression = isJSXEmptyExpression;
    generated$3.isJSXExpressionContainer = isJSXExpressionContainer;
    generated$3.isJSXSpreadChild = isJSXSpreadChild;
    generated$3.isJSXIdentifier = isJSXIdentifier;
    generated$3.isJSXMemberExpression = isJSXMemberExpression;
    generated$3.isJSXNamespacedName = isJSXNamespacedName;
    generated$3.isJSXOpeningElement = isJSXOpeningElement;
    generated$3.isJSXSpreadAttribute = isJSXSpreadAttribute;
    generated$3.isJSXText = isJSXText;
    generated$3.isJSXFragment = isJSXFragment;
    generated$3.isJSXOpeningFragment = isJSXOpeningFragment;
    generated$3.isJSXClosingFragment = isJSXClosingFragment;
    generated$3.isNoop = isNoop;
    generated$3.isPlaceholder = isPlaceholder;
    generated$3.isV8IntrinsicIdentifier = isV8IntrinsicIdentifier;
    generated$3.isArgumentPlaceholder = isArgumentPlaceholder;
    generated$3.isAwaitExpression = isAwaitExpression$1;
    generated$3.isBindExpression = isBindExpression;
    generated$3.isClassProperty = isClassProperty;
    generated$3.isOptionalMemberExpression = isOptionalMemberExpression$2;
    generated$3.isPipelineTopicExpression = isPipelineTopicExpression;
    generated$3.isPipelineBareFunction = isPipelineBareFunction;
    generated$3.isPipelinePrimaryTopicReference = isPipelinePrimaryTopicReference;
    generated$3.isOptionalCallExpression = isOptionalCallExpression$2;
    generated$3.isClassPrivateProperty = isClassPrivateProperty;
    generated$3.isClassPrivateMethod = isClassPrivateMethod;
    generated$3.isImport = isImport;
    generated$3.isImportAttribute = isImportAttribute;
    generated$3.isDecorator = isDecorator;
    generated$3.isDoExpression = isDoExpression;
    generated$3.isExportDefaultSpecifier = isExportDefaultSpecifier$1;
    generated$3.isExportNamespaceSpecifier = isExportNamespaceSpecifier$1;
    generated$3.isPrivateName = isPrivateName;
    generated$3.isBigIntLiteral = isBigIntLiteral;
    generated$3.isRecordExpression = isRecordExpression;
    generated$3.isTupleExpression = isTupleExpression;
    generated$3.isTSParameterProperty = isTSParameterProperty;
    generated$3.isTSDeclareFunction = isTSDeclareFunction;
    generated$3.isTSDeclareMethod = isTSDeclareMethod;
    generated$3.isTSQualifiedName = isTSQualifiedName;
    generated$3.isTSCallSignatureDeclaration = isTSCallSignatureDeclaration;
    generated$3.isTSConstructSignatureDeclaration = isTSConstructSignatureDeclaration;
    generated$3.isTSPropertySignature = isTSPropertySignature;
    generated$3.isTSMethodSignature = isTSMethodSignature;
    generated$3.isTSIndexSignature = isTSIndexSignature;
    generated$3.isTSAnyKeyword = isTSAnyKeyword;
    generated$3.isTSBooleanKeyword = isTSBooleanKeyword;
    generated$3.isTSBigIntKeyword = isTSBigIntKeyword;
    generated$3.isTSNeverKeyword = isTSNeverKeyword;
    generated$3.isTSNullKeyword = isTSNullKeyword;
    generated$3.isTSNumberKeyword = isTSNumberKeyword;
    generated$3.isTSObjectKeyword = isTSObjectKeyword;
    generated$3.isTSStringKeyword = isTSStringKeyword;
    generated$3.isTSSymbolKeyword = isTSSymbolKeyword;
    generated$3.isTSUndefinedKeyword = isTSUndefinedKeyword;
    generated$3.isTSUnknownKeyword = isTSUnknownKeyword;
    generated$3.isTSVoidKeyword = isTSVoidKeyword;
    generated$3.isTSThisType = isTSThisType;
    generated$3.isTSFunctionType = isTSFunctionType;
    generated$3.isTSConstructorType = isTSConstructorType;
    generated$3.isTSTypeReference = isTSTypeReference;
    generated$3.isTSTypePredicate = isTSTypePredicate;
    generated$3.isTSTypeQuery = isTSTypeQuery;
    generated$3.isTSTypeLiteral = isTSTypeLiteral;
    generated$3.isTSArrayType = isTSArrayType$1;
    generated$3.isTSTupleType = isTSTupleType;
    generated$3.isTSOptionalType = isTSOptionalType$1;
    generated$3.isTSRestType = isTSRestType$1;
    generated$3.isTSUnionType = isTSUnionType$1;
    generated$3.isTSIntersectionType = isTSIntersectionType$1;
    generated$3.isTSConditionalType = isTSConditionalType;
    generated$3.isTSInferType = isTSInferType;
    generated$3.isTSParenthesizedType = isTSParenthesizedType;
    generated$3.isTSTypeOperator = isTSTypeOperator;
    generated$3.isTSIndexedAccessType = isTSIndexedAccessType;
    generated$3.isTSMappedType = isTSMappedType;
    generated$3.isTSLiteralType = isTSLiteralType;
    generated$3.isTSExpressionWithTypeArguments = isTSExpressionWithTypeArguments;
    generated$3.isTSInterfaceDeclaration = isTSInterfaceDeclaration;
    generated$3.isTSInterfaceBody = isTSInterfaceBody;
    generated$3.isTSTypeAliasDeclaration = isTSTypeAliasDeclaration;
    generated$3.isTSAsExpression = isTSAsExpression$1;
    generated$3.isTSTypeAssertion = isTSTypeAssertion$1;
    generated$3.isTSEnumDeclaration = isTSEnumDeclaration;
    generated$3.isTSEnumMember = isTSEnumMember;
    generated$3.isTSModuleDeclaration = isTSModuleDeclaration;
    generated$3.isTSModuleBlock = isTSModuleBlock;
    generated$3.isTSImportType = isTSImportType;
    generated$3.isTSImportEqualsDeclaration = isTSImportEqualsDeclaration;
    generated$3.isTSExternalModuleReference = isTSExternalModuleReference;
    generated$3.isTSNonNullExpression = isTSNonNullExpression$1;
    generated$3.isTSExportAssignment = isTSExportAssignment;
    generated$3.isTSNamespaceExportDeclaration = isTSNamespaceExportDeclaration;
    generated$3.isTSTypeAnnotation = isTSTypeAnnotation;
    generated$3.isTSTypeParameterInstantiation = isTSTypeParameterInstantiation;
    generated$3.isTSTypeParameterDeclaration = isTSTypeParameterDeclaration;
    generated$3.isTSTypeParameter = isTSTypeParameter;
    generated$3.isExpression = isExpression;
    generated$3.isBinary = isBinary$2;
    generated$3.isScopable = isScopable;
    generated$3.isBlockParent = isBlockParent;
    generated$3.isBlock = isBlock;
    generated$3.isStatement = isStatement$2;
    generated$3.isTerminatorless = isTerminatorless;
    generated$3.isCompletionStatement = isCompletionStatement;
    generated$3.isConditional = isConditional$1;
    generated$3.isLoop = isLoop$2;
    generated$3.isWhile = isWhile;
    generated$3.isExpressionWrapper = isExpressionWrapper;
    generated$3.isFor = isFor$2;
    generated$3.isForXStatement = isForXStatement;
    generated$3.isFunction = isFunction$6;
    generated$3.isFunctionParent = isFunctionParent;
    generated$3.isPureish = isPureish;
    generated$3.isDeclaration = isDeclaration;
    generated$3.isPatternLike = isPatternLike;
    generated$3.isLVal = isLVal;
    generated$3.isTSEntityName = isTSEntityName;
    generated$3.isLiteral = isLiteral$2;
    generated$3.isImmutable = isImmutable$2;
    generated$3.isUserWhitespacable = isUserWhitespacable;
    generated$3.isMethod = isMethod;
    generated$3.isObjectMember = isObjectMember;
    generated$3.isProperty = isProperty;
    generated$3.isUnaryLike = isUnaryLike$1;
    generated$3.isPattern = isPattern;
    generated$3.isClass = isClass;
    generated$3.isModuleDeclaration = isModuleDeclaration;
    generated$3.isExportDeclaration = isExportDeclaration$1;
    generated$3.isModuleSpecifier = isModuleSpecifier;
    generated$3.isFlow = isFlow;
    generated$3.isFlowType = isFlowType;
    generated$3.isFlowBaseAnnotation = isFlowBaseAnnotation;
    generated$3.isFlowDeclaration = isFlowDeclaration;
    generated$3.isFlowPredicate = isFlowPredicate;
    generated$3.isEnumBody = isEnumBody;
    generated$3.isEnumMember = isEnumMember;
    generated$3.isJSX = isJSX;
    generated$3.isPrivate = isPrivate;
    generated$3.isTSTypeElement = isTSTypeElement;
    generated$3.isTSType = isTSType;
    generated$3.isTSBaseType = isTSBaseType;
    generated$3.isNumberLiteral = isNumberLiteral;
    generated$3.isRegexLiteral = isRegexLiteral;
    generated$3.isRestProperty = isRestProperty;
    generated$3.isSpreadProperty = isSpreadProperty;

    var _shallowEqual = _interopRequireDefault$y(shallowEqual$1);

    function _interopRequireDefault$y(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function isArrayExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrayExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isAssignmentExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AssignmentExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBinaryExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BinaryExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isInterpreterDirective(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterpreterDirective") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDirective(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Directive") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDirectiveLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DirectiveLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBlockStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BlockStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBreakStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BreakStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isCallExpression$4(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "CallExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isCatchClause(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "CatchClause") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isConditionalExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ConditionalExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isContinueStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ContinueStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDebuggerStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DebuggerStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDoWhileStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DoWhileStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEmptyStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EmptyStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExpressionStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExpressionStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFile$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "File") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isForInStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForInStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isForStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isIdentifier$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Identifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isIfStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "IfStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isLabeledStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "LabeledStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isStringLiteral$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StringLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNumericLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumericLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNullLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NullLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBooleanLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BooleanLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isRegExpLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RegExpLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isLogicalExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "LogicalExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isMemberExpression$4(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "MemberExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNewExpression$3(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NewExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isProgram$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Program") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectMethod(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isRestElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RestElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isReturnStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ReturnStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSequenceExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SequenceExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isParenthesizedExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ParenthesizedExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSwitchCase(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SwitchCase") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSwitchStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SwitchStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isThisExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ThisExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isThrowStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ThrowStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTryStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TryStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isUnaryExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UnaryExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isUpdateExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UpdateExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isVariableDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "VariableDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isVariableDeclarator$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "VariableDeclarator") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isWhileStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "WhileStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isWithStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "WithStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isAssignmentPattern$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AssignmentPattern") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isArrayPattern(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrayPattern") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isArrowFunctionExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrowFunctionExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassDeclaration$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportAllDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportAllDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportDefaultDeclaration$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportDefaultDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportNamedDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportNamedDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportSpecifier(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isForOfStatement$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForOfStatement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImportDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImportDefaultSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportDefaultSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImportNamespaceSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportNamespaceSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImportSpecifier(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isMetaProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "MetaProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassMethod(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectPattern$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectPattern") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSpreadElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SpreadElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSuper(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Super") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTaggedTemplateExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TaggedTemplateExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTemplateElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TemplateElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTemplateLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TemplateLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isYieldExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "YieldExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isAnyTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AnyTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isArrayTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArrayTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBooleanTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BooleanTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBooleanLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BooleanLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNullLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NullLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassImplements(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassImplements") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareClass(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareClass") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareFunction(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareFunction") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareInterface(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareInterface") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareModule(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareModule") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareModuleExports(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareModuleExports") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareTypeAlias(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareTypeAlias") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareOpaqueType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareOpaqueType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareVariable(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareVariable") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareExportDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareExportDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclareExportAllDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclareExportAllDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclaredPredicate(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DeclaredPredicate") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExistsTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExistsTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionTypeParam(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionTypeParam") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isGenericTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "GenericTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isInferredPredicate(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InferredPredicate") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isInterfaceExtends(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterfaceExtends") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isInterfaceDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterfaceDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isInterfaceTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "InterfaceTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isIntersectionTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "IntersectionTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isMixedTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "MixedTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEmptyTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EmptyTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNullableTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NullableTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNumberLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumberLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNumberTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumberTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeInternalSlot(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeInternalSlot") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeCallProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeCallProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeIndexer(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeIndexer") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectTypeSpreadProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectTypeSpreadProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isOpaqueType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OpaqueType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isQualifiedTypeIdentifier(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "QualifiedTypeIdentifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isStringLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StringLiteralTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isStringTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "StringTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSymbolTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SymbolTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isThisTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ThisTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTupleTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TupleTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeofTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeofTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeAlias(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeAlias") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeCastExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeCastExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeParameter(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeParameter") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeParameterDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeParameterDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTypeParameterInstantiation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TypeParameterInstantiation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isUnionTypeAnnotation$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UnionTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isVariance(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Variance") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isVoidTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "VoidTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumBooleanBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumBooleanBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumNumberBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumNumberBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumStringBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumStringBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumSymbolBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumSymbolBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumBooleanMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumBooleanMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumNumberMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumNumberMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumStringMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumStringMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumDefaultedMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumDefaultedMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXAttribute(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXAttribute") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXClosingElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXClosingElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXEmptyExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXEmptyExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXExpressionContainer(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXExpressionContainer") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXSpreadChild(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXSpreadChild") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXIdentifier(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXIdentifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXMemberExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXMemberExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXNamespacedName(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXNamespacedName") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXOpeningElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXOpeningElement") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXSpreadAttribute(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXSpreadAttribute") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXText(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXText") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXFragment(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXFragment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXOpeningFragment(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXOpeningFragment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSXClosingFragment(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSXClosingFragment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNoop(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Noop") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPlaceholder(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Placeholder") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isV8IntrinsicIdentifier(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "V8IntrinsicIdentifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isArgumentPlaceholder(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ArgumentPlaceholder") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isAwaitExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "AwaitExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBindExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BindExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isOptionalMemberExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OptionalMemberExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPipelineTopicExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PipelineTopicExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPipelineBareFunction(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PipelineBareFunction") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPipelinePrimaryTopicReference(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PipelinePrimaryTopicReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isOptionalCallExpression$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "OptionalCallExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassPrivateProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassPrivateProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClassPrivateMethod(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ClassPrivateMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImport(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Import") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImportAttribute(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ImportAttribute") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDecorator(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Decorator") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDoExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "DoExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportDefaultSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportDefaultSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportNamespaceSpecifier$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportNamespaceSpecifier") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPrivateName(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PrivateName") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBigIntLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BigIntLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isRecordExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RecordExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTupleExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TupleExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSParameterProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSParameterProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSDeclareFunction(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSDeclareFunction") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSDeclareMethod(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSDeclareMethod") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSQualifiedName(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSQualifiedName") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSCallSignatureDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSCallSignatureDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSConstructSignatureDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSConstructSignatureDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSPropertySignature(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSPropertySignature") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSMethodSignature(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSMethodSignature") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIndexSignature(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIndexSignature") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSAnyKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSAnyKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSBooleanKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSBooleanKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSBigIntKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSBigIntKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNeverKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNeverKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNullKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNullKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNumberKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNumberKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSObjectKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSObjectKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSStringKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSStringKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSSymbolKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSSymbolKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSUndefinedKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSUndefinedKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSUnknownKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSUnknownKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSVoidKeyword(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSVoidKeyword") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSThisType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSThisType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSFunctionType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSFunctionType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSConstructorType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSConstructorType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeReference(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypePredicate(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypePredicate") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeQuery(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeQuery") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeLiteral(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSArrayType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSArrayType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTupleType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTupleType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSOptionalType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSOptionalType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSRestType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSRestType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSUnionType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSUnionType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIntersectionType$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIntersectionType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSConditionalType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSConditionalType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSInferType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSInferType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSParenthesizedType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSParenthesizedType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeOperator(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeOperator") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSIndexedAccessType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSIndexedAccessType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSMappedType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSMappedType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSLiteralType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSLiteralType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSExpressionWithTypeArguments(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSExpressionWithTypeArguments") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSInterfaceDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSInterfaceDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSInterfaceBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSInterfaceBody") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeAliasDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeAliasDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSAsExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSAsExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeAssertion$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeAssertion") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSEnumDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSEnumDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSEnumMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSEnumMember") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSModuleDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSModuleDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSModuleBlock(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSModuleBlock") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSImportType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSImportType") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSImportEqualsDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSImportEqualsDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSExternalModuleReference(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSExternalModuleReference") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNonNullExpression$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNonNullExpression") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSExportAssignment(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSExportAssignment") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSNamespaceExportDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSNamespaceExportDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeAnnotation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeParameterInstantiation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeParameterInstantiation") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeParameterDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeParameterDeclaration") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeParameter(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeParameter") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExpression(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Expression" || "ArrayExpression" === nodeType || "AssignmentExpression" === nodeType || "BinaryExpression" === nodeType || "CallExpression" === nodeType || "ConditionalExpression" === nodeType || "FunctionExpression" === nodeType || "Identifier" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "LogicalExpression" === nodeType || "MemberExpression" === nodeType || "NewExpression" === nodeType || "ObjectExpression" === nodeType || "SequenceExpression" === nodeType || "ParenthesizedExpression" === nodeType || "ThisExpression" === nodeType || "UnaryExpression" === nodeType || "UpdateExpression" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "MetaProperty" === nodeType || "Super" === nodeType || "TaggedTemplateExpression" === nodeType || "TemplateLiteral" === nodeType || "YieldExpression" === nodeType || "TypeCastExpression" === nodeType || "JSXElement" === nodeType || "JSXFragment" === nodeType || "AwaitExpression" === nodeType || "BindExpression" === nodeType || "OptionalMemberExpression" === nodeType || "PipelinePrimaryTopicReference" === nodeType || "OptionalCallExpression" === nodeType || "Import" === nodeType || "DoExpression" === nodeType || "BigIntLiteral" === nodeType || "RecordExpression" === nodeType || "TupleExpression" === nodeType || "TSAsExpression" === nodeType || "TSTypeAssertion" === nodeType || "TSNonNullExpression" === nodeType || nodeType === "Placeholder" && ("Expression" === node.expectedNode || "Identifier" === node.expectedNode || "StringLiteral" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBinary$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Binary" || "BinaryExpression" === nodeType || "LogicalExpression" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isScopable(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Scopable" || "BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassExpression" === nodeType || "ClassDeclaration" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBlockParent(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "BlockParent" || "BlockStatement" === nodeType || "CatchClause" === nodeType || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "Program" === nodeType || "ObjectMethod" === nodeType || "SwitchStatement" === nodeType || "WhileStatement" === nodeType || "ArrowFunctionExpression" === nodeType || "ForOfStatement" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isBlock(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Block" || "BlockStatement" === nodeType || "Program" === nodeType || "TSModuleBlock" === nodeType || nodeType === "Placeholder" && "BlockStatement" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isStatement$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Statement" || "BlockStatement" === nodeType || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "DebuggerStatement" === nodeType || "DoWhileStatement" === nodeType || "EmptyStatement" === nodeType || "ExpressionStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "FunctionDeclaration" === nodeType || "IfStatement" === nodeType || "LabeledStatement" === nodeType || "ReturnStatement" === nodeType || "SwitchStatement" === nodeType || "ThrowStatement" === nodeType || "TryStatement" === nodeType || "VariableDeclaration" === nodeType || "WhileStatement" === nodeType || "WithStatement" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ForOfStatement" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || "TSImportEqualsDeclaration" === nodeType || "TSExportAssignment" === nodeType || "TSNamespaceExportDeclaration" === nodeType || nodeType === "Placeholder" && ("Statement" === node.expectedNode || "Declaration" === node.expectedNode || "BlockStatement" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTerminatorless(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Terminatorless" || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType || "YieldExpression" === nodeType || "AwaitExpression" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isCompletionStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "CompletionStatement" || "BreakStatement" === nodeType || "ContinueStatement" === nodeType || "ReturnStatement" === nodeType || "ThrowStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isConditional$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Conditional" || "ConditionalExpression" === nodeType || "IfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isLoop$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Loop" || "DoWhileStatement" === nodeType || "ForInStatement" === nodeType || "ForStatement" === nodeType || "WhileStatement" === nodeType || "ForOfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isWhile(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "While" || "DoWhileStatement" === nodeType || "WhileStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExpressionWrapper(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExpressionWrapper" || "ExpressionStatement" === nodeType || "ParenthesizedExpression" === nodeType || "TypeCastExpression" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFor$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "For" || "ForInStatement" === nodeType || "ForStatement" === nodeType || "ForOfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isForXStatement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ForXStatement" || "ForInStatement" === nodeType || "ForOfStatement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFunction$6(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Function" || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFunctionParent(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FunctionParent" || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "ObjectMethod" === nodeType || "ArrowFunctionExpression" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPureish(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Pureish" || "FunctionDeclaration" === nodeType || "FunctionExpression" === nodeType || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "ArrowFunctionExpression" === nodeType || "BigIntLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Declaration" || "FunctionDeclaration" === nodeType || "VariableDeclaration" === nodeType || "ClassDeclaration" === nodeType || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType || "EnumDeclaration" === nodeType || "TSDeclareFunction" === nodeType || "TSInterfaceDeclaration" === nodeType || "TSTypeAliasDeclaration" === nodeType || "TSEnumDeclaration" === nodeType || "TSModuleDeclaration" === nodeType || nodeType === "Placeholder" && "Declaration" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPatternLike(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "PatternLike" || "Identifier" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isLVal(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "LVal" || "Identifier" === nodeType || "MemberExpression" === nodeType || "RestElement" === nodeType || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || "TSParameterProperty" === nodeType || nodeType === "Placeholder" && ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode)) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSEntityName(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSEntityName" || "Identifier" === nodeType || "TSQualifiedName" === nodeType || nodeType === "Placeholder" && "Identifier" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isLiteral$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Literal" || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "RegExpLiteral" === nodeType || "TemplateLiteral" === nodeType || "BigIntLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isImmutable$2(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Immutable" || "StringLiteral" === nodeType || "NumericLiteral" === nodeType || "NullLiteral" === nodeType || "BooleanLiteral" === nodeType || "JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXOpeningElement" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType || "BigIntLiteral" === nodeType || nodeType === "Placeholder" && "StringLiteral" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isUserWhitespacable(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UserWhitespacable" || "ObjectMethod" === nodeType || "ObjectProperty" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isMethod(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Method" || "ObjectMethod" === nodeType || "ClassMethod" === nodeType || "ClassPrivateMethod" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isObjectMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ObjectMember" || "ObjectMethod" === nodeType || "ObjectProperty" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isProperty(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Property" || "ObjectProperty" === nodeType || "ClassProperty" === nodeType || "ClassPrivateProperty" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isUnaryLike$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "UnaryLike" || "UnaryExpression" === nodeType || "SpreadElement" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPattern(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Pattern" || "AssignmentPattern" === nodeType || "ArrayPattern" === nodeType || "ObjectPattern" === nodeType || nodeType === "Placeholder" && "Pattern" === node.expectedNode) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isClass(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Class" || "ClassExpression" === nodeType || "ClassDeclaration" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isModuleDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ModuleDeclaration" || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType || "ImportDeclaration" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isExportDeclaration$1(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ExportDeclaration" || "ExportAllDeclaration" === nodeType || "ExportDefaultDeclaration" === nodeType || "ExportNamedDeclaration" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isModuleSpecifier(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "ModuleSpecifier" || "ExportSpecifier" === nodeType || "ImportDefaultSpecifier" === nodeType || "ImportNamespaceSpecifier" === nodeType || "ImportSpecifier" === nodeType || "ExportDefaultSpecifier" === nodeType || "ExportNamespaceSpecifier" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFlow(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Flow" || "AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ClassImplements" === nodeType || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "DeclaredPredicate" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "FunctionTypeParam" === nodeType || "GenericTypeAnnotation" === nodeType || "InferredPredicate" === nodeType || "InterfaceExtends" === nodeType || "InterfaceDeclaration" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "ObjectTypeInternalSlot" === nodeType || "ObjectTypeCallProperty" === nodeType || "ObjectTypeIndexer" === nodeType || "ObjectTypeProperty" === nodeType || "ObjectTypeSpreadProperty" === nodeType || "OpaqueType" === nodeType || "QualifiedTypeIdentifier" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "TypeAlias" === nodeType || "TypeAnnotation" === nodeType || "TypeCastExpression" === nodeType || "TypeParameter" === nodeType || "TypeParameterDeclaration" === nodeType || "TypeParameterInstantiation" === nodeType || "UnionTypeAnnotation" === nodeType || "Variance" === nodeType || "VoidTypeAnnotation" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FlowType" || "AnyTypeAnnotation" === nodeType || "ArrayTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "BooleanLiteralTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "ExistsTypeAnnotation" === nodeType || "FunctionTypeAnnotation" === nodeType || "GenericTypeAnnotation" === nodeType || "InterfaceTypeAnnotation" === nodeType || "IntersectionTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NullableTypeAnnotation" === nodeType || "NumberLiteralTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "ObjectTypeAnnotation" === nodeType || "StringLiteralTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "TupleTypeAnnotation" === nodeType || "TypeofTypeAnnotation" === nodeType || "UnionTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowBaseAnnotation(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FlowBaseAnnotation" || "AnyTypeAnnotation" === nodeType || "BooleanTypeAnnotation" === nodeType || "NullLiteralTypeAnnotation" === nodeType || "MixedTypeAnnotation" === nodeType || "EmptyTypeAnnotation" === nodeType || "NumberTypeAnnotation" === nodeType || "StringTypeAnnotation" === nodeType || "SymbolTypeAnnotation" === nodeType || "ThisTypeAnnotation" === nodeType || "VoidTypeAnnotation" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowDeclaration(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FlowDeclaration" || "DeclareClass" === nodeType || "DeclareFunction" === nodeType || "DeclareInterface" === nodeType || "DeclareModule" === nodeType || "DeclareModuleExports" === nodeType || "DeclareTypeAlias" === nodeType || "DeclareOpaqueType" === nodeType || "DeclareVariable" === nodeType || "DeclareExportDeclaration" === nodeType || "DeclareExportAllDeclaration" === nodeType || "InterfaceDeclaration" === nodeType || "OpaqueType" === nodeType || "TypeAlias" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isFlowPredicate(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "FlowPredicate" || "DeclaredPredicate" === nodeType || "InferredPredicate" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumBody(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumBody" || "EnumBooleanBody" === nodeType || "EnumNumberBody" === nodeType || "EnumStringBody" === nodeType || "EnumSymbolBody" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isEnumMember(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "EnumMember" || "EnumBooleanMember" === nodeType || "EnumNumberMember" === nodeType || "EnumStringMember" === nodeType || "EnumDefaultedMember" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isJSX(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "JSX" || "JSXAttribute" === nodeType || "JSXClosingElement" === nodeType || "JSXElement" === nodeType || "JSXEmptyExpression" === nodeType || "JSXExpressionContainer" === nodeType || "JSXSpreadChild" === nodeType || "JSXIdentifier" === nodeType || "JSXMemberExpression" === nodeType || "JSXNamespacedName" === nodeType || "JSXOpeningElement" === nodeType || "JSXSpreadAttribute" === nodeType || "JSXText" === nodeType || "JSXFragment" === nodeType || "JSXOpeningFragment" === nodeType || "JSXClosingFragment" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isPrivate(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "Private" || "ClassPrivateProperty" === nodeType || "ClassPrivateMethod" === nodeType || "PrivateName" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSTypeElement(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSTypeElement" || "TSCallSignatureDeclaration" === nodeType || "TSConstructSignatureDeclaration" === nodeType || "TSPropertySignature" === nodeType || "TSMethodSignature" === nodeType || "TSIndexSignature" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSType" || "TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSFunctionType" === nodeType || "TSConstructorType" === nodeType || "TSTypeReference" === nodeType || "TSTypePredicate" === nodeType || "TSTypeQuery" === nodeType || "TSTypeLiteral" === nodeType || "TSArrayType" === nodeType || "TSTupleType" === nodeType || "TSOptionalType" === nodeType || "TSRestType" === nodeType || "TSUnionType" === nodeType || "TSIntersectionType" === nodeType || "TSConditionalType" === nodeType || "TSInferType" === nodeType || "TSParenthesizedType" === nodeType || "TSTypeOperator" === nodeType || "TSIndexedAccessType" === nodeType || "TSMappedType" === nodeType || "TSLiteralType" === nodeType || "TSExpressionWithTypeArguments" === nodeType || "TSImportType" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isTSBaseType(node, opts) {
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "TSBaseType" || "TSAnyKeyword" === nodeType || "TSBooleanKeyword" === nodeType || "TSBigIntKeyword" === nodeType || "TSNeverKeyword" === nodeType || "TSNullKeyword" === nodeType || "TSNumberKeyword" === nodeType || "TSObjectKeyword" === nodeType || "TSStringKeyword" === nodeType || "TSSymbolKeyword" === nodeType || "TSUndefinedKeyword" === nodeType || "TSUnknownKeyword" === nodeType || "TSVoidKeyword" === nodeType || "TSThisType" === nodeType || "TSLiteralType" === nodeType) {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isNumberLiteral(node, opts) {
      console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "NumberLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isRegexLiteral(node, opts) {
      console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RegexLiteral") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isRestProperty(node, opts) {
      console.trace("The node type RestProperty has been renamed to RestElement");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "RestProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    function isSpreadProperty(node, opts) {
      console.trace("The node type SpreadProperty has been renamed to SpreadElement");
      if (!node) return false;
      const nodeType = node.type;

      if (nodeType === "SpreadProperty") {
        if (typeof opts === "undefined") {
          return true;
        } else {
          return (0, _shallowEqual.default)(node, opts);
        }
      }

      return false;
    }

    Object.defineProperty(matchesPattern$1, "__esModule", {
      value: true
    });
    matchesPattern$1.default = matchesPattern;

    var _generated$n = generated$3;

    function matchesPattern(member, match, allowPartial) {
      if (!(0, _generated$n.isMemberExpression)(member)) return false;
      const parts = Array.isArray(match) ? match : match.split(".");
      const nodes = [];
      let node;

      for (node = member; (0, _generated$n.isMemberExpression)(node); node = node.object) {
        nodes.push(node.property);
      }

      nodes.push(node);
      if (nodes.length < parts.length) return false;
      if (!allowPartial && nodes.length > parts.length) return false;

      for (let i = 0, j = nodes.length - 1; i < parts.length; i++, j--) {
        const node = nodes[j];
        let value;

        if ((0, _generated$n.isIdentifier)(node)) {
          value = node.name;
        } else if ((0, _generated$n.isStringLiteral)(node)) {
          value = node.value;
        } else {
          return false;
        }

        if (parts[i] !== value) return false;
      }

      return true;
    }

    Object.defineProperty(buildMatchMemberExpression$1, "__esModule", {
      value: true
    });
    buildMatchMemberExpression$1.default = buildMatchMemberExpression;

    var _matchesPattern = _interopRequireDefault$x(matchesPattern$1);

    function _interopRequireDefault$x(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function buildMatchMemberExpression(match, allowPartial) {
      const parts = match.split(".");
      return member => (0, _matchesPattern.default)(member, parts, allowPartial);
    }

    Object.defineProperty(isReactComponent$2, "__esModule", {
      value: true
    });
    isReactComponent$2.default = void 0;

    var _buildMatchMemberExpression = _interopRequireDefault$w(buildMatchMemberExpression$1);

    function _interopRequireDefault$w(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    const isReactComponent$1 = (0, _buildMatchMemberExpression.default)("React.Component");
    var _default$3 = isReactComponent$1;
    isReactComponent$2.default = _default$3;

    var isCompatTag$1 = {};

    Object.defineProperty(isCompatTag$1, "__esModule", {
      value: true
    });
    isCompatTag$1.default = isCompatTag;

    function isCompatTag(tagName) {
      return !!tagName && /^[a-z]/.test(tagName);
    }

    var buildChildren$1 = {};

    var cleanJSXElementLiteralChild$1 = {};

    var generated$2 = {};

    var builder$1 = {};

    function listCacheClear$1() {
      this.__data__ = [];
      this.size = 0;
    }

    var _listCacheClear = listCacheClear$1;

    function eq$2(value, other) {
      return value === other || (value !== value && other !== other);
    }

    var eq_1 = eq$2;

    var eq$1 = eq_1;

    /**
     * Gets the index at which the `key` is found in `array` of key-value pairs.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} key The key to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */
    function assocIndexOf$4(array, key) {
      var length = array.length;
      while (length--) {
        if (eq$1(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }

    var _assocIndexOf = assocIndexOf$4;

    var assocIndexOf$3 = _assocIndexOf;

    /** Used for built-in method references. */
    var arrayProto = Array.prototype;

    /** Built-in value references. */
    var splice = arrayProto.splice;

    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function listCacheDelete$1(key) {
      var data = this.__data__,
          index = assocIndexOf$3(data, key);

      if (index < 0) {
        return false;
      }
      var lastIndex = data.length - 1;
      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }
      --this.size;
      return true;
    }

    var _listCacheDelete = listCacheDelete$1;

    var assocIndexOf$2 = _assocIndexOf;

    /**
     * Gets the list cache value for `key`.
     *
     * @private
     * @name get
     * @memberOf ListCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function listCacheGet$1(key) {
      var data = this.__data__,
          index = assocIndexOf$2(data, key);

      return index < 0 ? undefined : data[index][1];
    }

    var _listCacheGet = listCacheGet$1;

    var assocIndexOf$1 = _assocIndexOf;

    /**
     * Checks if a list cache value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf ListCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function listCacheHas$1(key) {
      return assocIndexOf$1(this.__data__, key) > -1;
    }

    var _listCacheHas = listCacheHas$1;

    var assocIndexOf = _assocIndexOf;

    /**
     * Sets the list cache `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */
    function listCacheSet$1(key, value) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        ++this.size;
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }
      return this;
    }

    var _listCacheSet = listCacheSet$1;

    var listCacheClear = _listCacheClear,
        listCacheDelete = _listCacheDelete,
        listCacheGet = _listCacheGet,
        listCacheHas = _listCacheHas,
        listCacheSet = _listCacheSet;

    /**
     * Creates an list cache object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function ListCache$4(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `ListCache`.
    ListCache$4.prototype.clear = listCacheClear;
    ListCache$4.prototype['delete'] = listCacheDelete;
    ListCache$4.prototype.get = listCacheGet;
    ListCache$4.prototype.has = listCacheHas;
    ListCache$4.prototype.set = listCacheSet;

    var _ListCache = ListCache$4;

    var ListCache$3 = _ListCache;

    /**
     * Removes all key-value entries from the stack.
     *
     * @private
     * @name clear
     * @memberOf Stack
     */
    function stackClear$1() {
      this.__data__ = new ListCache$3;
      this.size = 0;
    }

    var _stackClear = stackClear$1;

    function stackDelete$1(key) {
      var data = this.__data__,
          result = data['delete'](key);

      this.size = data.size;
      return result;
    }

    var _stackDelete = stackDelete$1;

    function stackGet$1(key) {
      return this.__data__.get(key);
    }

    var _stackGet = stackGet$1;

    function stackHas$1(key) {
      return this.__data__.has(key);
    }

    var _stackHas = stackHas$1;

    var freeGlobal$1 = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

    var _freeGlobal = freeGlobal$1;

    var freeGlobal = _freeGlobal;

    /** Detect free variable `self`. */
    var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

    /** Used as a reference to the global object. */
    var root$8 = freeGlobal || freeSelf || Function('return this')();

    var _root = root$8;

    var root$7 = _root;

    /** Built-in value references. */
    var Symbol$4 = root$7.Symbol;

    var _Symbol = Symbol$4;

    var Symbol$3 = _Symbol;

    /** Used for built-in method references. */
    var objectProto$d = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$b = objectProto$d.hasOwnProperty;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString$1 = objectProto$d.toString;

    /** Built-in value references. */
    var symToStringTag$1 = Symbol$3 ? Symbol$3.toStringTag : undefined;

    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */
    function getRawTag$1(value) {
      var isOwn = hasOwnProperty$b.call(value, symToStringTag$1),
          tag = value[symToStringTag$1];

      try {
        value[symToStringTag$1] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString$1.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag$1] = tag;
        } else {
          delete value[symToStringTag$1];
        }
      }
      return result;
    }

    var _getRawTag = getRawTag$1;

    var objectProto$c = Object.prototype;

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString = objectProto$c.toString;

    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */
    function objectToString$1(value) {
      return nativeObjectToString.call(value);
    }

    var _objectToString = objectToString$1;

    var Symbol$2 = _Symbol,
        getRawTag = _getRawTag,
        objectToString = _objectToString;

    /** `Object#toString` result references. */
    var nullTag = '[object Null]',
        undefinedTag = '[object Undefined]';

    /** Built-in value references. */
    var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : undefined;

    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    function baseGetTag$6(value) {
      if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
      }
      return (symToStringTag && symToStringTag in Object(value))
        ? getRawTag(value)
        : objectToString(value);
    }

    var _baseGetTag = baseGetTag$6;

    function isObject$6(value) {
      var type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }

    var isObject_1 = isObject$6;

    var baseGetTag$5 = _baseGetTag,
        isObject$5 = isObject_1;

    /** `Object#toString` result references. */
    var asyncTag = '[object AsyncFunction]',
        funcTag$2 = '[object Function]',
        genTag$1 = '[object GeneratorFunction]',
        proxyTag = '[object Proxy]';

    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */
    function isFunction$5(value) {
      if (!isObject$5(value)) {
        return false;
      }
      // The use of `Object#toString` avoids issues with the `typeof` operator
      // in Safari 9 which returns 'object' for typed arrays and other constructors.
      var tag = baseGetTag$5(value);
      return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
    }

    var isFunction_1 = isFunction$5;

    var root$6 = _root;

    /** Used to detect overreaching core-js shims. */
    var coreJsData$1 = root$6['__core-js_shared__'];

    var _coreJsData = coreJsData$1;

    var coreJsData = _coreJsData;

    /** Used to detect methods masquerading as native. */
    var maskSrcKey = (function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
      return uid ? ('Symbol(src)_1.' + uid) : '';
    }());

    /**
     * Checks if `func` has its source masked.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
     */
    function isMasked$1(func) {
      return !!maskSrcKey && (maskSrcKey in func);
    }

    var _isMasked = isMasked$1;

    var funcProto$2 = Function.prototype;

    /** Used to resolve the decompiled source of functions. */
    var funcToString$2 = funcProto$2.toString;

    /**
     * Converts `func` to its source code.
     *
     * @private
     * @param {Function} func The function to convert.
     * @returns {string} Returns the source code.
     */
    function toSource$2(func) {
      if (func != null) {
        try {
          return funcToString$2.call(func);
        } catch (e) {}
        try {
          return (func + '');
        } catch (e) {}
      }
      return '';
    }

    var _toSource = toSource$2;

    var isFunction$4 = isFunction_1,
        isMasked = _isMasked,
        isObject$4 = isObject_1,
        toSource$1 = _toSource;

    /**
     * Used to match `RegExp`
     * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
     */
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

    /** Used to detect host constructors (Safari). */
    var reIsHostCtor = /^\[object .+?Constructor\]$/;

    /** Used for built-in method references. */
    var funcProto$1 = Function.prototype,
        objectProto$b = Object.prototype;

    /** Used to resolve the decompiled source of functions. */
    var funcToString$1 = funcProto$1.toString;

    /** Used to check objects for own properties. */
    var hasOwnProperty$a = objectProto$b.hasOwnProperty;

    /** Used to detect if a method is native. */
    var reIsNative = RegExp('^' +
      funcToString$1.call(hasOwnProperty$a).replace(reRegExpChar, '\\$&')
      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
    );

    /**
     * The base implementation of `_.isNative` without bad shim checks.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     */
    function baseIsNative$1(value) {
      if (!isObject$4(value) || isMasked(value)) {
        return false;
      }
      var pattern = isFunction$4(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource$1(value));
    }

    var _baseIsNative = baseIsNative$1;

    function getValue$1(object, key) {
      return object == null ? undefined : object[key];
    }

    var _getValue = getValue$1;

    var baseIsNative = _baseIsNative,
        getValue = _getValue;

    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */
    function getNative$7(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : undefined;
    }

    var _getNative = getNative$7;

    var getNative$6 = _getNative,
        root$5 = _root;

    /* Built-in method references that are verified to be native. */
    var Map$4 = getNative$6(root$5, 'Map');

    var _Map = Map$4;

    var getNative$5 = _getNative;

    /* Built-in method references that are verified to be native. */
    var nativeCreate$4 = getNative$5(Object, 'create');

    var _nativeCreate = nativeCreate$4;

    var nativeCreate$3 = _nativeCreate;

    /**
     * Removes all key-value entries from the hash.
     *
     * @private
     * @name clear
     * @memberOf Hash
     */
    function hashClear$1() {
      this.__data__ = nativeCreate$3 ? nativeCreate$3(null) : {};
      this.size = 0;
    }

    var _hashClear = hashClear$1;

    function hashDelete$1(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }

    var _hashDelete = hashDelete$1;

    var nativeCreate$2 = _nativeCreate;

    /** Used to stand-in for `undefined` hash values. */
    var HASH_UNDEFINED$2 = '__lodash_hash_undefined__';

    /** Used for built-in method references. */
    var objectProto$a = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$9 = objectProto$a.hasOwnProperty;

    /**
     * Gets the hash value for `key`.
     *
     * @private
     * @name get
     * @memberOf Hash
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function hashGet$1(key) {
      var data = this.__data__;
      if (nativeCreate$2) {
        var result = data[key];
        return result === HASH_UNDEFINED$2 ? undefined : result;
      }
      return hasOwnProperty$9.call(data, key) ? data[key] : undefined;
    }

    var _hashGet = hashGet$1;

    var nativeCreate$1 = _nativeCreate;

    /** Used for built-in method references. */
    var objectProto$9 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$8 = objectProto$9.hasOwnProperty;

    /**
     * Checks if a hash value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Hash
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function hashHas$1(key) {
      var data = this.__data__;
      return nativeCreate$1 ? (data[key] !== undefined) : hasOwnProperty$8.call(data, key);
    }

    var _hashHas = hashHas$1;

    var nativeCreate = _nativeCreate;

    /** Used to stand-in for `undefined` hash values. */
    var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

    /**
     * Sets the hash `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Hash
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the hash instance.
     */
    function hashSet$1(key, value) {
      var data = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED$1 : value;
      return this;
    }

    var _hashSet = hashSet$1;

    var hashClear = _hashClear,
        hashDelete = _hashDelete,
        hashGet = _hashGet,
        hashHas = _hashHas,
        hashSet = _hashSet;

    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function Hash$1(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `Hash`.
    Hash$1.prototype.clear = hashClear;
    Hash$1.prototype['delete'] = hashDelete;
    Hash$1.prototype.get = hashGet;
    Hash$1.prototype.has = hashHas;
    Hash$1.prototype.set = hashSet;

    var _Hash = Hash$1;

    var Hash = _Hash,
        ListCache$2 = _ListCache,
        Map$3 = _Map;

    /**
     * Removes all key-value entries from the map.
     *
     * @private
     * @name clear
     * @memberOf MapCache
     */
    function mapCacheClear$1() {
      this.size = 0;
      this.__data__ = {
        'hash': new Hash,
        'map': new (Map$3 || ListCache$2),
        'string': new Hash
      };
    }

    var _mapCacheClear = mapCacheClear$1;

    function isKeyable$1(value) {
      var type = typeof value;
      return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
        ? (value !== '__proto__')
        : (value === null);
    }

    var _isKeyable = isKeyable$1;

    var isKeyable = _isKeyable;

    /**
     * Gets the data for `map`.
     *
     * @private
     * @param {Object} map The map to query.
     * @param {string} key The reference key.
     * @returns {*} Returns the map data.
     */
    function getMapData$4(map, key) {
      var data = map.__data__;
      return isKeyable(key)
        ? data[typeof key == 'string' ? 'string' : 'hash']
        : data.map;
    }

    var _getMapData = getMapData$4;

    var getMapData$3 = _getMapData;

    /**
     * Removes `key` and its value from the map.
     *
     * @private
     * @name delete
     * @memberOf MapCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function mapCacheDelete$1(key) {
      var result = getMapData$3(this, key)['delete'](key);
      this.size -= result ? 1 : 0;
      return result;
    }

    var _mapCacheDelete = mapCacheDelete$1;

    var getMapData$2 = _getMapData;

    /**
     * Gets the map value for `key`.
     *
     * @private
     * @name get
     * @memberOf MapCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function mapCacheGet$1(key) {
      return getMapData$2(this, key).get(key);
    }

    var _mapCacheGet = mapCacheGet$1;

    var getMapData$1 = _getMapData;

    /**
     * Checks if a map value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf MapCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function mapCacheHas$1(key) {
      return getMapData$1(this, key).has(key);
    }

    var _mapCacheHas = mapCacheHas$1;

    var getMapData = _getMapData;

    /**
     * Sets the map `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf MapCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the map cache instance.
     */
    function mapCacheSet$1(key, value) {
      var data = getMapData(this, key),
          size = data.size;

      data.set(key, value);
      this.size += data.size == size ? 0 : 1;
      return this;
    }

    var _mapCacheSet = mapCacheSet$1;

    var mapCacheClear = _mapCacheClear,
        mapCacheDelete = _mapCacheDelete,
        mapCacheGet = _mapCacheGet,
        mapCacheHas = _mapCacheHas,
        mapCacheSet = _mapCacheSet;

    /**
     * Creates a map cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function MapCache$2(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    // Add methods to `MapCache`.
    MapCache$2.prototype.clear = mapCacheClear;
    MapCache$2.prototype['delete'] = mapCacheDelete;
    MapCache$2.prototype.get = mapCacheGet;
    MapCache$2.prototype.has = mapCacheHas;
    MapCache$2.prototype.set = mapCacheSet;

    var _MapCache = MapCache$2;

    var ListCache$1 = _ListCache,
        Map$2 = _Map,
        MapCache$1 = _MapCache;

    /** Used as the size to enable large array optimizations. */
    var LARGE_ARRAY_SIZE$1 = 200;

    /**
     * Sets the stack `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Stack
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the stack cache instance.
     */
    function stackSet$1(key, value) {
      var data = this.__data__;
      if (data instanceof ListCache$1) {
        var pairs = data.__data__;
        if (!Map$2 || (pairs.length < LARGE_ARRAY_SIZE$1 - 1)) {
          pairs.push([key, value]);
          this.size = ++data.size;
          return this;
        }
        data = this.__data__ = new MapCache$1(pairs);
      }
      data.set(key, value);
      this.size = data.size;
      return this;
    }

    var _stackSet = stackSet$1;

    var ListCache = _ListCache,
        stackClear = _stackClear,
        stackDelete = _stackDelete,
        stackGet = _stackGet,
        stackHas = _stackHas,
        stackSet = _stackSet;

    /**
     * Creates a stack cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function Stack$1(entries) {
      var data = this.__data__ = new ListCache(entries);
      this.size = data.size;
    }

    // Add methods to `Stack`.
    Stack$1.prototype.clear = stackClear;
    Stack$1.prototype['delete'] = stackDelete;
    Stack$1.prototype.get = stackGet;
    Stack$1.prototype.has = stackHas;
    Stack$1.prototype.set = stackSet;

    var _Stack = Stack$1;

    function arrayEach$1(array, iteratee) {
      var index = -1,
          length = array == null ? 0 : array.length;

      while (++index < length) {
        if (iteratee(array[index], index, array) === false) {
          break;
        }
      }
      return array;
    }

    var _arrayEach = arrayEach$1;

    var getNative$4 = _getNative;

    var defineProperty$1 = (function() {
      try {
        var func = getNative$4(Object, 'defineProperty');
        func({}, '', {});
        return func;
      } catch (e) {}
    }());

    var _defineProperty = defineProperty$1;

    var defineProperty = _defineProperty;

    /**
     * The base implementation of `assignValue` and `assignMergeValue` without
     * value checks.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {string} key The key of the property to assign.
     * @param {*} value The value to assign.
     */
    function baseAssignValue$2(object, key, value) {
      if (key == '__proto__' && defineProperty) {
        defineProperty(object, key, {
          'configurable': true,
          'enumerable': true,
          'value': value,
          'writable': true
        });
      } else {
        object[key] = value;
      }
    }

    var _baseAssignValue = baseAssignValue$2;

    var baseAssignValue$1 = _baseAssignValue,
        eq = eq_1;

    /** Used for built-in method references. */
    var objectProto$8 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$7 = objectProto$8.hasOwnProperty;

    /**
     * Assigns `value` to `key` of `object` if the existing value is not equivalent
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {string} key The key of the property to assign.
     * @param {*} value The value to assign.
     */
    function assignValue$2(object, key, value) {
      var objValue = object[key];
      if (!(hasOwnProperty$7.call(object, key) && eq(objValue, value)) ||
          (value === undefined && !(key in object))) {
        baseAssignValue$1(object, key, value);
      }
    }

    var _assignValue = assignValue$2;

    var assignValue$1 = _assignValue,
        baseAssignValue = _baseAssignValue;

    /**
     * Copies properties of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy properties from.
     * @param {Array} props The property identifiers to copy.
     * @param {Object} [object={}] The object to copy properties to.
     * @param {Function} [customizer] The function to customize copied values.
     * @returns {Object} Returns `object`.
     */
    function copyObject$4(source, props, object, customizer) {
      var isNew = !object;
      object || (object = {});

      var index = -1,
          length = props.length;

      while (++index < length) {
        var key = props[index];

        var newValue = customizer
          ? customizer(object[key], source[key], key, object, source)
          : undefined;

        if (newValue === undefined) {
          newValue = source[key];
        }
        if (isNew) {
          baseAssignValue(object, key, newValue);
        } else {
          assignValue$1(object, key, newValue);
        }
      }
      return object;
    }

    var _copyObject = copyObject$4;

    function baseTimes$1(n, iteratee) {
      var index = -1,
          result = Array(n);

      while (++index < n) {
        result[index] = iteratee(index);
      }
      return result;
    }

    var _baseTimes = baseTimes$1;

    function isObjectLike$7(value) {
      return value != null && typeof value == 'object';
    }

    var isObjectLike_1 = isObjectLike$7;

    var baseGetTag$4 = _baseGetTag,
        isObjectLike$6 = isObjectLike_1;

    /** `Object#toString` result references. */
    var argsTag$2 = '[object Arguments]';

    /**
     * The base implementation of `_.isArguments`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     */
    function baseIsArguments$1(value) {
      return isObjectLike$6(value) && baseGetTag$4(value) == argsTag$2;
    }

    var _baseIsArguments = baseIsArguments$1;

    var baseIsArguments = _baseIsArguments,
        isObjectLike$5 = isObjectLike_1;

    /** Used for built-in method references. */
    var objectProto$7 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$6 = objectProto$7.hasOwnProperty;

    /** Built-in value references. */
    var propertyIsEnumerable$1 = objectProto$7.propertyIsEnumerable;

    /**
     * Checks if `value` is likely an `arguments` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     *  else `false`.
     * @example
     *
     * _.isArguments(function() { return arguments; }());
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */
    var isArguments$1 = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
      return isObjectLike$5(value) && hasOwnProperty$6.call(value, 'callee') &&
        !propertyIsEnumerable$1.call(value, 'callee');
    };

    var isArguments_1 = isArguments$1;

    var isArray$5 = Array.isArray;

    var isArray_1 = isArray$5;

    var isBufferExports = {};
    var isBuffer$4 = {
      get exports(){ return isBufferExports; },
      set exports(v){ isBufferExports = v; },
    };

    function stubFalse() {
      return false;
    }

    var stubFalse_1 = stubFalse;

    (function (module, exports) {
    	var root = _root,
    	    stubFalse = stubFalse_1;

    	/** Detect free variable `exports`. */
    	var freeExports = exports && !exports.nodeType && exports;

    	/** Detect free variable `module`. */
    	var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

    	/** Detect the popular CommonJS extension `module.exports`. */
    	var moduleExports = freeModule && freeModule.exports === freeExports;

    	/** Built-in value references. */
    	var Buffer = moduleExports ? root.Buffer : undefined;

    	/* Built-in method references for those with the same name as other `lodash` methods. */
    	var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

    	/**
    	 * Checks if `value` is a buffer.
    	 *
    	 * @static
    	 * @memberOf _
    	 * @since 4.3.0
    	 * @category Lang
    	 * @param {*} value The value to check.
    	 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
    	 * @example
    	 *
    	 * _.isBuffer(new Buffer(2));
    	 * // => true
    	 *
    	 * _.isBuffer(new Uint8Array(2));
    	 * // => false
    	 */
    	var isBuffer = nativeIsBuffer || stubFalse;

    	module.exports = isBuffer;
    } (isBuffer$4, isBufferExports));

    var MAX_SAFE_INTEGER$1 = 9007199254740991;

    /** Used to detect unsigned integer values. */
    var reIsUint = /^(?:0|[1-9]\d*)$/;

    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */
    function isIndex$1(value, length) {
      var type = typeof value;
      length = length == null ? MAX_SAFE_INTEGER$1 : length;

      return !!length &&
        (type == 'number' ||
          (type != 'symbol' && reIsUint.test(value))) &&
            (value > -1 && value % 1 == 0 && value < length);
    }

    var _isIndex = isIndex$1;

    var MAX_SAFE_INTEGER = 9007199254740991;

    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This method is loosely based on
     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     * @example
     *
     * _.isLength(3);
     * // => true
     *
     * _.isLength(Number.MIN_VALUE);
     * // => false
     *
     * _.isLength(Infinity);
     * // => false
     *
     * _.isLength('3');
     * // => false
     */
    function isLength$2(value) {
      return typeof value == 'number' &&
        value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }

    var isLength_1 = isLength$2;

    var baseGetTag$3 = _baseGetTag,
        isLength$1 = isLength_1,
        isObjectLike$4 = isObjectLike_1;

    /** `Object#toString` result references. */
    var argsTag$1 = '[object Arguments]',
        arrayTag$1 = '[object Array]',
        boolTag$2 = '[object Boolean]',
        dateTag$2 = '[object Date]',
        errorTag$1 = '[object Error]',
        funcTag$1 = '[object Function]',
        mapTag$4 = '[object Map]',
        numberTag$2 = '[object Number]',
        objectTag$3 = '[object Object]',
        regexpTag$3 = '[object RegExp]',
        setTag$4 = '[object Set]',
        stringTag$2 = '[object String]',
        weakMapTag$2 = '[object WeakMap]';

    var arrayBufferTag$2 = '[object ArrayBuffer]',
        dataViewTag$3 = '[object DataView]',
        float32Tag$2 = '[object Float32Array]',
        float64Tag$2 = '[object Float64Array]',
        int8Tag$2 = '[object Int8Array]',
        int16Tag$2 = '[object Int16Array]',
        int32Tag$2 = '[object Int32Array]',
        uint8Tag$2 = '[object Uint8Array]',
        uint8ClampedTag$2 = '[object Uint8ClampedArray]',
        uint16Tag$2 = '[object Uint16Array]',
        uint32Tag$2 = '[object Uint32Array]';

    /** Used to identify `toStringTag` values of typed arrays. */
    var typedArrayTags = {};
    typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] =
    typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] =
    typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] =
    typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] =
    typedArrayTags[uint32Tag$2] = true;
    typedArrayTags[argsTag$1] = typedArrayTags[arrayTag$1] =
    typedArrayTags[arrayBufferTag$2] = typedArrayTags[boolTag$2] =
    typedArrayTags[dataViewTag$3] = typedArrayTags[dateTag$2] =
    typedArrayTags[errorTag$1] = typedArrayTags[funcTag$1] =
    typedArrayTags[mapTag$4] = typedArrayTags[numberTag$2] =
    typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$3] =
    typedArrayTags[setTag$4] = typedArrayTags[stringTag$2] =
    typedArrayTags[weakMapTag$2] = false;

    /**
     * The base implementation of `_.isTypedArray` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     */
    function baseIsTypedArray$1(value) {
      return isObjectLike$4(value) &&
        isLength$1(value.length) && !!typedArrayTags[baseGetTag$3(value)];
    }

    var _baseIsTypedArray = baseIsTypedArray$1;

    function baseUnary$4(func) {
      return function(value) {
        return func(value);
      };
    }

    var _baseUnary = baseUnary$4;

    var _nodeUtilExports = {};
    var _nodeUtil = {
      get exports(){ return _nodeUtilExports; },
      set exports(v){ _nodeUtilExports = v; },
    };

    (function (module, exports) {
    	var freeGlobal = _freeGlobal;

    	/** Detect free variable `exports`. */
    	var freeExports = exports && !exports.nodeType && exports;

    	/** Detect free variable `module`. */
    	var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

    	/** Detect the popular CommonJS extension `module.exports`. */
    	var moduleExports = freeModule && freeModule.exports === freeExports;

    	/** Detect free variable `process` from Node.js. */
    	var freeProcess = moduleExports && freeGlobal.process;

    	/** Used to access faster Node.js helpers. */
    	var nodeUtil = (function() {
    	  try {
    	    // Use `util.types` for Node.js 10+.
    	    var types = freeModule && freeModule.require && freeModule.require('util').types;

    	    if (types) {
    	      return types;
    	    }

    	    // Legacy `process.binding('util')` for Node.js < 10.
    	    return freeProcess && freeProcess.binding && freeProcess.binding('util');
    	  } catch (e) {}
    	}());

    	module.exports = nodeUtil;
    } (_nodeUtil, _nodeUtilExports));

    var baseIsTypedArray = _baseIsTypedArray,
        baseUnary$3 = _baseUnary,
        nodeUtil$3 = _nodeUtilExports;

    /* Node.js helper references. */
    var nodeIsTypedArray = nodeUtil$3 && nodeUtil$3.isTypedArray;

    /**
     * Checks if `value` is classified as a typed array.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     * @example
     *
     * _.isTypedArray(new Uint8Array);
     * // => true
     *
     * _.isTypedArray([]);
     * // => false
     */
    var isTypedArray$1 = nodeIsTypedArray ? baseUnary$3(nodeIsTypedArray) : baseIsTypedArray;

    var isTypedArray_1 = isTypedArray$1;

    var baseTimes = _baseTimes,
        isArguments = isArguments_1,
        isArray$4 = isArray_1,
        isBuffer$3 = isBufferExports,
        isIndex = _isIndex,
        isTypedArray = isTypedArray_1;

    /** Used for built-in method references. */
    var objectProto$6 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$5 = objectProto$6.hasOwnProperty;

    /**
     * Creates an array of the enumerable property names of the array-like `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @param {boolean} inherited Specify returning inherited property names.
     * @returns {Array} Returns the array of property names.
     */
    function arrayLikeKeys$2(value, inherited) {
      var isArr = isArray$4(value),
          isArg = !isArr && isArguments(value),
          isBuff = !isArr && !isArg && isBuffer$3(value),
          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
          skipIndexes = isArr || isArg || isBuff || isType,
          result = skipIndexes ? baseTimes(value.length, String) : [],
          length = result.length;

      for (var key in value) {
        if ((inherited || hasOwnProperty$5.call(value, key)) &&
            !(skipIndexes && (
               // Safari 9 has enumerable `arguments.length` in strict mode.
               key == 'length' ||
               // Node.js 0.10 has enumerable non-index properties on buffers.
               (isBuff && (key == 'offset' || key == 'parent')) ||
               // PhantomJS 2 has enumerable non-index properties on typed arrays.
               (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
               // Skip index properties.
               isIndex(key, length)
            ))) {
          result.push(key);
        }
      }
      return result;
    }

    var _arrayLikeKeys = arrayLikeKeys$2;

    var objectProto$5 = Object.prototype;

    /**
     * Checks if `value` is likely a prototype object.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
     */
    function isPrototype$3(value) {
      var Ctor = value && value.constructor,
          proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto$5;

      return value === proto;
    }

    var _isPrototype = isPrototype$3;

    function overArg$2(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }

    var _overArg = overArg$2;

    var overArg$1 = _overArg;

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeKeys$1 = overArg$1(Object.keys, Object);

    var _nativeKeys = nativeKeys$1;

    var isPrototype$2 = _isPrototype,
        nativeKeys = _nativeKeys;

    /** Used for built-in method references. */
    var objectProto$4 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$4 = objectProto$4.hasOwnProperty;

    /**
     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function baseKeys$1(object) {
      if (!isPrototype$2(object)) {
        return nativeKeys(object);
      }
      var result = [];
      for (var key in Object(object)) {
        if (hasOwnProperty$4.call(object, key) && key != 'constructor') {
          result.push(key);
        }
      }
      return result;
    }

    var _baseKeys = baseKeys$1;

    var isFunction$3 = isFunction_1,
        isLength = isLength_1;

    /**
     * Checks if `value` is array-like. A value is considered array-like if it's
     * not a function and has a `value.length` that's an integer greater than or
     * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
     * @example
     *
     * _.isArrayLike([1, 2, 3]);
     * // => true
     *
     * _.isArrayLike(document.body.children);
     * // => true
     *
     * _.isArrayLike('abc');
     * // => true
     *
     * _.isArrayLike(_.noop);
     * // => false
     */
    function isArrayLike$2(value) {
      return value != null && isLength(value.length) && !isFunction$3(value);
    }

    var isArrayLike_1 = isArrayLike$2;

    var arrayLikeKeys$1 = _arrayLikeKeys,
        baseKeys = _baseKeys,
        isArrayLike$1 = isArrayLike_1;

    /**
     * Creates an array of the own enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects. See the
     * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
     * for more details.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keys(new Foo);
     * // => ['a', 'b'] (iteration order is not guaranteed)
     *
     * _.keys('hi');
     * // => ['0', '1']
     */
    function keys$3(object) {
      return isArrayLike$1(object) ? arrayLikeKeys$1(object) : baseKeys(object);
    }

    var keys_1 = keys$3;

    var copyObject$3 = _copyObject,
        keys$2 = keys_1;

    /**
     * The base implementation of `_.assign` without support for multiple sources
     * or `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @returns {Object} Returns `object`.
     */
    function baseAssign$1(object, source) {
      return object && copyObject$3(source, keys$2(source), object);
    }

    var _baseAssign = baseAssign$1;

    function nativeKeysIn$1(object) {
      var result = [];
      if (object != null) {
        for (var key in Object(object)) {
          result.push(key);
        }
      }
      return result;
    }

    var _nativeKeysIn = nativeKeysIn$1;

    var isObject$3 = isObject_1,
        isPrototype$1 = _isPrototype,
        nativeKeysIn = _nativeKeysIn;

    /** Used for built-in method references. */
    var objectProto$3 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$3 = objectProto$3.hasOwnProperty;

    /**
     * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function baseKeysIn$1(object) {
      if (!isObject$3(object)) {
        return nativeKeysIn(object);
      }
      var isProto = isPrototype$1(object),
          result = [];

      for (var key in object) {
        if (!(key == 'constructor' && (isProto || !hasOwnProperty$3.call(object, key)))) {
          result.push(key);
        }
      }
      return result;
    }

    var _baseKeysIn = baseKeysIn$1;

    var arrayLikeKeys = _arrayLikeKeys,
        baseKeysIn = _baseKeysIn,
        isArrayLike = isArrayLike_1;

    /**
     * Creates an array of the own and inherited enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keysIn(new Foo);
     * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
     */
    function keysIn$3(object) {
      return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
    }

    var keysIn_1 = keysIn$3;

    var copyObject$2 = _copyObject,
        keysIn$2 = keysIn_1;

    /**
     * The base implementation of `_.assignIn` without support for multiple sources
     * or `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @returns {Object} Returns `object`.
     */
    function baseAssignIn$1(object, source) {
      return object && copyObject$2(source, keysIn$2(source), object);
    }

    var _baseAssignIn = baseAssignIn$1;

    var _cloneBufferExports = {};
    var _cloneBuffer = {
      get exports(){ return _cloneBufferExports; },
      set exports(v){ _cloneBufferExports = v; },
    };

    (function (module, exports) {
    	var root = _root;

    	/** Detect free variable `exports`. */
    	var freeExports = exports && !exports.nodeType && exports;

    	/** Detect free variable `module`. */
    	var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

    	/** Detect the popular CommonJS extension `module.exports`. */
    	var moduleExports = freeModule && freeModule.exports === freeExports;

    	/** Built-in value references. */
    	var Buffer = moduleExports ? root.Buffer : undefined,
    	    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

    	/**
    	 * Creates a clone of  `buffer`.
    	 *
    	 * @private
    	 * @param {Buffer} buffer The buffer to clone.
    	 * @param {boolean} [isDeep] Specify a deep clone.
    	 * @returns {Buffer} Returns the cloned buffer.
    	 */
    	function cloneBuffer(buffer, isDeep) {
    	  if (isDeep) {
    	    return buffer.slice();
    	  }
    	  var length = buffer.length,
    	      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

    	  buffer.copy(result);
    	  return result;
    	}

    	module.exports = cloneBuffer;
    } (_cloneBuffer, _cloneBufferExports));

    function copyArray$1(source, array) {
      var index = -1,
          length = source.length;

      array || (array = Array(length));
      while (++index < length) {
        array[index] = source[index];
      }
      return array;
    }

    var _copyArray = copyArray$1;

    function arrayFilter$1(array, predicate) {
      var index = -1,
          length = array == null ? 0 : array.length,
          resIndex = 0,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (predicate(value, index, array)) {
          result[resIndex++] = value;
        }
      }
      return result;
    }

    var _arrayFilter = arrayFilter$1;

    function stubArray$2() {
      return [];
    }

    var stubArray_1 = stubArray$2;

    var arrayFilter = _arrayFilter,
        stubArray$1 = stubArray_1;

    /** Used for built-in method references. */
    var objectProto$2 = Object.prototype;

    /** Built-in value references. */
    var propertyIsEnumerable = objectProto$2.propertyIsEnumerable;

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeGetSymbols$1 = Object.getOwnPropertySymbols;

    /**
     * Creates an array of the own enumerable symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */
    var getSymbols$4 = !nativeGetSymbols$1 ? stubArray$1 : function(object) {
      if (object == null) {
        return [];
      }
      object = Object(object);
      return arrayFilter(nativeGetSymbols$1(object), function(symbol) {
        return propertyIsEnumerable.call(object, symbol);
      });
    };

    var _getSymbols = getSymbols$4;

    var copyObject$1 = _copyObject,
        getSymbols$3 = _getSymbols;

    /**
     * Copies own symbols of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy symbols from.
     * @param {Object} [object={}] The object to copy symbols to.
     * @returns {Object} Returns `object`.
     */
    function copySymbols$1(source, object) {
      return copyObject$1(source, getSymbols$3(source), object);
    }

    var _copySymbols = copySymbols$1;

    function arrayPush$2(array, values) {
      var index = -1,
          length = values.length,
          offset = array.length;

      while (++index < length) {
        array[offset + index] = values[index];
      }
      return array;
    }

    var _arrayPush = arrayPush$2;

    var overArg = _overArg;

    /** Built-in value references. */
    var getPrototype$3 = overArg(Object.getPrototypeOf, Object);

    var _getPrototype = getPrototype$3;

    var arrayPush$1 = _arrayPush,
        getPrototype$2 = _getPrototype,
        getSymbols$2 = _getSymbols,
        stubArray = stubArray_1;

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeGetSymbols = Object.getOwnPropertySymbols;

    /**
     * Creates an array of the own and inherited enumerable symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */
    var getSymbolsIn$2 = !nativeGetSymbols ? stubArray : function(object) {
      var result = [];
      while (object) {
        arrayPush$1(result, getSymbols$2(object));
        object = getPrototype$2(object);
      }
      return result;
    };

    var _getSymbolsIn = getSymbolsIn$2;

    var copyObject = _copyObject,
        getSymbolsIn$1 = _getSymbolsIn;

    /**
     * Copies own and inherited symbols of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy symbols from.
     * @param {Object} [object={}] The object to copy symbols to.
     * @returns {Object} Returns `object`.
     */
    function copySymbolsIn$1(source, object) {
      return copyObject(source, getSymbolsIn$1(source), object);
    }

    var _copySymbolsIn = copySymbolsIn$1;

    var arrayPush = _arrayPush,
        isArray$3 = isArray_1;

    /**
     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @param {Function} symbolsFunc The function to get the symbols of `object`.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function baseGetAllKeys$2(object, keysFunc, symbolsFunc) {
      var result = keysFunc(object);
      return isArray$3(object) ? result : arrayPush(result, symbolsFunc(object));
    }

    var _baseGetAllKeys = baseGetAllKeys$2;

    var baseGetAllKeys$1 = _baseGetAllKeys,
        getSymbols$1 = _getSymbols,
        keys$1 = keys_1;

    /**
     * Creates an array of own enumerable property names and symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function getAllKeys$1(object) {
      return baseGetAllKeys$1(object, keys$1, getSymbols$1);
    }

    var _getAllKeys = getAllKeys$1;

    var baseGetAllKeys = _baseGetAllKeys,
        getSymbolsIn = _getSymbolsIn,
        keysIn$1 = keysIn_1;

    /**
     * Creates an array of own and inherited enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function getAllKeysIn$1(object) {
      return baseGetAllKeys(object, keysIn$1, getSymbolsIn);
    }

    var _getAllKeysIn = getAllKeysIn$1;

    var getNative$3 = _getNative,
        root$4 = _root;

    /* Built-in method references that are verified to be native. */
    var DataView$1 = getNative$3(root$4, 'DataView');

    var _DataView = DataView$1;

    var getNative$2 = _getNative,
        root$3 = _root;

    /* Built-in method references that are verified to be native. */
    var Promise$2 = getNative$2(root$3, 'Promise');

    var _Promise = Promise$2;

    var getNative$1 = _getNative,
        root$2 = _root;

    /* Built-in method references that are verified to be native. */
    var Set$3 = getNative$1(root$2, 'Set');

    var _Set = Set$3;

    var getNative = _getNative,
        root$1 = _root;

    /* Built-in method references that are verified to be native. */
    var WeakMap$2 = getNative(root$1, 'WeakMap');

    var _WeakMap = WeakMap$2;

    var DataView = _DataView,
        Map$1 = _Map,
        Promise$1 = _Promise,
        Set$2 = _Set,
        WeakMap$1 = _WeakMap,
        baseGetTag$2 = _baseGetTag,
        toSource = _toSource;

    /** `Object#toString` result references. */
    var mapTag$3 = '[object Map]',
        objectTag$2 = '[object Object]',
        promiseTag = '[object Promise]',
        setTag$3 = '[object Set]',
        weakMapTag$1 = '[object WeakMap]';

    var dataViewTag$2 = '[object DataView]';

    /** Used to detect maps, sets, and weakmaps. */
    var dataViewCtorString = toSource(DataView),
        mapCtorString = toSource(Map$1),
        promiseCtorString = toSource(Promise$1),
        setCtorString = toSource(Set$2),
        weakMapCtorString = toSource(WeakMap$1);

    /**
     * Gets the `toStringTag` of `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    var getTag$3 = baseGetTag$2;

    // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
    if ((DataView && getTag$3(new DataView(new ArrayBuffer(1))) != dataViewTag$2) ||
        (Map$1 && getTag$3(new Map$1) != mapTag$3) ||
        (Promise$1 && getTag$3(Promise$1.resolve()) != promiseTag) ||
        (Set$2 && getTag$3(new Set$2) != setTag$3) ||
        (WeakMap$1 && getTag$3(new WeakMap$1) != weakMapTag$1)) {
      getTag$3 = function(value) {
        var result = baseGetTag$2(value),
            Ctor = result == objectTag$2 ? value.constructor : undefined,
            ctorString = Ctor ? toSource(Ctor) : '';

        if (ctorString) {
          switch (ctorString) {
            case dataViewCtorString: return dataViewTag$2;
            case mapCtorString: return mapTag$3;
            case promiseCtorString: return promiseTag;
            case setCtorString: return setTag$3;
            case weakMapCtorString: return weakMapTag$1;
          }
        }
        return result;
      };
    }

    var _getTag = getTag$3;

    var objectProto$1 = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty$2 = objectProto$1.hasOwnProperty;

    /**
     * Initializes an array clone.
     *
     * @private
     * @param {Array} array The array to clone.
     * @returns {Array} Returns the initialized clone.
     */
    function initCloneArray$1(array) {
      var length = array.length,
          result = new array.constructor(length);

      // Add properties assigned by `RegExp#exec`.
      if (length && typeof array[0] == 'string' && hasOwnProperty$2.call(array, 'index')) {
        result.index = array.index;
        result.input = array.input;
      }
      return result;
    }

    var _initCloneArray = initCloneArray$1;

    var root = _root;

    /** Built-in value references. */
    var Uint8Array$2 = root.Uint8Array;

    var _Uint8Array = Uint8Array$2;

    var Uint8Array$1 = _Uint8Array;

    /**
     * Creates a clone of `arrayBuffer`.
     *
     * @private
     * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
     * @returns {ArrayBuffer} Returns the cloned array buffer.
     */
    function cloneArrayBuffer$3(arrayBuffer) {
      var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
      new Uint8Array$1(result).set(new Uint8Array$1(arrayBuffer));
      return result;
    }

    var _cloneArrayBuffer = cloneArrayBuffer$3;

    var cloneArrayBuffer$2 = _cloneArrayBuffer;

    /**
     * Creates a clone of `dataView`.
     *
     * @private
     * @param {Object} dataView The data view to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the cloned data view.
     */
    function cloneDataView$1(dataView, isDeep) {
      var buffer = isDeep ? cloneArrayBuffer$2(dataView.buffer) : dataView.buffer;
      return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
    }

    var _cloneDataView = cloneDataView$1;

    var reFlags = /\w*$/;

    /**
     * Creates a clone of `regexp`.
     *
     * @private
     * @param {Object} regexp The regexp to clone.
     * @returns {Object} Returns the cloned regexp.
     */
    function cloneRegExp$1(regexp) {
      var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
      result.lastIndex = regexp.lastIndex;
      return result;
    }

    var _cloneRegExp = cloneRegExp$1;

    var Symbol$1 = _Symbol;

    /** Used to convert symbols to primitives and strings. */
    var symbolProto = Symbol$1 ? Symbol$1.prototype : undefined,
        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

    /**
     * Creates a clone of the `symbol` object.
     *
     * @private
     * @param {Object} symbol The symbol object to clone.
     * @returns {Object} Returns the cloned symbol object.
     */
    function cloneSymbol$1(symbol) {
      return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
    }

    var _cloneSymbol = cloneSymbol$1;

    var cloneArrayBuffer$1 = _cloneArrayBuffer;

    /**
     * Creates a clone of `typedArray`.
     *
     * @private
     * @param {Object} typedArray The typed array to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the cloned typed array.
     */
    function cloneTypedArray$1(typedArray, isDeep) {
      var buffer = isDeep ? cloneArrayBuffer$1(typedArray.buffer) : typedArray.buffer;
      return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
    }

    var _cloneTypedArray = cloneTypedArray$1;

    var cloneArrayBuffer = _cloneArrayBuffer,
        cloneDataView = _cloneDataView,
        cloneRegExp = _cloneRegExp,
        cloneSymbol = _cloneSymbol,
        cloneTypedArray = _cloneTypedArray;

    /** `Object#toString` result references. */
    var boolTag$1 = '[object Boolean]',
        dateTag$1 = '[object Date]',
        mapTag$2 = '[object Map]',
        numberTag$1 = '[object Number]',
        regexpTag$2 = '[object RegExp]',
        setTag$2 = '[object Set]',
        stringTag$1 = '[object String]',
        symbolTag$1 = '[object Symbol]';

    var arrayBufferTag$1 = '[object ArrayBuffer]',
        dataViewTag$1 = '[object DataView]',
        float32Tag$1 = '[object Float32Array]',
        float64Tag$1 = '[object Float64Array]',
        int8Tag$1 = '[object Int8Array]',
        int16Tag$1 = '[object Int16Array]',
        int32Tag$1 = '[object Int32Array]',
        uint8Tag$1 = '[object Uint8Array]',
        uint8ClampedTag$1 = '[object Uint8ClampedArray]',
        uint16Tag$1 = '[object Uint16Array]',
        uint32Tag$1 = '[object Uint32Array]';

    /**
     * Initializes an object clone based on its `toStringTag`.
     *
     * **Note:** This function only supports cloning values with tags of
     * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.
     *
     * @private
     * @param {Object} object The object to clone.
     * @param {string} tag The `toStringTag` of the object to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneByTag$1(object, tag, isDeep) {
      var Ctor = object.constructor;
      switch (tag) {
        case arrayBufferTag$1:
          return cloneArrayBuffer(object);

        case boolTag$1:
        case dateTag$1:
          return new Ctor(+object);

        case dataViewTag$1:
          return cloneDataView(object, isDeep);

        case float32Tag$1: case float64Tag$1:
        case int8Tag$1: case int16Tag$1: case int32Tag$1:
        case uint8Tag$1: case uint8ClampedTag$1: case uint16Tag$1: case uint32Tag$1:
          return cloneTypedArray(object, isDeep);

        case mapTag$2:
          return new Ctor;

        case numberTag$1:
        case stringTag$1:
          return new Ctor(object);

        case regexpTag$2:
          return cloneRegExp(object);

        case setTag$2:
          return new Ctor;

        case symbolTag$1:
          return cloneSymbol(object);
      }
    }

    var _initCloneByTag = initCloneByTag$1;

    var isObject$2 = isObject_1;

    /** Built-in value references. */
    var objectCreate = Object.create;

    /**
     * The base implementation of `_.create` without support for assigning
     * properties to the created object.
     *
     * @private
     * @param {Object} proto The object to inherit from.
     * @returns {Object} Returns the new object.
     */
    var baseCreate$1 = (function() {
      function object() {}
      return function(proto) {
        if (!isObject$2(proto)) {
          return {};
        }
        if (objectCreate) {
          return objectCreate(proto);
        }
        object.prototype = proto;
        var result = new object;
        object.prototype = undefined;
        return result;
      };
    }());

    var _baseCreate = baseCreate$1;

    var baseCreate = _baseCreate,
        getPrototype$1 = _getPrototype,
        isPrototype = _isPrototype;

    /**
     * Initializes an object clone.
     *
     * @private
     * @param {Object} object The object to clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneObject$1(object) {
      return (typeof object.constructor == 'function' && !isPrototype(object))
        ? baseCreate(getPrototype$1(object))
        : {};
    }

    var _initCloneObject = initCloneObject$1;

    var getTag$2 = _getTag,
        isObjectLike$3 = isObjectLike_1;

    /** `Object#toString` result references. */
    var mapTag$1 = '[object Map]';

    /**
     * The base implementation of `_.isMap` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
     */
    function baseIsMap$1(value) {
      return isObjectLike$3(value) && getTag$2(value) == mapTag$1;
    }

    var _baseIsMap = baseIsMap$1;

    var baseIsMap = _baseIsMap,
        baseUnary$2 = _baseUnary,
        nodeUtil$2 = _nodeUtilExports;

    /* Node.js helper references. */
    var nodeIsMap = nodeUtil$2 && nodeUtil$2.isMap;

    /**
     * Checks if `value` is classified as a `Map` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
     * @example
     *
     * _.isMap(new Map);
     * // => true
     *
     * _.isMap(new WeakMap);
     * // => false
     */
    var isMap$2 = nodeIsMap ? baseUnary$2(nodeIsMap) : baseIsMap;

    var isMap_1 = isMap$2;

    var getTag$1 = _getTag,
        isObjectLike$2 = isObjectLike_1;

    /** `Object#toString` result references. */
    var setTag$1 = '[object Set]';

    /**
     * The base implementation of `_.isSet` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
     */
    function baseIsSet$1(value) {
      return isObjectLike$2(value) && getTag$1(value) == setTag$1;
    }

    var _baseIsSet = baseIsSet$1;

    var baseIsSet = _baseIsSet,
        baseUnary$1 = _baseUnary,
        nodeUtil$1 = _nodeUtilExports;

    /* Node.js helper references. */
    var nodeIsSet = nodeUtil$1 && nodeUtil$1.isSet;

    /**
     * Checks if `value` is classified as a `Set` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
     * @example
     *
     * _.isSet(new Set);
     * // => true
     *
     * _.isSet(new WeakSet);
     * // => false
     */
    var isSet$2 = nodeIsSet ? baseUnary$1(nodeIsSet) : baseIsSet;

    var isSet_1 = isSet$2;

    var Stack = _Stack,
        arrayEach = _arrayEach,
        assignValue = _assignValue,
        baseAssign = _baseAssign,
        baseAssignIn = _baseAssignIn,
        cloneBuffer = _cloneBufferExports,
        copyArray = _copyArray,
        copySymbols = _copySymbols,
        copySymbolsIn = _copySymbolsIn,
        getAllKeys = _getAllKeys,
        getAllKeysIn = _getAllKeysIn,
        getTag = _getTag,
        initCloneArray = _initCloneArray,
        initCloneByTag = _initCloneByTag,
        initCloneObject = _initCloneObject,
        isArray$2 = isArray_1,
        isBuffer$2 = isBufferExports,
        isMap$1 = isMap_1,
        isObject$1 = isObject_1,
        isSet$1 = isSet_1,
        keys = keys_1;

    /** Used to compose bitmasks for cloning. */
    var CLONE_DEEP_FLAG = 1,
        CLONE_FLAT_FLAG = 2,
        CLONE_SYMBOLS_FLAG$1 = 4;

    /** `Object#toString` result references. */
    var argsTag = '[object Arguments]',
        arrayTag = '[object Array]',
        boolTag = '[object Boolean]',
        dateTag = '[object Date]',
        errorTag = '[object Error]',
        funcTag = '[object Function]',
        genTag = '[object GeneratorFunction]',
        mapTag = '[object Map]',
        numberTag = '[object Number]',
        objectTag$1 = '[object Object]',
        regexpTag$1 = '[object RegExp]',
        setTag = '[object Set]',
        stringTag = '[object String]',
        symbolTag = '[object Symbol]',
        weakMapTag = '[object WeakMap]';

    var arrayBufferTag = '[object ArrayBuffer]',
        dataViewTag = '[object DataView]',
        float32Tag = '[object Float32Array]',
        float64Tag = '[object Float64Array]',
        int8Tag = '[object Int8Array]',
        int16Tag = '[object Int16Array]',
        int32Tag = '[object Int32Array]',
        uint8Tag = '[object Uint8Array]',
        uint8ClampedTag = '[object Uint8ClampedArray]',
        uint16Tag = '[object Uint16Array]',
        uint32Tag = '[object Uint32Array]';

    /** Used to identify `toStringTag` values supported by `_.clone`. */
    var cloneableTags = {};
    cloneableTags[argsTag] = cloneableTags[arrayTag] =
    cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
    cloneableTags[boolTag] = cloneableTags[dateTag] =
    cloneableTags[float32Tag] = cloneableTags[float64Tag] =
    cloneableTags[int8Tag] = cloneableTags[int16Tag] =
    cloneableTags[int32Tag] = cloneableTags[mapTag] =
    cloneableTags[numberTag] = cloneableTags[objectTag$1] =
    cloneableTags[regexpTag$1] = cloneableTags[setTag] =
    cloneableTags[stringTag] = cloneableTags[symbolTag] =
    cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
    cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
    cloneableTags[errorTag] = cloneableTags[funcTag] =
    cloneableTags[weakMapTag] = false;

    /**
     * The base implementation of `_.clone` and `_.cloneDeep` which tracks
     * traversed objects.
     *
     * @private
     * @param {*} value The value to clone.
     * @param {boolean} bitmask The bitmask flags.
     *  1 - Deep clone
     *  2 - Flatten inherited properties
     *  4 - Clone symbols
     * @param {Function} [customizer] The function to customize cloning.
     * @param {string} [key] The key of `value`.
     * @param {Object} [object] The parent object of `value`.
     * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
     * @returns {*} Returns the cloned value.
     */
    function baseClone$1(value, bitmask, customizer, key, object, stack) {
      var result,
          isDeep = bitmask & CLONE_DEEP_FLAG,
          isFlat = bitmask & CLONE_FLAT_FLAG,
          isFull = bitmask & CLONE_SYMBOLS_FLAG$1;

      if (customizer) {
        result = object ? customizer(value, key, object, stack) : customizer(value);
      }
      if (result !== undefined) {
        return result;
      }
      if (!isObject$1(value)) {
        return value;
      }
      var isArr = isArray$2(value);
      if (isArr) {
        result = initCloneArray(value);
        if (!isDeep) {
          return copyArray(value, result);
        }
      } else {
        var tag = getTag(value),
            isFunc = tag == funcTag || tag == genTag;

        if (isBuffer$2(value)) {
          return cloneBuffer(value, isDeep);
        }
        if (tag == objectTag$1 || tag == argsTag || (isFunc && !object)) {
          result = (isFlat || isFunc) ? {} : initCloneObject(value);
          if (!isDeep) {
            return isFlat
              ? copySymbolsIn(value, baseAssignIn(result, value))
              : copySymbols(value, baseAssign(result, value));
          }
        } else {
          if (!cloneableTags[tag]) {
            return object ? value : {};
          }
          result = initCloneByTag(value, tag, isDeep);
        }
      }
      // Check for circular references and return its corresponding clone.
      stack || (stack = new Stack);
      var stacked = stack.get(value);
      if (stacked) {
        return stacked;
      }
      stack.set(value, result);

      if (isSet$1(value)) {
        value.forEach(function(subValue) {
          result.add(baseClone$1(subValue, bitmask, customizer, subValue, value, stack));
        });
      } else if (isMap$1(value)) {
        value.forEach(function(subValue, key) {
          result.set(key, baseClone$1(subValue, bitmask, customizer, key, value, stack));
        });
      }

      var keysFunc = isFull
        ? (isFlat ? getAllKeysIn : getAllKeys)
        : (isFlat ? keysIn : keys);

      var props = isArr ? undefined : keysFunc(value);
      arrayEach(props || value, function(subValue, key) {
        if (props) {
          key = subValue;
          subValue = value[key];
        }
        // Recursively populate clone (susceptible to call stack limits).
        assignValue(result, key, baseClone$1(subValue, bitmask, customizer, key, value, stack));
      });
      return result;
    }

    var _baseClone = baseClone$1;

    var baseClone = _baseClone;

    /** Used to compose bitmasks for cloning. */
    var CLONE_SYMBOLS_FLAG = 4;

    /**
     * Creates a shallow clone of `value`.
     *
     * **Note:** This method is loosely based on the
     * [structured clone algorithm](https://mdn.io/Structured_clone_algorithm)
     * and supports cloning arrays, array buffers, booleans, date objects, maps,
     * numbers, `Object` objects, regexes, sets, strings, symbols, and typed
     * arrays. The own enumerable properties of `arguments` objects are cloned
     * as plain objects. An empty object is returned for uncloneable values such
     * as error objects, functions, DOM nodes, and WeakMaps.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to clone.
     * @returns {*} Returns the cloned value.
     * @see _.cloneDeep
     * @example
     *
     * var objects = [{ 'a': 1 }, { 'b': 2 }];
     *
     * var shallow = _.clone(objects);
     * console.log(shallow[0] === objects[0]);
     * // => true
     */
    function clone$2(value) {
      return baseClone(value, CLONE_SYMBOLS_FLAG);
    }

    var clone_1 = clone$2;

    var definitions = {};

    var core = {};

    var is = {};

    var isType$1 = {};

    var hasRequiredIsType;

    function requireIsType () {
    	if (hasRequiredIsType) return isType$1;
    	hasRequiredIsType = 1;

    	Object.defineProperty(isType$1, "__esModule", {
    	  value: true
    	});
    	isType$1.default = isType;

    	var _definitions = requireDefinitions();

    	function isType(nodeType, targetType) {
    	  if (nodeType === targetType) return true;
    	  if (_definitions.ALIAS_KEYS[targetType]) return false;
    	  const aliases = _definitions.FLIPPED_ALIAS_KEYS[targetType];

    	  if (aliases) {
    	    if (aliases[0] === nodeType) return true;

    	    for (const alias of aliases) {
    	      if (nodeType === alias) return true;
    	    }
    	  }

    	  return false;
    	}
    	return isType$1;
    }

    var isPlaceholderType = {};

    var hasRequiredIsPlaceholderType;

    function requireIsPlaceholderType () {
    	if (hasRequiredIsPlaceholderType) return isPlaceholderType;
    	hasRequiredIsPlaceholderType = 1;

    	Object.defineProperty(isPlaceholderType, "__esModule", {
    	  value: true
    	});
    	isPlaceholderType.default = isPlaceholderType$1;

    	var _definitions = requireDefinitions();

    	function isPlaceholderType$1(placeholderType, targetType) {
    	  if (placeholderType === targetType) return true;
    	  const aliases = _definitions.PLACEHOLDERS_ALIAS[placeholderType];

    	  if (aliases) {
    	    for (const alias of aliases) {
    	      if (targetType === alias) return true;
    	    }
    	  }

    	  return false;
    	}
    	return isPlaceholderType;
    }

    var hasRequiredIs;

    function requireIs () {
    	if (hasRequiredIs) return is;
    	hasRequiredIs = 1;

    	Object.defineProperty(is, "__esModule", {
    	  value: true
    	});
    	is.default = is$1;

    	var _shallowEqual = _interopRequireDefault(shallowEqual$1);

    	var _isType = _interopRequireDefault(requireIsType());

    	var _isPlaceholderType = _interopRequireDefault(requireIsPlaceholderType());

    	var _definitions = requireDefinitions();

    	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    	function is$1(type, node, opts) {
    	  if (!node) return false;
    	  const matches = (0, _isType.default)(node.type, type);

    	  if (!matches) {
    	    if (!opts && node.type === "Placeholder" && type in _definitions.FLIPPED_ALIAS_KEYS) {
    	      return (0, _isPlaceholderType.default)(node.expectedNode, type);
    	    }

    	    return false;
    	  }

    	  if (typeof opts === "undefined") {
    	    return true;
    	  } else {
    	    return (0, _shallowEqual.default)(node, opts);
    	  }
    	}
    	return is;
    }

    var isValidIdentifier$1 = {};

    var lib$3 = {};

    var identifier = {};

    Object.defineProperty(identifier, "__esModule", {
      value: true
    });
    identifier.isIdentifierStart = isIdentifierStart$2;
    identifier.isIdentifierChar = isIdentifierChar$2;
    identifier.isIdentifierName = isIdentifierName;
    let nonASCIIidentifierStartChars$2 = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u08a0-\u08b4\u08b6-\u08c7\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c88\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\u9ffc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7bf\ua7c2-\ua7ca\ua7f5-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";
    let nonASCIIidentifierChars$2 = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf\u1ac0\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f";
    const nonASCIIidentifierStart$2 = new RegExp("[" + nonASCIIidentifierStartChars$2 + "]");
    const nonASCIIidentifier$2 = new RegExp("[" + nonASCIIidentifierStartChars$2 + nonASCIIidentifierChars$2 + "]");
    nonASCIIidentifierStartChars$2 = nonASCIIidentifierChars$2 = null;
    const astralIdentifierStartCodes$2 = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 157, 310, 10, 21, 11, 7, 153, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 107, 20, 28, 22, 13, 52, 76, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 230, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 35, 56, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2749, 1070, 4050, 582, 8634, 568, 8, 30, 114, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8952, 286, 50, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 2357, 44, 11, 6, 17, 0, 370, 43, 1301, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42717, 35, 4148, 12, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
    const astralIdentifierCodes$2 = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 176, 2, 54, 14, 32, 9, 16, 3, 46, 10, 54, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 135, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 5319, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 419, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

    function isInAstralSet$2(code, set) {
      let pos = 0x10000;

      for (let i = 0, length = set.length; i < length; i += 2) {
        pos += set[i];
        if (pos > code) return false;
        pos += set[i + 1];
        if (pos >= code) return true;
      }

      return false;
    }

    function isIdentifierStart$2(code) {
      if (code < 65) return code === 36;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;

      if (code <= 0xffff) {
        return code >= 0xaa && nonASCIIidentifierStart$2.test(String.fromCharCode(code));
      }

      return isInAstralSet$2(code, astralIdentifierStartCodes$2);
    }

    function isIdentifierChar$2(code) {
      if (code < 48) return code === 36;
      if (code < 58) return true;
      if (code < 65) return false;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;

      if (code <= 0xffff) {
        return code >= 0xaa && nonASCIIidentifier$2.test(String.fromCharCode(code));
      }

      return isInAstralSet$2(code, astralIdentifierStartCodes$2) || isInAstralSet$2(code, astralIdentifierCodes$2);
    }

    function isIdentifierName(name) {
      let isFirst = true;

      for (let _i = 0, _Array$from = Array.from(name); _i < _Array$from.length; _i++) {
        const char = _Array$from[_i];
        const cp = char.codePointAt(0);

        if (isFirst) {
          if (!isIdentifierStart$2(cp)) {
            return false;
          }

          isFirst = false;
        } else if (!isIdentifierChar$2(cp)) {
          return false;
        }
      }

      return !isFirst;
    }

    var keyword = {};

    Object.defineProperty(keyword, "__esModule", {
      value: true
    });
    keyword.isReservedWord = isReservedWord$2;
    keyword.isStrictReservedWord = isStrictReservedWord$2;
    keyword.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord$2;
    keyword.isStrictBindReservedWord = isStrictBindReservedWord$2;
    keyword.isKeyword = isKeyword$2;
    const reservedWords$2 = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    const keywords$3 = new Set(reservedWords$2.keyword);
    const reservedWordsStrictSet$2 = new Set(reservedWords$2.strict);
    const reservedWordsStrictBindSet$2 = new Set(reservedWords$2.strictBind);

    function isReservedWord$2(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }

    function isStrictReservedWord$2(word, inModule) {
      return isReservedWord$2(word, inModule) || reservedWordsStrictSet$2.has(word);
    }

    function isStrictBindOnlyReservedWord$2(word) {
      return reservedWordsStrictBindSet$2.has(word);
    }

    function isStrictBindReservedWord$2(word, inModule) {
      return isStrictReservedWord$2(word, inModule) || isStrictBindOnlyReservedWord$2(word);
    }

    function isKeyword$2(word) {
      return keywords$3.has(word);
    }

    (function (exports) {

    	Object.defineProperty(exports, "__esModule", {
    	  value: true
    	});
    	Object.defineProperty(exports, "isIdentifierName", {
    	  enumerable: true,
    	  get: function () {
    	    return _identifier.isIdentifierName;
    	  }
    	});
    	Object.defineProperty(exports, "isIdentifierChar", {
    	  enumerable: true,
    	  get: function () {
    	    return _identifier.isIdentifierChar;
    	  }
    	});
    	Object.defineProperty(exports, "isIdentifierStart", {
    	  enumerable: true,
    	  get: function () {
    	    return _identifier.isIdentifierStart;
    	  }
    	});
    	Object.defineProperty(exports, "isReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isStrictBindOnlyReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isStrictBindOnlyReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isStrictBindReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isStrictBindReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isStrictReservedWord", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isStrictReservedWord;
    	  }
    	});
    	Object.defineProperty(exports, "isKeyword", {
    	  enumerable: true,
    	  get: function () {
    	    return _keyword.isKeyword;
    	  }
    	});

    	var _identifier = identifier;

    	var _keyword = keyword;
    } (lib$3));

    Object.defineProperty(isValidIdentifier$1, "__esModule", {
      value: true
    });
    isValidIdentifier$1.default = isValidIdentifier;

    var _helperValidatorIdentifier = lib$3;

    function isValidIdentifier(name, reserved = true) {
      if (typeof name !== "string") return false;

      if (reserved) {
        if ((0, _helperValidatorIdentifier.isKeyword)(name) || (0, _helperValidatorIdentifier.isStrictReservedWord)(name)) {
          return false;
        } else if (name === "await") {
          return false;
        }
      }

      return (0, _helperValidatorIdentifier.isIdentifierName)(name);
    }

    var constants = {};

    Object.defineProperty(constants, "__esModule", {
      value: true
    });
    constants.NOT_LOCAL_BINDING = constants.BLOCK_SCOPED_SYMBOL = constants.INHERIT_KEYS = constants.UNARY_OPERATORS = constants.STRING_UNARY_OPERATORS = constants.NUMBER_UNARY_OPERATORS = constants.BOOLEAN_UNARY_OPERATORS = constants.ASSIGNMENT_OPERATORS = constants.BINARY_OPERATORS = constants.NUMBER_BINARY_OPERATORS = constants.BOOLEAN_BINARY_OPERATORS = constants.COMPARISON_BINARY_OPERATORS = constants.EQUALITY_BINARY_OPERATORS = constants.BOOLEAN_NUMBER_BINARY_OPERATORS = constants.UPDATE_OPERATORS = constants.LOGICAL_OPERATORS = constants.COMMENT_KEYS = constants.FOR_INIT_KEYS = constants.FLATTENABLE_KEYS = constants.STATEMENT_OR_BLOCK_KEYS = void 0;
    const STATEMENT_OR_BLOCK_KEYS = ["consequent", "body", "alternate"];
    constants.STATEMENT_OR_BLOCK_KEYS = STATEMENT_OR_BLOCK_KEYS;
    const FLATTENABLE_KEYS = ["body", "expressions"];
    constants.FLATTENABLE_KEYS = FLATTENABLE_KEYS;
    const FOR_INIT_KEYS = ["left", "init"];
    constants.FOR_INIT_KEYS = FOR_INIT_KEYS;
    const COMMENT_KEYS = ["leadingComments", "trailingComments", "innerComments"];
    constants.COMMENT_KEYS = COMMENT_KEYS;
    const LOGICAL_OPERATORS = ["||", "&&", "??"];
    constants.LOGICAL_OPERATORS = LOGICAL_OPERATORS;
    const UPDATE_OPERATORS = ["++", "--"];
    constants.UPDATE_OPERATORS = UPDATE_OPERATORS;
    const BOOLEAN_NUMBER_BINARY_OPERATORS = [">", "<", ">=", "<="];
    constants.BOOLEAN_NUMBER_BINARY_OPERATORS = BOOLEAN_NUMBER_BINARY_OPERATORS;
    const EQUALITY_BINARY_OPERATORS = ["==", "===", "!=", "!=="];
    constants.EQUALITY_BINARY_OPERATORS = EQUALITY_BINARY_OPERATORS;
    const COMPARISON_BINARY_OPERATORS = [...EQUALITY_BINARY_OPERATORS, "in", "instanceof"];
    constants.COMPARISON_BINARY_OPERATORS = COMPARISON_BINARY_OPERATORS;
    const BOOLEAN_BINARY_OPERATORS = [...COMPARISON_BINARY_OPERATORS, ...BOOLEAN_NUMBER_BINARY_OPERATORS];
    constants.BOOLEAN_BINARY_OPERATORS = BOOLEAN_BINARY_OPERATORS;
    const NUMBER_BINARY_OPERATORS = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
    constants.NUMBER_BINARY_OPERATORS = NUMBER_BINARY_OPERATORS;
    const BINARY_OPERATORS = ["+", ...NUMBER_BINARY_OPERATORS, ...BOOLEAN_BINARY_OPERATORS];
    constants.BINARY_OPERATORS = BINARY_OPERATORS;
    const ASSIGNMENT_OPERATORS = ["=", "+=", ...NUMBER_BINARY_OPERATORS.map(op => op + "="), ...LOGICAL_OPERATORS.map(op => op + "=")];
    constants.ASSIGNMENT_OPERATORS = ASSIGNMENT_OPERATORS;
    const BOOLEAN_UNARY_OPERATORS = ["delete", "!"];
    constants.BOOLEAN_UNARY_OPERATORS = BOOLEAN_UNARY_OPERATORS;
    const NUMBER_UNARY_OPERATORS = ["+", "-", "~"];
    constants.NUMBER_UNARY_OPERATORS = NUMBER_UNARY_OPERATORS;
    const STRING_UNARY_OPERATORS = ["typeof"];
    constants.STRING_UNARY_OPERATORS = STRING_UNARY_OPERATORS;
    const UNARY_OPERATORS = ["void", "throw", ...BOOLEAN_UNARY_OPERATORS, ...NUMBER_UNARY_OPERATORS, ...STRING_UNARY_OPERATORS];
    constants.UNARY_OPERATORS = UNARY_OPERATORS;
    const INHERIT_KEYS = {
      optional: ["typeAnnotation", "typeParameters", "returnType"],
      force: ["start", "loc", "end"]
    };
    constants.INHERIT_KEYS = INHERIT_KEYS;
    const BLOCK_SCOPED_SYMBOL = Symbol.for("var used to be block scoped");
    constants.BLOCK_SCOPED_SYMBOL = BLOCK_SCOPED_SYMBOL;
    const NOT_LOCAL_BINDING = Symbol.for("should not be considered a local binding");
    constants.NOT_LOCAL_BINDING = NOT_LOCAL_BINDING;

    var utils = {};

    var validate = {};

    var hasRequiredValidate;

    function requireValidate () {
    	if (hasRequiredValidate) return validate;
    	hasRequiredValidate = 1;

    	Object.defineProperty(validate, "__esModule", {
    	  value: true
    	});
    	validate.default = validate$1;
    	validate.validateField = validateField;
    	validate.validateChild = validateChild;

    	var _definitions = requireDefinitions();

    	function validate$1(node, key, val) {
    	  if (!node) return;
    	  const fields = _definitions.NODE_FIELDS[node.type];
    	  if (!fields) return;
    	  const field = fields[key];
    	  validateField(node, key, val, field);
    	  validateChild(node, key, val);
    	}

    	function validateField(node, key, val, field) {
    	  if (!(field == null ? void 0 : field.validate)) return;
    	  if (field.optional && val == null) return;
    	  field.validate(node, key, val);
    	}

    	function validateChild(node, key, val) {
    	  if (val == null) return;
    	  const validate = _definitions.NODE_PARENT_VALIDATIONS[val.type];
    	  if (!validate) return;
    	  validate(node, key, val);
    	}
    	return validate;
    }

    var hasRequiredUtils;

    function requireUtils () {
    	if (hasRequiredUtils) return utils;
    	hasRequiredUtils = 1;

    	Object.defineProperty(utils, "__esModule", {
    	  value: true
    	});
    	utils.validate = validate;
    	utils.typeIs = typeIs;
    	utils.validateType = validateType;
    	utils.validateOptional = validateOptional;
    	utils.validateOptionalType = validateOptionalType;
    	utils.arrayOf = arrayOf;
    	utils.arrayOfType = arrayOfType;
    	utils.validateArrayOfType = validateArrayOfType;
    	utils.assertEach = assertEach;
    	utils.assertOneOf = assertOneOf;
    	utils.assertNodeType = assertNodeType;
    	utils.assertNodeOrValueType = assertNodeOrValueType;
    	utils.assertValueType = assertValueType;
    	utils.assertShape = assertShape;
    	utils.assertOptionalChainStart = assertOptionalChainStart;
    	utils.chain = chain;
    	utils.default = defineType;
    	utils.NODE_PARENT_VALIDATIONS = utils.DEPRECATED_KEYS = utils.BUILDER_KEYS = utils.NODE_FIELDS = utils.FLIPPED_ALIAS_KEYS = utils.ALIAS_KEYS = utils.VISITOR_KEYS = void 0;

    	var _is = _interopRequireDefault(requireIs());

    	var _validate = requireValidate();

    	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    	const VISITOR_KEYS = {};
    	utils.VISITOR_KEYS = VISITOR_KEYS;
    	const ALIAS_KEYS = {};
    	utils.ALIAS_KEYS = ALIAS_KEYS;
    	const FLIPPED_ALIAS_KEYS = {};
    	utils.FLIPPED_ALIAS_KEYS = FLIPPED_ALIAS_KEYS;
    	const NODE_FIELDS = {};
    	utils.NODE_FIELDS = NODE_FIELDS;
    	const BUILDER_KEYS = {};
    	utils.BUILDER_KEYS = BUILDER_KEYS;
    	const DEPRECATED_KEYS = {};
    	utils.DEPRECATED_KEYS = DEPRECATED_KEYS;
    	const NODE_PARENT_VALIDATIONS = {};
    	utils.NODE_PARENT_VALIDATIONS = NODE_PARENT_VALIDATIONS;

    	function getType(val) {
    	  if (Array.isArray(val)) {
    	    return "array";
    	  } else if (val === null) {
    	    return "null";
    	  } else {
    	    return typeof val;
    	  }
    	}

    	function validate(validate) {
    	  return {
    	    validate
    	  };
    	}

    	function typeIs(typeName) {
    	  return typeof typeName === "string" ? assertNodeType(typeName) : assertNodeType(...typeName);
    	}

    	function validateType(typeName) {
    	  return validate(typeIs(typeName));
    	}

    	function validateOptional(validate) {
    	  return {
    	    validate,
    	    optional: true
    	  };
    	}

    	function validateOptionalType(typeName) {
    	  return {
    	    validate: typeIs(typeName),
    	    optional: true
    	  };
    	}

    	function arrayOf(elementType) {
    	  return chain(assertValueType("array"), assertEach(elementType));
    	}

    	function arrayOfType(typeName) {
    	  return arrayOf(typeIs(typeName));
    	}

    	function validateArrayOfType(typeName) {
    	  return validate(arrayOfType(typeName));
    	}

    	function assertEach(callback) {
    	  function validator(node, key, val) {
    	    if (!Array.isArray(val)) return;

    	    for (let i = 0; i < val.length; i++) {
    	      const subkey = `${key}[${i}]`;
    	      const v = val[i];
    	      callback(node, subkey, v);
    	      if (process$1.env.BABEL_TYPES_8_BREAKING) (0, _validate.validateChild)(node, subkey, v);
    	    }
    	  }

    	  validator.each = callback;
    	  return validator;
    	}

    	function assertOneOf(...values) {
    	  function validate(node, key, val) {
    	    if (values.indexOf(val) < 0) {
    	      throw new TypeError(`Property ${key} expected value to be one of ${JSON.stringify(values)} but got ${JSON.stringify(val)}`);
    	    }
    	  }

    	  validate.oneOf = values;
    	  return validate;
    	}

    	function assertNodeType(...types) {
    	  function validate(node, key, val) {
    	    for (const type of types) {
    	      if ((0, _is.default)(type, val)) {
    	        (0, _validate.validateChild)(node, key, val);
    	        return;
    	      }
    	    }

    	    throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
    	  }

    	  validate.oneOfNodeTypes = types;
    	  return validate;
    	}

    	function assertNodeOrValueType(...types) {
    	  function validate(node, key, val) {
    	    for (const type of types) {
    	      if (getType(val) === type || (0, _is.default)(type, val)) {
    	        (0, _validate.validateChild)(node, key, val);
    	        return;
    	      }
    	    }

    	    throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
    	  }

    	  validate.oneOfNodeOrValueTypes = types;
    	  return validate;
    	}

    	function assertValueType(type) {
    	  function validate(node, key, val) {
    	    const valid = getType(val) === type;

    	    if (!valid) {
    	      throw new TypeError(`Property ${key} expected type of ${type} but got ${getType(val)}`);
    	    }
    	  }

    	  validate.type = type;
    	  return validate;
    	}

    	function assertShape(shape) {
    	  function validate(node, key, val) {
    	    const errors = [];

    	    for (const property of Object.keys(shape)) {
    	      try {
    	        (0, _validate.validateField)(node, property, val[property], shape[property]);
    	      } catch (error) {
    	        if (error instanceof TypeError) {
    	          errors.push(error.message);
    	          continue;
    	        }

    	        throw error;
    	      }
    	    }

    	    if (errors.length) {
    	      throw new TypeError(`Property ${key} of ${node.type} expected to have the following:\n${errors.join("\n")}`);
    	    }
    	  }

    	  validate.shapeOf = shape;
    	  return validate;
    	}

    	function assertOptionalChainStart() {
    	  function validate(node) {
    	    var _current;

    	    let current = node;

    	    while (node) {
    	      const {
    	        type
    	      } = current;

    	      if (type === "OptionalCallExpression") {
    	        if (current.optional) return;
    	        current = current.callee;
    	        continue;
    	      }

    	      if (type === "OptionalMemberExpression") {
    	        if (current.optional) return;
    	        current = current.object;
    	        continue;
    	      }

    	      break;
    	    }

    	    throw new TypeError(`Non-optional ${node.type} must chain from an optional OptionalMemberExpression or OptionalCallExpression. Found chain from ${(_current = current) == null ? void 0 : _current.type}`);
    	  }

    	  return validate;
    	}

    	function chain(...fns) {
    	  function validate(...args) {
    	    for (const fn of fns) {
    	      fn(...args);
    	    }
    	  }

    	  validate.chainOf = fns;
    	  return validate;
    	}

    	const validTypeOpts = ["aliases", "builder", "deprecatedAlias", "fields", "inherits", "visitor", "validate"];
    	const validFieldKeys = ["default", "optional", "validate"];

    	function defineType(type, opts = {}) {
    	  const inherits = opts.inherits && store[opts.inherits] || {};
    	  let fields = opts.fields;

    	  if (!fields) {
    	    fields = {};

    	    if (inherits.fields) {
    	      const keys = Object.getOwnPropertyNames(inherits.fields);

    	      for (const key of keys) {
    	        const field = inherits.fields[key];
    	        fields[key] = {
    	          default: field.default,
    	          optional: field.optional,
    	          validate: field.validate
    	        };
    	      }
    	    }
    	  }

    	  const visitor = opts.visitor || inherits.visitor || [];
    	  const aliases = opts.aliases || inherits.aliases || [];
    	  const builder = opts.builder || inherits.builder || opts.visitor || [];

    	  for (const k of Object.keys(opts)) {
    	    if (validTypeOpts.indexOf(k) === -1) {
    	      throw new Error(`Unknown type option "${k}" on ${type}`);
    	    }
    	  }

    	  if (opts.deprecatedAlias) {
    	    DEPRECATED_KEYS[opts.deprecatedAlias] = type;
    	  }

    	  for (const key of visitor.concat(builder)) {
    	    fields[key] = fields[key] || {};
    	  }

    	  for (const key of Object.keys(fields)) {
    	    const field = fields[key];

    	    if (field.default !== undefined && builder.indexOf(key) === -1) {
    	      field.optional = true;
    	    }

    	    if (field.default === undefined) {
    	      field.default = null;
    	    } else if (!field.validate && field.default != null) {
    	      field.validate = assertValueType(getType(field.default));
    	    }

    	    for (const k of Object.keys(field)) {
    	      if (validFieldKeys.indexOf(k) === -1) {
    	        throw new Error(`Unknown field key "${k}" on ${type}.${key}`);
    	      }
    	    }
    	  }

    	  VISITOR_KEYS[type] = opts.visitor = visitor;
    	  BUILDER_KEYS[type] = opts.builder = builder;
    	  NODE_FIELDS[type] = opts.fields = fields;
    	  ALIAS_KEYS[type] = opts.aliases = aliases;
    	  aliases.forEach(alias => {
    	    FLIPPED_ALIAS_KEYS[alias] = FLIPPED_ALIAS_KEYS[alias] || [];
    	    FLIPPED_ALIAS_KEYS[alias].push(type);
    	  });

    	  if (opts.validate) {
    	    NODE_PARENT_VALIDATIONS[type] = opts.validate;
    	  }

    	  store[type] = opts;
    	}

    	const store = {};
    	return utils;
    }

    var hasRequiredCore;

    function requireCore () {
    	if (hasRequiredCore) return core;
    	hasRequiredCore = 1;

    	Object.defineProperty(core, "__esModule", {
    	  value: true
    	});
    	core.patternLikeCommon = core.functionDeclarationCommon = core.functionTypeAnnotationCommon = core.functionCommon = void 0;

    	var _is = _interopRequireDefault(requireIs());

    	var _isValidIdentifier = _interopRequireDefault(isValidIdentifier$1);

    	var _helperValidatorIdentifier = lib$3;

    	var _constants = constants;

    	var _utils = _interopRequireWildcard(requireUtils());

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    	(0, _utils.default)("ArrayExpression", {
    	  fields: {
    	    elements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "Expression", "SpreadElement"))),
    	      default: !process$1.env.BABEL_TYPES_8_BREAKING ? [] : undefined
    	    }
    	  },
    	  visitor: ["elements"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("AssignmentExpression", {
    	  fields: {
    	    operator: {
    	      validate: function () {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) {
    	          return (0, _utils.assertValueType)("string");
    	        }

    	        const identifier = (0, _utils.assertOneOf)(..._constants.ASSIGNMENT_OPERATORS);
    	        const pattern = (0, _utils.assertOneOf)("=");
    	        return function (node, key, val) {
    	          const validator = (0, _is.default)("Pattern", node.left) ? pattern : identifier;
    	          validator(node, key, val);
    	        };
    	      }()
    	    },
    	    left: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  builder: ["operator", "left", "right"],
    	  visitor: ["left", "right"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("BinaryExpression", {
    	  builder: ["operator", "left", "right"],
    	  fields: {
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.BINARY_OPERATORS)
    	    },
    	    left: {
    	      validate: function () {
    	        const expression = (0, _utils.assertNodeType)("Expression");
    	        const inOp = (0, _utils.assertNodeType)("Expression", "PrivateName");

    	        const validator = function (node, key, val) {
    	          const validator = node.operator === "in" ? inOp : expression;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "PrivateName"];
    	        return validator;
    	      }()
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  visitor: ["left", "right"],
    	  aliases: ["Binary", "Expression"]
    	});
    	(0, _utils.default)("InterpreterDirective", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("Directive", {
    	  visitor: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertNodeType)("DirectiveLiteral")
    	    }
    	  }
    	});
    	(0, _utils.default)("DirectiveLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("BlockStatement", {
    	  builder: ["body", "directives"],
    	  visitor: ["directives", "body"],
    	  fields: {
    	    directives: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Directive"))),
    	      default: []
    	    },
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent", "Block", "Statement"]
    	});
    	(0, _utils.default)("BreakStatement", {
    	  visitor: ["label"],
    	  fields: {
    	    label: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    }
    	  },
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"]
    	});
    	(0, _utils.default)("CallExpression", {
    	  visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
    	  builder: ["callee", "arguments"],
    	  aliases: ["Expression"],
    	  fields: Object.assign({
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression", "V8IntrinsicIdentifier")
    	    },
    	    arguments: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement", "JSXNamespacedName", "ArgumentPlaceholder")))
    	    }
    	  }, !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	    optional: {
    	      validate: (0, _utils.assertOneOf)(true, false),
    	      optional: true
    	    }
    	  } : {}, {
    	    typeArguments: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
    	      optional: true
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("CatchClause", {
    	  visitor: ["param", "body"],
    	  fields: {
    	    param: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent"]
    	});
    	(0, _utils.default)("ConditionalExpression", {
    	  visitor: ["test", "consequent", "alternate"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    consequent: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    alternate: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  aliases: ["Expression", "Conditional"]
    	});
    	(0, _utils.default)("ContinueStatement", {
    	  visitor: ["label"],
    	  fields: {
    	    label: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    }
    	  },
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"]
    	});
    	(0, _utils.default)("DebuggerStatement", {
    	  aliases: ["Statement"]
    	});
    	(0, _utils.default)("DoWhileStatement", {
    	  visitor: ["test", "body"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  },
    	  aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"]
    	});
    	(0, _utils.default)("EmptyStatement", {
    	  aliases: ["Statement"]
    	});
    	(0, _utils.default)("ExpressionStatement", {
    	  visitor: ["expression"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  },
    	  aliases: ["Statement", "ExpressionWrapper"]
    	});
    	(0, _utils.default)("File", {
    	  builder: ["program", "comments", "tokens"],
    	  visitor: ["program"],
    	  fields: {
    	    program: {
    	      validate: (0, _utils.assertNodeType)("Program")
    	    },
    	    comments: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? Object.assign(() => {}, {
    	        each: {
    	          oneOfNodeTypes: ["CommentBlock", "CommentLine"]
    	        }
    	      }) : (0, _utils.assertEach)((0, _utils.assertNodeType)("CommentBlock", "CommentLine")),
    	      optional: true
    	    },
    	    tokens: {
    	      validate: (0, _utils.assertEach)(Object.assign(() => {}, {
    	        type: "any"
    	      })),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ForInStatement", {
    	  visitor: ["left", "right", "body"],
    	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    	  fields: {
    	    left: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("VariableDeclaration", "LVal") : (0, _utils.assertNodeType)("VariableDeclaration", "Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("ForStatement", {
    	  visitor: ["init", "test", "update", "body"],
    	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop"],
    	  fields: {
    	    init: {
    	      validate: (0, _utils.assertNodeType)("VariableDeclaration", "Expression"),
    	      optional: true
    	    },
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    update: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	const functionCommon = {
    	  params: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Identifier", "Pattern", "RestElement", "TSParameterProperty")))
    	  },
    	  generator: {
    	    default: false
    	  },
    	  async: {
    	    default: false
    	  }
    	};
    	core.functionCommon = functionCommon;
    	const functionTypeAnnotationCommon = {
    	  returnType: {
    	    validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	    optional: true
    	  },
    	  typeParameters: {
    	    validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    	    optional: true
    	  }
    	};
    	core.functionTypeAnnotationCommon = functionTypeAnnotationCommon;
    	const functionDeclarationCommon = Object.assign({}, functionCommon, {
    	  declare: {
    	    validate: (0, _utils.assertValueType)("boolean"),
    	    optional: true
    	  },
    	  id: {
    	    validate: (0, _utils.assertNodeType)("Identifier"),
    	    optional: true
    	  }
    	});
    	core.functionDeclarationCommon = functionDeclarationCommon;
    	(0, _utils.default)("FunctionDeclaration", {
    	  builder: ["id", "params", "body", "generator", "async"],
    	  visitor: ["id", "params", "body", "returnType", "typeParameters"],
    	  fields: Object.assign({}, functionDeclarationCommon, functionTypeAnnotationCommon, {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }),
    	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Statement", "Pureish", "Declaration"],
    	  validate: function () {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return () => {};
    	    const identifier = (0, _utils.assertNodeType)("Identifier");
    	    return function (parent, key, node) {
    	      if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
    	        identifier(node, "id", node.id);
    	      }
    	    };
    	  }()
    	});
    	(0, _utils.default)("FunctionExpression", {
    	  inherits: "FunctionDeclaration",
    	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  })
    	});
    	const patternLikeCommon = {
    	  typeAnnotation: {
    	    validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	    optional: true
    	  },
    	  decorators: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator")))
    	  }
    	};
    	core.patternLikeCommon = patternLikeCommon;
    	(0, _utils.default)("Identifier", {
    	  builder: ["name"],
    	  visitor: ["typeAnnotation", "decorators"],
    	  aliases: ["Expression", "PatternLike", "LVal", "TSEntityName"],
    	  fields: Object.assign({}, patternLikeCommon, {
    	    name: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (!(0, _isValidIdentifier.default)(val, false)) {
    	          throw new TypeError(`"${val}" is not a valid identifier name`);
    	        }
    	      }, {
    	        type: "string"
    	      }))
    	    },
    	    optional: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  }),

    	  validate(parent, key, node) {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	    const match = /\.(\w+)$/.exec(key);
    	    if (!match) return;
    	    const [, parentKey] = match;
    	    const nonComp = {
    	      computed: false
    	    };

    	    if (parentKey === "property") {
    	      if ((0, _is.default)("MemberExpression", parent, nonComp)) return;
    	      if ((0, _is.default)("OptionalMemberExpression", parent, nonComp)) return;
    	    } else if (parentKey === "key") {
    	      if ((0, _is.default)("Property", parent, nonComp)) return;
    	      if ((0, _is.default)("Method", parent, nonComp)) return;
    	    } else if (parentKey === "exported") {
    	      if ((0, _is.default)("ExportSpecifier", parent)) return;
    	    } else if (parentKey === "imported") {
    	      if ((0, _is.default)("ImportSpecifier", parent, {
    	        imported: node
    	      })) return;
    	    } else if (parentKey === "meta") {
    	      if ((0, _is.default)("MetaProperty", parent, {
    	        meta: node
    	      })) return;
    	    }

    	    if (((0, _helperValidatorIdentifier.isKeyword)(node.name) || (0, _helperValidatorIdentifier.isReservedWord)(node.name)) && node.name !== "this") {
    	      throw new TypeError(`"${node.name}" is not a valid identifier`);
    	    }
    	  }

    	});
    	(0, _utils.default)("IfStatement", {
    	  visitor: ["test", "consequent", "alternate"],
    	  aliases: ["Statement", "Conditional"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    consequent: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    },
    	    alternate: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("LabeledStatement", {
    	  visitor: ["label", "body"],
    	  aliases: ["Statement"],
    	  fields: {
    	    label: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("StringLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("NumericLiteral", {
    	  builder: ["value"],
    	  deprecatedAlias: "NumberLiteral",
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("number")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("NullLiteral", {
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("BooleanLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("boolean")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("RegExpLiteral", {
    	  builder: ["pattern", "flags"],
    	  deprecatedAlias: "RegexLiteral",
    	  aliases: ["Expression", "Pureish", "Literal"],
    	  fields: {
    	    pattern: {
    	      validate: (0, _utils.assertValueType)("string")
    	    },
    	    flags: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	        const invalid = /[^gimsuy]/.exec(val);

    	        if (invalid) {
    	          throw new TypeError(`"${invalid[0]}" is not a valid RegExp flag`);
    	        }
    	      }, {
    	        type: "string"
    	      })),
    	      default: ""
    	    }
    	  }
    	});
    	(0, _utils.default)("LogicalExpression", {
    	  builder: ["operator", "left", "right"],
    	  visitor: ["left", "right"],
    	  aliases: ["Binary", "Expression"],
    	  fields: {
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.LOGICAL_OPERATORS)
    	    },
    	    left: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("MemberExpression", {
    	  builder: ["object", "property", "computed", "optional"],
    	  visitor: ["object", "property"],
    	  aliases: ["Expression", "LVal"],
    	  fields: Object.assign({
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    property: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier", "PrivateName");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier", "PrivateName"];
    	        return validator;
    	      }()
    	    },
    	    computed: {
    	      default: false
    	    }
    	  }, !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	    optional: {
    	      validate: (0, _utils.assertOneOf)(true, false),
    	      optional: true
    	    }
    	  } : {})
    	});
    	(0, _utils.default)("NewExpression", {
    	  inherits: "CallExpression"
    	});
    	(0, _utils.default)("Program", {
    	  visitor: ["directives", "body"],
    	  builder: ["body", "directives", "sourceType", "interpreter"],
    	  fields: {
    	    sourceFile: {
    	      validate: (0, _utils.assertValueType)("string")
    	    },
    	    sourceType: {
    	      validate: (0, _utils.assertOneOf)("script", "module"),
    	      default: "script"
    	    },
    	    interpreter: {
    	      validate: (0, _utils.assertNodeType)("InterpreterDirective"),
    	      default: null,
    	      optional: true
    	    },
    	    directives: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Directive"))),
    	      default: []
    	    },
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  },
    	  aliases: ["Scopable", "BlockParent", "Block"]
    	});
    	(0, _utils.default)("ObjectExpression", {
    	  visitor: ["properties"],
    	  aliases: ["Expression"],
    	  fields: {
    	    properties: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ObjectMethod", "ObjectProperty", "SpreadElement")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ObjectMethod", {
    	  builder: ["kind", "key", "params", "body", "computed", "generator", "async"],
    	  fields: Object.assign({}, functionCommon, functionTypeAnnotationCommon, {
    	    kind: Object.assign({
    	      validate: (0, _utils.assertOneOf)("method", "get", "set")
    	    }, !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	      default: "method"
    	    } : {}),
    	    computed: {
    	      default: false
    	    },
    	    key: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
    	        return validator;
    	      }()
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }),
    	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    	  aliases: ["UserWhitespacable", "Function", "Scopable", "BlockParent", "FunctionParent", "Method", "ObjectMember"]
    	});
    	(0, _utils.default)("ObjectProperty", {
    	  builder: ["key", "value", "computed", "shorthand", ...(!process$1.env.BABEL_TYPES_8_BREAKING ? ["decorators"] : [])],
    	  fields: {
    	    computed: {
    	      default: false
    	    },
    	    key: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral"];
    	        return validator;
    	      }()
    	    },
    	    value: {
    	      validate: (0, _utils.assertNodeType)("Expression", "PatternLike")
    	    },
    	    shorthand: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && node.computed) {
    	          throw new TypeError("Property shorthand of ObjectProperty cannot be true if computed is true");
    	        }
    	      }, {
    	        type: "boolean"
    	      }), function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && !(0, _is.default)("Identifier", node.key)) {
    	          throw new TypeError("Property shorthand of ObjectProperty cannot be true if key is not an Identifier");
    	        }
    	      }),
    	      default: false
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  },
    	  visitor: ["key", "value", "decorators"],
    	  aliases: ["UserWhitespacable", "Property", "ObjectMember"],
    	  validate: function () {
    	    const pattern = (0, _utils.assertNodeType)("Identifier", "Pattern");
    	    const expression = (0, _utils.assertNodeType)("Expression");
    	    return function (parent, key, node) {
    	      if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	      const validator = (0, _is.default)("ObjectPattern", parent) ? pattern : expression;
    	      validator(node, "value", node.value);
    	    };
    	  }()
    	});
    	(0, _utils.default)("RestElement", {
    	  visitor: ["argument", "typeAnnotation"],
    	  builder: ["argument"],
    	  aliases: ["LVal", "PatternLike"],
    	  deprecatedAlias: "RestProperty",
    	  fields: Object.assign({}, patternLikeCommon, {
    	    argument: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "Pattern", "MemberExpression")
    	    }
    	  }),

    	  validate(parent, key) {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	    const match = /(\w+)\[(\d+)\]/.exec(key);
    	    if (!match) throw new Error("Internal Babel error: malformed key.");
    	    const [, listKey, index] = match;

    	    if (parent[listKey].length > index + 1) {
    	      throw new TypeError(`RestElement must be last element of ${listKey}`);
    	    }
    	  }

    	});
    	(0, _utils.default)("ReturnStatement", {
    	  visitor: ["argument"],
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("SequenceExpression", {
    	  visitor: ["expressions"],
    	  fields: {
    	    expressions: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression")))
    	    }
    	  },
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("ParenthesizedExpression", {
    	  visitor: ["expression"],
    	  aliases: ["Expression", "ExpressionWrapper"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("SwitchCase", {
    	  visitor: ["test", "consequent"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    consequent: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Statement")))
    	    }
    	  }
    	});
    	(0, _utils.default)("SwitchStatement", {
    	  visitor: ["discriminant", "cases"],
    	  aliases: ["Statement", "BlockParent", "Scopable"],
    	  fields: {
    	    discriminant: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    cases: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("SwitchCase")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ThisExpression", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("ThrowStatement", {
    	  visitor: ["argument"],
    	  aliases: ["Statement", "Terminatorless", "CompletionStatement"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("TryStatement", {
    	  visitor: ["block", "handler", "finalizer"],
    	  aliases: ["Statement"],
    	  fields: {
    	    block: {
    	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("BlockStatement"), Object.assign(function (node) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (!node.handler && !node.finalizer) {
    	          throw new TypeError("TryStatement expects either a handler or finalizer, or both");
    	        }
    	      }, {
    	        oneOfNodeTypes: ["BlockStatement"]
    	      }))
    	    },
    	    handler: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("CatchClause")
    	    },
    	    finalizer: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }
    	});
    	(0, _utils.default)("UnaryExpression", {
    	  builder: ["operator", "argument", "prefix"],
    	  fields: {
    	    prefix: {
    	      default: true
    	    },
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.UNARY_OPERATORS)
    	    }
    	  },
    	  visitor: ["argument"],
    	  aliases: ["UnaryLike", "Expression"]
    	});
    	(0, _utils.default)("UpdateExpression", {
    	  builder: ["operator", "argument", "prefix"],
    	  fields: {
    	    prefix: {
    	      default: false
    	    },
    	    argument: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("Expression") : (0, _utils.assertNodeType)("Identifier", "MemberExpression")
    	    },
    	    operator: {
    	      validate: (0, _utils.assertOneOf)(..._constants.UPDATE_OPERATORS)
    	    }
    	  },
    	  visitor: ["argument"],
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("VariableDeclaration", {
    	  builder: ["kind", "declarations"],
    	  visitor: ["declarations"],
    	  aliases: ["Statement", "Declaration"],
    	  fields: {
    	    declare: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    kind: {
    	      validate: (0, _utils.assertOneOf)("var", "let", "const")
    	    },
    	    declarations: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("VariableDeclarator")))
    	    }
    	  },

    	  validate(parent, key, node) {
    	    if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	    if (!(0, _is.default)("ForXStatement", parent, {
    	      left: node
    	    })) return;

    	    if (node.declarations.length !== 1) {
    	      throw new TypeError(`Exactly one VariableDeclarator is required in the VariableDeclaration of a ${parent.type}`);
    	    }
    	  }

    	});
    	(0, _utils.default)("VariableDeclarator", {
    	  visitor: ["id", "init"],
    	  fields: {
    	    id: {
    	      validate: function () {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) {
    	          return (0, _utils.assertNodeType)("LVal");
    	        }

    	        const normal = (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern");
    	        const without = (0, _utils.assertNodeType)("Identifier");
    	        return function (node, key, val) {
    	          const validator = node.init ? normal : without;
    	          validator(node, key, val);
    	        };
    	      }()
    	    },
    	    definite: {
    	      optional: true,
    	      validate: (0, _utils.assertValueType)("boolean")
    	    },
    	    init: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("WhileStatement", {
    	  visitor: ["test", "body"],
    	  aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"],
    	  fields: {
    	    test: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	(0, _utils.default)("WithStatement", {
    	  visitor: ["object", "body"],
    	  aliases: ["Statement"],
    	  fields: {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    }
    	  }
    	});
    	return core;
    }

    var es2015 = {};

    var hasRequiredEs2015;

    function requireEs2015 () {
    	if (hasRequiredEs2015) return es2015;
    	hasRequiredEs2015 = 1;

    	Object.defineProperty(es2015, "__esModule", {
    	  value: true
    	});
    	es2015.classMethodOrDeclareMethodCommon = es2015.classMethodOrPropertyCommon = void 0;

    	var _utils = _interopRequireWildcard(requireUtils());

    	var _core = requireCore();

    	var _is = _interopRequireDefault(requireIs());

    	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	(0, _utils.default)("AssignmentPattern", {
    	  visitor: ["left", "right", "decorators"],
    	  builder: ["left", "right"],
    	  aliases: ["Pattern", "PatternLike", "LVal"],
    	  fields: Object.assign({}, _core.patternLikeCommon, {
    	    left: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "ObjectPattern", "ArrayPattern", "MemberExpression")
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("ArrayPattern", {
    	  visitor: ["elements", "typeAnnotation"],
    	  builder: ["elements"],
    	  aliases: ["Pattern", "PatternLike", "LVal"],
    	  fields: Object.assign({}, _core.patternLikeCommon, {
    	    elements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "PatternLike")))
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("ArrowFunctionExpression", {
    	  builder: ["params", "body", "async"],
    	  visitor: ["params", "body", "returnType", "typeParameters"],
    	  aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
    	  fields: Object.assign({}, _core.functionCommon, _core.functionTypeAnnotationCommon, {
    	    expression: {
    	      validate: (0, _utils.assertValueType)("boolean")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement", "Expression")
    	    }
    	  })
    	});
    	(0, _utils.default)("ClassBody", {
    	  visitor: ["body"],
    	  fields: {
    	    body: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ClassMethod", "ClassPrivateMethod", "ClassProperty", "ClassPrivateProperty", "TSDeclareMethod", "TSIndexSignature")))
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassExpression", {
    	  builder: ["id", "superClass", "body", "decorators"],
    	  visitor: ["id", "body", "superClass", "mixins", "typeParameters", "superTypeParameters", "implements", "decorators"],
    	  aliases: ["Scopable", "Class", "Expression"],
    	  fields: {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier"),
    	      optional: true
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("ClassBody")
    	    },
    	    superClass: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    superTypeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    },
    	    implements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    mixins: {
    	      validate: (0, _utils.assertNodeType)("InterfaceExtends"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassDeclaration", {
    	  inherits: "ClassExpression",
    	  aliases: ["Scopable", "Class", "Statement", "Declaration"],
    	  fields: {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
    	      optional: true
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("ClassBody")
    	    },
    	    superClass: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    superTypeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    },
    	    implements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSExpressionWithTypeArguments", "ClassImplements"))),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    mixins: {
    	      validate: (0, _utils.assertNodeType)("InterfaceExtends"),
    	      optional: true
    	    },
    	    declare: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    abstract: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  },
    	  validate: function () {
    	    const identifier = (0, _utils.assertNodeType)("Identifier");
    	    return function (parent, key, node) {
    	      if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	      if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
    	        identifier(node, "id", node.id);
    	      }
    	    };
    	  }()
    	});
    	(0, _utils.default)("ExportAllDeclaration", {
    	  visitor: ["source"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    	  fields: {
    	    source: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral")
    	    }
    	  }
    	});
    	(0, _utils.default)("ExportDefaultDeclaration", {
    	  visitor: ["declaration"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    	  fields: {
    	    declaration: {
    	      validate: (0, _utils.assertNodeType)("FunctionDeclaration", "TSDeclareFunction", "ClassDeclaration", "Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("ExportNamedDeclaration", {
    	  visitor: ["declaration", "specifiers", "source"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration", "ExportDeclaration"],
    	  fields: {
    	    declaration: {
    	      optional: true,
    	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("Declaration"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && node.specifiers.length) {
    	          throw new TypeError("Only declaration or specifiers is allowed on ExportNamedDeclaration");
    	        }
    	      }, {
    	        oneOfNodeTypes: ["Declaration"]
    	      }), function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && node.source) {
    	          throw new TypeError("Cannot export a declaration from a source");
    	        }
    	      })
    	    },
    	    specifiers: {
    	      default: [],
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)(function () {
    	        const sourced = (0, _utils.assertNodeType)("ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier");
    	        const sourceless = (0, _utils.assertNodeType)("ExportSpecifier");
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return sourced;
    	        return function (node, key, val) {
    	          const validator = node.source ? sourced : sourceless;
    	          validator(node, key, val);
    	        };
    	      }()))
    	    },
    	    source: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral"),
    	      optional: true
    	    },
    	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
    	  }
    	});
    	(0, _utils.default)("ExportSpecifier", {
    	  visitor: ["local", "exported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    exported: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("ForOfStatement", {
    	  visitor: ["left", "right", "body"],
    	  builder: ["left", "right", "body", "await"],
    	  aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
    	  fields: {
    	    left: {
    	      validate: function () {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) {
    	          return (0, _utils.assertNodeType)("VariableDeclaration", "LVal");
    	        }

    	        const declaration = (0, _utils.assertNodeType)("VariableDeclaration");
    	        const lval = (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern");
    	        return function (node, key, val) {
    	          if ((0, _is.default)("VariableDeclaration", val)) {
    	            declaration(node, key, val);
    	          } else {
    	            lval(node, key, val);
    	          }
    	        };
    	      }()
    	    },
    	    right: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("Statement")
    	    },
    	    await: {
    	      default: false
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportDeclaration", {
    	  visitor: ["specifiers", "source"],
    	  aliases: ["Statement", "Declaration", "ModuleDeclaration"],
    	  fields: {
    	    specifiers: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier")))
    	    },
    	    source: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral")
    	    },
    	    importKind: {
    	      validate: (0, _utils.assertOneOf)("type", "typeof", "value"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportDefaultSpecifier", {
    	  visitor: ["local"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportNamespaceSpecifier", {
    	  visitor: ["local"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("ImportSpecifier", {
    	  visitor: ["local", "imported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    local: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    imported: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    importKind: {
    	      validate: (0, _utils.assertOneOf)("type", "typeof"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("MetaProperty", {
    	  visitor: ["meta", "property"],
    	  aliases: ["Expression"],
    	  fields: {
    	    meta: {
    	      validate: (0, _utils.chain)((0, _utils.assertNodeType)("Identifier"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;
    	        let property;

    	        switch (val.name) {
    	          case "function":
    	            property = "sent";
    	            break;

    	          case "new":
    	            property = "target";
    	            break;

    	          case "import":
    	            property = "meta";
    	            break;
    	        }

    	        if (!(0, _is.default)("Identifier", node.property, {
    	          name: property
    	        })) {
    	          throw new TypeError("Unrecognised MetaProperty");
    	        }
    	      }, {
    	        oneOfNodeTypes: ["Identifier"]
    	      }))
    	    },
    	    property: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	const classMethodOrPropertyCommon = {
    	  abstract: {
    	    validate: (0, _utils.assertValueType)("boolean"),
    	    optional: true
    	  },
    	  accessibility: {
    	    validate: (0, _utils.assertOneOf)("public", "private", "protected"),
    	    optional: true
    	  },
    	  static: {
    	    default: false
    	  },
    	  computed: {
    	    default: false
    	  },
    	  optional: {
    	    validate: (0, _utils.assertValueType)("boolean"),
    	    optional: true
    	  },
    	  key: {
    	    validate: (0, _utils.chain)(function () {
    	      const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral");
    	      const computed = (0, _utils.assertNodeType)("Expression");
    	      return function (node, key, val) {
    	        const validator = node.computed ? computed : normal;
    	        validator(node, key, val);
    	      };
    	    }(), (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "Expression"))
    	  }
    	};
    	es2015.classMethodOrPropertyCommon = classMethodOrPropertyCommon;
    	const classMethodOrDeclareMethodCommon = Object.assign({}, _core.functionCommon, classMethodOrPropertyCommon, {
    	  kind: {
    	    validate: (0, _utils.assertOneOf)("get", "set", "method", "constructor"),
    	    default: "method"
    	  },
    	  access: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("public", "private", "protected")),
    	    optional: true
    	  },
    	  decorators: {
    	    validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	    optional: true
    	  }
    	});
    	es2015.classMethodOrDeclareMethodCommon = classMethodOrDeclareMethodCommon;
    	(0, _utils.default)("ClassMethod", {
    	  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
    	  builder: ["kind", "key", "params", "body", "computed", "static", "generator", "async"],
    	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    	  fields: Object.assign({}, classMethodOrDeclareMethodCommon, _core.functionTypeAnnotationCommon, {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  })
    	});
    	(0, _utils.default)("ObjectPattern", {
    	  visitor: ["properties", "typeAnnotation", "decorators"],
    	  builder: ["properties"],
    	  aliases: ["Pattern", "PatternLike", "LVal"],
    	  fields: Object.assign({}, _core.patternLikeCommon, {
    	    properties: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("RestElement", "ObjectProperty")))
    	    }
    	  })
    	});
    	(0, _utils.default)("SpreadElement", {
    	  visitor: ["argument"],
    	  aliases: ["UnaryLike"],
    	  deprecatedAlias: "SpreadProperty",
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("Super", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("TaggedTemplateExpression", {
    	  visitor: ["tag", "quasi"],
    	  aliases: ["Expression"],
    	  fields: {
    	    tag: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    quasi: {
    	      validate: (0, _utils.assertNodeType)("TemplateLiteral")
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("TemplateElement", {
    	  builder: ["value", "tail"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertShape)({
    	        raw: {
    	          validate: (0, _utils.assertValueType)("string")
    	        },
    	        cooked: {
    	          validate: (0, _utils.assertValueType)("string"),
    	          optional: true
    	        }
    	      })
    	    },
    	    tail: {
    	      default: false
    	    }
    	  }
    	});
    	(0, _utils.default)("TemplateLiteral", {
    	  visitor: ["quasis", "expressions"],
    	  aliases: ["Expression", "Literal"],
    	  fields: {
    	    quasis: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TemplateElement")))
    	    },
    	    expressions: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression")), function (node, key, val) {
    	        if (node.quasis.length !== val.length + 1) {
    	          throw new TypeError(`Number of ${node.type} quasis should be exactly one more than the number of expressions.\nExpected ${val.length + 1} quasis but got ${node.quasis.length}`);
    	        }
    	      })
    	    }
    	  }
    	});
    	(0, _utils.default)("YieldExpression", {
    	  builder: ["argument", "delegate"],
    	  visitor: ["argument"],
    	  aliases: ["Expression", "Terminatorless"],
    	  fields: {
    	    delegate: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function (node, key, val) {
    	        if (!process$1.env.BABEL_TYPES_8_BREAKING) return;

    	        if (val && !node.argument) {
    	          throw new TypeError("Property delegate of YieldExpression cannot be true if there is no argument");
    	        }
    	      }, {
    	        type: "boolean"
    	      })),
    	      default: false
    	    },
    	    argument: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	return es2015;
    }

    var flow$3 = {};

    var hasRequiredFlow;

    function requireFlow () {
    	if (hasRequiredFlow) return flow$3;
    	hasRequiredFlow = 1;

    	var _utils = _interopRequireWildcard(requireUtils());

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	const defineInterfaceishType = (name, typeParameterType = "TypeParameterDeclaration") => {
    	  (0, _utils.default)(name, {
    	    builder: ["id", "typeParameters", "extends", "body"],
    	    visitor: ["id", "typeParameters", "extends", "mixins", "implements", "body"],
    	    aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	    fields: {
    	      id: (0, _utils.validateType)("Identifier"),
    	      typeParameters: (0, _utils.validateOptionalType)(typeParameterType),
    	      extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
    	      mixins: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
    	      implements: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ClassImplements")),
    	      body: (0, _utils.validateType)("ObjectTypeAnnotation")
    	    }
    	  });
    	};

    	(0, _utils.default)("AnyTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ArrayTypeAnnotation", {
    	  visitor: ["elementType"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    elementType: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("BooleanTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("BooleanLiteralTypeAnnotation", {
    	  builder: ["value"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    value: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("NullLiteralTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ClassImplements", {
    	  visitor: ["id", "typeParameters"],
    	  aliases: ["Flow"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
    	  }
    	});
    	defineInterfaceishType("DeclareClass");
    	(0, _utils.default)("DeclareFunction", {
    	  visitor: ["id"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    predicate: (0, _utils.validateOptionalType)("DeclaredPredicate")
    	  }
    	});
    	defineInterfaceishType("DeclareInterface");
    	(0, _utils.default)("DeclareModule", {
    	  builder: ["id", "body", "kind"],
    	  visitor: ["id", "body"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    body: (0, _utils.validateType)("BlockStatement"),
    	    kind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("CommonJS", "ES"))
    	  }
    	});
    	(0, _utils.default)("DeclareModuleExports", {
    	  visitor: ["typeAnnotation"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
    	  }
    	});
    	(0, _utils.default)("DeclareTypeAlias", {
    	  visitor: ["id", "typeParameters", "right"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    right: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("DeclareOpaqueType", {
    	  visitor: ["id", "typeParameters", "supertype"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    supertype: (0, _utils.validateOptionalType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("DeclareVariable", {
    	  visitor: ["id"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	(0, _utils.default)("DeclareExportDeclaration", {
    	  visitor: ["declaration", "specifiers", "source"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    declaration: (0, _utils.validateOptionalType)("Flow"),
    	    specifiers: (0, _utils.validateOptional)((0, _utils.arrayOfType)(["ExportSpecifier", "ExportNamespaceSpecifier"])),
    	    source: (0, _utils.validateOptionalType)("StringLiteral"),
    	    default: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("DeclareExportAllDeclaration", {
    	  visitor: ["source"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    source: (0, _utils.validateType)("StringLiteral"),
    	    exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
    	  }
    	});
    	(0, _utils.default)("DeclaredPredicate", {
    	  visitor: ["value"],
    	  aliases: ["Flow", "FlowPredicate"],
    	  fields: {
    	    value: (0, _utils.validateType)("Flow")
    	  }
    	});
    	(0, _utils.default)("ExistsTypeAnnotation", {
    	  aliases: ["Flow", "FlowType"]
    	});
    	(0, _utils.default)("FunctionTypeAnnotation", {
    	  visitor: ["typeParameters", "params", "rest", "returnType"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    params: (0, _utils.validate)((0, _utils.arrayOfType)("FunctionTypeParam")),
    	    rest: (0, _utils.validateOptionalType)("FunctionTypeParam"),
    	    returnType: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("FunctionTypeParam", {
    	  visitor: ["name", "typeAnnotation"],
    	  aliases: ["Flow"],
    	  fields: {
    	    name: (0, _utils.validateOptionalType)("Identifier"),
    	    typeAnnotation: (0, _utils.validateType)("FlowType"),
    	    optional: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("GenericTypeAnnotation", {
    	  visitor: ["id", "typeParameters"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"]),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("InferredPredicate", {
    	  aliases: ["Flow", "FlowPredicate"]
    	});
    	(0, _utils.default)("InterfaceExtends", {
    	  visitor: ["id", "typeParameters"],
    	  aliases: ["Flow"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"]),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
    	  }
    	});
    	defineInterfaceishType("InterfaceDeclaration");
    	(0, _utils.default)("InterfaceTypeAnnotation", {
    	  visitor: ["extends", "body"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
    	    body: (0, _utils.validateType)("ObjectTypeAnnotation")
    	  }
    	});
    	(0, _utils.default)("IntersectionTypeAnnotation", {
    	  visitor: ["types"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("MixedTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("EmptyTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("NullableTypeAnnotation", {
    	  visitor: ["typeAnnotation"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("NumberLiteralTypeAnnotation", {
    	  builder: ["value"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    value: (0, _utils.validate)((0, _utils.assertValueType)("number"))
    	  }
    	});
    	(0, _utils.default)("NumberTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ObjectTypeAnnotation", {
    	  visitor: ["properties", "indexers", "callProperties", "internalSlots"],
    	  aliases: ["Flow", "FlowType"],
    	  builder: ["properties", "indexers", "callProperties", "internalSlots", "exact"],
    	  fields: {
    	    properties: (0, _utils.validate)((0, _utils.arrayOfType)(["ObjectTypeProperty", "ObjectTypeSpreadProperty"])),
    	    indexers: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeIndexer")),
    	    callProperties: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeCallProperty")),
    	    internalSlots: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ObjectTypeInternalSlot")),
    	    exact: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      default: false
    	    },
    	    inexact: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeInternalSlot", {
    	  visitor: ["id", "value", "optional", "static", "method"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    value: (0, _utils.validateType)("FlowType"),
    	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    method: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeCallProperty", {
    	  visitor: ["value"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    value: (0, _utils.validateType)("FlowType"),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
    	  }
    	});
    	(0, _utils.default)("ObjectTypeIndexer", {
    	  visitor: ["id", "key", "value", "variance"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    id: (0, _utils.validateOptionalType)("Identifier"),
    	    key: (0, _utils.validateType)("FlowType"),
    	    value: (0, _utils.validateType)("FlowType"),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    variance: (0, _utils.validateOptionalType)("Variance")
    	  }
    	});
    	(0, _utils.default)("ObjectTypeProperty", {
    	  visitor: ["key", "value", "variance"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    key: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    value: (0, _utils.validateType)("FlowType"),
    	    kind: (0, _utils.validate)((0, _utils.assertOneOf)("init", "get", "set")),
    	    static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    proto: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    variance: (0, _utils.validateOptionalType)("Variance")
    	  }
    	});
    	(0, _utils.default)("ObjectTypeSpreadProperty", {
    	  visitor: ["argument"],
    	  aliases: ["Flow", "UserWhitespacable"],
    	  fields: {
    	    argument: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("OpaqueType", {
    	  visitor: ["id", "typeParameters", "supertype", "impltype"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    supertype: (0, _utils.validateOptionalType)("FlowType"),
    	    impltype: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("QualifiedTypeIdentifier", {
    	  visitor: ["id", "qualification"],
    	  aliases: ["Flow"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    qualification: (0, _utils.validateType)(["Identifier", "QualifiedTypeIdentifier"])
    	  }
    	});
    	(0, _utils.default)("StringLiteralTypeAnnotation", {
    	  builder: ["value"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    value: (0, _utils.validate)((0, _utils.assertValueType)("string"))
    	  }
    	});
    	(0, _utils.default)("StringTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("SymbolTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("ThisTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("TupleTypeAnnotation", {
    	  visitor: ["types"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("TypeofTypeAnnotation", {
    	  visitor: ["argument"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    argument: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("TypeAlias", {
    	  visitor: ["id", "typeParameters", "right"],
    	  aliases: ["Flow", "FlowDeclaration", "Statement", "Declaration"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
    	    right: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("TypeAnnotation", {
    	  aliases: ["Flow"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("FlowType")
    	  }
    	});
    	(0, _utils.default)("TypeCastExpression", {
    	  visitor: ["expression", "typeAnnotation"],
    	  aliases: ["Flow", "ExpressionWrapper", "Expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression"),
    	    typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
    	  }
    	});
    	(0, _utils.default)("TypeParameter", {
    	  aliases: ["Flow"],
    	  visitor: ["bound", "default", "variance"],
    	  fields: {
    	    name: (0, _utils.validate)((0, _utils.assertValueType)("string")),
    	    bound: (0, _utils.validateOptionalType)("TypeAnnotation"),
    	    default: (0, _utils.validateOptionalType)("FlowType"),
    	    variance: (0, _utils.validateOptionalType)("Variance")
    	  }
    	});
    	(0, _utils.default)("TypeParameterDeclaration", {
    	  aliases: ["Flow"],
    	  visitor: ["params"],
    	  fields: {
    	    params: (0, _utils.validate)((0, _utils.arrayOfType)("TypeParameter"))
    	  }
    	});
    	(0, _utils.default)("TypeParameterInstantiation", {
    	  aliases: ["Flow"],
    	  visitor: ["params"],
    	  fields: {
    	    params: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("UnionTypeAnnotation", {
    	  visitor: ["types"],
    	  aliases: ["Flow", "FlowType"],
    	  fields: {
    	    types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
    	  }
    	});
    	(0, _utils.default)("Variance", {
    	  aliases: ["Flow"],
    	  builder: ["kind"],
    	  fields: {
    	    kind: (0, _utils.validate)((0, _utils.assertOneOf)("minus", "plus"))
    	  }
    	});
    	(0, _utils.default)("VoidTypeAnnotation", {
    	  aliases: ["Flow", "FlowType", "FlowBaseAnnotation"]
    	});
    	(0, _utils.default)("EnumDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "body"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    body: (0, _utils.validateType)(["EnumBooleanBody", "EnumNumberBody", "EnumStringBody", "EnumSymbolBody"])
    	  }
    	});
    	(0, _utils.default)("EnumBooleanBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    explicit: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    members: (0, _utils.validateArrayOfType)("EnumBooleanMember")
    	  }
    	});
    	(0, _utils.default)("EnumNumberBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    explicit: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    members: (0, _utils.validateArrayOfType)("EnumNumberMember")
    	  }
    	});
    	(0, _utils.default)("EnumStringBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    explicit: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
    	    members: (0, _utils.validateArrayOfType)(["EnumStringMember", "EnumDefaultedMember"])
    	  }
    	});
    	(0, _utils.default)("EnumSymbolBody", {
    	  aliases: ["EnumBody"],
    	  visitor: ["members"],
    	  fields: {
    	    members: (0, _utils.validateArrayOfType)("EnumDefaultedMember")
    	  }
    	});
    	(0, _utils.default)("EnumBooleanMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    init: (0, _utils.validateType)("BooleanLiteral")
    	  }
    	});
    	(0, _utils.default)("EnumNumberMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id", "init"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    init: (0, _utils.validateType)("NumericLiteral")
    	  }
    	});
    	(0, _utils.default)("EnumStringMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id", "init"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier"),
    	    init: (0, _utils.validateType)("StringLiteral")
    	  }
    	});
    	(0, _utils.default)("EnumDefaultedMember", {
    	  aliases: ["EnumMember"],
    	  visitor: ["id"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	return flow$3;
    }

    var jsx$3 = {};

    var hasRequiredJsx;

    function requireJsx () {
    	if (hasRequiredJsx) return jsx$3;
    	hasRequiredJsx = 1;

    	var _utils = _interopRequireWildcard(requireUtils());

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	(0, _utils.default)("JSXAttribute", {
    	  visitor: ["name", "value"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXNamespacedName")
    	    },
    	    value: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("JSXElement", "JSXFragment", "StringLiteral", "JSXExpressionContainer")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXClosingElement", {
    	  visitor: ["name"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXElement", {
    	  builder: ["openingElement", "closingElement", "children", "selfClosing"],
    	  visitor: ["openingElement", "children", "closingElement"],
    	  aliases: ["JSX", "Immutable", "Expression"],
    	  fields: {
    	    openingElement: {
    	      validate: (0, _utils.assertNodeType)("JSXOpeningElement")
    	    },
    	    closingElement: {
    	      optional: true,
    	      validate: (0, _utils.assertNodeType)("JSXClosingElement")
    	    },
    	    children: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
    	    },
    	    selfClosing: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXEmptyExpression", {
    	  aliases: ["JSX"]
    	});
    	(0, _utils.default)("JSXExpressionContainer", {
    	  visitor: ["expression"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression", "JSXEmptyExpression")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXSpreadChild", {
    	  visitor: ["expression"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXIdentifier", {
    	  builder: ["name"],
    	  aliases: ["JSX"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXMemberExpression", {
    	  visitor: ["object", "property"],
    	  aliases: ["JSX"],
    	  fields: {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("JSXMemberExpression", "JSXIdentifier")
    	    },
    	    property: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXNamespacedName", {
    	  visitor: ["namespace", "name"],
    	  aliases: ["JSX"],
    	  fields: {
    	    namespace: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
    	    },
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXOpeningElement", {
    	  builder: ["name", "attributes", "selfClosing"],
    	  visitor: ["name", "attributes"],
    	  aliases: ["JSX", "Immutable"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
    	    },
    	    selfClosing: {
    	      default: false
    	    },
    	    attributes: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXAttribute", "JSXSpreadAttribute")))
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXSpreadAttribute", {
    	  visitor: ["argument"],
    	  aliases: ["JSX"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXText", {
    	  aliases: ["JSX", "Immutable"],
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXFragment", {
    	  builder: ["openingFragment", "closingFragment", "children"],
    	  visitor: ["openingFragment", "children", "closingFragment"],
    	  aliases: ["JSX", "Immutable", "Expression"],
    	  fields: {
    	    openingFragment: {
    	      validate: (0, _utils.assertNodeType)("JSXOpeningFragment")
    	    },
    	    closingFragment: {
    	      validate: (0, _utils.assertNodeType)("JSXClosingFragment")
    	    },
    	    children: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")))
    	    }
    	  }
    	});
    	(0, _utils.default)("JSXOpeningFragment", {
    	  aliases: ["JSX", "Immutable"]
    	});
    	(0, _utils.default)("JSXClosingFragment", {
    	  aliases: ["JSX", "Immutable"]
    	});
    	return jsx$3;
    }

    var misc = {};

    var placeholders$2 = {};

    var hasRequiredPlaceholders;

    function requirePlaceholders () {
    	if (hasRequiredPlaceholders) return placeholders$2;
    	hasRequiredPlaceholders = 1;

    	Object.defineProperty(placeholders$2, "__esModule", {
    	  value: true
    	});
    	placeholders$2.PLACEHOLDERS_FLIPPED_ALIAS = placeholders$2.PLACEHOLDERS_ALIAS = placeholders$2.PLACEHOLDERS = void 0;

    	var _utils = requireUtils();

    	const PLACEHOLDERS = ["Identifier", "StringLiteral", "Expression", "Statement", "Declaration", "BlockStatement", "ClassBody", "Pattern"];
    	placeholders$2.PLACEHOLDERS = PLACEHOLDERS;
    	const PLACEHOLDERS_ALIAS = {
    	  Declaration: ["Statement"],
    	  Pattern: ["PatternLike", "LVal"]
    	};
    	placeholders$2.PLACEHOLDERS_ALIAS = PLACEHOLDERS_ALIAS;

    	for (const type of PLACEHOLDERS) {
    	  const alias = _utils.ALIAS_KEYS[type];
    	  if (alias == null ? void 0 : alias.length) PLACEHOLDERS_ALIAS[type] = alias;
    	}

    	const PLACEHOLDERS_FLIPPED_ALIAS = {};
    	placeholders$2.PLACEHOLDERS_FLIPPED_ALIAS = PLACEHOLDERS_FLIPPED_ALIAS;
    	Object.keys(PLACEHOLDERS_ALIAS).forEach(type => {
    	  PLACEHOLDERS_ALIAS[type].forEach(alias => {
    	    if (!Object.hasOwnProperty.call(PLACEHOLDERS_FLIPPED_ALIAS, alias)) {
    	      PLACEHOLDERS_FLIPPED_ALIAS[alias] = [];
    	    }

    	    PLACEHOLDERS_FLIPPED_ALIAS[alias].push(type);
    	  });
    	});
    	return placeholders$2;
    }

    var hasRequiredMisc;

    function requireMisc () {
    	if (hasRequiredMisc) return misc;
    	hasRequiredMisc = 1;

    	var _utils = _interopRequireWildcard(requireUtils());

    	var _placeholders = requirePlaceholders();

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	(0, _utils.default)("Noop", {
    	  visitor: []
    	});
    	(0, _utils.default)("Placeholder", {
    	  visitor: [],
    	  builder: ["expectedNode", "name"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    expectedNode: {
    	      validate: (0, _utils.assertOneOf)(..._placeholders.PLACEHOLDERS)
    	    }
    	  }
    	});
    	(0, _utils.default)("V8IntrinsicIdentifier", {
    	  builder: ["name"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  }
    	});
    	return misc;
    }

    var experimental = {};

    var hasRequiredExperimental;

    function requireExperimental () {
    	if (hasRequiredExperimental) return experimental;
    	hasRequiredExperimental = 1;

    	var _utils = _interopRequireWildcard(requireUtils());

    	var _es = requireEs2015();

    	var _core = requireCore();

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	(0, _utils.default)("ArgumentPlaceholder", {});
    	(0, _utils.default)("AwaitExpression", {
    	  builder: ["argument"],
    	  visitor: ["argument"],
    	  aliases: ["Expression", "Terminatorless"],
    	  fields: {
    	    argument: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("BindExpression", {
    	  visitor: ["object", "callee"],
    	  aliases: ["Expression"],
    	  fields: !process$1.env.BABEL_TYPES_8_BREAKING ? {
    	    object: {
    	      validate: Object.assign(() => {}, {
    	        oneOfNodeTypes: ["Expression"]
    	      })
    	    },
    	    callee: {
    	      validate: Object.assign(() => {}, {
    	        oneOfNodeTypes: ["Expression"]
    	      })
    	    }
    	  } : {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassProperty", {
    	  visitor: ["key", "value", "typeAnnotation", "decorators"],
    	  builder: ["key", "value", "typeAnnotation", "decorators", "computed", "static"],
    	  aliases: ["Property"],
    	  fields: Object.assign({}, _es.classMethodOrPropertyCommon, {
    	    value: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    definite: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    typeAnnotation: {
    	      validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    },
    	    readonly: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    declare: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    }
    	  })
    	});
    	(0, _utils.default)("OptionalMemberExpression", {
    	  builder: ["object", "property", "computed", "optional"],
    	  visitor: ["object", "property"],
    	  aliases: ["Expression"],
    	  fields: {
    	    object: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    property: {
    	      validate: function () {
    	        const normal = (0, _utils.assertNodeType)("Identifier");
    	        const computed = (0, _utils.assertNodeType)("Expression");

    	        const validator = function (node, key, val) {
    	          const validator = node.computed ? computed : normal;
    	          validator(node, key, val);
    	        };

    	        validator.oneOfNodeTypes = ["Expression", "Identifier"];
    	        return validator;
    	      }()
    	    },
    	    computed: {
    	      default: false
    	    },
    	    optional: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
    	    }
    	  }
    	});
    	(0, _utils.default)("PipelineTopicExpression", {
    	  builder: ["expression"],
    	  visitor: ["expression"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("PipelineBareFunction", {
    	  builder: ["callee"],
    	  visitor: ["callee"],
    	  fields: {
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("PipelinePrimaryTopicReference", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("OptionalCallExpression", {
    	  visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
    	  builder: ["callee", "arguments", "optional"],
    	  aliases: ["Expression"],
    	  fields: {
    	    callee: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    },
    	    arguments: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement", "JSXNamespacedName")))
    	    },
    	    optional: {
    	      validate: !process$1.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
    	    },
    	    typeArguments: {
    	      validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
    	      optional: true
    	    },
    	    typeParameters: {
    	      validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassPrivateProperty", {
    	  visitor: ["key", "value", "decorators"],
    	  builder: ["key", "value", "decorators"],
    	  aliases: ["Property", "Private"],
    	  fields: {
    	    key: {
    	      validate: (0, _utils.assertNodeType)("PrivateName")
    	    },
    	    value: {
    	      validate: (0, _utils.assertNodeType)("Expression"),
    	      optional: true
    	    },
    	    decorators: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Decorator"))),
    	      optional: true
    	    }
    	  }
    	});
    	(0, _utils.default)("ClassPrivateMethod", {
    	  builder: ["kind", "key", "params", "body", "static"],
    	  visitor: ["key", "params", "body", "decorators", "returnType", "typeParameters"],
    	  aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method", "Private"],
    	  fields: Object.assign({}, _es.classMethodOrDeclareMethodCommon, _core.functionTypeAnnotationCommon, {
    	    key: {
    	      validate: (0, _utils.assertNodeType)("PrivateName")
    	    },
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  })
    	});
    	(0, _utils.default)("Import", {
    	  aliases: ["Expression"]
    	});
    	(0, _utils.default)("ImportAttribute", {
    	  visitor: ["key", "value"],
    	  fields: {
    	    key: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    },
    	    value: {
    	      validate: (0, _utils.assertNodeType)("StringLiteral")
    	    }
    	  }
    	});
    	(0, _utils.default)("Decorator", {
    	  visitor: ["expression"],
    	  fields: {
    	    expression: {
    	      validate: (0, _utils.assertNodeType)("Expression")
    	    }
    	  }
    	});
    	(0, _utils.default)("DoExpression", {
    	  visitor: ["body"],
    	  aliases: ["Expression"],
    	  fields: {
    	    body: {
    	      validate: (0, _utils.assertNodeType)("BlockStatement")
    	    }
    	  }
    	});
    	(0, _utils.default)("ExportDefaultSpecifier", {
    	  visitor: ["exported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    exported: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("ExportNamespaceSpecifier", {
    	  visitor: ["exported"],
    	  aliases: ["ModuleSpecifier"],
    	  fields: {
    	    exported: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("PrivateName", {
    	  visitor: ["id"],
    	  aliases: ["Private"],
    	  fields: {
    	    id: {
    	      validate: (0, _utils.assertNodeType)("Identifier")
    	    }
    	  }
    	});
    	(0, _utils.default)("BigIntLiteral", {
    	  builder: ["value"],
    	  fields: {
    	    value: {
    	      validate: (0, _utils.assertValueType)("string")
    	    }
    	  },
    	  aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    	});
    	(0, _utils.default)("RecordExpression", {
    	  visitor: ["properties"],
    	  aliases: ["Expression"],
    	  fields: {
    	    properties: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("ObjectProperty", "SpreadElement")))
    	    }
    	  }
    	});
    	(0, _utils.default)("TupleExpression", {
    	  fields: {
    	    elements: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "SpreadElement"))),
    	      default: []
    	    }
    	  },
    	  visitor: ["elements"],
    	  aliases: ["Expression"]
    	});
    	return experimental;
    }

    var typescript$3 = {};

    var hasRequiredTypescript;

    function requireTypescript () {
    	if (hasRequiredTypescript) return typescript$3;
    	hasRequiredTypescript = 1;

    	var _utils = _interopRequireWildcard(requireUtils());

    	var _core = requireCore();

    	var _es = requireEs2015();

    	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

    	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

    	const bool = (0, _utils.assertValueType)("boolean");
    	const tSFunctionTypeAnnotationCommon = {
    	  returnType: {
    	    validate: (0, _utils.assertNodeType)("TSTypeAnnotation", "Noop"),
    	    optional: true
    	  },
    	  typeParameters: {
    	    validate: (0, _utils.assertNodeType)("TSTypeParameterDeclaration", "Noop"),
    	    optional: true
    	  }
    	};
    	(0, _utils.default)("TSParameterProperty", {
    	  aliases: ["LVal"],
    	  visitor: ["parameter"],
    	  fields: {
    	    accessibility: {
    	      validate: (0, _utils.assertOneOf)("public", "private", "protected"),
    	      optional: true
    	    },
    	    readonly: {
    	      validate: (0, _utils.assertValueType)("boolean"),
    	      optional: true
    	    },
    	    parameter: {
    	      validate: (0, _utils.assertNodeType)("Identifier", "AssignmentPattern")
    	    }
    	  }
    	});
    	(0, _utils.default)("TSDeclareFunction", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "typeParameters", "params", "returnType"],
    	  fields: Object.assign({}, _core.functionDeclarationCommon, tSFunctionTypeAnnotationCommon)
    	});
    	(0, _utils.default)("TSDeclareMethod", {
    	  visitor: ["decorators", "key", "typeParameters", "params", "returnType"],
    	  fields: Object.assign({}, _es.classMethodOrDeclareMethodCommon, tSFunctionTypeAnnotationCommon)
    	});
    	(0, _utils.default)("TSQualifiedName", {
    	  aliases: ["TSEntityName"],
    	  visitor: ["left", "right"],
    	  fields: {
    	    left: (0, _utils.validateType)("TSEntityName"),
    	    right: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	const signatureDeclarationCommon = {
    	  typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
    	  parameters: (0, _utils.validateArrayOfType)(["Identifier", "RestElement"]),
    	  typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
    	};
    	const callConstructSignatureDeclaration = {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["typeParameters", "parameters", "typeAnnotation"],
    	  fields: signatureDeclarationCommon
    	};
    	(0, _utils.default)("TSCallSignatureDeclaration", callConstructSignatureDeclaration);
    	(0, _utils.default)("TSConstructSignatureDeclaration", callConstructSignatureDeclaration);
    	const namedTypeElementCommon = {
    	  key: (0, _utils.validateType)("Expression"),
    	  computed: (0, _utils.validate)(bool),
    	  optional: (0, _utils.validateOptional)(bool)
    	};
    	(0, _utils.default)("TSPropertySignature", {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["key", "typeAnnotation", "initializer"],
    	  fields: Object.assign({}, namedTypeElementCommon, {
    	    readonly: (0, _utils.validateOptional)(bool),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
    	    initializer: (0, _utils.validateOptionalType)("Expression")
    	  })
    	});
    	(0, _utils.default)("TSMethodSignature", {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["key", "typeParameters", "parameters", "typeAnnotation"],
    	  fields: Object.assign({}, signatureDeclarationCommon, namedTypeElementCommon)
    	});
    	(0, _utils.default)("TSIndexSignature", {
    	  aliases: ["TSTypeElement"],
    	  visitor: ["parameters", "typeAnnotation"],
    	  fields: {
    	    readonly: (0, _utils.validateOptional)(bool),
    	    parameters: (0, _utils.validateArrayOfType)("Identifier"),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
    	  }
    	});
    	const tsKeywordTypes = ["TSAnyKeyword", "TSBooleanKeyword", "TSBigIntKeyword", "TSNeverKeyword", "TSNullKeyword", "TSNumberKeyword", "TSObjectKeyword", "TSStringKeyword", "TSSymbolKeyword", "TSUndefinedKeyword", "TSUnknownKeyword", "TSVoidKeyword"];

    	for (const type of tsKeywordTypes) {
    	  (0, _utils.default)(type, {
    	    aliases: ["TSType", "TSBaseType"],
    	    visitor: [],
    	    fields: {}
    	  });
    	}

    	(0, _utils.default)("TSThisType", {
    	  aliases: ["TSType", "TSBaseType"],
    	  visitor: [],
    	  fields: {}
    	});
    	const fnOrCtr = {
    	  aliases: ["TSType"],
    	  visitor: ["typeParameters", "parameters", "typeAnnotation"],
    	  fields: signatureDeclarationCommon
    	};
    	(0, _utils.default)("TSFunctionType", fnOrCtr);
    	(0, _utils.default)("TSConstructorType", fnOrCtr);
    	(0, _utils.default)("TSTypeReference", {
    	  aliases: ["TSType"],
    	  visitor: ["typeName", "typeParameters"],
    	  fields: {
    	    typeName: (0, _utils.validateType)("TSEntityName"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("TSTypePredicate", {
    	  aliases: ["TSType"],
    	  visitor: ["parameterName", "typeAnnotation"],
    	  builder: ["parameterName", "typeAnnotation", "asserts"],
    	  fields: {
    	    parameterName: (0, _utils.validateType)(["Identifier", "TSThisType"]),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
    	    asserts: (0, _utils.validateOptional)(bool)
    	  }
    	});
    	(0, _utils.default)("TSTypeQuery", {
    	  aliases: ["TSType"],
    	  visitor: ["exprName"],
    	  fields: {
    	    exprName: (0, _utils.validateType)(["TSEntityName", "TSImportType"])
    	  }
    	});
    	(0, _utils.default)("TSTypeLiteral", {
    	  aliases: ["TSType"],
    	  visitor: ["members"],
    	  fields: {
    	    members: (0, _utils.validateArrayOfType)("TSTypeElement")
    	  }
    	});
    	(0, _utils.default)("TSArrayType", {
    	  aliases: ["TSType"],
    	  visitor: ["elementType"],
    	  fields: {
    	    elementType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSTupleType", {
    	  aliases: ["TSType"],
    	  visitor: ["elementTypes"],
    	  fields: {
    	    elementTypes: (0, _utils.validateArrayOfType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSOptionalType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSRestType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	const unionOrIntersection = {
    	  aliases: ["TSType"],
    	  visitor: ["types"],
    	  fields: {
    	    types: (0, _utils.validateArrayOfType)("TSType")
    	  }
    	};
    	(0, _utils.default)("TSUnionType", unionOrIntersection);
    	(0, _utils.default)("TSIntersectionType", unionOrIntersection);
    	(0, _utils.default)("TSConditionalType", {
    	  aliases: ["TSType"],
    	  visitor: ["checkType", "extendsType", "trueType", "falseType"],
    	  fields: {
    	    checkType: (0, _utils.validateType)("TSType"),
    	    extendsType: (0, _utils.validateType)("TSType"),
    	    trueType: (0, _utils.validateType)("TSType"),
    	    falseType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSInferType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeParameter"],
    	  fields: {
    	    typeParameter: (0, _utils.validateType)("TSTypeParameter")
    	  }
    	});
    	(0, _utils.default)("TSParenthesizedType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSTypeOperator", {
    	  aliases: ["TSType"],
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    operator: (0, _utils.validate)((0, _utils.assertValueType)("string")),
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSIndexedAccessType", {
    	  aliases: ["TSType"],
    	  visitor: ["objectType", "indexType"],
    	  fields: {
    	    objectType: (0, _utils.validateType)("TSType"),
    	    indexType: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSMappedType", {
    	  aliases: ["TSType"],
    	  visitor: ["typeParameter", "typeAnnotation"],
    	  fields: {
    	    readonly: (0, _utils.validateOptional)(bool),
    	    typeParameter: (0, _utils.validateType)("TSTypeParameter"),
    	    optional: (0, _utils.validateOptional)(bool),
    	    typeAnnotation: (0, _utils.validateOptionalType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSLiteralType", {
    	  aliases: ["TSType", "TSBaseType"],
    	  visitor: ["literal"],
    	  fields: {
    	    literal: (0, _utils.validateType)(["NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral"])
    	  }
    	});
    	(0, _utils.default)("TSExpressionWithTypeArguments", {
    	  aliases: ["TSType"],
    	  visitor: ["expression", "typeParameters"],
    	  fields: {
    	    expression: (0, _utils.validateType)("TSEntityName"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("TSInterfaceDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "typeParameters", "extends", "body"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
    	    extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("TSExpressionWithTypeArguments")),
    	    body: (0, _utils.validateType)("TSInterfaceBody")
    	  }
    	});
    	(0, _utils.default)("TSInterfaceBody", {
    	  visitor: ["body"],
    	  fields: {
    	    body: (0, _utils.validateArrayOfType)("TSTypeElement")
    	  }
    	});
    	(0, _utils.default)("TSTypeAliasDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "typeParameters", "typeAnnotation"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSAsExpression", {
    	  aliases: ["Expression"],
    	  visitor: ["expression", "typeAnnotation"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression"),
    	    typeAnnotation: (0, _utils.validateType)("TSType")
    	  }
    	});
    	(0, _utils.default)("TSTypeAssertion", {
    	  aliases: ["Expression"],
    	  visitor: ["typeAnnotation", "expression"],
    	  fields: {
    	    typeAnnotation: (0, _utils.validateType)("TSType"),
    	    expression: (0, _utils.validateType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSEnumDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "members"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    const: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    members: (0, _utils.validateArrayOfType)("TSEnumMember"),
    	    initializer: (0, _utils.validateOptionalType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSEnumMember", {
    	  visitor: ["id", "initializer"],
    	  fields: {
    	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    initializer: (0, _utils.validateOptionalType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSModuleDeclaration", {
    	  aliases: ["Statement", "Declaration"],
    	  visitor: ["id", "body"],
    	  fields: {
    	    declare: (0, _utils.validateOptional)(bool),
    	    global: (0, _utils.validateOptional)(bool),
    	    id: (0, _utils.validateType)(["Identifier", "StringLiteral"]),
    	    body: (0, _utils.validateType)(["TSModuleBlock", "TSModuleDeclaration"])
    	  }
    	});
    	(0, _utils.default)("TSModuleBlock", {
    	  aliases: ["Scopable", "Block", "BlockParent"],
    	  visitor: ["body"],
    	  fields: {
    	    body: (0, _utils.validateArrayOfType)("Statement")
    	  }
    	});
    	(0, _utils.default)("TSImportType", {
    	  aliases: ["TSType"],
    	  visitor: ["argument", "qualifier", "typeParameters"],
    	  fields: {
    	    argument: (0, _utils.validateType)("StringLiteral"),
    	    qualifier: (0, _utils.validateOptionalType)("TSEntityName"),
    	    typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
    	  }
    	});
    	(0, _utils.default)("TSImportEqualsDeclaration", {
    	  aliases: ["Statement"],
    	  visitor: ["id", "moduleReference"],
    	  fields: {
    	    isExport: (0, _utils.validate)(bool),
    	    id: (0, _utils.validateType)("Identifier"),
    	    moduleReference: (0, _utils.validateType)(["TSEntityName", "TSExternalModuleReference"])
    	  }
    	});
    	(0, _utils.default)("TSExternalModuleReference", {
    	  visitor: ["expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("StringLiteral")
    	  }
    	});
    	(0, _utils.default)("TSNonNullExpression", {
    	  aliases: ["Expression"],
    	  visitor: ["expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSExportAssignment", {
    	  aliases: ["Statement"],
    	  visitor: ["expression"],
    	  fields: {
    	    expression: (0, _utils.validateType)("Expression")
    	  }
    	});
    	(0, _utils.default)("TSNamespaceExportDeclaration", {
    	  aliases: ["Statement"],
    	  visitor: ["id"],
    	  fields: {
    	    id: (0, _utils.validateType)("Identifier")
    	  }
    	});
    	(0, _utils.default)("TSTypeAnnotation", {
    	  visitor: ["typeAnnotation"],
    	  fields: {
    	    typeAnnotation: {
    	      validate: (0, _utils.assertNodeType)("TSType")
    	    }
    	  }
    	});
    	(0, _utils.default)("TSTypeParameterInstantiation", {
    	  visitor: ["params"],
    	  fields: {
    	    params: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSType")))
    	    }
    	  }
    	});
    	(0, _utils.default)("TSTypeParameterDeclaration", {
    	  visitor: ["params"],
    	  fields: {
    	    params: {
    	      validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("TSTypeParameter")))
    	    }
    	  }
    	});
    	(0, _utils.default)("TSTypeParameter", {
    	  builder: ["constraint", "default", "name"],
    	  visitor: ["constraint", "default"],
    	  fields: {
    	    name: {
    	      validate: (0, _utils.assertValueType)("string")
    	    },
    	    constraint: {
    	      validate: (0, _utils.assertNodeType)("TSType"),
    	      optional: true
    	    },
    	    default: {
    	      validate: (0, _utils.assertNodeType)("TSType"),
    	      optional: true
    	    }
    	  }
    	});
    	return typescript$3;
    }

    var hasRequiredDefinitions;

    function requireDefinitions () {
    	if (hasRequiredDefinitions) return definitions;
    	hasRequiredDefinitions = 1;
    	(function (exports) {

    		Object.defineProperty(exports, "__esModule", {
    		  value: true
    		});
    		Object.defineProperty(exports, "VISITOR_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.VISITOR_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "ALIAS_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.ALIAS_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "FLIPPED_ALIAS_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.FLIPPED_ALIAS_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "NODE_FIELDS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.NODE_FIELDS;
    		  }
    		});
    		Object.defineProperty(exports, "BUILDER_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.BUILDER_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "DEPRECATED_KEYS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.DEPRECATED_KEYS;
    		  }
    		});
    		Object.defineProperty(exports, "NODE_PARENT_VALIDATIONS", {
    		  enumerable: true,
    		  get: function () {
    		    return _utils.NODE_PARENT_VALIDATIONS;
    		  }
    		});
    		Object.defineProperty(exports, "PLACEHOLDERS", {
    		  enumerable: true,
    		  get: function () {
    		    return _placeholders.PLACEHOLDERS;
    		  }
    		});
    		Object.defineProperty(exports, "PLACEHOLDERS_ALIAS", {
    		  enumerable: true,
    		  get: function () {
    		    return _placeholders.PLACEHOLDERS_ALIAS;
    		  }
    		});
    		Object.defineProperty(exports, "PLACEHOLDERS_FLIPPED_ALIAS", {
    		  enumerable: true,
    		  get: function () {
    		    return _placeholders.PLACEHOLDERS_FLIPPED_ALIAS;
    		  }
    		});
    		exports.TYPES = void 0;

    		var _toFastProperties = _interopRequireDefault(toFastProperties);

    		requireCore();

    		requireEs2015();

    		requireFlow();

    		requireJsx();

    		requireMisc();

    		requireExperimental();

    		requireTypescript();

    		var _utils = requireUtils();

    		var _placeholders = requirePlaceholders();

    		function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    		(0, _toFastProperties.default)(_utils.VISITOR_KEYS);
    		(0, _toFastProperties.default)(_utils.ALIAS_KEYS);
    		(0, _toFastProperties.default)(_utils.FLIPPED_ALIAS_KEYS);
    		(0, _toFastProperties.default)(_utils.NODE_FIELDS);
    		(0, _toFastProperties.default)(_utils.BUILDER_KEYS);
    		(0, _toFastProperties.default)(_utils.DEPRECATED_KEYS);
    		(0, _toFastProperties.default)(_placeholders.PLACEHOLDERS_ALIAS);
    		(0, _toFastProperties.default)(_placeholders.PLACEHOLDERS_FLIPPED_ALIAS);
    		const TYPES = Object.keys(_utils.VISITOR_KEYS).concat(Object.keys(_utils.FLIPPED_ALIAS_KEYS)).concat(Object.keys(_utils.DEPRECATED_KEYS));
    		exports.TYPES = TYPES;
    } (definitions));
    	return definitions;
    }

    Object.defineProperty(builder$1, "__esModule", {
      value: true
    });
    builder$1.default = builder;

    var _clone = _interopRequireDefault$v(clone_1);

    var _definitions$6 = requireDefinitions();

    var _validate = _interopRequireDefault$v(requireValidate());

    function _interopRequireDefault$v(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function builder(type, ...args) {
      const keys = _definitions$6.BUILDER_KEYS[type];
      const countArgs = args.length;

      if (countArgs > keys.length) {
        throw new Error(`${type}: Too many arguments passed. Received ${countArgs} but can receive no more than ${keys.length}`);
      }

      const node = {
        type
      };
      let i = 0;
      keys.forEach(key => {
        const field = _definitions$6.NODE_FIELDS[type][key];
        let arg;
        if (i < countArgs) arg = args[i];
        if (arg === undefined) arg = (0, _clone.default)(field.default);
        node[key] = arg;
        i++;
      });

      for (const key of Object.keys(node)) {
        (0, _validate.default)(node, key, node[key]);
      }

      return node;
    }

    Object.defineProperty(generated$2, "__esModule", {
      value: true
    });
    generated$2.arrayExpression = generated$2.ArrayExpression = ArrayExpression$1;
    generated$2.assignmentExpression = generated$2.AssignmentExpression = AssignmentExpression$2;
    generated$2.binaryExpression = generated$2.BinaryExpression = BinaryExpression$1;
    generated$2.interpreterDirective = generated$2.InterpreterDirective = InterpreterDirective$1;
    generated$2.directive = generated$2.Directive = Directive$1;
    generated$2.directiveLiteral = generated$2.DirectiveLiteral = DirectiveLiteral$1;
    generated$2.blockStatement = generated$2.BlockStatement = BlockStatement$1;
    generated$2.breakStatement = generated$2.BreakStatement = BreakStatement$1;
    generated$2.callExpression = generated$2.CallExpression = CallExpression$1;
    generated$2.catchClause = generated$2.CatchClause = CatchClause$1;
    generated$2.conditionalExpression = generated$2.ConditionalExpression = ConditionalExpression$2;
    generated$2.continueStatement = generated$2.ContinueStatement = ContinueStatement$1;
    generated$2.debuggerStatement = generated$2.DebuggerStatement = DebuggerStatement$1;
    generated$2.doWhileStatement = generated$2.DoWhileStatement = DoWhileStatement$1;
    generated$2.emptyStatement = generated$2.EmptyStatement = EmptyStatement$1;
    generated$2.expressionStatement = generated$2.ExpressionStatement = ExpressionStatement$1;
    generated$2.file = generated$2.File = File$1;
    generated$2.forInStatement = generated$2.ForInStatement = ForInStatement$1;
    generated$2.forStatement = generated$2.ForStatement = ForStatement$1;
    generated$2.functionDeclaration = generated$2.FunctionDeclaration = FunctionDeclaration;
    generated$2.functionExpression = generated$2.FunctionExpression = FunctionExpression$2;
    generated$2.identifier = generated$2.Identifier = Identifier$2;
    generated$2.ifStatement = generated$2.IfStatement = IfStatement$1;
    generated$2.labeledStatement = generated$2.LabeledStatement = LabeledStatement$1;
    generated$2.stringLiteral = generated$2.StringLiteral = StringLiteral$1;
    generated$2.numericLiteral = generated$2.NumericLiteral = NumericLiteral$1;
    generated$2.nullLiteral = generated$2.NullLiteral = NullLiteral$1;
    generated$2.booleanLiteral = generated$2.BooleanLiteral = BooleanLiteral$1;
    generated$2.regExpLiteral = generated$2.RegExpLiteral = RegExpLiteral$1;
    generated$2.logicalExpression = generated$2.LogicalExpression = LogicalExpression$1;
    generated$2.memberExpression = generated$2.MemberExpression = MemberExpression$1;
    generated$2.newExpression = generated$2.NewExpression = NewExpression$1;
    generated$2.program = generated$2.Program = Program$1;
    generated$2.objectExpression = generated$2.ObjectExpression = ObjectExpression$2;
    generated$2.objectMethod = generated$2.ObjectMethod = ObjectMethod$1;
    generated$2.objectProperty = generated$2.ObjectProperty = ObjectProperty$1;
    generated$2.restElement = generated$2.RestElement = RestElement$1;
    generated$2.returnStatement = generated$2.ReturnStatement = ReturnStatement$1;
    generated$2.sequenceExpression = generated$2.SequenceExpression = SequenceExpression$2;
    generated$2.parenthesizedExpression = generated$2.ParenthesizedExpression = ParenthesizedExpression$1;
    generated$2.switchCase = generated$2.SwitchCase = SwitchCase$1;
    generated$2.switchStatement = generated$2.SwitchStatement = SwitchStatement$1;
    generated$2.thisExpression = generated$2.ThisExpression = ThisExpression$1;
    generated$2.throwStatement = generated$2.ThrowStatement = ThrowStatement$1;
    generated$2.tryStatement = generated$2.TryStatement = TryStatement$1;
    generated$2.unaryExpression = generated$2.UnaryExpression = UnaryExpression$1;
    generated$2.updateExpression = generated$2.UpdateExpression = UpdateExpression$2;
    generated$2.variableDeclaration = generated$2.VariableDeclaration = VariableDeclaration$1;
    generated$2.variableDeclarator = generated$2.VariableDeclarator = VariableDeclarator$1;
    generated$2.whileStatement = generated$2.WhileStatement = WhileStatement$1;
    generated$2.withStatement = generated$2.WithStatement = WithStatement$1;
    generated$2.assignmentPattern = generated$2.AssignmentPattern = AssignmentPattern$1;
    generated$2.arrayPattern = generated$2.ArrayPattern = ArrayPattern;
    generated$2.arrowFunctionExpression = generated$2.ArrowFunctionExpression = ArrowFunctionExpression$2;
    generated$2.classBody = generated$2.ClassBody = ClassBody$1;
    generated$2.classExpression = generated$2.ClassExpression = ClassExpression$1;
    generated$2.classDeclaration = generated$2.ClassDeclaration = ClassDeclaration$1;
    generated$2.exportAllDeclaration = generated$2.ExportAllDeclaration = ExportAllDeclaration$1;
    generated$2.exportDefaultDeclaration = generated$2.ExportDefaultDeclaration = ExportDefaultDeclaration$1;
    generated$2.exportNamedDeclaration = generated$2.ExportNamedDeclaration = ExportNamedDeclaration$1;
    generated$2.exportSpecifier = generated$2.ExportSpecifier = ExportSpecifier$1;
    generated$2.forOfStatement = generated$2.ForOfStatement = ForOfStatement$1;
    generated$2.importDeclaration = generated$2.ImportDeclaration = ImportDeclaration$1;
    generated$2.importDefaultSpecifier = generated$2.ImportDefaultSpecifier = ImportDefaultSpecifier$1;
    generated$2.importNamespaceSpecifier = generated$2.ImportNamespaceSpecifier = ImportNamespaceSpecifier$1;
    generated$2.importSpecifier = generated$2.ImportSpecifier = ImportSpecifier$1;
    generated$2.metaProperty = generated$2.MetaProperty = MetaProperty$1;
    generated$2.classMethod = generated$2.ClassMethod = ClassMethod$1;
    generated$2.objectPattern = generated$2.ObjectPattern = ObjectPattern;
    generated$2.spreadElement = generated$2.SpreadElement = SpreadElement;
    generated$2.super = generated$2.Super = Super$1;
    generated$2.taggedTemplateExpression = generated$2.TaggedTemplateExpression = TaggedTemplateExpression$1;
    generated$2.templateElement = generated$2.TemplateElement = TemplateElement$1;
    generated$2.templateLiteral = generated$2.TemplateLiteral = TemplateLiteral$1;
    generated$2.yieldExpression = generated$2.YieldExpression = YieldExpression$2;
    generated$2.anyTypeAnnotation = generated$2.AnyTypeAnnotation = AnyTypeAnnotation;
    generated$2.arrayTypeAnnotation = generated$2.ArrayTypeAnnotation = ArrayTypeAnnotation;
    generated$2.booleanTypeAnnotation = generated$2.BooleanTypeAnnotation = BooleanTypeAnnotation;
    generated$2.booleanLiteralTypeAnnotation = generated$2.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
    generated$2.nullLiteralTypeAnnotation = generated$2.NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
    generated$2.classImplements = generated$2.ClassImplements = ClassImplements;
    generated$2.declareClass = generated$2.DeclareClass = DeclareClass;
    generated$2.declareFunction = generated$2.DeclareFunction = DeclareFunction;
    generated$2.declareInterface = generated$2.DeclareInterface = DeclareInterface;
    generated$2.declareModule = generated$2.DeclareModule = DeclareModule;
    generated$2.declareModuleExports = generated$2.DeclareModuleExports = DeclareModuleExports;
    generated$2.declareTypeAlias = generated$2.DeclareTypeAlias = DeclareTypeAlias;
    generated$2.declareOpaqueType = generated$2.DeclareOpaqueType = DeclareOpaqueType;
    generated$2.declareVariable = generated$2.DeclareVariable = DeclareVariable;
    generated$2.declareExportDeclaration = generated$2.DeclareExportDeclaration = DeclareExportDeclaration;
    generated$2.declareExportAllDeclaration = generated$2.DeclareExportAllDeclaration = DeclareExportAllDeclaration;
    generated$2.declaredPredicate = generated$2.DeclaredPredicate = DeclaredPredicate;
    generated$2.existsTypeAnnotation = generated$2.ExistsTypeAnnotation = ExistsTypeAnnotation;
    generated$2.functionTypeAnnotation = generated$2.FunctionTypeAnnotation = FunctionTypeAnnotation$1;
    generated$2.functionTypeParam = generated$2.FunctionTypeParam = FunctionTypeParam;
    generated$2.genericTypeAnnotation = generated$2.GenericTypeAnnotation = GenericTypeAnnotation;
    generated$2.inferredPredicate = generated$2.InferredPredicate = InferredPredicate;
    generated$2.interfaceExtends = generated$2.InterfaceExtends = InterfaceExtends;
    generated$2.interfaceDeclaration = generated$2.InterfaceDeclaration = InterfaceDeclaration;
    generated$2.interfaceTypeAnnotation = generated$2.InterfaceTypeAnnotation = InterfaceTypeAnnotation;
    generated$2.intersectionTypeAnnotation = generated$2.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
    generated$2.mixedTypeAnnotation = generated$2.MixedTypeAnnotation = MixedTypeAnnotation;
    generated$2.emptyTypeAnnotation = generated$2.EmptyTypeAnnotation = EmptyTypeAnnotation;
    generated$2.nullableTypeAnnotation = generated$2.NullableTypeAnnotation = NullableTypeAnnotation$1;
    generated$2.numberLiteralTypeAnnotation = generated$2.NumberLiteralTypeAnnotation = NumberLiteralTypeAnnotation;
    generated$2.numberTypeAnnotation = generated$2.NumberTypeAnnotation = NumberTypeAnnotation;
    generated$2.objectTypeAnnotation = generated$2.ObjectTypeAnnotation = ObjectTypeAnnotation;
    generated$2.objectTypeInternalSlot = generated$2.ObjectTypeInternalSlot = ObjectTypeInternalSlot;
    generated$2.objectTypeCallProperty = generated$2.ObjectTypeCallProperty = ObjectTypeCallProperty;
    generated$2.objectTypeIndexer = generated$2.ObjectTypeIndexer = ObjectTypeIndexer;
    generated$2.objectTypeProperty = generated$2.ObjectTypeProperty = ObjectTypeProperty;
    generated$2.objectTypeSpreadProperty = generated$2.ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
    generated$2.opaqueType = generated$2.OpaqueType = OpaqueType;
    generated$2.qualifiedTypeIdentifier = generated$2.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
    generated$2.stringLiteralTypeAnnotation = generated$2.StringLiteralTypeAnnotation = StringLiteralTypeAnnotation;
    generated$2.stringTypeAnnotation = generated$2.StringTypeAnnotation = StringTypeAnnotation;
    generated$2.symbolTypeAnnotation = generated$2.SymbolTypeAnnotation = SymbolTypeAnnotation;
    generated$2.thisTypeAnnotation = generated$2.ThisTypeAnnotation = ThisTypeAnnotation;
    generated$2.tupleTypeAnnotation = generated$2.TupleTypeAnnotation = TupleTypeAnnotation;
    generated$2.typeofTypeAnnotation = generated$2.TypeofTypeAnnotation = TypeofTypeAnnotation;
    generated$2.typeAlias = generated$2.TypeAlias = TypeAlias;
    generated$2.typeAnnotation = generated$2.TypeAnnotation = TypeAnnotation;
    generated$2.typeCastExpression = generated$2.TypeCastExpression = TypeCastExpression;
    generated$2.typeParameter = generated$2.TypeParameter = TypeParameter;
    generated$2.typeParameterDeclaration = generated$2.TypeParameterDeclaration = TypeParameterDeclaration;
    generated$2.typeParameterInstantiation = generated$2.TypeParameterInstantiation = TypeParameterInstantiation;
    generated$2.unionTypeAnnotation = generated$2.UnionTypeAnnotation = UnionTypeAnnotation$1;
    generated$2.variance = generated$2.Variance = Variance;
    generated$2.voidTypeAnnotation = generated$2.VoidTypeAnnotation = VoidTypeAnnotation;
    generated$2.enumDeclaration = generated$2.EnumDeclaration = EnumDeclaration;
    generated$2.enumBooleanBody = generated$2.EnumBooleanBody = EnumBooleanBody;
    generated$2.enumNumberBody = generated$2.EnumNumberBody = EnumNumberBody;
    generated$2.enumStringBody = generated$2.EnumStringBody = EnumStringBody;
    generated$2.enumSymbolBody = generated$2.EnumSymbolBody = EnumSymbolBody;
    generated$2.enumBooleanMember = generated$2.EnumBooleanMember = EnumBooleanMember;
    generated$2.enumNumberMember = generated$2.EnumNumberMember = EnumNumberMember;
    generated$2.enumStringMember = generated$2.EnumStringMember = EnumStringMember;
    generated$2.enumDefaultedMember = generated$2.EnumDefaultedMember = EnumDefaultedMember;
    generated$2.jSXAttribute = generated$2.jsxAttribute = generated$2.JSXAttribute = JSXAttribute$1;
    generated$2.jSXClosingElement = generated$2.jsxClosingElement = generated$2.JSXClosingElement = JSXClosingElement$1;
    generated$2.jSXElement = generated$2.jsxElement = generated$2.JSXElement = JSXElement$1;
    generated$2.jSXEmptyExpression = generated$2.jsxEmptyExpression = generated$2.JSXEmptyExpression = JSXEmptyExpression$1;
    generated$2.jSXExpressionContainer = generated$2.jsxExpressionContainer = generated$2.JSXExpressionContainer = JSXExpressionContainer$1;
    generated$2.jSXSpreadChild = generated$2.jsxSpreadChild = generated$2.JSXSpreadChild = JSXSpreadChild$1;
    generated$2.jSXIdentifier = generated$2.jsxIdentifier = generated$2.JSXIdentifier = JSXIdentifier$1;
    generated$2.jSXMemberExpression = generated$2.jsxMemberExpression = generated$2.JSXMemberExpression = JSXMemberExpression$1;
    generated$2.jSXNamespacedName = generated$2.jsxNamespacedName = generated$2.JSXNamespacedName = JSXNamespacedName$1;
    generated$2.jSXOpeningElement = generated$2.jsxOpeningElement = generated$2.JSXOpeningElement = JSXOpeningElement$1;
    generated$2.jSXSpreadAttribute = generated$2.jsxSpreadAttribute = generated$2.JSXSpreadAttribute = JSXSpreadAttribute$1;
    generated$2.jSXText = generated$2.jsxText = generated$2.JSXText = JSXText$1;
    generated$2.jSXFragment = generated$2.jsxFragment = generated$2.JSXFragment = JSXFragment$1;
    generated$2.jSXOpeningFragment = generated$2.jsxOpeningFragment = generated$2.JSXOpeningFragment = JSXOpeningFragment$1;
    generated$2.jSXClosingFragment = generated$2.jsxClosingFragment = generated$2.JSXClosingFragment = JSXClosingFragment$1;
    generated$2.noop = generated$2.Noop = Noop;
    generated$2.placeholder = generated$2.Placeholder = Placeholder$1;
    generated$2.v8IntrinsicIdentifier = generated$2.V8IntrinsicIdentifier = V8IntrinsicIdentifier$1;
    generated$2.argumentPlaceholder = generated$2.ArgumentPlaceholder = ArgumentPlaceholder$1;
    generated$2.awaitExpression = generated$2.AwaitExpression = AwaitExpression$1;
    generated$2.bindExpression = generated$2.BindExpression = BindExpression$1;
    generated$2.classProperty = generated$2.ClassProperty = ClassProperty$1;
    generated$2.optionalMemberExpression = generated$2.OptionalMemberExpression = OptionalMemberExpression$2;
    generated$2.pipelineTopicExpression = generated$2.PipelineTopicExpression = PipelineTopicExpression$1;
    generated$2.pipelineBareFunction = generated$2.PipelineBareFunction = PipelineBareFunction$1;
    generated$2.pipelinePrimaryTopicReference = generated$2.PipelinePrimaryTopicReference = PipelinePrimaryTopicReference$1;
    generated$2.optionalCallExpression = generated$2.OptionalCallExpression = OptionalCallExpression$1;
    generated$2.classPrivateProperty = generated$2.ClassPrivateProperty = ClassPrivateProperty$1;
    generated$2.classPrivateMethod = generated$2.ClassPrivateMethod = ClassPrivateMethod$1;
    generated$2.import = generated$2.Import = Import$1;
    generated$2.importAttribute = generated$2.ImportAttribute = ImportAttribute$1;
    generated$2.decorator = generated$2.Decorator = Decorator$1;
    generated$2.doExpression = generated$2.DoExpression = DoExpression$2;
    generated$2.exportDefaultSpecifier = generated$2.ExportDefaultSpecifier = ExportDefaultSpecifier$1;
    generated$2.exportNamespaceSpecifier = generated$2.ExportNamespaceSpecifier = ExportNamespaceSpecifier$1;
    generated$2.privateName = generated$2.PrivateName = PrivateName$1;
    generated$2.bigIntLiteral = generated$2.BigIntLiteral = BigIntLiteral$1;
    generated$2.recordExpression = generated$2.RecordExpression = RecordExpression$1;
    generated$2.tupleExpression = generated$2.TupleExpression = TupleExpression$1;
    generated$2.tSParameterProperty = generated$2.tsParameterProperty = generated$2.TSParameterProperty = TSParameterProperty$1;
    generated$2.tSDeclareFunction = generated$2.tsDeclareFunction = generated$2.TSDeclareFunction = TSDeclareFunction$1;
    generated$2.tSDeclareMethod = generated$2.tsDeclareMethod = generated$2.TSDeclareMethod = TSDeclareMethod$1;
    generated$2.tSQualifiedName = generated$2.tsQualifiedName = generated$2.TSQualifiedName = TSQualifiedName$1;
    generated$2.tSCallSignatureDeclaration = generated$2.tsCallSignatureDeclaration = generated$2.TSCallSignatureDeclaration = TSCallSignatureDeclaration$1;
    generated$2.tSConstructSignatureDeclaration = generated$2.tsConstructSignatureDeclaration = generated$2.TSConstructSignatureDeclaration = TSConstructSignatureDeclaration$1;
    generated$2.tSPropertySignature = generated$2.tsPropertySignature = generated$2.TSPropertySignature = TSPropertySignature$1;
    generated$2.tSMethodSignature = generated$2.tsMethodSignature = generated$2.TSMethodSignature = TSMethodSignature$1;
    generated$2.tSIndexSignature = generated$2.tsIndexSignature = generated$2.TSIndexSignature = TSIndexSignature$1;
    generated$2.tSAnyKeyword = generated$2.tsAnyKeyword = generated$2.TSAnyKeyword = TSAnyKeyword$1;
    generated$2.tSBooleanKeyword = generated$2.tsBooleanKeyword = generated$2.TSBooleanKeyword = TSBooleanKeyword$1;
    generated$2.tSBigIntKeyword = generated$2.tsBigIntKeyword = generated$2.TSBigIntKeyword = TSBigIntKeyword$1;
    generated$2.tSNeverKeyword = generated$2.tsNeverKeyword = generated$2.TSNeverKeyword = TSNeverKeyword$1;
    generated$2.tSNullKeyword = generated$2.tsNullKeyword = generated$2.TSNullKeyword = TSNullKeyword$1;
    generated$2.tSNumberKeyword = generated$2.tsNumberKeyword = generated$2.TSNumberKeyword = TSNumberKeyword$1;
    generated$2.tSObjectKeyword = generated$2.tsObjectKeyword = generated$2.TSObjectKeyword = TSObjectKeyword$1;
    generated$2.tSStringKeyword = generated$2.tsStringKeyword = generated$2.TSStringKeyword = TSStringKeyword$1;
    generated$2.tSSymbolKeyword = generated$2.tsSymbolKeyword = generated$2.TSSymbolKeyword = TSSymbolKeyword$1;
    generated$2.tSUndefinedKeyword = generated$2.tsUndefinedKeyword = generated$2.TSUndefinedKeyword = TSUndefinedKeyword$1;
    generated$2.tSUnknownKeyword = generated$2.tsUnknownKeyword = generated$2.TSUnknownKeyword = TSUnknownKeyword$1;
    generated$2.tSVoidKeyword = generated$2.tsVoidKeyword = generated$2.TSVoidKeyword = TSVoidKeyword$1;
    generated$2.tSThisType = generated$2.tsThisType = generated$2.TSThisType = TSThisType$1;
    generated$2.tSFunctionType = generated$2.tsFunctionType = generated$2.TSFunctionType = TSFunctionType$1;
    generated$2.tSConstructorType = generated$2.tsConstructorType = generated$2.TSConstructorType = TSConstructorType$1;
    generated$2.tSTypeReference = generated$2.tsTypeReference = generated$2.TSTypeReference = TSTypeReference$1;
    generated$2.tSTypePredicate = generated$2.tsTypePredicate = generated$2.TSTypePredicate = TSTypePredicate$1;
    generated$2.tSTypeQuery = generated$2.tsTypeQuery = generated$2.TSTypeQuery = TSTypeQuery$1;
    generated$2.tSTypeLiteral = generated$2.tsTypeLiteral = generated$2.TSTypeLiteral = TSTypeLiteral$1;
    generated$2.tSArrayType = generated$2.tsArrayType = generated$2.TSArrayType = TSArrayType$1;
    generated$2.tSTupleType = generated$2.tsTupleType = generated$2.TSTupleType = TSTupleType$1;
    generated$2.tSOptionalType = generated$2.tsOptionalType = generated$2.TSOptionalType = TSOptionalType$1;
    generated$2.tSRestType = generated$2.tsRestType = generated$2.TSRestType = TSRestType$1;
    generated$2.tSUnionType = generated$2.tsUnionType = generated$2.TSUnionType = TSUnionType$2;
    generated$2.tSIntersectionType = generated$2.tsIntersectionType = generated$2.TSIntersectionType = TSIntersectionType$1;
    generated$2.tSConditionalType = generated$2.tsConditionalType = generated$2.TSConditionalType = TSConditionalType$1;
    generated$2.tSInferType = generated$2.tsInferType = generated$2.TSInferType = TSInferType$2;
    generated$2.tSParenthesizedType = generated$2.tsParenthesizedType = generated$2.TSParenthesizedType = TSParenthesizedType$1;
    generated$2.tSTypeOperator = generated$2.tsTypeOperator = generated$2.TSTypeOperator = TSTypeOperator$1;
    generated$2.tSIndexedAccessType = generated$2.tsIndexedAccessType = generated$2.TSIndexedAccessType = TSIndexedAccessType$1;
    generated$2.tSMappedType = generated$2.tsMappedType = generated$2.TSMappedType = TSMappedType$1;
    generated$2.tSLiteralType = generated$2.tsLiteralType = generated$2.TSLiteralType = TSLiteralType$1;
    generated$2.tSExpressionWithTypeArguments = generated$2.tsExpressionWithTypeArguments = generated$2.TSExpressionWithTypeArguments = TSExpressionWithTypeArguments$1;
    generated$2.tSInterfaceDeclaration = generated$2.tsInterfaceDeclaration = generated$2.TSInterfaceDeclaration = TSInterfaceDeclaration$1;
    generated$2.tSInterfaceBody = generated$2.tsInterfaceBody = generated$2.TSInterfaceBody = TSInterfaceBody$1;
    generated$2.tSTypeAliasDeclaration = generated$2.tsTypeAliasDeclaration = generated$2.TSTypeAliasDeclaration = TSTypeAliasDeclaration$1;
    generated$2.tSAsExpression = generated$2.tsAsExpression = generated$2.TSAsExpression = TSAsExpression$2;
    generated$2.tSTypeAssertion = generated$2.tsTypeAssertion = generated$2.TSTypeAssertion = TSTypeAssertion$2;
    generated$2.tSEnumDeclaration = generated$2.tsEnumDeclaration = generated$2.TSEnumDeclaration = TSEnumDeclaration$1;
    generated$2.tSEnumMember = generated$2.tsEnumMember = generated$2.TSEnumMember = TSEnumMember$1;
    generated$2.tSModuleDeclaration = generated$2.tsModuleDeclaration = generated$2.TSModuleDeclaration = TSModuleDeclaration$1;
    generated$2.tSModuleBlock = generated$2.tsModuleBlock = generated$2.TSModuleBlock = TSModuleBlock$1;
    generated$2.tSImportType = generated$2.tsImportType = generated$2.TSImportType = TSImportType$1;
    generated$2.tSImportEqualsDeclaration = generated$2.tsImportEqualsDeclaration = generated$2.TSImportEqualsDeclaration = TSImportEqualsDeclaration$1;
    generated$2.tSExternalModuleReference = generated$2.tsExternalModuleReference = generated$2.TSExternalModuleReference = TSExternalModuleReference$1;
    generated$2.tSNonNullExpression = generated$2.tsNonNullExpression = generated$2.TSNonNullExpression = TSNonNullExpression$1;
    generated$2.tSExportAssignment = generated$2.tsExportAssignment = generated$2.TSExportAssignment = TSExportAssignment$1;
    generated$2.tSNamespaceExportDeclaration = generated$2.tsNamespaceExportDeclaration = generated$2.TSNamespaceExportDeclaration = TSNamespaceExportDeclaration$1;
    generated$2.tSTypeAnnotation = generated$2.tsTypeAnnotation = generated$2.TSTypeAnnotation = TSTypeAnnotation$1;
    generated$2.tSTypeParameterInstantiation = generated$2.tsTypeParameterInstantiation = generated$2.TSTypeParameterInstantiation = TSTypeParameterInstantiation$1;
    generated$2.tSTypeParameterDeclaration = generated$2.tsTypeParameterDeclaration = generated$2.TSTypeParameterDeclaration = TSTypeParameterDeclaration;
    generated$2.tSTypeParameter = generated$2.tsTypeParameter = generated$2.TSTypeParameter = TSTypeParameter$1;
    generated$2.numberLiteral = generated$2.NumberLiteral = NumberLiteral;
    generated$2.regexLiteral = generated$2.RegexLiteral = RegexLiteral;
    generated$2.restProperty = generated$2.RestProperty = RestProperty;
    generated$2.spreadProperty = generated$2.SpreadProperty = SpreadProperty;

    var _builder = _interopRequireDefault$u(builder$1);

    function _interopRequireDefault$u(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function ArrayExpression$1(...args) {
      return (0, _builder.default)("ArrayExpression", ...args);
    }

    function AssignmentExpression$2(...args) {
      return (0, _builder.default)("AssignmentExpression", ...args);
    }

    function BinaryExpression$1(...args) {
      return (0, _builder.default)("BinaryExpression", ...args);
    }

    function InterpreterDirective$1(...args) {
      return (0, _builder.default)("InterpreterDirective", ...args);
    }

    function Directive$1(...args) {
      return (0, _builder.default)("Directive", ...args);
    }

    function DirectiveLiteral$1(...args) {
      return (0, _builder.default)("DirectiveLiteral", ...args);
    }

    function BlockStatement$1(...args) {
      return (0, _builder.default)("BlockStatement", ...args);
    }

    function BreakStatement$1(...args) {
      return (0, _builder.default)("BreakStatement", ...args);
    }

    function CallExpression$1(...args) {
      return (0, _builder.default)("CallExpression", ...args);
    }

    function CatchClause$1(...args) {
      return (0, _builder.default)("CatchClause", ...args);
    }

    function ConditionalExpression$2(...args) {
      return (0, _builder.default)("ConditionalExpression", ...args);
    }

    function ContinueStatement$1(...args) {
      return (0, _builder.default)("ContinueStatement", ...args);
    }

    function DebuggerStatement$1(...args) {
      return (0, _builder.default)("DebuggerStatement", ...args);
    }

    function DoWhileStatement$1(...args) {
      return (0, _builder.default)("DoWhileStatement", ...args);
    }

    function EmptyStatement$1(...args) {
      return (0, _builder.default)("EmptyStatement", ...args);
    }

    function ExpressionStatement$1(...args) {
      return (0, _builder.default)("ExpressionStatement", ...args);
    }

    function File$1(...args) {
      return (0, _builder.default)("File", ...args);
    }

    function ForInStatement$1(...args) {
      return (0, _builder.default)("ForInStatement", ...args);
    }

    function ForStatement$1(...args) {
      return (0, _builder.default)("ForStatement", ...args);
    }

    function FunctionDeclaration(...args) {
      return (0, _builder.default)("FunctionDeclaration", ...args);
    }

    function FunctionExpression$2(...args) {
      return (0, _builder.default)("FunctionExpression", ...args);
    }

    function Identifier$2(...args) {
      return (0, _builder.default)("Identifier", ...args);
    }

    function IfStatement$1(...args) {
      return (0, _builder.default)("IfStatement", ...args);
    }

    function LabeledStatement$1(...args) {
      return (0, _builder.default)("LabeledStatement", ...args);
    }

    function StringLiteral$1(...args) {
      return (0, _builder.default)("StringLiteral", ...args);
    }

    function NumericLiteral$1(...args) {
      return (0, _builder.default)("NumericLiteral", ...args);
    }

    function NullLiteral$1(...args) {
      return (0, _builder.default)("NullLiteral", ...args);
    }

    function BooleanLiteral$1(...args) {
      return (0, _builder.default)("BooleanLiteral", ...args);
    }

    function RegExpLiteral$1(...args) {
      return (0, _builder.default)("RegExpLiteral", ...args);
    }

    function LogicalExpression$1(...args) {
      return (0, _builder.default)("LogicalExpression", ...args);
    }

    function MemberExpression$1(...args) {
      return (0, _builder.default)("MemberExpression", ...args);
    }

    function NewExpression$1(...args) {
      return (0, _builder.default)("NewExpression", ...args);
    }

    function Program$1(...args) {
      return (0, _builder.default)("Program", ...args);
    }

    function ObjectExpression$2(...args) {
      return (0, _builder.default)("ObjectExpression", ...args);
    }

    function ObjectMethod$1(...args) {
      return (0, _builder.default)("ObjectMethod", ...args);
    }

    function ObjectProperty$1(...args) {
      return (0, _builder.default)("ObjectProperty", ...args);
    }

    function RestElement$1(...args) {
      return (0, _builder.default)("RestElement", ...args);
    }

    function ReturnStatement$1(...args) {
      return (0, _builder.default)("ReturnStatement", ...args);
    }

    function SequenceExpression$2(...args) {
      return (0, _builder.default)("SequenceExpression", ...args);
    }

    function ParenthesizedExpression$1(...args) {
      return (0, _builder.default)("ParenthesizedExpression", ...args);
    }

    function SwitchCase$1(...args) {
      return (0, _builder.default)("SwitchCase", ...args);
    }

    function SwitchStatement$1(...args) {
      return (0, _builder.default)("SwitchStatement", ...args);
    }

    function ThisExpression$1(...args) {
      return (0, _builder.default)("ThisExpression", ...args);
    }

    function ThrowStatement$1(...args) {
      return (0, _builder.default)("ThrowStatement", ...args);
    }

    function TryStatement$1(...args) {
      return (0, _builder.default)("TryStatement", ...args);
    }

    function UnaryExpression$1(...args) {
      return (0, _builder.default)("UnaryExpression", ...args);
    }

    function UpdateExpression$2(...args) {
      return (0, _builder.default)("UpdateExpression", ...args);
    }

    function VariableDeclaration$1(...args) {
      return (0, _builder.default)("VariableDeclaration", ...args);
    }

    function VariableDeclarator$1(...args) {
      return (0, _builder.default)("VariableDeclarator", ...args);
    }

    function WhileStatement$1(...args) {
      return (0, _builder.default)("WhileStatement", ...args);
    }

    function WithStatement$1(...args) {
      return (0, _builder.default)("WithStatement", ...args);
    }

    function AssignmentPattern$1(...args) {
      return (0, _builder.default)("AssignmentPattern", ...args);
    }

    function ArrayPattern(...args) {
      return (0, _builder.default)("ArrayPattern", ...args);
    }

    function ArrowFunctionExpression$2(...args) {
      return (0, _builder.default)("ArrowFunctionExpression", ...args);
    }

    function ClassBody$1(...args) {
      return (0, _builder.default)("ClassBody", ...args);
    }

    function ClassExpression$1(...args) {
      return (0, _builder.default)("ClassExpression", ...args);
    }

    function ClassDeclaration$1(...args) {
      return (0, _builder.default)("ClassDeclaration", ...args);
    }

    function ExportAllDeclaration$1(...args) {
      return (0, _builder.default)("ExportAllDeclaration", ...args);
    }

    function ExportDefaultDeclaration$1(...args) {
      return (0, _builder.default)("ExportDefaultDeclaration", ...args);
    }

    function ExportNamedDeclaration$1(...args) {
      return (0, _builder.default)("ExportNamedDeclaration", ...args);
    }

    function ExportSpecifier$1(...args) {
      return (0, _builder.default)("ExportSpecifier", ...args);
    }

    function ForOfStatement$1(...args) {
      return (0, _builder.default)("ForOfStatement", ...args);
    }

    function ImportDeclaration$1(...args) {
      return (0, _builder.default)("ImportDeclaration", ...args);
    }

    function ImportDefaultSpecifier$1(...args) {
      return (0, _builder.default)("ImportDefaultSpecifier", ...args);
    }

    function ImportNamespaceSpecifier$1(...args) {
      return (0, _builder.default)("ImportNamespaceSpecifier", ...args);
    }

    function ImportSpecifier$1(...args) {
      return (0, _builder.default)("ImportSpecifier", ...args);
    }

    function MetaProperty$1(...args) {
      return (0, _builder.default)("MetaProperty", ...args);
    }

    function ClassMethod$1(...args) {
      return (0, _builder.default)("ClassMethod", ...args);
    }

    function ObjectPattern(...args) {
      return (0, _builder.default)("ObjectPattern", ...args);
    }

    function SpreadElement(...args) {
      return (0, _builder.default)("SpreadElement", ...args);
    }

    function Super$1(...args) {
      return (0, _builder.default)("Super", ...args);
    }

    function TaggedTemplateExpression$1(...args) {
      return (0, _builder.default)("TaggedTemplateExpression", ...args);
    }

    function TemplateElement$1(...args) {
      return (0, _builder.default)("TemplateElement", ...args);
    }

    function TemplateLiteral$1(...args) {
      return (0, _builder.default)("TemplateLiteral", ...args);
    }

    function YieldExpression$2(...args) {
      return (0, _builder.default)("YieldExpression", ...args);
    }

    function AnyTypeAnnotation(...args) {
      return (0, _builder.default)("AnyTypeAnnotation", ...args);
    }

    function ArrayTypeAnnotation(...args) {
      return (0, _builder.default)("ArrayTypeAnnotation", ...args);
    }

    function BooleanTypeAnnotation(...args) {
      return (0, _builder.default)("BooleanTypeAnnotation", ...args);
    }

    function BooleanLiteralTypeAnnotation(...args) {
      return (0, _builder.default)("BooleanLiteralTypeAnnotation", ...args);
    }

    function NullLiteralTypeAnnotation(...args) {
      return (0, _builder.default)("NullLiteralTypeAnnotation", ...args);
    }

    function ClassImplements(...args) {
      return (0, _builder.default)("ClassImplements", ...args);
    }

    function DeclareClass(...args) {
      return (0, _builder.default)("DeclareClass", ...args);
    }

    function DeclareFunction(...args) {
      return (0, _builder.default)("DeclareFunction", ...args);
    }

    function DeclareInterface(...args) {
      return (0, _builder.default)("DeclareInterface", ...args);
    }

    function DeclareModule(...args) {
      return (0, _builder.default)("DeclareModule", ...args);
    }

    function DeclareModuleExports(...args) {
      return (0, _builder.default)("DeclareModuleExports", ...args);
    }

    function DeclareTypeAlias(...args) {
      return (0, _builder.default)("DeclareTypeAlias", ...args);
    }

    function DeclareOpaqueType(...args) {
      return (0, _builder.default)("DeclareOpaqueType", ...args);
    }

    function DeclareVariable(...args) {
      return (0, _builder.default)("DeclareVariable", ...args);
    }

    function DeclareExportDeclaration(...args) {
      return (0, _builder.default)("DeclareExportDeclaration", ...args);
    }

    function DeclareExportAllDeclaration(...args) {
      return (0, _builder.default)("DeclareExportAllDeclaration", ...args);
    }

    function DeclaredPredicate(...args) {
      return (0, _builder.default)("DeclaredPredicate", ...args);
    }

    function ExistsTypeAnnotation(...args) {
      return (0, _builder.default)("ExistsTypeAnnotation", ...args);
    }

    function FunctionTypeAnnotation$1(...args) {
      return (0, _builder.default)("FunctionTypeAnnotation", ...args);
    }

    function FunctionTypeParam(...args) {
      return (0, _builder.default)("FunctionTypeParam", ...args);
    }

    function GenericTypeAnnotation(...args) {
      return (0, _builder.default)("GenericTypeAnnotation", ...args);
    }

    function InferredPredicate(...args) {
      return (0, _builder.default)("InferredPredicate", ...args);
    }

    function InterfaceExtends(...args) {
      return (0, _builder.default)("InterfaceExtends", ...args);
    }

    function InterfaceDeclaration(...args) {
      return (0, _builder.default)("InterfaceDeclaration", ...args);
    }

    function InterfaceTypeAnnotation(...args) {
      return (0, _builder.default)("InterfaceTypeAnnotation", ...args);
    }

    function IntersectionTypeAnnotation(...args) {
      return (0, _builder.default)("IntersectionTypeAnnotation", ...args);
    }

    function MixedTypeAnnotation(...args) {
      return (0, _builder.default)("MixedTypeAnnotation", ...args);
    }

    function EmptyTypeAnnotation(...args) {
      return (0, _builder.default)("EmptyTypeAnnotation", ...args);
    }

    function NullableTypeAnnotation$1(...args) {
      return (0, _builder.default)("NullableTypeAnnotation", ...args);
    }

    function NumberLiteralTypeAnnotation(...args) {
      return (0, _builder.default)("NumberLiteralTypeAnnotation", ...args);
    }

    function NumberTypeAnnotation(...args) {
      return (0, _builder.default)("NumberTypeAnnotation", ...args);
    }

    function ObjectTypeAnnotation(...args) {
      return (0, _builder.default)("ObjectTypeAnnotation", ...args);
    }

    function ObjectTypeInternalSlot(...args) {
      return (0, _builder.default)("ObjectTypeInternalSlot", ...args);
    }

    function ObjectTypeCallProperty(...args) {
      return (0, _builder.default)("ObjectTypeCallProperty", ...args);
    }

    function ObjectTypeIndexer(...args) {
      return (0, _builder.default)("ObjectTypeIndexer", ...args);
    }

    function ObjectTypeProperty(...args) {
      return (0, _builder.default)("ObjectTypeProperty", ...args);
    }

    function ObjectTypeSpreadProperty(...args) {
      return (0, _builder.default)("ObjectTypeSpreadProperty", ...args);
    }

    function OpaqueType(...args) {
      return (0, _builder.default)("OpaqueType", ...args);
    }

    function QualifiedTypeIdentifier(...args) {
      return (0, _builder.default)("QualifiedTypeIdentifier", ...args);
    }

    function StringLiteralTypeAnnotation(...args) {
      return (0, _builder.default)("StringLiteralTypeAnnotation", ...args);
    }

    function StringTypeAnnotation(...args) {
      return (0, _builder.default)("StringTypeAnnotation", ...args);
    }

    function SymbolTypeAnnotation(...args) {
      return (0, _builder.default)("SymbolTypeAnnotation", ...args);
    }

    function ThisTypeAnnotation(...args) {
      return (0, _builder.default)("ThisTypeAnnotation", ...args);
    }

    function TupleTypeAnnotation(...args) {
      return (0, _builder.default)("TupleTypeAnnotation", ...args);
    }

    function TypeofTypeAnnotation(...args) {
      return (0, _builder.default)("TypeofTypeAnnotation", ...args);
    }

    function TypeAlias(...args) {
      return (0, _builder.default)("TypeAlias", ...args);
    }

    function TypeAnnotation(...args) {
      return (0, _builder.default)("TypeAnnotation", ...args);
    }

    function TypeCastExpression(...args) {
      return (0, _builder.default)("TypeCastExpression", ...args);
    }

    function TypeParameter(...args) {
      return (0, _builder.default)("TypeParameter", ...args);
    }

    function TypeParameterDeclaration(...args) {
      return (0, _builder.default)("TypeParameterDeclaration", ...args);
    }

    function TypeParameterInstantiation(...args) {
      return (0, _builder.default)("TypeParameterInstantiation", ...args);
    }

    function UnionTypeAnnotation$1(...args) {
      return (0, _builder.default)("UnionTypeAnnotation", ...args);
    }

    function Variance(...args) {
      return (0, _builder.default)("Variance", ...args);
    }

    function VoidTypeAnnotation(...args) {
      return (0, _builder.default)("VoidTypeAnnotation", ...args);
    }

    function EnumDeclaration(...args) {
      return (0, _builder.default)("EnumDeclaration", ...args);
    }

    function EnumBooleanBody(...args) {
      return (0, _builder.default)("EnumBooleanBody", ...args);
    }

    function EnumNumberBody(...args) {
      return (0, _builder.default)("EnumNumberBody", ...args);
    }

    function EnumStringBody(...args) {
      return (0, _builder.default)("EnumStringBody", ...args);
    }

    function EnumSymbolBody(...args) {
      return (0, _builder.default)("EnumSymbolBody", ...args);
    }

    function EnumBooleanMember(...args) {
      return (0, _builder.default)("EnumBooleanMember", ...args);
    }

    function EnumNumberMember(...args) {
      return (0, _builder.default)("EnumNumberMember", ...args);
    }

    function EnumStringMember(...args) {
      return (0, _builder.default)("EnumStringMember", ...args);
    }

    function EnumDefaultedMember(...args) {
      return (0, _builder.default)("EnumDefaultedMember", ...args);
    }

    function JSXAttribute$1(...args) {
      return (0, _builder.default)("JSXAttribute", ...args);
    }

    function JSXClosingElement$1(...args) {
      return (0, _builder.default)("JSXClosingElement", ...args);
    }

    function JSXElement$1(...args) {
      return (0, _builder.default)("JSXElement", ...args);
    }

    function JSXEmptyExpression$1(...args) {
      return (0, _builder.default)("JSXEmptyExpression", ...args);
    }

    function JSXExpressionContainer$1(...args) {
      return (0, _builder.default)("JSXExpressionContainer", ...args);
    }

    function JSXSpreadChild$1(...args) {
      return (0, _builder.default)("JSXSpreadChild", ...args);
    }

    function JSXIdentifier$1(...args) {
      return (0, _builder.default)("JSXIdentifier", ...args);
    }

    function JSXMemberExpression$1(...args) {
      return (0, _builder.default)("JSXMemberExpression", ...args);
    }

    function JSXNamespacedName$1(...args) {
      return (0, _builder.default)("JSXNamespacedName", ...args);
    }

    function JSXOpeningElement$1(...args) {
      return (0, _builder.default)("JSXOpeningElement", ...args);
    }

    function JSXSpreadAttribute$1(...args) {
      return (0, _builder.default)("JSXSpreadAttribute", ...args);
    }

    function JSXText$1(...args) {
      return (0, _builder.default)("JSXText", ...args);
    }

    function JSXFragment$1(...args) {
      return (0, _builder.default)("JSXFragment", ...args);
    }

    function JSXOpeningFragment$1(...args) {
      return (0, _builder.default)("JSXOpeningFragment", ...args);
    }

    function JSXClosingFragment$1(...args) {
      return (0, _builder.default)("JSXClosingFragment", ...args);
    }

    function Noop(...args) {
      return (0, _builder.default)("Noop", ...args);
    }

    function Placeholder$1(...args) {
      return (0, _builder.default)("Placeholder", ...args);
    }

    function V8IntrinsicIdentifier$1(...args) {
      return (0, _builder.default)("V8IntrinsicIdentifier", ...args);
    }

    function ArgumentPlaceholder$1(...args) {
      return (0, _builder.default)("ArgumentPlaceholder", ...args);
    }

    function AwaitExpression$1(...args) {
      return (0, _builder.default)("AwaitExpression", ...args);
    }

    function BindExpression$1(...args) {
      return (0, _builder.default)("BindExpression", ...args);
    }

    function ClassProperty$1(...args) {
      return (0, _builder.default)("ClassProperty", ...args);
    }

    function OptionalMemberExpression$2(...args) {
      return (0, _builder.default)("OptionalMemberExpression", ...args);
    }

    function PipelineTopicExpression$1(...args) {
      return (0, _builder.default)("PipelineTopicExpression", ...args);
    }

    function PipelineBareFunction$1(...args) {
      return (0, _builder.default)("PipelineBareFunction", ...args);
    }

    function PipelinePrimaryTopicReference$1(...args) {
      return (0, _builder.default)("PipelinePrimaryTopicReference", ...args);
    }

    function OptionalCallExpression$1(...args) {
      return (0, _builder.default)("OptionalCallExpression", ...args);
    }

    function ClassPrivateProperty$1(...args) {
      return (0, _builder.default)("ClassPrivateProperty", ...args);
    }

    function ClassPrivateMethod$1(...args) {
      return (0, _builder.default)("ClassPrivateMethod", ...args);
    }

    function Import$1(...args) {
      return (0, _builder.default)("Import", ...args);
    }

    function ImportAttribute$1(...args) {
      return (0, _builder.default)("ImportAttribute", ...args);
    }

    function Decorator$1(...args) {
      return (0, _builder.default)("Decorator", ...args);
    }

    function DoExpression$2(...args) {
      return (0, _builder.default)("DoExpression", ...args);
    }

    function ExportDefaultSpecifier$1(...args) {
      return (0, _builder.default)("ExportDefaultSpecifier", ...args);
    }

    function ExportNamespaceSpecifier$1(...args) {
      return (0, _builder.default)("ExportNamespaceSpecifier", ...args);
    }

    function PrivateName$1(...args) {
      return (0, _builder.default)("PrivateName", ...args);
    }

    function BigIntLiteral$1(...args) {
      return (0, _builder.default)("BigIntLiteral", ...args);
    }

    function RecordExpression$1(...args) {
      return (0, _builder.default)("RecordExpression", ...args);
    }

    function TupleExpression$1(...args) {
      return (0, _builder.default)("TupleExpression", ...args);
    }

    function TSParameterProperty$1(...args) {
      return (0, _builder.default)("TSParameterProperty", ...args);
    }

    function TSDeclareFunction$1(...args) {
      return (0, _builder.default)("TSDeclareFunction", ...args);
    }

    function TSDeclareMethod$1(...args) {
      return (0, _builder.default)("TSDeclareMethod", ...args);
    }

    function TSQualifiedName$1(...args) {
      return (0, _builder.default)("TSQualifiedName", ...args);
    }

    function TSCallSignatureDeclaration$1(...args) {
      return (0, _builder.default)("TSCallSignatureDeclaration", ...args);
    }

    function TSConstructSignatureDeclaration$1(...args) {
      return (0, _builder.default)("TSConstructSignatureDeclaration", ...args);
    }

    function TSPropertySignature$1(...args) {
      return (0, _builder.default)("TSPropertySignature", ...args);
    }

    function TSMethodSignature$1(...args) {
      return (0, _builder.default)("TSMethodSignature", ...args);
    }

    function TSIndexSignature$1(...args) {
      return (0, _builder.default)("TSIndexSignature", ...args);
    }

    function TSAnyKeyword$1(...args) {
      return (0, _builder.default)("TSAnyKeyword", ...args);
    }

    function TSBooleanKeyword$1(...args) {
      return (0, _builder.default)("TSBooleanKeyword", ...args);
    }

    function TSBigIntKeyword$1(...args) {
      return (0, _builder.default)("TSBigIntKeyword", ...args);
    }

    function TSNeverKeyword$1(...args) {
      return (0, _builder.default)("TSNeverKeyword", ...args);
    }

    function TSNullKeyword$1(...args) {
      return (0, _builder.default)("TSNullKeyword", ...args);
    }

    function TSNumberKeyword$1(...args) {
      return (0, _builder.default)("TSNumberKeyword", ...args);
    }

    function TSObjectKeyword$1(...args) {
      return (0, _builder.default)("TSObjectKeyword", ...args);
    }

    function TSStringKeyword$1(...args) {
      return (0, _builder.default)("TSStringKeyword", ...args);
    }

    function TSSymbolKeyword$1(...args) {
      return (0, _builder.default)("TSSymbolKeyword", ...args);
    }

    function TSUndefinedKeyword$1(...args) {
      return (0, _builder.default)("TSUndefinedKeyword", ...args);
    }

    function TSUnknownKeyword$1(...args) {
      return (0, _builder.default)("TSUnknownKeyword", ...args);
    }

    function TSVoidKeyword$1(...args) {
      return (0, _builder.default)("TSVoidKeyword", ...args);
    }

    function TSThisType$1(...args) {
      return (0, _builder.default)("TSThisType", ...args);
    }

    function TSFunctionType$1(...args) {
      return (0, _builder.default)("TSFunctionType", ...args);
    }

    function TSConstructorType$1(...args) {
      return (0, _builder.default)("TSConstructorType", ...args);
    }

    function TSTypeReference$1(...args) {
      return (0, _builder.default)("TSTypeReference", ...args);
    }

    function TSTypePredicate$1(...args) {
      return (0, _builder.default)("TSTypePredicate", ...args);
    }

    function TSTypeQuery$1(...args) {
      return (0, _builder.default)("TSTypeQuery", ...args);
    }

    function TSTypeLiteral$1(...args) {
      return (0, _builder.default)("TSTypeLiteral", ...args);
    }

    function TSArrayType$1(...args) {
      return (0, _builder.default)("TSArrayType", ...args);
    }

    function TSTupleType$1(...args) {
      return (0, _builder.default)("TSTupleType", ...args);
    }

    function TSOptionalType$1(...args) {
      return (0, _builder.default)("TSOptionalType", ...args);
    }

    function TSRestType$1(...args) {
      return (0, _builder.default)("TSRestType", ...args);
    }

    function TSUnionType$2(...args) {
      return (0, _builder.default)("TSUnionType", ...args);
    }

    function TSIntersectionType$1(...args) {
      return (0, _builder.default)("TSIntersectionType", ...args);
    }

    function TSConditionalType$1(...args) {
      return (0, _builder.default)("TSConditionalType", ...args);
    }

    function TSInferType$2(...args) {
      return (0, _builder.default)("TSInferType", ...args);
    }

    function TSParenthesizedType$1(...args) {
      return (0, _builder.default)("TSParenthesizedType", ...args);
    }

    function TSTypeOperator$1(...args) {
      return (0, _builder.default)("TSTypeOperator", ...args);
    }

    function TSIndexedAccessType$1(...args) {
      return (0, _builder.default)("TSIndexedAccessType", ...args);
    }

    function TSMappedType$1(...args) {
      return (0, _builder.default)("TSMappedType", ...args);
    }

    function TSLiteralType$1(...args) {
      return (0, _builder.default)("TSLiteralType", ...args);
    }

    function TSExpressionWithTypeArguments$1(...args) {
      return (0, _builder.default)("TSExpressionWithTypeArguments", ...args);
    }

    function TSInterfaceDeclaration$1(...args) {
      return (0, _builder.default)("TSInterfaceDeclaration", ...args);
    }

    function TSInterfaceBody$1(...args) {
      return (0, _builder.default)("TSInterfaceBody", ...args);
    }

    function TSTypeAliasDeclaration$1(...args) {
      return (0, _builder.default)("TSTypeAliasDeclaration", ...args);
    }

    function TSAsExpression$2(...args) {
      return (0, _builder.default)("TSAsExpression", ...args);
    }

    function TSTypeAssertion$2(...args) {
      return (0, _builder.default)("TSTypeAssertion", ...args);
    }

    function TSEnumDeclaration$1(...args) {
      return (0, _builder.default)("TSEnumDeclaration", ...args);
    }

    function TSEnumMember$1(...args) {
      return (0, _builder.default)("TSEnumMember", ...args);
    }

    function TSModuleDeclaration$1(...args) {
      return (0, _builder.default)("TSModuleDeclaration", ...args);
    }

    function TSModuleBlock$1(...args) {
      return (0, _builder.default)("TSModuleBlock", ...args);
    }

    function TSImportType$1(...args) {
      return (0, _builder.default)("TSImportType", ...args);
    }

    function TSImportEqualsDeclaration$1(...args) {
      return (0, _builder.default)("TSImportEqualsDeclaration", ...args);
    }

    function TSExternalModuleReference$1(...args) {
      return (0, _builder.default)("TSExternalModuleReference", ...args);
    }

    function TSNonNullExpression$1(...args) {
      return (0, _builder.default)("TSNonNullExpression", ...args);
    }

    function TSExportAssignment$1(...args) {
      return (0, _builder.default)("TSExportAssignment", ...args);
    }

    function TSNamespaceExportDeclaration$1(...args) {
      return (0, _builder.default)("TSNamespaceExportDeclaration", ...args);
    }

    function TSTypeAnnotation$1(...args) {
      return (0, _builder.default)("TSTypeAnnotation", ...args);
    }

    function TSTypeParameterInstantiation$1(...args) {
      return (0, _builder.default)("TSTypeParameterInstantiation", ...args);
    }

    function TSTypeParameterDeclaration(...args) {
      return (0, _builder.default)("TSTypeParameterDeclaration", ...args);
    }

    function TSTypeParameter$1(...args) {
      return (0, _builder.default)("TSTypeParameter", ...args);
    }

    function NumberLiteral(...args) {
      console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
      return NumberLiteral("NumberLiteral", ...args);
    }

    function RegexLiteral(...args) {
      console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
      return RegexLiteral("RegexLiteral", ...args);
    }

    function RestProperty(...args) {
      console.trace("The node type RestProperty has been renamed to RestElement");
      return RestProperty("RestProperty", ...args);
    }

    function SpreadProperty(...args) {
      console.trace("The node type SpreadProperty has been renamed to SpreadElement");
      return SpreadProperty("SpreadProperty", ...args);
    }

    Object.defineProperty(cleanJSXElementLiteralChild$1, "__esModule", {
      value: true
    });
    cleanJSXElementLiteralChild$1.default = cleanJSXElementLiteralChild;

    var _generated$m = generated$2;

    function cleanJSXElementLiteralChild(child, args) {
      const lines = child.value.split(/\r\n|\n|\r/);
      let lastNonEmptyLine = 0;

      for (let i = 0; i < lines.length; i++) {
        if (lines[i].match(/[^ \t]/)) {
          lastNonEmptyLine = i;
        }
      }

      let str = "";

      for (let i = 0; i < lines.length; i++) {
        const line = lines[i];
        const isFirstLine = i === 0;
        const isLastLine = i === lines.length - 1;
        const isLastNonEmptyLine = i === lastNonEmptyLine;
        let trimmedLine = line.replace(/\t/g, " ");

        if (!isFirstLine) {
          trimmedLine = trimmedLine.replace(/^[ ]+/, "");
        }

        if (!isLastLine) {
          trimmedLine = trimmedLine.replace(/[ ]+$/, "");
        }

        if (trimmedLine) {
          if (!isLastNonEmptyLine) {
            trimmedLine += " ";
          }

          str += trimmedLine;
        }
      }

      if (str) args.push((0, _generated$m.stringLiteral)(str));
    }

    Object.defineProperty(buildChildren$1, "__esModule", {
      value: true
    });
    buildChildren$1.default = buildChildren;

    var _generated$l = generated$3;

    var _cleanJSXElementLiteralChild = _interopRequireDefault$t(cleanJSXElementLiteralChild$1);

    function _interopRequireDefault$t(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function buildChildren(node) {
      const elements = [];

      for (let i = 0; i < node.children.length; i++) {
        let child = node.children[i];

        if ((0, _generated$l.isJSXText)(child)) {
          (0, _cleanJSXElementLiteralChild.default)(child, elements);
          continue;
        }

        if ((0, _generated$l.isJSXExpressionContainer)(child)) child = child.expression;
        if ((0, _generated$l.isJSXEmptyExpression)(child)) continue;
        elements.push(child);
      }

      return elements;
    }

    var assertNode$1 = {};

    var isNode$2 = {};

    Object.defineProperty(isNode$2, "__esModule", {
      value: true
    });
    isNode$2.default = isNode$1;

    var _definitions$5 = requireDefinitions();

    function isNode$1(node) {
      return !!(node && _definitions$5.VISITOR_KEYS[node.type]);
    }

    Object.defineProperty(assertNode$1, "__esModule", {
      value: true
    });
    assertNode$1.default = assertNode;

    var _isNode = _interopRequireDefault$s(isNode$2);

    function _interopRequireDefault$s(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function assertNode(node) {
      if (!(0, _isNode.default)(node)) {
        var _node$type;

        const type = (_node$type = node == null ? void 0 : node.type) != null ? _node$type : JSON.stringify(node);
        throw new TypeError(`Not a valid node of type "${type}"`);
      }
    }

    var generated$1 = {};

    Object.defineProperty(generated$1, "__esModule", {
      value: true
    });
    generated$1.assertArrayExpression = assertArrayExpression;
    generated$1.assertAssignmentExpression = assertAssignmentExpression;
    generated$1.assertBinaryExpression = assertBinaryExpression;
    generated$1.assertInterpreterDirective = assertInterpreterDirective;
    generated$1.assertDirective = assertDirective;
    generated$1.assertDirectiveLiteral = assertDirectiveLiteral;
    generated$1.assertBlockStatement = assertBlockStatement;
    generated$1.assertBreakStatement = assertBreakStatement;
    generated$1.assertCallExpression = assertCallExpression;
    generated$1.assertCatchClause = assertCatchClause;
    generated$1.assertConditionalExpression = assertConditionalExpression;
    generated$1.assertContinueStatement = assertContinueStatement;
    generated$1.assertDebuggerStatement = assertDebuggerStatement;
    generated$1.assertDoWhileStatement = assertDoWhileStatement;
    generated$1.assertEmptyStatement = assertEmptyStatement;
    generated$1.assertExpressionStatement = assertExpressionStatement;
    generated$1.assertFile = assertFile;
    generated$1.assertForInStatement = assertForInStatement;
    generated$1.assertForStatement = assertForStatement;
    generated$1.assertFunctionDeclaration = assertFunctionDeclaration;
    generated$1.assertFunctionExpression = assertFunctionExpression;
    generated$1.assertIdentifier = assertIdentifier;
    generated$1.assertIfStatement = assertIfStatement;
    generated$1.assertLabeledStatement = assertLabeledStatement;
    generated$1.assertStringLiteral = assertStringLiteral;
    generated$1.assertNumericLiteral = assertNumericLiteral;
    generated$1.assertNullLiteral = assertNullLiteral;
    generated$1.assertBooleanLiteral = assertBooleanLiteral;
    generated$1.assertRegExpLiteral = assertRegExpLiteral;
    generated$1.assertLogicalExpression = assertLogicalExpression;
    generated$1.assertMemberExpression = assertMemberExpression;
    generated$1.assertNewExpression = assertNewExpression;
    generated$1.assertProgram = assertProgram;
    generated$1.assertObjectExpression = assertObjectExpression;
    generated$1.assertObjectMethod = assertObjectMethod;
    generated$1.assertObjectProperty = assertObjectProperty;
    generated$1.assertRestElement = assertRestElement;
    generated$1.assertReturnStatement = assertReturnStatement;
    generated$1.assertSequenceExpression = assertSequenceExpression;
    generated$1.assertParenthesizedExpression = assertParenthesizedExpression;
    generated$1.assertSwitchCase = assertSwitchCase;
    generated$1.assertSwitchStatement = assertSwitchStatement;
    generated$1.assertThisExpression = assertThisExpression;
    generated$1.assertThrowStatement = assertThrowStatement;
    generated$1.assertTryStatement = assertTryStatement;
    generated$1.assertUnaryExpression = assertUnaryExpression;
    generated$1.assertUpdateExpression = assertUpdateExpression;
    generated$1.assertVariableDeclaration = assertVariableDeclaration;
    generated$1.assertVariableDeclarator = assertVariableDeclarator;
    generated$1.assertWhileStatement = assertWhileStatement;
    generated$1.assertWithStatement = assertWithStatement;
    generated$1.assertAssignmentPattern = assertAssignmentPattern;
    generated$1.assertArrayPattern = assertArrayPattern;
    generated$1.assertArrowFunctionExpression = assertArrowFunctionExpression;
    generated$1.assertClassBody = assertClassBody;
    generated$1.assertClassExpression = assertClassExpression;
    generated$1.assertClassDeclaration = assertClassDeclaration;
    generated$1.assertExportAllDeclaration = assertExportAllDeclaration;
    generated$1.assertExportDefaultDeclaration = assertExportDefaultDeclaration;
    generated$1.assertExportNamedDeclaration = assertExportNamedDeclaration;
    generated$1.assertExportSpecifier = assertExportSpecifier;
    generated$1.assertForOfStatement = assertForOfStatement;
    generated$1.assertImportDeclaration = assertImportDeclaration;
    generated$1.assertImportDefaultSpecifier = assertImportDefaultSpecifier;
    generated$1.assertImportNamespaceSpecifier = assertImportNamespaceSpecifier;
    generated$1.assertImportSpecifier = assertImportSpecifier;
    generated$1.assertMetaProperty = assertMetaProperty;
    generated$1.assertClassMethod = assertClassMethod;
    generated$1.assertObjectPattern = assertObjectPattern;
    generated$1.assertSpreadElement = assertSpreadElement;
    generated$1.assertSuper = assertSuper;
    generated$1.assertTaggedTemplateExpression = assertTaggedTemplateExpression;
    generated$1.assertTemplateElement = assertTemplateElement;
    generated$1.assertTemplateLiteral = assertTemplateLiteral;
    generated$1.assertYieldExpression = assertYieldExpression;
    generated$1.assertAnyTypeAnnotation = assertAnyTypeAnnotation;
    generated$1.assertArrayTypeAnnotation = assertArrayTypeAnnotation;
    generated$1.assertBooleanTypeAnnotation = assertBooleanTypeAnnotation;
    generated$1.assertBooleanLiteralTypeAnnotation = assertBooleanLiteralTypeAnnotation;
    generated$1.assertNullLiteralTypeAnnotation = assertNullLiteralTypeAnnotation;
    generated$1.assertClassImplements = assertClassImplements;
    generated$1.assertDeclareClass = assertDeclareClass;
    generated$1.assertDeclareFunction = assertDeclareFunction;
    generated$1.assertDeclareInterface = assertDeclareInterface;
    generated$1.assertDeclareModule = assertDeclareModule;
    generated$1.assertDeclareModuleExports = assertDeclareModuleExports;
    generated$1.assertDeclareTypeAlias = assertDeclareTypeAlias;
    generated$1.assertDeclareOpaqueType = assertDeclareOpaqueType;
    generated$1.assertDeclareVariable = assertDeclareVariable;
    generated$1.assertDeclareExportDeclaration = assertDeclareExportDeclaration;
    generated$1.assertDeclareExportAllDeclaration = assertDeclareExportAllDeclaration;
    generated$1.assertDeclaredPredicate = assertDeclaredPredicate;
    generated$1.assertExistsTypeAnnotation = assertExistsTypeAnnotation;
    generated$1.assertFunctionTypeAnnotation = assertFunctionTypeAnnotation;
    generated$1.assertFunctionTypeParam = assertFunctionTypeParam;
    generated$1.assertGenericTypeAnnotation = assertGenericTypeAnnotation;
    generated$1.assertInferredPredicate = assertInferredPredicate;
    generated$1.assertInterfaceExtends = assertInterfaceExtends;
    generated$1.assertInterfaceDeclaration = assertInterfaceDeclaration;
    generated$1.assertInterfaceTypeAnnotation = assertInterfaceTypeAnnotation;
    generated$1.assertIntersectionTypeAnnotation = assertIntersectionTypeAnnotation;
    generated$1.assertMixedTypeAnnotation = assertMixedTypeAnnotation;
    generated$1.assertEmptyTypeAnnotation = assertEmptyTypeAnnotation;
    generated$1.assertNullableTypeAnnotation = assertNullableTypeAnnotation;
    generated$1.assertNumberLiteralTypeAnnotation = assertNumberLiteralTypeAnnotation;
    generated$1.assertNumberTypeAnnotation = assertNumberTypeAnnotation;
    generated$1.assertObjectTypeAnnotation = assertObjectTypeAnnotation;
    generated$1.assertObjectTypeInternalSlot = assertObjectTypeInternalSlot;
    generated$1.assertObjectTypeCallProperty = assertObjectTypeCallProperty;
    generated$1.assertObjectTypeIndexer = assertObjectTypeIndexer;
    generated$1.assertObjectTypeProperty = assertObjectTypeProperty;
    generated$1.assertObjectTypeSpreadProperty = assertObjectTypeSpreadProperty;
    generated$1.assertOpaqueType = assertOpaqueType;
    generated$1.assertQualifiedTypeIdentifier = assertQualifiedTypeIdentifier;
    generated$1.assertStringLiteralTypeAnnotation = assertStringLiteralTypeAnnotation;
    generated$1.assertStringTypeAnnotation = assertStringTypeAnnotation;
    generated$1.assertSymbolTypeAnnotation = assertSymbolTypeAnnotation;
    generated$1.assertThisTypeAnnotation = assertThisTypeAnnotation;
    generated$1.assertTupleTypeAnnotation = assertTupleTypeAnnotation;
    generated$1.assertTypeofTypeAnnotation = assertTypeofTypeAnnotation;
    generated$1.assertTypeAlias = assertTypeAlias;
    generated$1.assertTypeAnnotation = assertTypeAnnotation;
    generated$1.assertTypeCastExpression = assertTypeCastExpression;
    generated$1.assertTypeParameter = assertTypeParameter;
    generated$1.assertTypeParameterDeclaration = assertTypeParameterDeclaration;
    generated$1.assertTypeParameterInstantiation = assertTypeParameterInstantiation;
    generated$1.assertUnionTypeAnnotation = assertUnionTypeAnnotation;
    generated$1.assertVariance = assertVariance;
    generated$1.assertVoidTypeAnnotation = assertVoidTypeAnnotation;
    generated$1.assertEnumDeclaration = assertEnumDeclaration;
    generated$1.assertEnumBooleanBody = assertEnumBooleanBody;
    generated$1.assertEnumNumberBody = assertEnumNumberBody;
    generated$1.assertEnumStringBody = assertEnumStringBody;
    generated$1.assertEnumSymbolBody = assertEnumSymbolBody;
    generated$1.assertEnumBooleanMember = assertEnumBooleanMember;
    generated$1.assertEnumNumberMember = assertEnumNumberMember;
    generated$1.assertEnumStringMember = assertEnumStringMember;
    generated$1.assertEnumDefaultedMember = assertEnumDefaultedMember;
    generated$1.assertJSXAttribute = assertJSXAttribute;
    generated$1.assertJSXClosingElement = assertJSXClosingElement;
    generated$1.assertJSXElement = assertJSXElement;
    generated$1.assertJSXEmptyExpression = assertJSXEmptyExpression;
    generated$1.assertJSXExpressionContainer = assertJSXExpressionContainer;
    generated$1.assertJSXSpreadChild = assertJSXSpreadChild;
    generated$1.assertJSXIdentifier = assertJSXIdentifier;
    generated$1.assertJSXMemberExpression = assertJSXMemberExpression;
    generated$1.assertJSXNamespacedName = assertJSXNamespacedName;
    generated$1.assertJSXOpeningElement = assertJSXOpeningElement;
    generated$1.assertJSXSpreadAttribute = assertJSXSpreadAttribute;
    generated$1.assertJSXText = assertJSXText;
    generated$1.assertJSXFragment = assertJSXFragment;
    generated$1.assertJSXOpeningFragment = assertJSXOpeningFragment;
    generated$1.assertJSXClosingFragment = assertJSXClosingFragment;
    generated$1.assertNoop = assertNoop;
    generated$1.assertPlaceholder = assertPlaceholder;
    generated$1.assertV8IntrinsicIdentifier = assertV8IntrinsicIdentifier;
    generated$1.assertArgumentPlaceholder = assertArgumentPlaceholder;
    generated$1.assertAwaitExpression = assertAwaitExpression;
    generated$1.assertBindExpression = assertBindExpression;
    generated$1.assertClassProperty = assertClassProperty;
    generated$1.assertOptionalMemberExpression = assertOptionalMemberExpression;
    generated$1.assertPipelineTopicExpression = assertPipelineTopicExpression;
    generated$1.assertPipelineBareFunction = assertPipelineBareFunction;
    generated$1.assertPipelinePrimaryTopicReference = assertPipelinePrimaryTopicReference;
    generated$1.assertOptionalCallExpression = assertOptionalCallExpression;
    generated$1.assertClassPrivateProperty = assertClassPrivateProperty;
    generated$1.assertClassPrivateMethod = assertClassPrivateMethod;
    generated$1.assertImport = assertImport;
    generated$1.assertImportAttribute = assertImportAttribute;
    generated$1.assertDecorator = assertDecorator;
    generated$1.assertDoExpression = assertDoExpression;
    generated$1.assertExportDefaultSpecifier = assertExportDefaultSpecifier;
    generated$1.assertExportNamespaceSpecifier = assertExportNamespaceSpecifier;
    generated$1.assertPrivateName = assertPrivateName;
    generated$1.assertBigIntLiteral = assertBigIntLiteral;
    generated$1.assertRecordExpression = assertRecordExpression;
    generated$1.assertTupleExpression = assertTupleExpression;
    generated$1.assertTSParameterProperty = assertTSParameterProperty;
    generated$1.assertTSDeclareFunction = assertTSDeclareFunction;
    generated$1.assertTSDeclareMethod = assertTSDeclareMethod;
    generated$1.assertTSQualifiedName = assertTSQualifiedName;
    generated$1.assertTSCallSignatureDeclaration = assertTSCallSignatureDeclaration;
    generated$1.assertTSConstructSignatureDeclaration = assertTSConstructSignatureDeclaration;
    generated$1.assertTSPropertySignature = assertTSPropertySignature;
    generated$1.assertTSMethodSignature = assertTSMethodSignature;
    generated$1.assertTSIndexSignature = assertTSIndexSignature;
    generated$1.assertTSAnyKeyword = assertTSAnyKeyword;
    generated$1.assertTSBooleanKeyword = assertTSBooleanKeyword;
    generated$1.assertTSBigIntKeyword = assertTSBigIntKeyword;
    generated$1.assertTSNeverKeyword = assertTSNeverKeyword;
    generated$1.assertTSNullKeyword = assertTSNullKeyword;
    generated$1.assertTSNumberKeyword = assertTSNumberKeyword;
    generated$1.assertTSObjectKeyword = assertTSObjectKeyword;
    generated$1.assertTSStringKeyword = assertTSStringKeyword;
    generated$1.assertTSSymbolKeyword = assertTSSymbolKeyword;
    generated$1.assertTSUndefinedKeyword = assertTSUndefinedKeyword;
    generated$1.assertTSUnknownKeyword = assertTSUnknownKeyword;
    generated$1.assertTSVoidKeyword = assertTSVoidKeyword;
    generated$1.assertTSThisType = assertTSThisType;
    generated$1.assertTSFunctionType = assertTSFunctionType;
    generated$1.assertTSConstructorType = assertTSConstructorType;
    generated$1.assertTSTypeReference = assertTSTypeReference;
    generated$1.assertTSTypePredicate = assertTSTypePredicate;
    generated$1.assertTSTypeQuery = assertTSTypeQuery;
    generated$1.assertTSTypeLiteral = assertTSTypeLiteral;
    generated$1.assertTSArrayType = assertTSArrayType;
    generated$1.assertTSTupleType = assertTSTupleType;
    generated$1.assertTSOptionalType = assertTSOptionalType;
    generated$1.assertTSRestType = assertTSRestType;
    generated$1.assertTSUnionType = assertTSUnionType;
    generated$1.assertTSIntersectionType = assertTSIntersectionType;
    generated$1.assertTSConditionalType = assertTSConditionalType;
    generated$1.assertTSInferType = assertTSInferType;
    generated$1.assertTSParenthesizedType = assertTSParenthesizedType;
    generated$1.assertTSTypeOperator = assertTSTypeOperator;
    generated$1.assertTSIndexedAccessType = assertTSIndexedAccessType;
    generated$1.assertTSMappedType = assertTSMappedType;
    generated$1.assertTSLiteralType = assertTSLiteralType;
    generated$1.assertTSExpressionWithTypeArguments = assertTSExpressionWithTypeArguments;
    generated$1.assertTSInterfaceDeclaration = assertTSInterfaceDeclaration;
    generated$1.assertTSInterfaceBody = assertTSInterfaceBody;
    generated$1.assertTSTypeAliasDeclaration = assertTSTypeAliasDeclaration;
    generated$1.assertTSAsExpression = assertTSAsExpression;
    generated$1.assertTSTypeAssertion = assertTSTypeAssertion;
    generated$1.assertTSEnumDeclaration = assertTSEnumDeclaration;
    generated$1.assertTSEnumMember = assertTSEnumMember;
    generated$1.assertTSModuleDeclaration = assertTSModuleDeclaration;
    generated$1.assertTSModuleBlock = assertTSModuleBlock;
    generated$1.assertTSImportType = assertTSImportType;
    generated$1.assertTSImportEqualsDeclaration = assertTSImportEqualsDeclaration;
    generated$1.assertTSExternalModuleReference = assertTSExternalModuleReference;
    generated$1.assertTSNonNullExpression = assertTSNonNullExpression;
    generated$1.assertTSExportAssignment = assertTSExportAssignment;
    generated$1.assertTSNamespaceExportDeclaration = assertTSNamespaceExportDeclaration;
    generated$1.assertTSTypeAnnotation = assertTSTypeAnnotation;
    generated$1.assertTSTypeParameterInstantiation = assertTSTypeParameterInstantiation;
    generated$1.assertTSTypeParameterDeclaration = assertTSTypeParameterDeclaration;
    generated$1.assertTSTypeParameter = assertTSTypeParameter;
    generated$1.assertExpression = assertExpression;
    generated$1.assertBinary = assertBinary;
    generated$1.assertScopable = assertScopable;
    generated$1.assertBlockParent = assertBlockParent;
    generated$1.assertBlock = assertBlock;
    generated$1.assertStatement = assertStatement;
    generated$1.assertTerminatorless = assertTerminatorless;
    generated$1.assertCompletionStatement = assertCompletionStatement;
    generated$1.assertConditional = assertConditional;
    generated$1.assertLoop = assertLoop;
    generated$1.assertWhile = assertWhile;
    generated$1.assertExpressionWrapper = assertExpressionWrapper;
    generated$1.assertFor = assertFor;
    generated$1.assertForXStatement = assertForXStatement;
    generated$1.assertFunction = assertFunction;
    generated$1.assertFunctionParent = assertFunctionParent;
    generated$1.assertPureish = assertPureish;
    generated$1.assertDeclaration = assertDeclaration;
    generated$1.assertPatternLike = assertPatternLike;
    generated$1.assertLVal = assertLVal;
    generated$1.assertTSEntityName = assertTSEntityName;
    generated$1.assertLiteral = assertLiteral;
    generated$1.assertImmutable = assertImmutable;
    generated$1.assertUserWhitespacable = assertUserWhitespacable;
    generated$1.assertMethod = assertMethod;
    generated$1.assertObjectMember = assertObjectMember;
    generated$1.assertProperty = assertProperty;
    generated$1.assertUnaryLike = assertUnaryLike;
    generated$1.assertPattern = assertPattern;
    generated$1.assertClass = assertClass;
    generated$1.assertModuleDeclaration = assertModuleDeclaration;
    generated$1.assertExportDeclaration = assertExportDeclaration;
    generated$1.assertModuleSpecifier = assertModuleSpecifier;
    generated$1.assertFlow = assertFlow;
    generated$1.assertFlowType = assertFlowType;
    generated$1.assertFlowBaseAnnotation = assertFlowBaseAnnotation;
    generated$1.assertFlowDeclaration = assertFlowDeclaration;
    generated$1.assertFlowPredicate = assertFlowPredicate;
    generated$1.assertEnumBody = assertEnumBody;
    generated$1.assertEnumMember = assertEnumMember;
    generated$1.assertJSX = assertJSX;
    generated$1.assertPrivate = assertPrivate;
    generated$1.assertTSTypeElement = assertTSTypeElement;
    generated$1.assertTSType = assertTSType;
    generated$1.assertTSBaseType = assertTSBaseType;
    generated$1.assertNumberLiteral = assertNumberLiteral;
    generated$1.assertRegexLiteral = assertRegexLiteral;
    generated$1.assertRestProperty = assertRestProperty;
    generated$1.assertSpreadProperty = assertSpreadProperty;

    var _is = _interopRequireDefault$r(requireIs());

    function _interopRequireDefault$r(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function assert$2(type, node, opts) {
      if (!(0, _is.default)(type, node, opts)) {
        throw new Error(`Expected type "${type}" with option ${JSON.stringify(opts)}, ` + `but instead got "${node.type}".`);
      }
    }

    function assertArrayExpression(node, opts = {}) {
      assert$2("ArrayExpression", node, opts);
    }

    function assertAssignmentExpression(node, opts = {}) {
      assert$2("AssignmentExpression", node, opts);
    }

    function assertBinaryExpression(node, opts = {}) {
      assert$2("BinaryExpression", node, opts);
    }

    function assertInterpreterDirective(node, opts = {}) {
      assert$2("InterpreterDirective", node, opts);
    }

    function assertDirective(node, opts = {}) {
      assert$2("Directive", node, opts);
    }

    function assertDirectiveLiteral(node, opts = {}) {
      assert$2("DirectiveLiteral", node, opts);
    }

    function assertBlockStatement(node, opts = {}) {
      assert$2("BlockStatement", node, opts);
    }

    function assertBreakStatement(node, opts = {}) {
      assert$2("BreakStatement", node, opts);
    }

    function assertCallExpression(node, opts = {}) {
      assert$2("CallExpression", node, opts);
    }

    function assertCatchClause(node, opts = {}) {
      assert$2("CatchClause", node, opts);
    }

    function assertConditionalExpression(node, opts = {}) {
      assert$2("ConditionalExpression", node, opts);
    }

    function assertContinueStatement(node, opts = {}) {
      assert$2("ContinueStatement", node, opts);
    }

    function assertDebuggerStatement(node, opts = {}) {
      assert$2("DebuggerStatement", node, opts);
    }

    function assertDoWhileStatement(node, opts = {}) {
      assert$2("DoWhileStatement", node, opts);
    }

    function assertEmptyStatement(node, opts = {}) {
      assert$2("EmptyStatement", node, opts);
    }

    function assertExpressionStatement(node, opts = {}) {
      assert$2("ExpressionStatement", node, opts);
    }

    function assertFile(node, opts = {}) {
      assert$2("File", node, opts);
    }

    function assertForInStatement(node, opts = {}) {
      assert$2("ForInStatement", node, opts);
    }

    function assertForStatement(node, opts = {}) {
      assert$2("ForStatement", node, opts);
    }

    function assertFunctionDeclaration(node, opts = {}) {
      assert$2("FunctionDeclaration", node, opts);
    }

    function assertFunctionExpression(node, opts = {}) {
      assert$2("FunctionExpression", node, opts);
    }

    function assertIdentifier(node, opts = {}) {
      assert$2("Identifier", node, opts);
    }

    function assertIfStatement(node, opts = {}) {
      assert$2("IfStatement", node, opts);
    }

    function assertLabeledStatement(node, opts = {}) {
      assert$2("LabeledStatement", node, opts);
    }

    function assertStringLiteral(node, opts = {}) {
      assert$2("StringLiteral", node, opts);
    }

    function assertNumericLiteral(node, opts = {}) {
      assert$2("NumericLiteral", node, opts);
    }

    function assertNullLiteral(node, opts = {}) {
      assert$2("NullLiteral", node, opts);
    }

    function assertBooleanLiteral(node, opts = {}) {
      assert$2("BooleanLiteral", node, opts);
    }

    function assertRegExpLiteral(node, opts = {}) {
      assert$2("RegExpLiteral", node, opts);
    }

    function assertLogicalExpression(node, opts = {}) {
      assert$2("LogicalExpression", node, opts);
    }

    function assertMemberExpression(node, opts = {}) {
      assert$2("MemberExpression", node, opts);
    }

    function assertNewExpression(node, opts = {}) {
      assert$2("NewExpression", node, opts);
    }

    function assertProgram(node, opts = {}) {
      assert$2("Program", node, opts);
    }

    function assertObjectExpression(node, opts = {}) {
      assert$2("ObjectExpression", node, opts);
    }

    function assertObjectMethod(node, opts = {}) {
      assert$2("ObjectMethod", node, opts);
    }

    function assertObjectProperty(node, opts = {}) {
      assert$2("ObjectProperty", node, opts);
    }

    function assertRestElement(node, opts = {}) {
      assert$2("RestElement", node, opts);
    }

    function assertReturnStatement(node, opts = {}) {
      assert$2("ReturnStatement", node, opts);
    }

    function assertSequenceExpression(node, opts = {}) {
      assert$2("SequenceExpression", node, opts);
    }

    function assertParenthesizedExpression(node, opts = {}) {
      assert$2("ParenthesizedExpression", node, opts);
    }

    function assertSwitchCase(node, opts = {}) {
      assert$2("SwitchCase", node, opts);
    }

    function assertSwitchStatement(node, opts = {}) {
      assert$2("SwitchStatement", node, opts);
    }

    function assertThisExpression(node, opts = {}) {
      assert$2("ThisExpression", node, opts);
    }

    function assertThrowStatement(node, opts = {}) {
      assert$2("ThrowStatement", node, opts);
    }

    function assertTryStatement(node, opts = {}) {
      assert$2("TryStatement", node, opts);
    }

    function assertUnaryExpression(node, opts = {}) {
      assert$2("UnaryExpression", node, opts);
    }

    function assertUpdateExpression(node, opts = {}) {
      assert$2("UpdateExpression", node, opts);
    }

    function assertVariableDeclaration(node, opts = {}) {
      assert$2("VariableDeclaration", node, opts);
    }

    function assertVariableDeclarator(node, opts = {}) {
      assert$2("VariableDeclarator", node, opts);
    }

    function assertWhileStatement(node, opts = {}) {
      assert$2("WhileStatement", node, opts);
    }

    function assertWithStatement(node, opts = {}) {
      assert$2("WithStatement", node, opts);
    }

    function assertAssignmentPattern(node, opts = {}) {
      assert$2("AssignmentPattern", node, opts);
    }

    function assertArrayPattern(node, opts = {}) {
      assert$2("ArrayPattern", node, opts);
    }

    function assertArrowFunctionExpression(node, opts = {}) {
      assert$2("ArrowFunctionExpression", node, opts);
    }

    function assertClassBody(node, opts = {}) {
      assert$2("ClassBody", node, opts);
    }

    function assertClassExpression(node, opts = {}) {
      assert$2("ClassExpression", node, opts);
    }

    function assertClassDeclaration(node, opts = {}) {
      assert$2("ClassDeclaration", node, opts);
    }

    function assertExportAllDeclaration(node, opts = {}) {
      assert$2("ExportAllDeclaration", node, opts);
    }

    function assertExportDefaultDeclaration(node, opts = {}) {
      assert$2("ExportDefaultDeclaration", node, opts);
    }

    function assertExportNamedDeclaration(node, opts = {}) {
      assert$2("ExportNamedDeclaration", node, opts);
    }

    function assertExportSpecifier(node, opts = {}) {
      assert$2("ExportSpecifier", node, opts);
    }

    function assertForOfStatement(node, opts = {}) {
      assert$2("ForOfStatement", node, opts);
    }

    function assertImportDeclaration(node, opts = {}) {
      assert$2("ImportDeclaration", node, opts);
    }

    function assertImportDefaultSpecifier(node, opts = {}) {
      assert$2("ImportDefaultSpecifier", node, opts);
    }

    function assertImportNamespaceSpecifier(node, opts = {}) {
      assert$2("ImportNamespaceSpecifier", node, opts);
    }

    function assertImportSpecifier(node, opts = {}) {
      assert$2("ImportSpecifier", node, opts);
    }

    function assertMetaProperty(node, opts = {}) {
      assert$2("MetaProperty", node, opts);
    }

    function assertClassMethod(node, opts = {}) {
      assert$2("ClassMethod", node, opts);
    }

    function assertObjectPattern(node, opts = {}) {
      assert$2("ObjectPattern", node, opts);
    }

    function assertSpreadElement(node, opts = {}) {
      assert$2("SpreadElement", node, opts);
    }

    function assertSuper(node, opts = {}) {
      assert$2("Super", node, opts);
    }

    function assertTaggedTemplateExpression(node, opts = {}) {
      assert$2("TaggedTemplateExpression", node, opts);
    }

    function assertTemplateElement(node, opts = {}) {
      assert$2("TemplateElement", node, opts);
    }

    function assertTemplateLiteral(node, opts = {}) {
      assert$2("TemplateLiteral", node, opts);
    }

    function assertYieldExpression(node, opts = {}) {
      assert$2("YieldExpression", node, opts);
    }

    function assertAnyTypeAnnotation(node, opts = {}) {
      assert$2("AnyTypeAnnotation", node, opts);
    }

    function assertArrayTypeAnnotation(node, opts = {}) {
      assert$2("ArrayTypeAnnotation", node, opts);
    }

    function assertBooleanTypeAnnotation(node, opts = {}) {
      assert$2("BooleanTypeAnnotation", node, opts);
    }

    function assertBooleanLiteralTypeAnnotation(node, opts = {}) {
      assert$2("BooleanLiteralTypeAnnotation", node, opts);
    }

    function assertNullLiteralTypeAnnotation(node, opts = {}) {
      assert$2("NullLiteralTypeAnnotation", node, opts);
    }

    function assertClassImplements(node, opts = {}) {
      assert$2("ClassImplements", node, opts);
    }

    function assertDeclareClass(node, opts = {}) {
      assert$2("DeclareClass", node, opts);
    }

    function assertDeclareFunction(node, opts = {}) {
      assert$2("DeclareFunction", node, opts);
    }

    function assertDeclareInterface(node, opts = {}) {
      assert$2("DeclareInterface", node, opts);
    }

    function assertDeclareModule(node, opts = {}) {
      assert$2("DeclareModule", node, opts);
    }

    function assertDeclareModuleExports(node, opts = {}) {
      assert$2("DeclareModuleExports", node, opts);
    }

    function assertDeclareTypeAlias(node, opts = {}) {
      assert$2("DeclareTypeAlias", node, opts);
    }

    function assertDeclareOpaqueType(node, opts = {}) {
      assert$2("DeclareOpaqueType", node, opts);
    }

    function assertDeclareVariable(node, opts = {}) {
      assert$2("DeclareVariable", node, opts);
    }

    function assertDeclareExportDeclaration(node, opts = {}) {
      assert$2("DeclareExportDeclaration", node, opts);
    }

    function assertDeclareExportAllDeclaration(node, opts = {}) {
      assert$2("DeclareExportAllDeclaration", node, opts);
    }

    function assertDeclaredPredicate(node, opts = {}) {
      assert$2("DeclaredPredicate", node, opts);
    }

    function assertExistsTypeAnnotation(node, opts = {}) {
      assert$2("ExistsTypeAnnotation", node, opts);
    }

    function assertFunctionTypeAnnotation(node, opts = {}) {
      assert$2("FunctionTypeAnnotation", node, opts);
    }

    function assertFunctionTypeParam(node, opts = {}) {
      assert$2("FunctionTypeParam", node, opts);
    }

    function assertGenericTypeAnnotation(node, opts = {}) {
      assert$2("GenericTypeAnnotation", node, opts);
    }

    function assertInferredPredicate(node, opts = {}) {
      assert$2("InferredPredicate", node, opts);
    }

    function assertInterfaceExtends(node, opts = {}) {
      assert$2("InterfaceExtends", node, opts);
    }

    function assertInterfaceDeclaration(node, opts = {}) {
      assert$2("InterfaceDeclaration", node, opts);
    }

    function assertInterfaceTypeAnnotation(node, opts = {}) {
      assert$2("InterfaceTypeAnnotation", node, opts);
    }

    function assertIntersectionTypeAnnotation(node, opts = {}) {
      assert$2("IntersectionTypeAnnotation", node, opts);
    }

    function assertMixedTypeAnnotation(node, opts = {}) {
      assert$2("MixedTypeAnnotation", node, opts);
    }

    function assertEmptyTypeAnnotation(node, opts = {}) {
      assert$2("EmptyTypeAnnotation", node, opts);
    }

    function assertNullableTypeAnnotation(node, opts = {}) {
      assert$2("NullableTypeAnnotation", node, opts);
    }

    function assertNumberLiteralTypeAnnotation(node, opts = {}) {
      assert$2("NumberLiteralTypeAnnotation", node, opts);
    }

    function assertNumberTypeAnnotation(node, opts = {}) {
      assert$2("NumberTypeAnnotation", node, opts);
    }

    function assertObjectTypeAnnotation(node, opts = {}) {
      assert$2("ObjectTypeAnnotation", node, opts);
    }

    function assertObjectTypeInternalSlot(node, opts = {}) {
      assert$2("ObjectTypeInternalSlot", node, opts);
    }

    function assertObjectTypeCallProperty(node, opts = {}) {
      assert$2("ObjectTypeCallProperty", node, opts);
    }

    function assertObjectTypeIndexer(node, opts = {}) {
      assert$2("ObjectTypeIndexer", node, opts);
    }

    function assertObjectTypeProperty(node, opts = {}) {
      assert$2("ObjectTypeProperty", node, opts);
    }

    function assertObjectTypeSpreadProperty(node, opts = {}) {
      assert$2("ObjectTypeSpreadProperty", node, opts);
    }

    function assertOpaqueType(node, opts = {}) {
      assert$2("OpaqueType", node, opts);
    }

    function assertQualifiedTypeIdentifier(node, opts = {}) {
      assert$2("QualifiedTypeIdentifier", node, opts);
    }

    function assertStringLiteralTypeAnnotation(node, opts = {}) {
      assert$2("StringLiteralTypeAnnotation", node, opts);
    }

    function assertStringTypeAnnotation(node, opts = {}) {
      assert$2("StringTypeAnnotation", node, opts);
    }

    function assertSymbolTypeAnnotation(node, opts = {}) {
      assert$2("SymbolTypeAnnotation", node, opts);
    }

    function assertThisTypeAnnotation(node, opts = {}) {
      assert$2("ThisTypeAnnotation", node, opts);
    }

    function assertTupleTypeAnnotation(node, opts = {}) {
      assert$2("TupleTypeAnnotation", node, opts);
    }

    function assertTypeofTypeAnnotation(node, opts = {}) {
      assert$2("TypeofTypeAnnotation", node, opts);
    }

    function assertTypeAlias(node, opts = {}) {
      assert$2("TypeAlias", node, opts);
    }

    function assertTypeAnnotation(node, opts = {}) {
      assert$2("TypeAnnotation", node, opts);
    }

    function assertTypeCastExpression(node, opts = {}) {
      assert$2("TypeCastExpression", node, opts);
    }

    function assertTypeParameter(node, opts = {}) {
      assert$2("TypeParameter", node, opts);
    }

    function assertTypeParameterDeclaration(node, opts = {}) {
      assert$2("TypeParameterDeclaration", node, opts);
    }

    function assertTypeParameterInstantiation(node, opts = {}) {
      assert$2("TypeParameterInstantiation", node, opts);
    }

    function assertUnionTypeAnnotation(node, opts = {}) {
      assert$2("UnionTypeAnnotation", node, opts);
    }

    function assertVariance(node, opts = {}) {
      assert$2("Variance", node, opts);
    }

    function assertVoidTypeAnnotation(node, opts = {}) {
      assert$2("VoidTypeAnnotation", node, opts);
    }

    function assertEnumDeclaration(node, opts = {}) {
      assert$2("EnumDeclaration", node, opts);
    }

    function assertEnumBooleanBody(node, opts = {}) {
      assert$2("EnumBooleanBody", node, opts);
    }

    function assertEnumNumberBody(node, opts = {}) {
      assert$2("EnumNumberBody", node, opts);
    }

    function assertEnumStringBody(node, opts = {}) {
      assert$2("EnumStringBody", node, opts);
    }

    function assertEnumSymbolBody(node, opts = {}) {
      assert$2("EnumSymbolBody", node, opts);
    }

    function assertEnumBooleanMember(node, opts = {}) {
      assert$2("EnumBooleanMember", node, opts);
    }

    function assertEnumNumberMember(node, opts = {}) {
      assert$2("EnumNumberMember", node, opts);
    }

    function assertEnumStringMember(node, opts = {}) {
      assert$2("EnumStringMember", node, opts);
    }

    function assertEnumDefaultedMember(node, opts = {}) {
      assert$2("EnumDefaultedMember", node, opts);
    }

    function assertJSXAttribute(node, opts = {}) {
      assert$2("JSXAttribute", node, opts);
    }

    function assertJSXClosingElement(node, opts = {}) {
      assert$2("JSXClosingElement", node, opts);
    }

    function assertJSXElement(node, opts = {}) {
      assert$2("JSXElement", node, opts);
    }

    function assertJSXEmptyExpression(node, opts = {}) {
      assert$2("JSXEmptyExpression", node, opts);
    }

    function assertJSXExpressionContainer(node, opts = {}) {
      assert$2("JSXExpressionContainer", node, opts);
    }

    function assertJSXSpreadChild(node, opts = {}) {
      assert$2("JSXSpreadChild", node, opts);
    }

    function assertJSXIdentifier(node, opts = {}) {
      assert$2("JSXIdentifier", node, opts);
    }

    function assertJSXMemberExpression(node, opts = {}) {
      assert$2("JSXMemberExpression", node, opts);
    }

    function assertJSXNamespacedName(node, opts = {}) {
      assert$2("JSXNamespacedName", node, opts);
    }

    function assertJSXOpeningElement(node, opts = {}) {
      assert$2("JSXOpeningElement", node, opts);
    }

    function assertJSXSpreadAttribute(node, opts = {}) {
      assert$2("JSXSpreadAttribute", node, opts);
    }

    function assertJSXText(node, opts = {}) {
      assert$2("JSXText", node, opts);
    }

    function assertJSXFragment(node, opts = {}) {
      assert$2("JSXFragment", node, opts);
    }

    function assertJSXOpeningFragment(node, opts = {}) {
      assert$2("JSXOpeningFragment", node, opts);
    }

    function assertJSXClosingFragment(node, opts = {}) {
      assert$2("JSXClosingFragment", node, opts);
    }

    function assertNoop(node, opts = {}) {
      assert$2("Noop", node, opts);
    }

    function assertPlaceholder(node, opts = {}) {
      assert$2("Placeholder", node, opts);
    }

    function assertV8IntrinsicIdentifier(node, opts = {}) {
      assert$2("V8IntrinsicIdentifier", node, opts);
    }

    function assertArgumentPlaceholder(node, opts = {}) {
      assert$2("ArgumentPlaceholder", node, opts);
    }

    function assertAwaitExpression(node, opts = {}) {
      assert$2("AwaitExpression", node, opts);
    }

    function assertBindExpression(node, opts = {}) {
      assert$2("BindExpression", node, opts);
    }

    function assertClassProperty(node, opts = {}) {
      assert$2("ClassProperty", node, opts);
    }

    function assertOptionalMemberExpression(node, opts = {}) {
      assert$2("OptionalMemberExpression", node, opts);
    }

    function assertPipelineTopicExpression(node, opts = {}) {
      assert$2("PipelineTopicExpression", node, opts);
    }

    function assertPipelineBareFunction(node, opts = {}) {
      assert$2("PipelineBareFunction", node, opts);
    }

    function assertPipelinePrimaryTopicReference(node, opts = {}) {
      assert$2("PipelinePrimaryTopicReference", node, opts);
    }

    function assertOptionalCallExpression(node, opts = {}) {
      assert$2("OptionalCallExpression", node, opts);
    }

    function assertClassPrivateProperty(node, opts = {}) {
      assert$2("ClassPrivateProperty", node, opts);
    }

    function assertClassPrivateMethod(node, opts = {}) {
      assert$2("ClassPrivateMethod", node, opts);
    }

    function assertImport(node, opts = {}) {
      assert$2("Import", node, opts);
    }

    function assertImportAttribute(node, opts = {}) {
      assert$2("ImportAttribute", node, opts);
    }

    function assertDecorator(node, opts = {}) {
      assert$2("Decorator", node, opts);
    }

    function assertDoExpression(node, opts = {}) {
      assert$2("DoExpression", node, opts);
    }

    function assertExportDefaultSpecifier(node, opts = {}) {
      assert$2("ExportDefaultSpecifier", node, opts);
    }

    function assertExportNamespaceSpecifier(node, opts = {}) {
      assert$2("ExportNamespaceSpecifier", node, opts);
    }

    function assertPrivateName(node, opts = {}) {
      assert$2("PrivateName", node, opts);
    }

    function assertBigIntLiteral(node, opts = {}) {
      assert$2("BigIntLiteral", node, opts);
    }

    function assertRecordExpression(node, opts = {}) {
      assert$2("RecordExpression", node, opts);
    }

    function assertTupleExpression(node, opts = {}) {
      assert$2("TupleExpression", node, opts);
    }

    function assertTSParameterProperty(node, opts = {}) {
      assert$2("TSParameterProperty", node, opts);
    }

    function assertTSDeclareFunction(node, opts = {}) {
      assert$2("TSDeclareFunction", node, opts);
    }

    function assertTSDeclareMethod(node, opts = {}) {
      assert$2("TSDeclareMethod", node, opts);
    }

    function assertTSQualifiedName(node, opts = {}) {
      assert$2("TSQualifiedName", node, opts);
    }

    function assertTSCallSignatureDeclaration(node, opts = {}) {
      assert$2("TSCallSignatureDeclaration", node, opts);
    }

    function assertTSConstructSignatureDeclaration(node, opts = {}) {
      assert$2("TSConstructSignatureDeclaration", node, opts);
    }

    function assertTSPropertySignature(node, opts = {}) {
      assert$2("TSPropertySignature", node, opts);
    }

    function assertTSMethodSignature(node, opts = {}) {
      assert$2("TSMethodSignature", node, opts);
    }

    function assertTSIndexSignature(node, opts = {}) {
      assert$2("TSIndexSignature", node, opts);
    }

    function assertTSAnyKeyword(node, opts = {}) {
      assert$2("TSAnyKeyword", node, opts);
    }

    function assertTSBooleanKeyword(node, opts = {}) {
      assert$2("TSBooleanKeyword", node, opts);
    }

    function assertTSBigIntKeyword(node, opts = {}) {
      assert$2("TSBigIntKeyword", node, opts);
    }

    function assertTSNeverKeyword(node, opts = {}) {
      assert$2("TSNeverKeyword", node, opts);
    }

    function assertTSNullKeyword(node, opts = {}) {
      assert$2("TSNullKeyword", node, opts);
    }

    function assertTSNumberKeyword(node, opts = {}) {
      assert$2("TSNumberKeyword", node, opts);
    }

    function assertTSObjectKeyword(node, opts = {}) {
      assert$2("TSObjectKeyword", node, opts);
    }

    function assertTSStringKeyword(node, opts = {}) {
      assert$2("TSStringKeyword", node, opts);
    }

    function assertTSSymbolKeyword(node, opts = {}) {
      assert$2("TSSymbolKeyword", node, opts);
    }

    function assertTSUndefinedKeyword(node, opts = {}) {
      assert$2("TSUndefinedKeyword", node, opts);
    }

    function assertTSUnknownKeyword(node, opts = {}) {
      assert$2("TSUnknownKeyword", node, opts);
    }

    function assertTSVoidKeyword(node, opts = {}) {
      assert$2("TSVoidKeyword", node, opts);
    }

    function assertTSThisType(node, opts = {}) {
      assert$2("TSThisType", node, opts);
    }

    function assertTSFunctionType(node, opts = {}) {
      assert$2("TSFunctionType", node, opts);
    }

    function assertTSConstructorType(node, opts = {}) {
      assert$2("TSConstructorType", node, opts);
    }

    function assertTSTypeReference(node, opts = {}) {
      assert$2("TSTypeReference", node, opts);
    }

    function assertTSTypePredicate(node, opts = {}) {
      assert$2("TSTypePredicate", node, opts);
    }

    function assertTSTypeQuery(node, opts = {}) {
      assert$2("TSTypeQuery", node, opts);
    }

    function assertTSTypeLiteral(node, opts = {}) {
      assert$2("TSTypeLiteral", node, opts);
    }

    function assertTSArrayType(node, opts = {}) {
      assert$2("TSArrayType", node, opts);
    }

    function assertTSTupleType(node, opts = {}) {
      assert$2("TSTupleType", node, opts);
    }

    function assertTSOptionalType(node, opts = {}) {
      assert$2("TSOptionalType", node, opts);
    }

    function assertTSRestType(node, opts = {}) {
      assert$2("TSRestType", node, opts);
    }

    function assertTSUnionType(node, opts = {}) {
      assert$2("TSUnionType", node, opts);
    }

    function assertTSIntersectionType(node, opts = {}) {
      assert$2("TSIntersectionType", node, opts);
    }

    function assertTSConditionalType(node, opts = {}) {
      assert$2("TSConditionalType", node, opts);
    }

    function assertTSInferType(node, opts = {}) {
      assert$2("TSInferType", node, opts);
    }

    function assertTSParenthesizedType(node, opts = {}) {
      assert$2("TSParenthesizedType", node, opts);
    }

    function assertTSTypeOperator(node, opts = {}) {
      assert$2("TSTypeOperator", node, opts);
    }

    function assertTSIndexedAccessType(node, opts = {}) {
      assert$2("TSIndexedAccessType", node, opts);
    }

    function assertTSMappedType(node, opts = {}) {
      assert$2("TSMappedType", node, opts);
    }

    function assertTSLiteralType(node, opts = {}) {
      assert$2("TSLiteralType", node, opts);
    }

    function assertTSExpressionWithTypeArguments(node, opts = {}) {
      assert$2("TSExpressionWithTypeArguments", node, opts);
    }

    function assertTSInterfaceDeclaration(node, opts = {}) {
      assert$2("TSInterfaceDeclaration", node, opts);
    }

    function assertTSInterfaceBody(node, opts = {}) {
      assert$2("TSInterfaceBody", node, opts);
    }

    function assertTSTypeAliasDeclaration(node, opts = {}) {
      assert$2("TSTypeAliasDeclaration", node, opts);
    }

    function assertTSAsExpression(node, opts = {}) {
      assert$2("TSAsExpression", node, opts);
    }

    function assertTSTypeAssertion(node, opts = {}) {
      assert$2("TSTypeAssertion", node, opts);
    }

    function assertTSEnumDeclaration(node, opts = {}) {
      assert$2("TSEnumDeclaration", node, opts);
    }

    function assertTSEnumMember(node, opts = {}) {
      assert$2("TSEnumMember", node, opts);
    }

    function assertTSModuleDeclaration(node, opts = {}) {
      assert$2("TSModuleDeclaration", node, opts);
    }

    function assertTSModuleBlock(node, opts = {}) {
      assert$2("TSModuleBlock", node, opts);
    }

    function assertTSImportType(node, opts = {}) {
      assert$2("TSImportType", node, opts);
    }

    function assertTSImportEqualsDeclaration(node, opts = {}) {
      assert$2("TSImportEqualsDeclaration", node, opts);
    }

    function assertTSExternalModuleReference(node, opts = {}) {
      assert$2("TSExternalModuleReference", node, opts);
    }

    function assertTSNonNullExpression(node, opts = {}) {
      assert$2("TSNonNullExpression", node, opts);
    }

    function assertTSExportAssignment(node, opts = {}) {
      assert$2("TSExportAssignment", node, opts);
    }

    function assertTSNamespaceExportDeclaration(node, opts = {}) {
      assert$2("TSNamespaceExportDeclaration", node, opts);
    }

    function assertTSTypeAnnotation(node, opts = {}) {
      assert$2("TSTypeAnnotation", node, opts);
    }

    function assertTSTypeParameterInstantiation(node, opts = {}) {
      assert$2("TSTypeParameterInstantiation", node, opts);
    }

    function assertTSTypeParameterDeclaration(node, opts = {}) {
      assert$2("TSTypeParameterDeclaration", node, opts);
    }

    function assertTSTypeParameter(node, opts = {}) {
      assert$2("TSTypeParameter", node, opts);
    }

    function assertExpression(node, opts = {}) {
      assert$2("Expression", node, opts);
    }

    function assertBinary(node, opts = {}) {
      assert$2("Binary", node, opts);
    }

    function assertScopable(node, opts = {}) {
      assert$2("Scopable", node, opts);
    }

    function assertBlockParent(node, opts = {}) {
      assert$2("BlockParent", node, opts);
    }

    function assertBlock(node, opts = {}) {
      assert$2("Block", node, opts);
    }

    function assertStatement(node, opts = {}) {
      assert$2("Statement", node, opts);
    }

    function assertTerminatorless(node, opts = {}) {
      assert$2("Terminatorless", node, opts);
    }

    function assertCompletionStatement(node, opts = {}) {
      assert$2("CompletionStatement", node, opts);
    }

    function assertConditional(node, opts = {}) {
      assert$2("Conditional", node, opts);
    }

    function assertLoop(node, opts = {}) {
      assert$2("Loop", node, opts);
    }

    function assertWhile(node, opts = {}) {
      assert$2("While", node, opts);
    }

    function assertExpressionWrapper(node, opts = {}) {
      assert$2("ExpressionWrapper", node, opts);
    }

    function assertFor(node, opts = {}) {
      assert$2("For", node, opts);
    }

    function assertForXStatement(node, opts = {}) {
      assert$2("ForXStatement", node, opts);
    }

    function assertFunction(node, opts = {}) {
      assert$2("Function", node, opts);
    }

    function assertFunctionParent(node, opts = {}) {
      assert$2("FunctionParent", node, opts);
    }

    function assertPureish(node, opts = {}) {
      assert$2("Pureish", node, opts);
    }

    function assertDeclaration(node, opts = {}) {
      assert$2("Declaration", node, opts);
    }

    function assertPatternLike(node, opts = {}) {
      assert$2("PatternLike", node, opts);
    }

    function assertLVal(node, opts = {}) {
      assert$2("LVal", node, opts);
    }

    function assertTSEntityName(node, opts = {}) {
      assert$2("TSEntityName", node, opts);
    }

    function assertLiteral(node, opts = {}) {
      assert$2("Literal", node, opts);
    }

    function assertImmutable(node, opts = {}) {
      assert$2("Immutable", node, opts);
    }

    function assertUserWhitespacable(node, opts = {}) {
      assert$2("UserWhitespacable", node, opts);
    }

    function assertMethod(node, opts = {}) {
      assert$2("Method", node, opts);
    }

    function assertObjectMember(node, opts = {}) {
      assert$2("ObjectMember", node, opts);
    }

    function assertProperty(node, opts = {}) {
      assert$2("Property", node, opts);
    }

    function assertUnaryLike(node, opts = {}) {
      assert$2("UnaryLike", node, opts);
    }

    function assertPattern(node, opts = {}) {
      assert$2("Pattern", node, opts);
    }

    function assertClass(node, opts = {}) {
      assert$2("Class", node, opts);
    }

    function assertModuleDeclaration(node, opts = {}) {
      assert$2("ModuleDeclaration", node, opts);
    }

    function assertExportDeclaration(node, opts = {}) {
      assert$2("ExportDeclaration", node, opts);
    }

    function assertModuleSpecifier(node, opts = {}) {
      assert$2("ModuleSpecifier", node, opts);
    }

    function assertFlow(node, opts = {}) {
      assert$2("Flow", node, opts);
    }

    function assertFlowType(node, opts = {}) {
      assert$2("FlowType", node, opts);
    }

    function assertFlowBaseAnnotation(node, opts = {}) {
      assert$2("FlowBaseAnnotation", node, opts);
    }

    function assertFlowDeclaration(node, opts = {}) {
      assert$2("FlowDeclaration", node, opts);
    }

    function assertFlowPredicate(node, opts = {}) {
      assert$2("FlowPredicate", node, opts);
    }

    function assertEnumBody(node, opts = {}) {
      assert$2("EnumBody", node, opts);
    }

    function assertEnumMember(node, opts = {}) {
      assert$2("EnumMember", node, opts);
    }

    function assertJSX(node, opts = {}) {
      assert$2("JSX", node, opts);
    }

    function assertPrivate(node, opts = {}) {
      assert$2("Private", node, opts);
    }

    function assertTSTypeElement(node, opts = {}) {
      assert$2("TSTypeElement", node, opts);
    }

    function assertTSType(node, opts = {}) {
      assert$2("TSType", node, opts);
    }

    function assertTSBaseType(node, opts = {}) {
      assert$2("TSBaseType", node, opts);
    }

    function assertNumberLiteral(node, opts) {
      console.trace("The node type NumberLiteral has been renamed to NumericLiteral");
      assert$2("NumberLiteral", node, opts);
    }

    function assertRegexLiteral(node, opts) {
      console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
      assert$2("RegexLiteral", node, opts);
    }

    function assertRestProperty(node, opts) {
      console.trace("The node type RestProperty has been renamed to RestElement");
      assert$2("RestProperty", node, opts);
    }

    function assertSpreadProperty(node, opts) {
      console.trace("The node type SpreadProperty has been renamed to SpreadElement");
      assert$2("SpreadProperty", node, opts);
    }

    var createTypeAnnotationBasedOnTypeof$1 = {};

    Object.defineProperty(createTypeAnnotationBasedOnTypeof$1, "__esModule", {
      value: true
    });
    createTypeAnnotationBasedOnTypeof$1.default = createTypeAnnotationBasedOnTypeof;

    var _generated$k = generated$2;

    function createTypeAnnotationBasedOnTypeof(type) {
      if (type === "string") {
        return (0, _generated$k.stringTypeAnnotation)();
      } else if (type === "number") {
        return (0, _generated$k.numberTypeAnnotation)();
      } else if (type === "undefined") {
        return (0, _generated$k.voidTypeAnnotation)();
      } else if (type === "boolean") {
        return (0, _generated$k.booleanTypeAnnotation)();
      } else if (type === "function") {
        return (0, _generated$k.genericTypeAnnotation)((0, _generated$k.identifier)("Function"));
      } else if (type === "object") {
        return (0, _generated$k.genericTypeAnnotation)((0, _generated$k.identifier)("Object"));
      } else if (type === "symbol") {
        return (0, _generated$k.genericTypeAnnotation)((0, _generated$k.identifier)("Symbol"));
      } else {
        throw new Error("Invalid typeof value");
      }
    }

    var createFlowUnionType$1 = {};

    var removeTypeDuplicates$3 = {};

    Object.defineProperty(removeTypeDuplicates$3, "__esModule", {
      value: true
    });
    removeTypeDuplicates$3.default = removeTypeDuplicates$2;

    var _generated$j = generated$3;

    function removeTypeDuplicates$2(nodes) {
      const generics = {};
      const bases = {};
      const typeGroups = [];
      const types = [];

      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (!node) continue;

        if (types.indexOf(node) >= 0) {
          continue;
        }

        if ((0, _generated$j.isAnyTypeAnnotation)(node)) {
          return [node];
        }

        if ((0, _generated$j.isFlowBaseAnnotation)(node)) {
          bases[node.type] = node;
          continue;
        }

        if ((0, _generated$j.isUnionTypeAnnotation)(node)) {
          if (typeGroups.indexOf(node.types) < 0) {
            nodes = nodes.concat(node.types);
            typeGroups.push(node.types);
          }

          continue;
        }

        if ((0, _generated$j.isGenericTypeAnnotation)(node)) {
          const name = node.id.name;

          if (generics[name]) {
            let existing = generics[name];

            if (existing.typeParameters) {
              if (node.typeParameters) {
                existing.typeParameters.params = removeTypeDuplicates$2(existing.typeParameters.params.concat(node.typeParameters.params));
              }
            } else {
              existing = node.typeParameters;
            }
          } else {
            generics[name] = node;
          }

          continue;
        }

        types.push(node);
      }

      for (const type of Object.keys(bases)) {
        types.push(bases[type]);
      }

      for (const name of Object.keys(generics)) {
        types.push(generics[name]);
      }

      return types;
    }

    Object.defineProperty(createFlowUnionType$1, "__esModule", {
      value: true
    });
    createFlowUnionType$1.default = createFlowUnionType;

    var _generated$i = generated$2;

    var _removeTypeDuplicates$1 = _interopRequireDefault$q(removeTypeDuplicates$3);

    function _interopRequireDefault$q(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function createFlowUnionType(types) {
      const flattened = (0, _removeTypeDuplicates$1.default)(types);

      if (flattened.length === 1) {
        return flattened[0];
      } else {
        return (0, _generated$i.unionTypeAnnotation)(flattened);
      }
    }

    var createTSUnionType$1 = {};

    var removeTypeDuplicates$1 = {};

    Object.defineProperty(removeTypeDuplicates$1, "__esModule", {
      value: true
    });
    removeTypeDuplicates$1.default = removeTypeDuplicates;

    var _generated$h = generated$3;

    function removeTypeDuplicates(nodes) {
      const generics = {};
      const bases = {};
      const typeGroups = [];
      const types = [];

      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (!node) continue;

        if (types.indexOf(node) >= 0) {
          continue;
        }

        if ((0, _generated$h.isTSAnyKeyword)(node.type)) {
          return [node];
        }

        if ((0, _generated$h.isTSBaseType)(node)) {
          bases[node.type] = node;
          continue;
        }

        if ((0, _generated$h.isTSUnionType)(node)) {
          if (typeGroups.indexOf(node.types) < 0) {
            nodes = nodes.concat(node.types);
            typeGroups.push(node.types);
          }

          continue;
        }

        types.push(node);
      }

      for (const type of Object.keys(bases)) {
        types.push(bases[type]);
      }

      for (const name of Object.keys(generics)) {
        types.push(generics[name]);
      }

      return types;
    }

    Object.defineProperty(createTSUnionType$1, "__esModule", {
      value: true
    });
    createTSUnionType$1.default = createTSUnionType;

    var _generated$g = generated$2;

    var _removeTypeDuplicates = _interopRequireDefault$p(removeTypeDuplicates$1);

    function _interopRequireDefault$p(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function createTSUnionType(typeAnnotations) {
      const types = typeAnnotations.map(type => type.typeAnnotations);
      const flattened = (0, _removeTypeDuplicates.default)(types);

      if (flattened.length === 1) {
        return flattened[0];
      } else {
        return (0, _generated$g.TSUnionType)(flattened);
      }
    }

    var cloneNode$1 = {};

    Object.defineProperty(cloneNode$1, "__esModule", {
      value: true
    });
    cloneNode$1.default = cloneNode;

    var _definitions$4 = requireDefinitions();

    const has$1 = Function.call.bind(Object.prototype.hasOwnProperty);

    function cloneIfNode(obj, deep, withoutLoc) {
      if (obj && typeof obj.type === "string") {
        return cloneNode(obj, deep, withoutLoc);
      }

      return obj;
    }

    function cloneIfNodeOrArray(obj, deep, withoutLoc) {
      if (Array.isArray(obj)) {
        return obj.map(node => cloneIfNode(node, deep, withoutLoc));
      }

      return cloneIfNode(obj, deep, withoutLoc);
    }

    function cloneNode(node, deep = true, withoutLoc = false) {
      if (!node) return node;
      const {
        type
      } = node;
      const newNode = {
        type
      };

      if (type === "Identifier") {
        newNode.name = node.name;

        if (has$1(node, "optional") && typeof node.optional === "boolean") {
          newNode.optional = node.optional;
        }

        if (has$1(node, "typeAnnotation")) {
          newNode.typeAnnotation = deep ? cloneIfNodeOrArray(node.typeAnnotation, true, withoutLoc) : node.typeAnnotation;
        }
      } else if (!has$1(_definitions$4.NODE_FIELDS, type)) {
        throw new Error(`Unknown node type: "${type}"`);
      } else {
        for (const field of Object.keys(_definitions$4.NODE_FIELDS[type])) {
          if (has$1(node, field)) {
            if (deep) {
              newNode[field] = type === "File" && field === "comments" ? maybeCloneComments(node.comments, deep, withoutLoc) : cloneIfNodeOrArray(node[field], true, withoutLoc);
            } else {
              newNode[field] = node[field];
            }
          }
        }
      }

      if (has$1(node, "loc")) {
        if (withoutLoc) {
          newNode.loc = null;
        } else {
          newNode.loc = node.loc;
        }
      }

      if (has$1(node, "leadingComments")) {
        newNode.leadingComments = maybeCloneComments(node.leadingComments, deep, withoutLoc);
      }

      if (has$1(node, "innerComments")) {
        newNode.innerComments = maybeCloneComments(node.innerComments, deep, withoutLoc);
      }

      if (has$1(node, "trailingComments")) {
        newNode.trailingComments = maybeCloneComments(node.trailingComments, deep, withoutLoc);
      }

      if (has$1(node, "extra")) {
        newNode.extra = Object.assign({}, node.extra);
      }

      return newNode;
    }

    function cloneCommentsWithoutLoc(comments) {
      return comments.map(({
        type,
        value
      }) => ({
        type,
        value,
        loc: null
      }));
    }

    function maybeCloneComments(comments, deep, withoutLoc) {
      return deep && withoutLoc ? cloneCommentsWithoutLoc(comments) : comments;
    }

    var clone$1 = {};

    Object.defineProperty(clone$1, "__esModule", {
      value: true
    });
    clone$1.default = clone;

    var _cloneNode$5 = _interopRequireDefault$o(cloneNode$1);

    function _interopRequireDefault$o(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function clone(node) {
      return (0, _cloneNode$5.default)(node, false);
    }

    var cloneDeep$1 = {};

    Object.defineProperty(cloneDeep$1, "__esModule", {
      value: true
    });
    cloneDeep$1.default = cloneDeep;

    var _cloneNode$4 = _interopRequireDefault$n(cloneNode$1);

    function _interopRequireDefault$n(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function cloneDeep(node) {
      return (0, _cloneNode$4.default)(node);
    }

    var cloneDeepWithoutLoc$1 = {};

    Object.defineProperty(cloneDeepWithoutLoc$1, "__esModule", {
      value: true
    });
    cloneDeepWithoutLoc$1.default = cloneDeepWithoutLoc;

    var _cloneNode$3 = _interopRequireDefault$m(cloneNode$1);

    function _interopRequireDefault$m(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function cloneDeepWithoutLoc(node) {
      return (0, _cloneNode$3.default)(node, true, true);
    }

    var cloneWithoutLoc$1 = {};

    Object.defineProperty(cloneWithoutLoc$1, "__esModule", {
      value: true
    });
    cloneWithoutLoc$1.default = cloneWithoutLoc;

    var _cloneNode$2 = _interopRequireDefault$l(cloneNode$1);

    function _interopRequireDefault$l(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function cloneWithoutLoc(node) {
      return (0, _cloneNode$2.default)(node, false, true);
    }

    var addComment$1 = {};

    var addComments$1 = {};

    Object.defineProperty(addComments$1, "__esModule", {
      value: true
    });
    addComments$1.default = addComments;

    function addComments(node, type, comments) {
      if (!comments || !node) return node;
      const key = `${type}Comments`;

      if (node[key]) {
        if (type === "leading") {
          node[key] = comments.concat(node[key]);
        } else {
          node[key] = node[key].concat(comments);
        }
      } else {
        node[key] = comments;
      }

      return node;
    }

    Object.defineProperty(addComment$1, "__esModule", {
      value: true
    });
    addComment$1.default = addComment;

    var _addComments = _interopRequireDefault$k(addComments$1);

    function _interopRequireDefault$k(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function addComment(node, type, content, line) {
      return (0, _addComments.default)(node, type, [{
        type: line ? "CommentLine" : "CommentBlock",
        value: content
      }]);
    }

    var inheritInnerComments$1 = {};

    var inherit$1 = {};

    var HASH_UNDEFINED = '__lodash_hash_undefined__';

    /**
     * Adds `value` to the array cache.
     *
     * @private
     * @name add
     * @memberOf SetCache
     * @alias push
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache instance.
     */
    function setCacheAdd$1(value) {
      this.__data__.set(value, HASH_UNDEFINED);
      return this;
    }

    var _setCacheAdd = setCacheAdd$1;

    function setCacheHas$1(value) {
      return this.__data__.has(value);
    }

    var _setCacheHas = setCacheHas$1;

    var MapCache = _MapCache,
        setCacheAdd = _setCacheAdd,
        setCacheHas = _setCacheHas;

    /**
     *
     * Creates an array cache object to store unique values.
     *
     * @private
     * @constructor
     * @param {Array} [values] The values to cache.
     */
    function SetCache$1(values) {
      var index = -1,
          length = values == null ? 0 : values.length;

      this.__data__ = new MapCache;
      while (++index < length) {
        this.add(values[index]);
      }
    }

    // Add methods to `SetCache`.
    SetCache$1.prototype.add = SetCache$1.prototype.push = setCacheAdd;
    SetCache$1.prototype.has = setCacheHas;

    var _SetCache = SetCache$1;

    function baseFindIndex$1(array, predicate, fromIndex, fromRight) {
      var length = array.length,
          index = fromIndex + (fromRight ? 1 : -1);

      while ((fromRight ? index-- : ++index < length)) {
        if (predicate(array[index], index, array)) {
          return index;
        }
      }
      return -1;
    }

    var _baseFindIndex = baseFindIndex$1;

    function baseIsNaN$1(value) {
      return value !== value;
    }

    var _baseIsNaN = baseIsNaN$1;

    function strictIndexOf$1(array, value, fromIndex) {
      var index = fromIndex - 1,
          length = array.length;

      while (++index < length) {
        if (array[index] === value) {
          return index;
        }
      }
      return -1;
    }

    var _strictIndexOf = strictIndexOf$1;

    var baseFindIndex = _baseFindIndex,
        baseIsNaN = _baseIsNaN,
        strictIndexOf = _strictIndexOf;

    /**
     * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} value The value to search for.
     * @param {number} fromIndex The index to search from.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */
    function baseIndexOf$1(array, value, fromIndex) {
      return value === value
        ? strictIndexOf(array, value, fromIndex)
        : baseFindIndex(array, baseIsNaN, fromIndex);
    }

    var _baseIndexOf = baseIndexOf$1;

    var baseIndexOf = _baseIndexOf;

    /**
     * A specialized version of `_.includes` for arrays without support for
     * specifying an index to search from.
     *
     * @private
     * @param {Array} [array] The array to inspect.
     * @param {*} target The value to search for.
     * @returns {boolean} Returns `true` if `target` is found, else `false`.
     */
    function arrayIncludes$1(array, value) {
      var length = array == null ? 0 : array.length;
      return !!length && baseIndexOf(array, value, 0) > -1;
    }

    var _arrayIncludes = arrayIncludes$1;

    function arrayIncludesWith$1(array, value, comparator) {
      var index = -1,
          length = array == null ? 0 : array.length;

      while (++index < length) {
        if (comparator(value, array[index])) {
          return true;
        }
      }
      return false;
    }

    var _arrayIncludesWith = arrayIncludesWith$1;

    function cacheHas$1(cache, key) {
      return cache.has(key);
    }

    var _cacheHas = cacheHas$1;

    function noop$1() {
      // No operation performed.
    }

    var noop_1 = noop$1;

    function setToArray$2(set) {
      var index = -1,
          result = Array(set.size);

      set.forEach(function(value) {
        result[++index] = value;
      });
      return result;
    }

    var _setToArray = setToArray$2;

    var Set$1 = _Set,
        noop = noop_1,
        setToArray$1 = _setToArray;

    /** Used as references for various `Number` constants. */
    var INFINITY = 1 / 0;

    /**
     * Creates a set object of `values`.
     *
     * @private
     * @param {Array} values The values to add to the set.
     * @returns {Object} Returns the new set.
     */
    var createSet$1 = !(Set$1 && (1 / setToArray$1(new Set$1([,-0]))[1]) == INFINITY) ? noop : function(values) {
      return new Set$1(values);
    };

    var _createSet = createSet$1;

    var SetCache = _SetCache,
        arrayIncludes = _arrayIncludes,
        arrayIncludesWith = _arrayIncludesWith,
        cacheHas = _cacheHas,
        createSet = _createSet,
        setToArray = _setToArray;

    /** Used as the size to enable large array optimizations. */
    var LARGE_ARRAY_SIZE = 200;

    /**
     * The base implementation of `_.uniqBy` without support for iteratee shorthands.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new duplicate free array.
     */
    function baseUniq$1(array, iteratee, comparator) {
      var index = -1,
          includes = arrayIncludes,
          length = array.length,
          isCommon = true,
          result = [],
          seen = result;

      if (comparator) {
        isCommon = false;
        includes = arrayIncludesWith;
      }
      else if (length >= LARGE_ARRAY_SIZE) {
        var set = iteratee ? null : createSet(array);
        if (set) {
          return setToArray(set);
        }
        isCommon = false;
        includes = cacheHas;
        seen = new SetCache;
      }
      else {
        seen = iteratee ? [] : result;
      }
      outer:
      while (++index < length) {
        var value = array[index],
            computed = iteratee ? iteratee(value) : value;

        value = (comparator || value !== 0) ? value : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        }
        else if (!includes(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
      return result;
    }

    var _baseUniq = baseUniq$1;

    var baseUniq = _baseUniq;

    /**
     * Creates a duplicate-free version of an array, using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons, in which only the first occurrence of each element
     * is kept. The order of result values is determined by the order they occur
     * in the array.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @returns {Array} Returns the new duplicate free array.
     * @example
     *
     * _.uniq([2, 1, 2]);
     * // => [2, 1]
     */
    function uniq(array) {
      return (array && array.length) ? baseUniq(array) : [];
    }

    var uniq_1 = uniq;

    Object.defineProperty(inherit$1, "__esModule", {
      value: true
    });
    inherit$1.default = inherit;

    var _uniq = _interopRequireDefault$j(uniq_1);

    function _interopRequireDefault$j(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function inherit(key, child, parent) {
      if (child && parent) {
        child[key] = (0, _uniq.default)([].concat(child[key], parent[key]).filter(Boolean));
      }
    }

    Object.defineProperty(inheritInnerComments$1, "__esModule", {
      value: true
    });
    inheritInnerComments$1.default = inheritInnerComments;

    var _inherit$2 = _interopRequireDefault$i(inherit$1);

    function _interopRequireDefault$i(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function inheritInnerComments(child, parent) {
      (0, _inherit$2.default)("innerComments", child, parent);
    }

    var inheritLeadingComments$1 = {};

    Object.defineProperty(inheritLeadingComments$1, "__esModule", {
      value: true
    });
    inheritLeadingComments$1.default = inheritLeadingComments;

    var _inherit$1 = _interopRequireDefault$h(inherit$1);

    function _interopRequireDefault$h(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function inheritLeadingComments(child, parent) {
      (0, _inherit$1.default)("leadingComments", child, parent);
    }

    var inheritsComments$1 = {};

    var inheritTrailingComments$1 = {};

    Object.defineProperty(inheritTrailingComments$1, "__esModule", {
      value: true
    });
    inheritTrailingComments$1.default = inheritTrailingComments;

    var _inherit = _interopRequireDefault$g(inherit$1);

    function _interopRequireDefault$g(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function inheritTrailingComments(child, parent) {
      (0, _inherit.default)("trailingComments", child, parent);
    }

    Object.defineProperty(inheritsComments$1, "__esModule", {
      value: true
    });
    inheritsComments$1.default = inheritsComments;

    var _inheritTrailingComments = _interopRequireDefault$f(inheritTrailingComments$1);

    var _inheritLeadingComments = _interopRequireDefault$f(inheritLeadingComments$1);

    var _inheritInnerComments = _interopRequireDefault$f(inheritInnerComments$1);

    function _interopRequireDefault$f(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

    function inheritsComments(child, parent) {
      (0, _inheritTrailingComments.default)(child, parent);
      (0, _inheritLeadingComments.default)(child, parent);
      (0, _inheritInnerComments.default)(child, parent);
      return child;
    }

    var removeComments$1 = {};

    Object.defineProperty(removeComments$1, "__esModule", {
      value: true
    });
    removeComments$1.default = removeComments;

    var _constants$4 = constants;

    function removeComments(node) {
      _constants$4.COMMENT_KEYS.forEach(key => {
        node[key] = null;
      });

      return node;
    }

    var generated = {};

    Object.defineProperty(generated, "__esModule", {
      value: true
    });
    generated.TSBASETYPE_TYPES = generated.TSTYPE_TYPES = generated.TSTYPEELEMENT_TYPES = generated.PRIVATE_TYPES = generated.JSX_TYPES = generated.ENUMMEMBER_TYPES = generated.ENUMBODY_TYPES = generated.FLOWPREDICATE_TYPES = generated.FLOWDECLARATION_TYPES = generated.FLOWBASEANNOTATION_TYPES = generated.FLOWTYPE_TYPES = generated.FLOW_TYPES = generated.MODULESPECIFIER_TYPES = generated.EXPORTDECLARATION_TYPES = generated.MODULEDECLARATION_TYPES = generated.CLASS_TYPES = generated.PATTERN_TYPES = generated.UNARYLIKE_TYPES = generated.PROPERTY_TYPES = generated.OBJECTMEMBER_TYPES = generated.METHOD_TYPES = generated.USERWHITESPACABLE_TYPES = generated.IMMUTABLE_TYPES = generated.LITERAL_TYPES = generated.TSENTITYNAME_TYPES = generated.LVAL_TYPES = generated.PATTERNLIKE_TYPES = generated.DECLARATION_TYPES = generated.PUREISH_TYPES = generated.FUNCTIONPARENT_TYPES = generated.FUNCTION_TYPES = generated.FORXSTATEMENT_TYPES = generated.FOR_TYPES = generated.EXPRESSIONWRAPPER_TYPES = generated.WHILE_TYPES = generated.LOOP_TYPES = generated.CONDITIONAL_TYPES = generated.COMPLETIONSTATEMENT_TYPES = generated.TERMINATORLESS_TYPES = generated.STATEMENT_TYPES = generated.BLOCK_TYPES = generated.BLOCKPARENT_TYPES = generated.SCOPABLE_TYPES = generated.BINARY_TYPES = generated.EXPRESSION_TYPES = void 0;

    var _definitions$3 = requireDefinitions();

    const EXPRESSION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Expression"];
    generated.EXPRESSION_TYPES = EXPRESSION_TYPES;
    const BINARY_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Binary"];
    generated.BINARY_TYPES = BINARY_TYPES;
    const SCOPABLE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Scopable"];
    generated.SCOPABLE_TYPES = SCOPABLE_TYPES;
    const BLOCKPARENT_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["BlockParent"];
    generated.BLOCKPARENT_TYPES = BLOCKPARENT_TYPES;
    const BLOCK_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Block"];
    generated.BLOCK_TYPES = BLOCK_TYPES;
    const STATEMENT_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Statement"];
    generated.STATEMENT_TYPES = STATEMENT_TYPES;
    const TERMINATORLESS_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Terminatorless"];
    generated.TERMINATORLESS_TYPES = TERMINATORLESS_TYPES;
    const COMPLETIONSTATEMENT_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["CompletionStatement"];
    generated.COMPLETIONSTATEMENT_TYPES = COMPLETIONSTATEMENT_TYPES;
    const CONDITIONAL_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Conditional"];
    generated.CONDITIONAL_TYPES = CONDITIONAL_TYPES;
    const LOOP_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Loop"];
    generated.LOOP_TYPES = LOOP_TYPES;
    const WHILE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["While"];
    generated.WHILE_TYPES = WHILE_TYPES;
    const EXPRESSIONWRAPPER_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["ExpressionWrapper"];
    generated.EXPRESSIONWRAPPER_TYPES = EXPRESSIONWRAPPER_TYPES;
    const FOR_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["For"];
    generated.FOR_TYPES = FOR_TYPES;
    const FORXSTATEMENT_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["ForXStatement"];
    generated.FORXSTATEMENT_TYPES = FORXSTATEMENT_TYPES;
    const FUNCTION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Function"];
    generated.FUNCTION_TYPES = FUNCTION_TYPES;
    const FUNCTIONPARENT_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["FunctionParent"];
    generated.FUNCTIONPARENT_TYPES = FUNCTIONPARENT_TYPES;
    const PUREISH_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Pureish"];
    generated.PUREISH_TYPES = PUREISH_TYPES;
    const DECLARATION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Declaration"];
    generated.DECLARATION_TYPES = DECLARATION_TYPES;
    const PATTERNLIKE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["PatternLike"];
    generated.PATTERNLIKE_TYPES = PATTERNLIKE_TYPES;
    const LVAL_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["LVal"];
    generated.LVAL_TYPES = LVAL_TYPES;
    const TSENTITYNAME_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["TSEntityName"];
    generated.TSENTITYNAME_TYPES = TSENTITYNAME_TYPES;
    const LITERAL_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Literal"];
    generated.LITERAL_TYPES = LITERAL_TYPES;
    const IMMUTABLE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Immutable"];
    generated.IMMUTABLE_TYPES = IMMUTABLE_TYPES;
    const USERWHITESPACABLE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["UserWhitespacable"];
    generated.USERWHITESPACABLE_TYPES = USERWHITESPACABLE_TYPES;
    const METHOD_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Method"];
    generated.METHOD_TYPES = METHOD_TYPES;
    const OBJECTMEMBER_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["ObjectMember"];
    generated.OBJECTMEMBER_TYPES = OBJECTMEMBER_TYPES;
    const PROPERTY_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Property"];
    generated.PROPERTY_TYPES = PROPERTY_TYPES;
    const UNARYLIKE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["UnaryLike"];
    generated.UNARYLIKE_TYPES = UNARYLIKE_TYPES;
    const PATTERN_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Pattern"];
    generated.PATTERN_TYPES = PATTERN_TYPES;
    const CLASS_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Class"];
    generated.CLASS_TYPES = CLASS_TYPES;
    const MODULEDECLARATION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["ModuleDeclaration"];
    generated.MODULEDECLARATION_TYPES = MODULEDECLARATION_TYPES;
    const EXPORTDECLARATION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["ExportDeclaration"];
    generated.EXPORTDECLARATION_TYPES = EXPORTDECLARATION_TYPES;
    const MODULESPECIFIER_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["ModuleSpecifier"];
    generated.MODULESPECIFIER_TYPES = MODULESPECIFIER_TYPES;
    const FLOW_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Flow"];
    generated.FLOW_TYPES = FLOW_TYPES;
    const FLOWTYPE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["FlowType"];
    generated.FLOWTYPE_TYPES = FLOWTYPE_TYPES;
    const FLOWBASEANNOTATION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["FlowBaseAnnotation"];
    generated.FLOWBASEANNOTATION_TYPES = FLOWBASEANNOTATION_TYPES;
    const FLOWDECLARATION_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["FlowDeclaration"];
    generated.FLOWDECLARATION_TYPES = FLOWDECLARATION_TYPES;
    const FLOWPREDICATE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["FlowPredicate"];
    generated.FLOWPREDICATE_TYPES = FLOWPREDICATE_TYPES;
    const ENUMBODY_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["EnumBody"];
    generated.ENUMBODY_TYPES = ENUMBODY_TYPES;
    const ENUMMEMBER_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["EnumMember"];
    generated.ENUMMEMBER_TYPES = ENUMMEMBER_TYPES;
    const JSX_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["JSX"];
    generated.JSX_TYPES = JSX_TYPES;
    const PRIVATE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["Private"];
    generated.PRIVATE_TYPES = PRIVATE_TYPES;
    const TSTYPEELEMENT_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["TSTypeElement"];
    generated.TSTYPEELEMENT_TYPES = TSTYPEELEMENT_TYPES;
    const TSTYPE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["TSType"];
    generated.TSTYPE_TYPES = TSTYPE_TYPES;
    const TSBASETYPE_TYPES = _definitions$3.FLIPPED_ALIAS_KEYS["TSBaseType"];
    generated.TSBASETYPE_TYPES = TSBASETYPE_TYPES;

    var ensureBlock$1 = {};

    var toBlock$1 = {};

    Object.defineProperty(toBlock$1, "__esModule", {
      value: true
    });
    toBlock$1.default = toBlock;

    var _generated$f = generated$3;

  