/* THIS FILE IS AUTOGENERATED FROM Clients.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_CLIENTSBINDING_H_
#define DOM_CLIENTSBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Client;
struct ClientQueryOptionsAtoms;
class Clients;
struct NativePropertyHooks;
class OwningClientOrUndefined;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class ClientType : uint8_t {
  Window,
  Worker,
  Sharedworker,
  Serviceworker,
  All,
};

namespace binding_detail {
template <> struct EnumStrings<ClientType> {
  static const nsLiteralCString Values[5];
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ClientType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningClientOrUndefined& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningClientOrUndefined& aUnion);


class ClientOrUndefined : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eClient,
    eUndefined
  };
public:
  enum class Type
  {
    eClient = TypeOrUninit::eClient,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Client> > mClient;

  };

  TypeOrUninit mType;
  Value mValue;

  ClientOrUndefined(const ClientOrUndefined&) = delete;
  ClientOrUndefined& operator=(const ClientOrUndefined&) = delete;
public:
  explicit inline ClientOrUndefined()
    : mType(eUninitialized)
  {
  }

  inline ~ClientOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Client>&
  RawSetAsClient()
  {
    if (mType == eClient) {
      return mValue.mClient.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eClient;
    return mValue.mClient.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Client>&
  SetAsClient()
  {
    if (mType == eClient) {
      return mValue.mClient.Value();
    }
    Uninit();
    mType = eClient;
    return mValue.mClient.SetValue();
  }

  inline bool
  IsClient() const
  {
    return mType == eClient;
  }

  inline NonNull<mozilla::dom::Client>&
  GetAsClient()
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline mozilla::dom::Client&
  GetAsClient() const
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eClient: {
        DestroyClient();
        break;
      }
      case eUndefined: {
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToClient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToClient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyClient()
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    mValue.mClient.Destroy();
    mType = eUninitialized;
  }
};


class OwningClientOrUndefined : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningClientOrUndefined& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eClient,
    eUndefined
  };
public:
  enum class Type
  {
    eClient = TypeOrUninit::eClient,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Client> > mClient;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningClientOrUndefined()
    : mType(eUninitialized)
  {
  }

  OwningClientOrUndefined(OwningClientOrUndefined&& aOther);

  explicit inline OwningClientOrUndefined(const OwningClientOrUndefined& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningClientOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Client>&
  RawSetAsClient();

  [[nodiscard]] OwningNonNull<mozilla::dom::Client>&
  SetAsClient();

  inline bool
  IsClient() const
  {
    return mType == eClient;
  }

  inline OwningNonNull<mozilla::dom::Client>&
  GetAsClient()
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline OwningNonNull<mozilla::dom::Client> const &
  GetAsClient() const
  {
    MOZ_RELEASE_ASSERT(IsClient(), "Wrong type!");
    return mValue.mClient.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningClientOrUndefined&
  operator=(OwningClientOrUndefined&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningClientOrUndefined&
  operator=(const OwningClientOrUndefined& aOther);

private:
  bool
  TrySetToClient(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToClient(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyClient();
};


struct ClientQueryOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIncludeUncontrolled;
  MOZ_INIT_OUTSIDE_CTOR ClientType mType;

  ClientQueryOptions();

  explicit inline ClientQueryOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ClientQueryOptions(ClientQueryOptions&& aOther) = default;

  explicit inline ClientQueryOptions(const ClientQueryOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ClientQueryOptions&
  operator=(const ClientQueryOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ClientQueryOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastClientQueryOptions : public ClientQueryOptions
{
  inline FastClientQueryOptions()
    : ClientQueryOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Clients_Binding {

  typedef mozilla::dom::Clients NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Clients* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Clients,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Clients,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Clients,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Clients_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::ClientType>
{
  static constexpr dom::ClientType value = dom::ClientType::All;

  static_assert(static_cast<uint8_t>(dom::ClientType::Window) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(mozilla::ArrayLength(dom::binding_detail::EnumStrings<dom::ClientType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_CLIENTSBINDING_H_
