/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.util.ArrayList;
import java.util.List;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.utils.ArrayUtil;

public class MockClassLoaderBuilder {
    private final List<MockTransformer> mockTransformerChain = new ArrayList<MockTransformer>(3);
    private String[] packagesToIgnore;
    private String[] classesToModify;

    MockClassLoaderBuilder() {
    }

    public MockClassLoader build() {
        MockClassLoader classLoader = new MockClassLoader();
        classLoader.setMockTransformerChain(this.mockTransformerChain);
        classLoader.addIgnorePackage(this.packagesToIgnore);
        classLoader.addClassesToModify(this.classesToModify);
        return classLoader;
    }

    public MockClassLoaderBuilder addMockTransformerChain(List<MockTransformer> mockTransformerChain) {
        this.mockTransformerChain.addAll(mockTransformerChain);
        return this;
    }

    public MockClassLoaderBuilder addIgnorePackage(String[] packagesToIgnore) {
        this.packagesToIgnore = ArrayUtil.addAll(this.packagesToIgnore, packagesToIgnore);
        return this;
    }

    public MockClassLoaderBuilder addClassesToModify(String[] classesToModify) {
        this.classesToModify = ArrayUtil.addAll(this.classesToModify, classesToModify);
        return this;
    }
}

