/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import org.mockito.exceptions.base.MockitoException;

public final class IOUtil {
    public static void writeText(String text, File output) {
        OutputStreamWriter pw = null;
        try {
            pw = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);
            pw.write(text);
        }
        catch (Exception e) {
            try {
                throw new MockitoException("Problems writing text to file: " + output, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(pw);
                throw throwable;
            }
        }
        IOUtil.close(pw);
    }

    public static Collection<String> readLines(InputStream is) {
        LinkedList<String> out = new LinkedList<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                out.add(line);
            }
        }
        catch (IOException e) {
            throw new MockitoException("Problems reading from: " + is, e);
        }
        return out;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            IOUtil.close(closeable);
        }
        catch (MockitoException mockitoException) {
            // empty catch block
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new MockitoException("Problems closing stream: " + closeable, e);
            }
        }
    }

    private IOUtil() {
    }
}

