/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue.lbcore258;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileLockSimulator {
    static String LINE_SEPARATOR = System.getProperty("line.separator");
    static final int DOT_FREQ = 128;
    static final int DOT_WITH_NEW_LINE_FREQ = 10240;
    static String instanceName;
    static int delay;
    static FileOutputStream fos;
    static FileChannel fileChannel;

    public static void main(String[] args) throws IOException, InterruptedException {
        String instanceName = args[0];
        System.out.println("Instance named as [" + instanceName + "]");
        String fileStr = args[1];
        System.out.println("Output target specified as [" + fileStr + "]");
        int delay = Integer.parseInt(args[2]);
        System.out.println("Sleep delay specified as [" + delay + "] milliseconds");
        fos = new FileOutputStream(fileStr, true);
        fileChannel = fos.getChannel();
        int i = 1;
        while (true) {
            FileLockSimulator.printDotAndSleep(i);
            FileLockSimulator.lockAndWrite(i);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lockAndWrite(int i) throws InterruptedException, IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long position = fileChannel.position();
            long size = fileChannel.size();
            if (size != position) {
                fileChannel.position(size);
            }
            String msg = "hello from" + instanceName + " " + i + LINE_SEPARATOR;
            fos.write(msg.getBytes());
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
        }
    }

    static void printDotAndSleep(int i) throws InterruptedException {
        if (i % 128 == 0) {
            System.out.print(".");
            Thread.sleep(delay);
        }
        if (i % 10240 == 0) {
            System.out.println("");
        }
    }
}

