/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.stream.Stream;
import org.eclipse.jetty.http.MimeTypes;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MimeTypesTest {
    public static Stream<Arguments> mimeTypesByExtensionCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"test.gz", "application/gzip"}), Arguments.of((Object[])new Object[]{"foo.webp", "image/webp"}), Arguments.of((Object[])new Object[]{"zed.avif", "image/avif"}), Arguments.of((Object[])new Object[]{"test.png", "image/png"}), Arguments.of((Object[])new Object[]{"TEST.PNG", "image/png"}), Arguments.of((Object[])new Object[]{"Test.Png", "image/png"}), Arguments.of((Object[])new Object[]{"test.txt", "text/plain"}), Arguments.of((Object[])new Object[]{"TEST.TXT", "text/plain"}), Arguments.of((Object[])new Object[]{"org.eclipse.jetty.Logo.png", "image/png"}), Arguments.of((Object[])new Object[]{"org/eclipse/jetty/Logo.png", "image/png"}), Arguments.of((Object[])new Object[]{"org/eclipse.jpg/jetty/Logo.png", "image/png"}));
    }

    @ParameterizedTest
    @MethodSource(value={"mimeTypesByExtensionCases"})
    public void testMimeTypesByExtension(String filename, String expectedMimeType) {
        MimeTypes mimetypes = new MimeTypes();
        String contentType = mimetypes.getMimeByExtension(filename);
        MatcherAssert.assertThat((String)("MimeTypes.getMimeByExtension(\"" + filename + "\")"), (Object)contentType, (Matcher)Matchers.is((Object)expectedMimeType));
    }

    @Test
    public void testGetMimeByExtensionNoExtension() {
        MimeTypes mimetypes = new MimeTypes();
        String contentType = mimetypes.getMimeByExtension("README");
        Assertions.assertNull((Object)contentType);
    }

    public static Stream<Arguments> charsetFromContentTypeCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"foo/bar;charset=abc;some=else", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar;charset=abc", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar ; charset = abc", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar ; charset = abc ; some=else", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar;other=param;charset=abc;some=else", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar;other=param;charset=abc", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar other = param ; charset = abc", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar other = param ; charset = abc ; some=else", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar other = param ; charset = abc", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar other = param ; charset = \"abc\" ; some=else", "abc"}), Arguments.of((Object[])new Object[]{"foo/bar", null}), Arguments.of((Object[])new Object[]{"foo/bar;charset=uTf8", "utf-8"}), Arguments.of((Object[])new Object[]{"foo/bar;other=\"charset=abc\";charset=uTf8", "utf-8"}), Arguments.of((Object[])new Object[]{"application/pdf; charset=UTF-8", "utf-8"}), Arguments.of((Object[])new Object[]{"application/pdf;; charset=UTF-8", "utf-8"}), Arguments.of((Object[])new Object[]{"application/pdf;;; charset=UTF-8", "utf-8"}), Arguments.of((Object[])new Object[]{"application/pdf;;;; charset=UTF-8", "utf-8"}), Arguments.of((Object[])new Object[]{"text/html;charset=utf-8", "utf-8"}));
    }

    @ParameterizedTest
    @MethodSource(value={"charsetFromContentTypeCases"})
    public void testCharsetFromContentType(String contentType, String expectedCharset) {
        MatcherAssert.assertThat((String)("getCharsetFromContentType(\"" + contentType + "\")"), (Object)MimeTypes.getCharsetFromContentType((String)contentType), (Matcher)Matchers.is((Object)expectedCharset));
    }

    public static Stream<Arguments> contentTypeWithoutCharsetCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"foo/bar;charset=abc;some=else", "foo/bar;some=else"}), Arguments.of((Object[])new Object[]{"foo/bar;charset=abc", "foo/bar"}), Arguments.of((Object[])new Object[]{"foo/bar ; charset = abc", "foo/bar"}), Arguments.of((Object[])new Object[]{"foo/bar ; charset = abc ; some=else", "foo/bar;some=else"}), Arguments.of((Object[])new Object[]{"foo/bar;other=param;charset=abc;some=else", "foo/bar;other=param;some=else"}), Arguments.of((Object[])new Object[]{"foo/bar;other=param;charset=abc", "foo/bar;other=param"}), Arguments.of((Object[])new Object[]{"foo/bar ; other = param ; charset = abc", "foo/bar ; other = param"}), Arguments.of((Object[])new Object[]{"foo/bar ; other = param ; charset = abc ; some=else", "foo/bar ; other = param;some=else"}), Arguments.of((Object[])new Object[]{"foo/bar ; other = param ; charset = abc", "foo/bar ; other = param"}), Arguments.of((Object[])new Object[]{"foo/bar ; other = param ; charset = \"abc\" ; some=else", "foo/bar ; other = param;some=else"}), Arguments.of((Object[])new Object[]{"foo/bar", "foo/bar"}), Arguments.of((Object[])new Object[]{"foo/bar;charset=uTf8", "foo/bar"}), Arguments.of((Object[])new Object[]{"foo/bar;other=\"charset=abc\";charset=uTf8", "foo/bar;other=\"charset=abc\""}), Arguments.of((Object[])new Object[]{"text/html;charset=utf-8", "text/html"}));
    }

    @ParameterizedTest
    @MethodSource(value={"contentTypeWithoutCharsetCases"})
    public void testContentTypeWithoutCharset(String contentTypeWithCharset, String expectedContentType) {
        MatcherAssert.assertThat((String)("MimeTypes.getContentTypeWithoutCharset(\"" + contentTypeWithCharset + "\")"), (Object)MimeTypes.getContentTypeWithoutCharset((String)contentTypeWithCharset), (Matcher)Matchers.is((Object)expectedContentType));
    }
}

