/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Condition;
import org.assertj.core.util.VisibleForTesting;

public abstract class Join<T>
extends Condition<T> {
    @VisibleForTesting
    final Collection<Condition<? super T>> conditions;

    protected Join(Condition<? super T> ... conditions) {
        if (conditions == null) {
            throw Join.conditionsIsNull();
        }
        this.conditions = new ArrayList<Condition<? super T>>();
        for (Condition<? super T> condition : conditions) {
            this.conditions.add(Join.notNull(condition));
        }
    }

    protected Join(Iterable<? extends Condition<? super T>> conditions) {
        if (conditions == null) {
            throw Join.conditionsIsNull();
        }
        this.conditions = new ArrayList<Condition<? super T>>();
        for (Condition<T> condition : conditions) {
            this.conditions.add(Join.notNull(condition));
        }
    }

    private static NullPointerException conditionsIsNull() {
        return new NullPointerException("The given conditions should not be null");
    }

    private static <T> Condition<T> notNull(Condition<T> condition) {
        if (condition == null) {
            throw new NullPointerException("The given conditions should not have null entries");
        }
        return condition;
    }

    protected final Collection<Condition<? super T>> conditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }
}

