/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.text.MessageFormat;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.helpers.BogoPerf;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@Ignore
public class MessageFormatterPerfTest {
    Integer i1 = new Integer(1);
    Integer i2 = new Integer(2);
    static long RUN_LENGTH = 100000L;
    static long REFERENCE_BIPS = 48416L;

    public void XtestJDKFormatterPerf() {
        this.jdkMessageFormatter(RUN_LENGTH);
        double duration = this.jdkMessageFormatter(RUN_LENGTH);
        System.out.println("jdk duration = " + duration + " nanos");
    }

    @Test
    public void testSLF4JPerf_OneArg() {
        this.slf4jMessageFormatter_OneArg(RUN_LENGTH);
        double duration = this.slf4jMessageFormatter_OneArg(RUN_LENGTH);
        System.out.println("duration=" + duration);
        long referencePerf = 36L;
        BogoPerf.assertDuration(duration, referencePerf, REFERENCE_BIPS);
    }

    @Test
    public void testSLF4JPerf_TwoArg() {
        this.slf4jMessageFormatter_TwoArg(RUN_LENGTH);
        double duration = this.slf4jMessageFormatter_TwoArg(RUN_LENGTH);
        long referencePerf = 60L;
        BogoPerf.assertDuration(duration, referencePerf, REFERENCE_BIPS);
    }

    public double slf4jMessageFormatter_OneArg(long len) {
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < len) {
            FormattingTuple tp = MessageFormatter.format((String)"This is some rather short message {} ", (Object)this.i1);
            tp.getMessage();
            tp.getArgArray();
            tp.getThrowable();
            MessageFormatter.format((String)"This is some rather short message {} ", (Object)this.i1);
            ++i;
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    public double slf4jMessageFormatter_TwoArg(long len) {
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < len) {
            FormattingTuple tp = MessageFormatter.format((String)"This is some {} short message {} ", (Object)this.i1, (Object)this.i2);
            tp.getMessage();
            tp.getArgArray();
            tp.getThrowable();
            ++i;
        }
        long end = System.nanoTime();
        return (double)(end - start) / 1000000.0;
    }

    public double jdkMessageFormatter(long len) {
        String s = "";
        s = s + "";
        long start = System.currentTimeMillis();
        Object[] oa = new Object[]{this.i1};
        int i = 0;
        while ((long)i < len) {
            s = MessageFormat.format("This is some rather short message {0}", oa);
            ++i;
        }
        long end = System.currentTimeMillis();
        return 1.0 * (double)end - (double)start;
    }
}

