/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.Invoker;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InvokerTest {
    private Server _server;
    private LocalConnector _connector;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        ((HttpConfiguration.ConnectionFactory)this._connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendServerVersion(false);
        ((HttpConfiguration.ConnectionFactory)this._connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendDateHeader(false);
        ServletContextHandler context = new ServletContextHandler(1);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)context);
        context.setContextPath("/");
        ServletHolder holder = context.addServlet(Invoker.class, "/servlet/*");
        holder.setInitParameter("nonContextServlets", "true");
        this._server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testInvoker() throws Exception {
        String requestPath = "/servlet/" + TestServlet.class.getName();
        String request = "GET " + requestPath + " HTTP/1.0\r\nHost: tester\r\n\r\n";
        String expectedResponse = "HTTP/1.1 200 OK\r\nContent-Length: 20\r\n\r\nInvoked TestServlet!";
        String response = this._connector.getResponse(request);
        Assertions.assertEquals((Object)expectedResponse, (Object)response);
    }

    public static class TestServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getWriter().append("Invoked TestServlet!");
            response.getWriter().close();
        }
    }
}

