/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action.http;

import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.mustache.MustacheTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class HttpResponseTemplateActionHandler {
    private VelocityTemplateEngine velocityTemplateEngine;
    private final MockServerLogger mockServerLogger;
    private JavaScriptTemplateEngine javaScriptTemplateEngine;
    private MustacheTemplateEngine mustacheTemplateEngine;

    public HttpResponseTemplateActionHandler(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public HttpResponse handle(HttpTemplate httpTemplate, HttpRequest httpRequest) {
        HttpResponse templatedResponse;
        TemplateEngine templateEngine;
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.getVelocityTemplateEngine();
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.getJavaScriptTemplateEngine();
                break;
            }
            case MUSTACHE: {
                templateEngine = this.getMustacheTemplateEngine();
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedResponse = (HttpResponse)templateEngine.executeTemplate(httpTemplate.getTemplate(), httpRequest, HttpResponseDTO.class)) != null) {
            return templatedResponse;
        }
        return httpResponse;
    }

    private VelocityTemplateEngine getVelocityTemplateEngine() {
        if (this.velocityTemplateEngine == null) {
            this.velocityTemplateEngine = new VelocityTemplateEngine(this.mockServerLogger);
        }
        return this.velocityTemplateEngine;
    }

    private JavaScriptTemplateEngine getJavaScriptTemplateEngine() {
        if (this.javaScriptTemplateEngine == null) {
            this.javaScriptTemplateEngine = new JavaScriptTemplateEngine(this.mockServerLogger);
        }
        return this.javaScriptTemplateEngine;
    }

    private MustacheTemplateEngine getMustacheTemplateEngine() {
        if (this.mustacheTemplateEngine == null) {
            this.mustacheTemplateEngine = new MustacheTemplateEngine(this.mockServerLogger);
        }
        return this.mustacheTemplateEngine;
    }
}

